/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2017-12-13 15:48:49 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_ab_appointments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `series_id` int(10) unsigned DEFAULT NULL,
  `staff_id` int(10) unsigned NOT NULL,
  `service_id` int(10) unsigned DEFAULT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `google_event_id` varchar(255) DEFAULT NULL,
  `extras_duration` int(11) NOT NULL DEFAULT '0',
  `internal_note` text,
  PRIMARY KEY (`id`),
  KEY `series_id` (`series_id`),
  KEY `staff_id` (`staff_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `wp_ab_appointments_ibfk_1` FOREIGN KEY (`series_id`) REFERENCES `wp_ab_series` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `wp_ab_appointments_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `wp_ab_staff` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `wp_ab_appointments_ibfk_3` FOREIGN KEY (`service_id`) REFERENCES `wp_ab_services` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_ab_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `position` int(11) NOT NULL DEFAULT '9999',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_ab_coupon_services` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `coupon_id` int(10) unsigned NOT NULL,
  `service_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `wp_ab_coupon_services_ibfk_1` FOREIGN KEY (`coupon_id`) REFERENCES `wp_ab_coupons` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `wp_ab_coupon_services_ibfk_2` FOREIGN KEY (`service_id`) REFERENCES `wp_ab_services` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_ab_coupons` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL DEFAULT '',
  `discount` decimal(3,0) NOT NULL DEFAULT '0',
  `deduction` decimal(10,2) NOT NULL DEFAULT '0.00',
  `usage_limit` int(10) unsigned NOT NULL DEFAULT '1',
  `used` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_ab_customer_appointments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int(10) unsigned NOT NULL,
  `appointment_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned DEFAULT NULL,
  `payment_id` int(10) unsigned DEFAULT NULL,
  `number_of_persons` int(10) unsigned NOT NULL DEFAULT '1',
  `extras` text,
  `custom_fields` text,
  `status` enum('pending','approved','cancelled','rejected') NOT NULL DEFAULT 'approved',
  `token` varchar(255) DEFAULT NULL,
  `time_zone_offset` int(11) DEFAULT NULL,
  `locale` varchar(8) DEFAULT NULL,
  `compound_service_id` int(10) unsigned DEFAULT NULL,
  `compound_token` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `appointment_id` (`appointment_id`),
  KEY `payment_id` (`payment_id`),
  CONSTRAINT `wp_ab_customer_appointments_ibfk_1` FOREIGN KEY (`customer_id`) REFERENCES `wp_ab_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `wp_ab_customer_appointments_ibfk_2` FOREIGN KEY (`appointment_id`) REFERENCES `wp_ab_appointments` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `wp_ab_customer_appointments_ibfk_3` FOREIGN KEY (`payment_id`) REFERENCES `wp_ab_payments` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_ab_customers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `wp_user_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `phone` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `notes` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_ab_holidays` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `staff_id` int(10) unsigned DEFAULT NULL,
  `parent_id` int(10) unsigned DEFAULT NULL,
  `date` date NOT NULL,
  `repeat_event` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `wp_ab_holidays_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `wp_ab_staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_ab_notifications` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gateway` enum('email','sms') NOT NULL DEFAULT 'email',
  `type` varchar(255) NOT NULL DEFAULT '',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `copy` tinyint(1) NOT NULL DEFAULT '0',
  `subject` varchar(255) NOT NULL DEFAULT '',
  `message` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_ab_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `type` enum('local','coupon','paypal','authorize_net','stripe','2checkout','payu_latam','payson','mollie','woocommerce') NOT NULL DEFAULT 'local',
  `total` decimal(10,2) NOT NULL DEFAULT '0.00',
  `paid` decimal(10,2) NOT NULL DEFAULT '0.00',
  `status` enum('pending','completed') NOT NULL DEFAULT 'completed',
  `details` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_ab_schedule_item_breaks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `staff_schedule_item_id` int(10) unsigned NOT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staff_schedule_item_id` (`staff_schedule_item_id`),
  CONSTRAINT `wp_ab_schedule_item_breaks_ibfk_1` FOREIGN KEY (`staff_schedule_item_id`) REFERENCES `wp_ab_staff_schedule_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_ab_sent_notifications` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_appointment_id` int(10) unsigned DEFAULT NULL,
  `staff_id` int(10) unsigned DEFAULT NULL,
  `gateway` enum('email','sms') NOT NULL DEFAULT 'email',
  `type` varchar(60) NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_appointment_id` (`customer_appointment_id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `wp_ab_sent_notifications_ibfk_1` FOREIGN KEY (`customer_appointment_id`) REFERENCES `wp_ab_customer_appointments` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `wp_ab_sent_notifications_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `wp_ab_staff` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_ab_series` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `repeat` varchar(255) DEFAULT NULL,
  `token` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_ab_services` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `title` varchar(255) DEFAULT '',
  `duration` int(11) NOT NULL DEFAULT '900',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `color` varchar(255) NOT NULL DEFAULT '#FFFFFF',
  `capacity` int(11) NOT NULL DEFAULT '1',
  `padding_left` int(11) NOT NULL DEFAULT '0',
  `padding_right` int(11) NOT NULL DEFAULT '0',
  `info` text,
  `type` enum('simple','compound') NOT NULL DEFAULT 'simple',
  `sub_services` text NOT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `visibility` enum('public','private') NOT NULL DEFAULT 'public',
  `position` int(11) NOT NULL DEFAULT '9999',
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  CONSTRAINT `wp_ab_services_ibfk_1` FOREIGN KEY (`category_id`) REFERENCES `wp_ab_categories` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_ab_staff` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `wp_user_id` bigint(20) unsigned DEFAULT NULL,
  `attachment_id` int(10) unsigned DEFAULT NULL,
  `full_name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `info` text,
  `google_data` text,
  `google_calendar_id` varchar(255) DEFAULT NULL,
  `visibility` enum('public','private') NOT NULL DEFAULT 'public',
  `position` int(11) NOT NULL DEFAULT '9999',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_ab_staff_schedule_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `staff_id` int(10) unsigned NOT NULL,
  `day_index` int(10) unsigned NOT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_ids_idx` (`staff_id`,`day_index`),
  CONSTRAINT `wp_ab_staff_schedule_items_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `wp_ab_staff` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_ab_staff_services` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `staff_id` int(10) unsigned NOT NULL,
  `service_id` int(10) unsigned NOT NULL,
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `deposit` varchar(100) NOT NULL DEFAULT '100%',
  `capacity` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_ids_idx` (`staff_id`,`service_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `wp_ab_staff_services_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `wp_ab_staff` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `wp_ab_staff_services_ibfk_2` FOREIGN KEY (`service_id`) REFERENCES `wp_ab_services` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_app_appointmentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `app_appointment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `app_appointment_id` (`app_appointment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_app_appointments` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created` datetime DEFAULT NULL,
  `user` bigint(20) NOT NULL DEFAULT '0',
  `name` varchar(250) DEFAULT NULL,
  `email` varchar(250) DEFAULT NULL,
  `phone` varchar(250) DEFAULT NULL,
  `address` varchar(250) DEFAULT NULL,
  `city` varchar(250) DEFAULT NULL,
  `location` bigint(20) NOT NULL DEFAULT '0',
  `service` bigint(20) NOT NULL DEFAULT '0',
  `worker` bigint(20) NOT NULL DEFAULT '0',
  `price` float DEFAULT NULL,
  `status` varchar(35) DEFAULT NULL,
  `start` datetime DEFAULT NULL,
  `end` datetime DEFAULT NULL,
  `sent` text,
  `sent_worker` text,
  `note` text,
  `gcal_ID` varchar(250) DEFAULT NULL,
  `gcal_updated` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_app_exceptions` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location` bigint(20) NOT NULL DEFAULT '0',
  `service` bigint(20) NOT NULL DEFAULT '0',
  `worker` bigint(20) NOT NULL DEFAULT '0',
  `status` varchar(30) DEFAULT NULL,
  `days` text,
  `note` text,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_app_services` (
  `ID` bigint(20) unsigned NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `capacity` bigint(20) NOT NULL DEFAULT '0',
  `duration` bigint(20) NOT NULL DEFAULT '0',
  `price` varchar(255) DEFAULT NULL,
  `page` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_app_transactions` (
  `transaction_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_app_ID` bigint(20) NOT NULL DEFAULT '0',
  `transaction_paypal_ID` varchar(30) DEFAULT NULL,
  `transaction_stamp` bigint(35) NOT NULL DEFAULT '0',
  `transaction_total_amount` bigint(20) DEFAULT NULL,
  `transaction_currency` varchar(35) DEFAULT NULL,
  `transaction_status` varchar(35) DEFAULT NULL,
  `transaction_note` text,
  PRIMARY KEY (`transaction_ID`),
  KEY `transaction_app_ID` (`transaction_app_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_app_workers` (
  `ID` bigint(20) unsigned NOT NULL,
  `dummy` varchar(255) DEFAULT NULL,
  `price` varchar(255) DEFAULT NULL,
  `services_provided` text,
  `page` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_app_working_hours` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location` bigint(20) NOT NULL DEFAULT '0',
  `service` bigint(20) NOT NULL DEFAULT '0',
  `worker` bigint(20) NOT NULL DEFAULT '0',
  `status` varchar(30) DEFAULT NULL,
  `hours` text,
  `note` text,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_bap_carts` (
  `session_id` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `place_id` int(11) NOT NULL,
  `date` datetime NOT NULL,
  KEY `place_id` (`place_id`),
  CONSTRAINT `wp_bap_carts_ibfk_1` FOREIGN KEY (`place_id`) REFERENCES `wp_bap_places` (`place_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_bap_events` (
  `event_id` int(11) NOT NULL AUTO_INCREMENT,
  `scheme_id` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `hours` float NOT NULL DEFAULT '0',
  `background_color` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `border_color` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `text_color` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `start` datetime NOT NULL,
  `end` datetime NOT NULL,
  `timezone_offset` float NOT NULL DEFAULT '0',
  `all_day` int(11) NOT NULL DEFAULT '1',
  `status_id` int(11) NOT NULL,
  PRIMARY KEY (`event_id`),
  KEY `scheme_id` (`scheme_id`),
  CONSTRAINT `wp_bap_events_ibfk_1` FOREIGN KEY (`scheme_id`) REFERENCES `wp_bap_schemes` (`scheme_id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_bap_orders` (
  `order_id` int(11) NOT NULL AUTO_INCREMENT,
  `first_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_520_ci,
  `date` datetime DEFAULT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `places` text COLLATE utf8mb4_unicode_520_ci,
  `total_price` float NOT NULL DEFAULT '0',
  `status_id` int(11) NOT NULL DEFAULT '0',
  `admin_notes` text COLLATE utf8mb4_unicode_520_ci,
  `event_id` int(11) DEFAULT NULL,
  `event_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `event` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_bap_places` (
  `place_id` int(11) NOT NULL AUTO_INCREMENT,
  `type` int(11) NOT NULL DEFAULT '0',
  `cells` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `price` float NOT NULL DEFAULT '0',
  `scheme_id` int(11) NOT NULL,
  `status_id` int(11) NOT NULL,
  `color` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`place_id`),
  KEY `scheme_id` (`scheme_id`),
  CONSTRAINT `wp_bap_places_ibfk_1` FOREIGN KEY (`scheme_id`) REFERENCES `wp_bap_schemes` (`scheme_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_bap_schemes` (
  `scheme_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  `is_hidden` tinyint(1) NOT NULL DEFAULT '0',
  `description` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`scheme_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_booking` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(30) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `date` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_confirmed` int(11) DEFAULT '0',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_bookingdates` (
  `booking_id` bigint(20) unsigned NOT NULL,
  `booking_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `approved` bigint(20) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `booking_id_dates` (`booking_id`,`booking_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_cf7_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_cf7_data_entry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cf7_id` int(11) NOT NULL,
  `data_id` int(11) NOT NULL,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `value` text COLLATE utf8mb4_unicode_520_ci,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_db7_forms` (
  `form_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_post_id` bigint(20) NOT NULL,
  `form_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `form_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`form_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_ea_error_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `error_type` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `errors` text COLLATE utf8mb4_unicode_520_ci,
  `errors_data` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_em_bookings` (
  `booking_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` bigint(20) unsigned DEFAULT NULL,
  `person_id` bigint(20) unsigned NOT NULL,
  `booking_spaces` int(5) NOT NULL,
  `booking_comment` mediumtext COLLATE utf8mb4_unicode_ci,
  `booking_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `booking_status` tinyint(1) NOT NULL DEFAULT '1',
  `booking_price` decimal(14,4) unsigned NOT NULL DEFAULT '0.0000',
  `booking_tax_rate` decimal(7,4) DEFAULT NULL,
  `booking_taxes` decimal(14,4) DEFAULT NULL,
  `booking_meta` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`booking_id`),
  KEY `event_id` (`event_id`),
  KEY `person_id` (`person_id`),
  KEY `booking_status` (`booking_status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_em_events` (
  `event_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL,
  `event_slug` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_owner` bigint(20) unsigned DEFAULT NULL,
  `event_status` int(1) DEFAULT NULL,
  `event_name` mediumtext COLLATE utf8mb4_unicode_ci,
  `event_start_time` time DEFAULT NULL,
  `event_end_time` time DEFAULT NULL,
  `event_all_day` int(1) DEFAULT NULL,
  `event_start_date` date DEFAULT NULL,
  `event_end_date` date DEFAULT NULL,
  `post_content` longtext COLLATE utf8mb4_unicode_ci,
  `event_rsvp` tinyint(1) NOT NULL DEFAULT '0',
  `event_rsvp_date` date DEFAULT NULL,
  `event_rsvp_time` time DEFAULT NULL,
  `event_rsvp_spaces` int(5) DEFAULT NULL,
  `event_spaces` int(5) DEFAULT '0',
  `event_private` tinyint(1) NOT NULL DEFAULT '0',
  `location_id` bigint(20) unsigned DEFAULT NULL,
  `recurrence_id` bigint(20) unsigned DEFAULT NULL,
  `event_category_id` bigint(20) unsigned DEFAULT NULL,
  `event_attributes` mediumtext COLLATE utf8mb4_unicode_ci,
  `event_date_created` datetime DEFAULT NULL,
  `event_date_modified` datetime DEFAULT NULL,
  `recurrence` tinyint(1) NOT NULL DEFAULT '0',
  `recurrence_interval` int(4) DEFAULT NULL,
  `recurrence_freq` text COLLATE utf8mb4_unicode_ci,
  `recurrence_byday` text COLLATE utf8mb4_unicode_ci,
  `recurrence_byweekno` int(4) DEFAULT NULL,
  `recurrence_days` int(4) DEFAULT NULL,
  `recurrence_rsvp_days` int(3) DEFAULT NULL,
  `blog_id` bigint(20) unsigned DEFAULT NULL,
  `group_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`event_id`),
  KEY `event_status` (`event_status`),
  KEY `post_id` (`post_id`),
  KEY `blog_id` (`blog_id`),
  KEY `group_id` (`group_id`),
  KEY `location_id` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_em_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL,
  `blog_id` bigint(20) unsigned DEFAULT NULL,
  `location_slug` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_name` mediumtext COLLATE utf8mb4_unicode_ci,
  `location_owner` bigint(20) unsigned NOT NULL DEFAULT '0',
  `location_address` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_town` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_state` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_postcode` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_region` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_country` char(2) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_latitude` float(10,6) DEFAULT NULL,
  `location_longitude` float(10,6) DEFAULT NULL,
  `post_content` longtext COLLATE utf8mb4_unicode_ci,
  `location_status` int(1) DEFAULT NULL,
  `location_private` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`location_id`),
  KEY `location_state` (`location_state`(191)),
  KEY `location_region` (`location_region`(191)),
  KEY `location_country` (`location_country`),
  KEY `post_id` (`post_id`),
  KEY `blog_id` (`blog_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_em_meta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `object_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  `meta_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`meta_id`),
  KEY `object_id` (`object_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_em_tickets` (
  `ticket_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` bigint(20) unsigned NOT NULL,
  `ticket_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `ticket_description` mediumtext COLLATE utf8mb4_unicode_ci,
  `ticket_price` decimal(14,4) DEFAULT NULL,
  `ticket_start` datetime DEFAULT NULL,
  `ticket_end` datetime DEFAULT NULL,
  `ticket_min` int(10) DEFAULT NULL,
  `ticket_max` int(10) DEFAULT NULL,
  `ticket_spaces` int(11) DEFAULT NULL,
  `ticket_members` int(1) DEFAULT NULL,
  `ticket_members_roles` longtext COLLATE utf8mb4_unicode_ci,
  `ticket_guests` int(1) DEFAULT NULL,
  `ticket_required` int(1) DEFAULT NULL,
  `ticket_meta` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`ticket_id`),
  KEY `event_id` (`event_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_em_tickets_bookings` (
  `ticket_booking_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `booking_id` bigint(20) unsigned NOT NULL,
  `ticket_id` bigint(20) unsigned NOT NULL,
  `ticket_booking_spaces` int(6) NOT NULL,
  `ticket_booking_price` decimal(14,4) NOT NULL,
  PRIMARY KEY (`ticket_booking_id`),
  KEY `booking_id` (`booking_id`),
  KEY `ticket_id` (`ticket_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_es_deliverreport` (
  `es_deliver_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `es_deliver_sentguid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `es_deliver_emailid` int(10) unsigned NOT NULL,
  `es_deliver_emailmail` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `es_deliver_sentdate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `es_deliver_status` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `es_deliver_viewdate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `es_deliver_sentstatus` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Sent',
  `es_deliver_senttype` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Immediately',
  PRIMARY KEY (`es_deliver_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_es_emaillist` (
  `es_email_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `es_email_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `es_email_mail` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `es_email_status` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Unconfirmed',
  `es_email_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `es_email_viewcount` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `es_email_group` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Public',
  `es_email_guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`es_email_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_es_notification` (
  `es_note_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `es_note_cat` text COLLATE utf8mb4_unicode_520_ci,
  `es_note_group` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `es_note_templ` int(10) unsigned NOT NULL,
  `es_note_status` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Enable',
  PRIMARY KEY (`es_note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_es_sentdetails` (
  `es_sent_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `es_sent_guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `es_sent_qstring` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `es_sent_source` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `es_sent_starttime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `es_sent_endtime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `es_sent_count` int(10) unsigned NOT NULL,
  `es_sent_preview` text COLLATE utf8mb4_unicode_520_ci,
  `es_sent_status` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Sent',
  `es_sent_type` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Immediately',
  `es_sent_subject` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`es_sent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_newsletter` (
  `name` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `token` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `status` varchar(1) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'S',
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `list` int(11) NOT NULL DEFAULT '0',
  `profile` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated` int(11) NOT NULL DEFAULT '0',
  `followup_step` tinyint(4) NOT NULL DEFAULT '0',
  `followup_time` bigint(20) NOT NULL DEFAULT '0',
  `followup` tinyint(4) NOT NULL DEFAULT '0',
  `surname` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `sex` char(1) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'n',
  `feed_time` bigint(20) NOT NULL DEFAULT '0',
  `feed` tinyint(4) NOT NULL DEFAULT '0',
  `referrer` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `ip` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `wp_user_id` int(11) NOT NULL DEFAULT '0',
  `http_referer` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `country` varchar(4) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `region` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `bounce_type` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `bounce_time` int(11) NOT NULL DEFAULT '0',
  `unsub_email_id` int(11) NOT NULL DEFAULT '0',
  `unsub_time` int(11) NOT NULL DEFAULT '0',
  `list_1` tinyint(4) NOT NULL DEFAULT '0',
  `list_2` tinyint(4) NOT NULL DEFAULT '0',
  `list_3` tinyint(4) NOT NULL DEFAULT '0',
  `list_4` tinyint(4) NOT NULL DEFAULT '0',
  `list_5` tinyint(4) NOT NULL DEFAULT '0',
  `list_6` tinyint(4) NOT NULL DEFAULT '0',
  `list_7` tinyint(4) NOT NULL DEFAULT '0',
  `list_8` tinyint(4) NOT NULL DEFAULT '0',
  `list_9` tinyint(4) NOT NULL DEFAULT '0',
  `list_10` tinyint(4) NOT NULL DEFAULT '0',
  `list_11` tinyint(4) NOT NULL DEFAULT '0',
  `list_12` tinyint(4) NOT NULL DEFAULT '0',
  `list_13` tinyint(4) NOT NULL DEFAULT '0',
  `list_14` tinyint(4) NOT NULL DEFAULT '0',
  `list_15` tinyint(4) NOT NULL DEFAULT '0',
  `list_16` tinyint(4) NOT NULL DEFAULT '0',
  `list_17` tinyint(4) NOT NULL DEFAULT '0',
  `list_18` tinyint(4) NOT NULL DEFAULT '0',
  `list_19` tinyint(4) NOT NULL DEFAULT '0',
  `list_20` tinyint(4) NOT NULL DEFAULT '0',
  `profile_1` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_2` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_3` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_4` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_5` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_6` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_7` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_8` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_9` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_10` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_11` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_12` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_13` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_14` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_15` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_16` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_17` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_18` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_19` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_20` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `test` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `wp_user_id` (`wp_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_newsletter_emails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `subject` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `message` longtext COLLATE utf8mb4_unicode_520_ci,
  `subject2` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `message2` longtext COLLATE utf8mb4_unicode_520_ci,
  `name2` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` enum('new','sending','sent','paused') COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'new',
  `total` int(11) NOT NULL DEFAULT '0',
  `last_id` int(11) NOT NULL DEFAULT '0',
  `sent` int(11) NOT NULL DEFAULT '0',
  `track` int(11) NOT NULL DEFAULT '0',
  `list` int(11) NOT NULL DEFAULT '0',
  `type` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `query` longtext COLLATE utf8mb4_unicode_520_ci,
  `editor` tinyint(4) NOT NULL DEFAULT '0',
  `sex` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `theme` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `message_text` longtext COLLATE utf8mb4_unicode_520_ci,
  `preferences` longtext COLLATE utf8mb4_unicode_520_ci,
  `send_on` int(11) NOT NULL DEFAULT '0',
  `token` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `options` longtext COLLATE utf8mb4_unicode_520_ci,
  `private` tinyint(1) NOT NULL DEFAULT '0',
  `click_count` int(10) unsigned NOT NULL DEFAULT '0',
  `version` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `open_count` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_newsletter_sent` (
  `email_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `open` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `error` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`email_id`,`user_id`),
  KEY `user_id` (`user_id`),
  KEY `email_id` (`email_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_newsletter_stats` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `newsletter` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `anchor` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `email_id` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '0',
  `link_id` int(11) NOT NULL DEFAULT '0',
  `ip` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `country` varchar(4) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `email_id` (`email_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=1830 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=1576 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=294 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_sml` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `sml_name` varchar(200) NOT NULL,
  `sml_email` varchar(200) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_sndr_mail_users_info` (
  `mail_users_info_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `user_email` varchar(255) NOT NULL,
  `user_display_name` varchar(255) NOT NULL,
  `subscribe` int(1) NOT NULL DEFAULT '1',
  `unsubscribe_code` varchar(100) NOT NULL,
  `subscribe_time` int(10) unsigned NOT NULL,
  `unsubscribe_time` int(10) unsigned NOT NULL,
  `delete` int(10) unsigned NOT NULL,
  `black_list` int(10) unsigned NOT NULL,
  PRIMARY KEY (`mail_users_info_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpdevart_calendars` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `title` varchar(128) NOT NULL,
  `hours_enabled` varchar(3) NOT NULL,
  `hours_interval_enabled` varchar(3) NOT NULL,
  `theme_id` int(11) NOT NULL,
  `form_id` int(11) NOT NULL,
  `extra_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wpdevart_dates` (
  `unique_id` varchar(32) NOT NULL,
  `calendar_id` int(11) NOT NULL,
  `day` varchar(16) NOT NULL,
  `data` text NOT NULL,
  PRIMARY KEY (`unique_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wpdevart_extras` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(32) NOT NULL,
  `data` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wpdevart_forms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(32) NOT NULL,
  `data` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wpdevart_payments` (
  `pay_id` int(11) NOT NULL AUTO_INCREMENT,
  `res_id` int(11) NOT NULL,
  `payment_price` float NOT NULL,
  `tax` float NOT NULL,
  `pay_status` varchar(20) NOT NULL,
  `ip` varchar(32) NOT NULL,
  `ipn` varchar(32) NOT NULL,
  `payment_address` varchar(350) NOT NULL,
  `payment_info` text NOT NULL,
  `modified_date` varchar(20) NOT NULL,
  PRIMARY KEY (`pay_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wpdevart_reservations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `calendar_id` int(11) NOT NULL,
  `single_day` varchar(16) NOT NULL,
  `check_in` varchar(16) NOT NULL,
  `check_out` varchar(16) NOT NULL,
  `start_hour` varchar(16) NOT NULL,
  `end_hour` varchar(16) NOT NULL,
  `currency` varchar(32) NOT NULL,
  `count_item` int(10) NOT NULL,
  `price` float NOT NULL,
  `total_price` float NOT NULL,
  `extras` text NOT NULL,
  `extras_price` float NOT NULL,
  `form` text NOT NULL,
  `address_billing` text NOT NULL,
  `address_shipping` text NOT NULL,
  `email` varchar(128) NOT NULL,
  `status` varchar(16) NOT NULL,
  `payment_method` varchar(32) NOT NULL,
  `payment_status` varchar(32) NOT NULL,
  `date_created` varchar(64) NOT NULL,
  `is_new` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wpdevart_themes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(32) NOT NULL,
  `value` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;


/* INSERT TABLE DATA: wp_ab_notifications */
INSERT INTO `wp_ab_notifications` VALUES("1", "email", "client_pending_appointment", "0", "0", "Your appointment information", "<p>Dear {client_name}.</p>\n<p>This is a confirmation that you have booked {service_name}.</p>\n<p>We are waiting you at {company_address} on {appointment_date} at {appointment_time}.</p>\n<p>Thank you for choosing our company.</p>\n<p>{company_name}<br />\n{company_phone}<br />\n{company_website}</p>\n");
INSERT INTO `wp_ab_notifications` VALUES("2", "email", "client_pending_appointment_cart", "0", "0", "Your appointment information", "<p>Dear {client_name}.</p>\n<p>This is a confirmation that you have booked the following items:</p>\n<p>{cart_info}</p>\n<p>Thank you for choosing our company.</p>\n<p>{company_name}<br />\n{company_phone}<br />\n{company_website}</p>\n");
INSERT INTO `wp_ab_notifications` VALUES("3", "email", "staff_pending_appointment", "0", "0", "New booking information", "<p>Hello.</p>\n<p>You have new booking.</p>\n<p>Service: {service_name}<br />\nDate: {appointment_date}<br />\nTime: {appointment_time}<br />\nClient name: {client_name}<br />\nClient phone: {client_phone}<br />\nClient email: {client_email}</p>\n");
INSERT INTO `wp_ab_notifications` VALUES("4", "email", "client_approved_appointment", "0", "0", "Your appointment information", "<p>Dear {client_name}.</p>\n<p>This is a confirmation that you have booked {service_name}.</p>\n<p>We are waiting you at {company_address} on {appointment_date} at {appointment_time}.</p>\n<p>Thank you for choosing our company.</p>\n<p>{company_name}<br />\n{company_phone}<br />\n{company_website}</p>\n");
INSERT INTO `wp_ab_notifications` VALUES("5", "email", "client_approved_appointment_cart", "0", "0", "Your appointment information", "<p>Dear {client_name}.</p>\n<p>This is a confirmation that you have booked the following items:</p>\n<p>{cart_info}</p>\n<p>Thank you for choosing our company.</p>\n<p>{company_name}<br />\n{company_phone}<br />\n{company_website}</p>\n");
INSERT INTO `wp_ab_notifications` VALUES("6", "email", "staff_approved_appointment", "0", "0", "New booking information", "<p>Hello.</p>\n<p>You have new booking.</p>\n<p>Service: {service_name}<br />\nDate: {appointment_date}<br />\nTime: {appointment_time}<br />\nClient name: {client_name}<br />\nClient phone: {client_phone}<br />\nClient email: {client_email}</p>\n");
INSERT INTO `wp_ab_notifications` VALUES("7", "email", "client_cancelled_appointment", "0", "0", "Booking cancellation", "<p>Dear {client_name}.</p>\n<p>You have cancelled your booking of {service_name} on {appointment_date} at {appointment_time}.</p>\n<p>Thank you for choosing our company.</p>\n<p>{company_name}<br />\n{company_phone}<br />\n{company_website}</p>\n");
INSERT INTO `wp_ab_notifications` VALUES("8", "email", "staff_cancelled_appointment", "0", "0", "Booking cancellation", "<p>Hello.</p>\n<p>The following booking has been cancelled.</p>\n<p>Service: {service_name}<br />\nDate: {appointment_date}<br />\nTime: {appointment_time}<br />\nClient name: {client_name}<br />\nClient phone: {client_phone}<br />\nClient email: {client_email}</p>\n");
INSERT INTO `wp_ab_notifications` VALUES("9", "email", "client_rejected_appointment", "0", "0", "Booking rejection", "<p>Dear {client_name}.</p>\n<p>Your booking of {service_name} on {appointment_date} at {appointment_time} has been rejected.</p>\n<p>Reason: {cancellation_reason}</p>\n<p>Thank you for choosing our company.</p>\n<p>{company_name}<br />\n{company_phone}<br />\n{company_website}</p>\n");
INSERT INTO `wp_ab_notifications` VALUES("10", "email", "staff_rejected_appointment", "0", "0", "Booking rejection", "<p>Hello.</p>\n<p>The following booking has been rejected.</p>\n<p>Reason: {cancellation_reason}</p>\n<p>Service: {service_name}<br />\nDate: {appointment_date}<br />\nTime: {appointment_time}<br />\nClient name: {client_name}<br />\nClient phone: {client_phone}<br />\nClient email: {client_email}</p>\n");
INSERT INTO `wp_ab_notifications` VALUES("11", "email", "client_new_wp_user", "0", "0", "New customer", "<p>Hello.</p>\n<p>An account was created for you at {site_address}</p>\n<p>Your user details:<br />\nuser: {new_username}<br />\npassword: {new_password}</p>\n<p>Thanks.</p>\n");
INSERT INTO `wp_ab_notifications` VALUES("12", "email", "client_reminder", "0", "0", "Your appointment at {company_name}", "<p>Dear {client_name}.</p>\n<p>We would like to remind you that you have booked {service_name} tomorrow on {appointment_time}. We are waiting you at {company_address}.</p>\n<p>Thank you for choosing our company.</p>\n<p>{company_name}<br />\n{company_phone}<br />\n{company_website}</p>\n");
INSERT INTO `wp_ab_notifications` VALUES("13", "email", "client_follow_up", "0", "0", "Your visit to {company_name}", "<p>Dear {client_name}.</p>\n<p>Thank you for choosing {company_name}. We hope you were satisfied with your {service_name}.</p>\n<p>Thank you and we look forward to seeing you again soon.</p>\n<p>{company_name}<br />\n{company_phone}<br />\n{company_website}</p>\n");
INSERT INTO `wp_ab_notifications` VALUES("14", "email", "staff_agenda", "0", "0", "Your agenda for {tomorrow_date}", "<p>Hello.</p>\n<p>Your agenda for tomorrow is:</p>\n<p>{next_day_agenda}</p>\n");
INSERT INTO `wp_ab_notifications` VALUES("15", "sms", "client_pending_appointment", "1", "0", "", "Dear {client_name}.\nThis is a confirmation that you have booked {service_name}.\nWe are waiting you at {company_address} on {appointment_date} at {appointment_time}.\nThank you for choosing our company.\n{company_name}\n{company_phone}\n{company_website}");
INSERT INTO `wp_ab_notifications` VALUES("16", "sms", "client_pending_appointment_cart", "1", "0", "", "Dear {client_name}.\nThis is a confirmation that you have booked the following items:\n{cart_info}\nThank you for choosing our company.\n{company_name}\n{company_phone}\n{company_website}");
INSERT INTO `wp_ab_notifications` VALUES("17", "sms", "staff_pending_appointment", "1", "0", "", "Hello.\nYou have new booking.\nService: {service_name}\nDate: {appointment_date}\nTime: {appointment_time}\nClient name: {client_name}\nClient phone: {client_phone}\nClient email: {client_email}");
INSERT INTO `wp_ab_notifications` VALUES("18", "sms", "client_approved_appointment", "1", "0", "", "Dear {client_name}.\nThis is a confirmation that you have booked {service_name}.\nWe are waiting you at {company_address} on {appointment_date} at {appointment_time}.\nThank you for choosing our company.\n{company_name}\n{company_phone}\n{company_website}");
INSERT INTO `wp_ab_notifications` VALUES("19", "sms", "client_approved_appointment_cart", "1", "0", "", "Dear {client_name}.\nThis is a confirmation that you have booked the following items:\n{cart_info}\nThank you for choosing our company.\n{company_name}\n{company_phone}\n{company_website}");
INSERT INTO `wp_ab_notifications` VALUES("20", "sms", "staff_approved_appointment", "1", "0", "", "Hello.\nYou have new booking.\nService: {service_name}\nDate: {appointment_date}\nTime: {appointment_time}\nClient name: {client_name}\nClient phone: {client_phone}\nClient email: {client_email}");
INSERT INTO `wp_ab_notifications` VALUES("21", "sms", "client_cancelled_appointment", "1", "0", "", "Dear {client_name}.\nYou have cancelled your booking of {service_name} on {appointment_date} at {appointment_time}.\nThank you for choosing our company.\n{company_name}\n{company_phone}\n{company_website}");
INSERT INTO `wp_ab_notifications` VALUES("22", "sms", "staff_cancelled_appointment", "1", "0", "", "Hello.\nThe following booking has been cancelled.\nService: {service_name}\nDate: {appointment_date}\nTime: {appointment_time}\nClient name: {client_name}\nClient phone: {client_phone}\nClient email: {client_email}");
INSERT INTO `wp_ab_notifications` VALUES("23", "sms", "client_rejected_appointment", "1", "0", "", "Dear {client_name}.\nYour booking of {service_name} on {appointment_date} at {appointment_time} has been rejected.\nReason: {cancellation_reason}\nThank you for choosing our company.\n{company_name}\n{company_phone}\n{company_website}");
INSERT INTO `wp_ab_notifications` VALUES("24", "sms", "staff_rejected_appointment", "1", "0", "", "Hello.\nThe following booking has been rejected.\nReason: {cancellation_reason}\nService: {service_name}\nDate: {appointment_date}\nTime: {appointment_time}\nClient name: {client_name}\nClient phone: {client_phone}\nClient email: {client_email}");
INSERT INTO `wp_ab_notifications` VALUES("25", "sms", "client_new_wp_user", "1", "0", "", "Hello.\nAn account was created for you at {site_address}\nYour user details:\nuser: {new_username}\npassword: {new_password}\n\nThanks.");
INSERT INTO `wp_ab_notifications` VALUES("26", "sms", "client_reminder", "0", "0", "", "Dear {client_name}.\nWe would like to remind you that you have booked {service_name} tomorrow on {appointment_time}. We are waiting you at {company_address}.\nThank you for choosing our company.\n{company_name}\n{company_phone}\n{company_website}");
INSERT INTO `wp_ab_notifications` VALUES("27", "sms", "client_follow_up", "0", "0", "", "Dear {client_name}.\nThank you for choosing {company_name}. We hope you were satisfied with your {service_name}.\nThank you and we look forward to seeing you again soon.\n{company_name}\n{company_phone}\n{company_website}");
INSERT INTO `wp_ab_notifications` VALUES("28", "sms", "staff_agenda", "0", "0", "", "Hello.\nYour agenda for tomorrow is:\n{next_day_agenda}");

/* INSERT TABLE DATA: wp_ab_services */
INSERT INTO `wp_ab_services` VALUES("1", NULL, "Rezerwacja spotkania", "86400", "0.00", "#379B8E", "1", "0", "0", "", "simple", "[]", NULL, NULL, "public", "9999");

/* INSERT TABLE DATA: wp_ab_staff */
INSERT INTO `wp_ab_staff` VALUES("1", NULL, NULL, "Employee", NULL, NULL, NULL, NULL, NULL, "public", "9999");

/* INSERT TABLE DATA: wp_ab_staff_schedule_items */
INSERT INTO `wp_ab_staff_schedule_items` VALUES("1", "1", "1", "08:00:00", "18:00:00");
INSERT INTO `wp_ab_staff_schedule_items` VALUES("2", "1", "2", "08:00:00", "18:00:00");
INSERT INTO `wp_ab_staff_schedule_items` VALUES("3", "1", "3", "08:00:00", "18:00:00");
INSERT INTO `wp_ab_staff_schedule_items` VALUES("4", "1", "4", "08:00:00", "18:00:00");
INSERT INTO `wp_ab_staff_schedule_items` VALUES("5", "1", "5", "08:00:00", "18:00:00");
INSERT INTO `wp_ab_staff_schedule_items` VALUES("6", "1", "6", "08:00:00", "18:00:00");
INSERT INTO `wp_ab_staff_schedule_items` VALUES("7", "1", "7", "08:00:00", "18:00:00");

/* INSERT TABLE DATA: wp_ab_staff_services */
INSERT INTO `wp_ab_staff_services` VALUES("1", "1", "1", "0.00", "100{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}", "1");

/* INSERT TABLE DATA: wp_app_services */
INSERT INTO `wp_app_services` VALUES("1", "Default Service", "0", "30", "1", "0");

/* INSERT TABLE DATA: wp_app_working_hours */
INSERT INTO `wp_app_working_hours` VALUES("1", "0", "0", "0", "open", "a:7:{s:6:\"Sunday\";a:3:{s:6:\"active\";s:2:\"no\";s:5:\"start\";s:5:\"08:00\";s:3:\"end\";s:5:\"13:00\";}s:6:\"Monday\";a:3:{s:6:\"active\";s:3:\"yes\";s:5:\"start\";s:5:\"08:00\";s:3:\"end\";s:5:\"17:00\";}s:7:\"Tuesday\";a:3:{s:6:\"active\";s:3:\"yes\";s:5:\"start\";s:5:\"08:00\";s:3:\"end\";s:5:\"17:00\";}s:9:\"Wednesday\";a:3:{s:6:\"active\";s:3:\"yes\";s:5:\"start\";s:5:\"08:00\";s:3:\"end\";s:5:\"17:00\";}s:8:\"Thursday\";a:3:{s:6:\"active\";s:3:\"yes\";s:5:\"start\";s:5:\"08:00\";s:3:\"end\";s:5:\"17:00\";}s:6:\"Friday\";a:3:{s:6:\"active\";s:3:\"yes\";s:5:\"start\";s:5:\"08:00\";s:3:\"end\";s:5:\"17:00\";}s:8:\"Saturday\";a:3:{s:6:\"active\";s:2:\"no\";s:5:\"start\";s:5:\"08:00\";s:3:\"end\";s:5:\"13:00\";}}", NULL);
INSERT INTO `wp_app_working_hours` VALUES("2", "0", "0", "0", "closed", "a:7:{s:6:\"Sunday\";a:3:{s:6:\"active\";s:2:\"no\";s:5:\"start\";s:5:\"12:00\";s:3:\"end\";s:5:\"13:00\";}s:6:\"Monday\";a:3:{s:6:\"active\";s:2:\"no\";s:5:\"start\";s:5:\"12:00\";s:3:\"end\";s:5:\"13:00\";}s:7:\"Tuesday\";a:3:{s:6:\"active\";s:2:\"no\";s:5:\"start\";s:5:\"12:00\";s:3:\"end\";s:5:\"13:00\";}s:9:\"Wednesday\";a:3:{s:6:\"active\";s:2:\"no\";s:5:\"start\";s:5:\"12:00\";s:3:\"end\";s:5:\"13:00\";}s:8:\"Thursday\";a:3:{s:6:\"active\";s:2:\"no\";s:5:\"start\";s:5:\"12:00\";s:3:\"end\";s:5:\"13:00\";}s:6:\"Friday\";a:3:{s:6:\"active\";s:2:\"no\";s:5:\"start\";s:5:\"12:00\";s:3:\"end\";s:5:\"13:00\";}s:8:\"Saturday\";a:3:{s:6:\"active\";s:2:\"no\";s:5:\"start\";s:5:\"12:00\";s:3:\"end\";s:5:\"13:00\";}}", NULL);

/* INSERT TABLE DATA: wp_bookingdates */
INSERT INTO `wp_bookingdates` VALUES("0", "2017-10-31 00:00:00", "0");
INSERT INTO `wp_bookingdates` VALUES("0", "2017-11-01 00:00:00", "0");
INSERT INTO `wp_bookingdates` VALUES("0", "2017-11-02 00:00:00", "0");
INSERT INTO `wp_bookingdates` VALUES("1105", "2017-10-31 00:00:00", "0");
INSERT INTO `wp_bookingdates` VALUES("1105", "2017-11-01 00:00:00", "0");
INSERT INTO `wp_bookingdates` VALUES("1105", "2017-11-02 00:00:00", "0");

/* INSERT TABLE DATA: wp_cf7_data */
INSERT INTO `wp_cf7_data` VALUES("1", "2017-10-29 14:48:10");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "A WordPress Commenter", "wapuu@wordpress.example", "https://wordpress.org/", "", "2017-10-05 10:42:16", "2017-10-05 10:42:16", "Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com\">Gravatar</a>.", "0", "1", "", "", "0", "0");

/* INSERT TABLE DATA: wp_db7_forms */
INSERT INTO `wp_db7_forms` VALUES("1", "121", "a:5:{s:12:\"cfdb7_status\";s:6:\"unread\";s:9:\"your-name\";s:17:\"Michał Staniecko\";s:10:\"your-email\";s:26:\"michal.staniecko@gmail.com\";s:10:\"your-phone\";s:9:\"792006171\";s:9:\"your-date\";s:10:\"18.10.2017\";}", "2017-10-29 14:44:09");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20171213_bodybrain", "96979ec70e89adeb2232171213153912", "50", "2017-12-13 15:41:46", "admin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-12-13 15:39:12\";s:7:\"Version\";s:6:\"1.2.26\";s:9:\"VersionWP\";s:5:\"4.9.1\";s:9:\"VersionDB\";s:7:\"10.1.24\";s:10:\"VersionPHP\";s:6:\"5.6.32\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:18:\"20171213_bodybrain\";s:4:\"Hash\";s:32:\"96979ec70e89adeb2232171213153912\";s:8:\"NameHash\";s:51:\"20171213_bodybrain_96979ec70e89adeb2232171213153912\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:71:\"/home/staniecko/domains/testuj.website/public_html/bnb/wp-snapshots/tmp\";s:8:\"StoreURL\";s:39:\"http://bnb.testuj.website/wp-snapshots/\";s:8:\"ScanFile\";s:61:\"20171213_bodybrain_96979ec70e89adeb2232171213153912_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":18:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:63:\"20171213_bodybrain_96979ec70e89adeb2232171213153912_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:54:\"/home/staniecko/domains/testuj.website/public_html/bnb\";s:4:\"Size\";i:262112781;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:63:\"/home/staniecko/domains/testuj.website/public_html/bnb/wp-admin\";i:1;s:73:\"/home/staniecko/domains/testuj.website/public_html/bnb/wp-content/uploads\";i:2;s:75:\"/home/staniecko/domains/testuj.website/public_html/bnb/wp-content/languages\";i:3;s:73:\"/home/staniecko/domains/testuj.website/public_html/bnb/wp-content/plugins\";i:4;s:72:\"/home/staniecko/domains/testuj.website/public_html/bnb/wp-content/themes\";i:5;s:66:\"/home/staniecko/domains/testuj.website/public_html/bnb/wp-includes\";}}s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";s:65:\"20171213_bodybrain_96979ec70e89adeb2232171213153912_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-12-13 15:39:12\";s:7:\"Version\";s:6:\"1.2.26\";s:9:\"VersionWP\";s:5:\"4.9.1\";s:9:\"VersionDB\";s:7:\"10.1.24\";s:10:\"VersionPHP\";s:6:\"5.6.32\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:18:\"20171213_bodybrain\";s:4:\"Hash\";s:32:\"96979ec70e89adeb2232171213153912\";s:8:\"NameHash\";s:51:\"20171213_bodybrain_96979ec70e89adeb2232171213153912\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:71:\"/home/staniecko/domains/testuj.website/public_html/bnb/wp-snapshots/tmp\";s:8:\"StoreURL\";s:39:\"http://bnb.testuj.website/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";r:66;s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:724224;s:4:\"File\";s:64:\"20171213_bodybrain_96979ec70e89adeb2232171213153912_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:136:\"/home/staniecko/domains/testuj.website/public_html/bnb/wp-snapshots/tmp/20171213_bodybrain_96979ec70e89adeb2232171213153912_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}}s:8:\"Database\";r:96;}");
INSERT INTO `wp_duplicator_packages` VALUES("2", "20171213_bodybrain", "14c6a9d352bb378e2463171213154832", "20", "2017-12-13 15:48:49", "admin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-12-13 15:48:32\";s:7:\"Version\";s:6:\"1.2.26\";s:9:\"VersionWP\";s:5:\"4.9.1\";s:9:\"VersionDB\";s:7:\"10.1.24\";s:10:\"VersionPHP\";s:6:\"5.6.32\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:2;s:4:\"Name\";s:18:\"20171213_bodybrain\";s:4:\"Hash\";s:32:\"14c6a9d352bb378e2463171213154832\";s:8:\"NameHash\";s:51:\"20171213_bodybrain_14c6a9d352bb378e2463171213154832\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:71:\"/home/staniecko/domains/testuj.website/public_html/bnb/wp-snapshots/tmp\";s:8:\"StoreURL\";s:39:\"http://bnb.testuj.website/wp-snapshots/\";s:8:\"ScanFile\";s:61:\"20171213_bodybrain_14c6a9d352bb378e2463171213154832_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":18:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:63:\"20171213_bodybrain_14c6a9d352bb378e2463171213154832_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:54:\"/home/staniecko/domains/testuj.website/public_html/bnb\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-12-13 15:48:32\";s:7:\"Version\";s:6:\"1.2.26\";s:9:\"VersionWP\";s:5:\"4.9.1\";s:9:\"VersionDB\";s:7:\"10.1.24\";s:10:\"VersionPHP\";s:6:\"5.6.32\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:18:\"20171213_bodybrain\";s:4:\"Hash\";s:32:\"14c6a9d352bb378e2463171213154832\";s:8:\"NameHash\";s:51:\"20171213_bodybrain_14c6a9d352bb378e2463171213154832\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:71:\"/home/staniecko/domains/testuj.website/public_html/bnb/wp-snapshots/tmp\";s:8:\"StoreURL\";s:39:\"http://bnb.testuj.website/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";s:65:\"20171213_bodybrain_14c6a9d352bb378e2463171213154832_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";r:57;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:64:\"20171213_bodybrain_14c6a9d352bb378e2463171213154832_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:63:\"/home/staniecko/domains/testuj.website/public_html/bnb/wp-admin\";i:1;s:73:\"/home/staniecko/domains/testuj.website/public_html/bnb/wp-content/uploads\";i:2;s:75:\"/home/staniecko/domains/testuj.website/public_html/bnb/wp-content/languages\";i:3;s:73:\"/home/staniecko/domains/testuj.website/public_html/bnb/wp-content/plugins\";i:4;s:72:\"/home/staniecko/domains/testuj.website/public_html/bnb/wp-content/themes\";i:5;s:66:\"/home/staniecko/domains/testuj.website/public_html/bnb/wp-includes\";}}s:9:\"Installer\";r:79;s:8:\"Database\";r:87;}");

/* INSERT TABLE DATA: wp_es_emaillist */
INSERT INTO `wp_es_emaillist` VALUES("1", "Admin", "vccw@example.com", "Confirmed", "2017-10-28 17:19:14", "0", "Public", "mkqecs-fpqstm-wovcng-fsrtoe-nyeihk");
INSERT INTO `wp_es_emaillist` VALUES("2", "Example", "a.example@example.com", "Confirmed", "2017-10-28 17:19:14", "0", "Public", "iaeuwf-dcsybf-wskqah-dxhaqz-ymohqn");

/* INSERT TABLE DATA: wp_es_notification */
INSERT INTO `wp_es_notification` VALUES("1", " ##Uncategorized## ", "Public", "106", "Enable");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "http://bnb.testuj.website", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "http://bnb.testuj.website", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "Body &amp; Brain", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "Body &amp; Brain", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "wordpress@bnb.testuj.website", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "12", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "M jS Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}postname{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:207:{s:31:\"wydarzenia/(\\d{4}-\\d{2}-\\d{2})$\";s:55:\"index.php?pagename=wydarzenia/&calendar_day=$matches[1]\";s:17:\"wydarzenia/rss/?$\";s:35:\"index.php?post_type=event&feed=feed\";s:18:\"wydarzenia/feed/?$\";s:35:\"index.php?post_type=event&feed=feed\";s:22:\"wydarzenia/event/(.+)$\";s:67:\"index.php?pagename=wydarzenia/&em_redirect=1&event_slug=$matches[1]\";s:25:\"wydarzenia/location/(.+)$\";s:70:\"index.php?pagename=wydarzenia/&em_redirect=1&location_slug=$matches[1]\";s:25:\"wydarzenia/category/(.+)$\";s:70:\"index.php?pagename=wydarzenia/&em_redirect=1&category_slug=$matches[1]\";s:13:\"wydarzenia/?$\";s:29:\"index.php?pagename=wydarzenia\";s:22:\"events/([^/]+)/ical/?$\";s:34:\"index.php?event=$matches[1]&ical=1\";s:25:\"locations/([^/]+)/ical/?$\";s:37:\"index.php?location=$matches[1]&ical=1\";s:33:\"events/categories/([^/]+)/ical/?$\";s:45:\"index.php?event-categories=$matches[1]&ical=1\";s:27:\"events/tags/([^/]+)/ical/?$\";s:39:\"index.php?event-tags=$matches[1]&ical=1\";s:24:\"locations/([^/]+)/rss/?$\";s:36:\"index.php?location=$matches[1]&rss=1\";s:9:\"opinie/?$\";s:32:\"index.php?post_type=testimonials\";s:39:\"opinie/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=testimonials&feed=$matches[1]\";s:34:\"opinie/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=testimonials&feed=$matches[1]\";s:26:\"opinie/page/([0-9]{1,})/?$\";s:50:\"index.php?post_type=testimonials&paged=$matches[1]\";s:12:\"locations/?$\";s:28:\"index.php?post_type=location\";s:42:\"locations/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=location&feed=$matches[1]\";s:37:\"locations/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=location&feed=$matches[1]\";s:29:\"locations/page/([0-9]{1,})/?$\";s:46:\"index.php?post_type=location&paged=$matches[1]\";s:9:\"events/?$\";s:25:\"index.php?post_type=event\";s:39:\"events/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=event&feed=$matches[1]\";s:34:\"events/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=event&feed=$matches[1]\";s:26:\"events/page/([0-9]{1,})/?$\";s:43:\"index.php?post_type=event&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:35:\"warsztaty/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"warsztaty/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"warsztaty/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"warsztaty/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"warsztaty/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"warsztaty/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"warsztaty/(.+?)/embed/?$\";s:42:\"index.php?warsztaty=$matches[1]&embed=true\";s:28:\"warsztaty/(.+?)/trackback/?$\";s:36:\"index.php?warsztaty=$matches[1]&tb=1\";s:36:\"warsztaty/(.+?)/page/?([0-9]{1,})/?$\";s:49:\"index.php?warsztaty=$matches[1]&paged=$matches[2]\";s:43:\"warsztaty/(.+?)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?warsztaty=$matches[1]&cpage=$matches[2]\";s:32:\"warsztaty/(.+?)(?:/([0-9]+))?/?$\";s:48:\"index.php?warsztaty=$matches[1]&page=$matches[2]\";s:34:\"opinie/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"opinie/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"opinie/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"opinie/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"opinie/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"opinie/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"opinie/([^/]+)/embed/?$\";s:45:\"index.php?testimonials=$matches[1]&embed=true\";s:27:\"opinie/([^/]+)/trackback/?$\";s:39:\"index.php?testimonials=$matches[1]&tb=1\";s:47:\"opinie/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?testimonials=$matches[1]&feed=$matches[2]\";s:42:\"opinie/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?testimonials=$matches[1]&feed=$matches[2]\";s:35:\"opinie/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?testimonials=$matches[1]&paged=$matches[2]\";s:42:\"opinie/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?testimonials=$matches[1]&cpage=$matches[2]\";s:31:\"opinie/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?testimonials=$matches[1]&page=$matches[2]\";s:23:\"opinie/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"opinie/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"opinie/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"opinie/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"opinie/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"opinie/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:52:\"events/tags/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?event-tags=$matches[1]&feed=$matches[2]\";s:47:\"events/tags/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?event-tags=$matches[1]&feed=$matches[2]\";s:28:\"events/tags/([^/]+)/embed/?$\";s:43:\"index.php?event-tags=$matches[1]&embed=true\";s:40:\"events/tags/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?event-tags=$matches[1]&paged=$matches[2]\";s:22:\"events/tags/([^/]+)/?$\";s:32:\"index.php?event-tags=$matches[1]\";s:56:\"events/categories/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?event-categories=$matches[1]&feed=$matches[2]\";s:51:\"events/categories/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?event-categories=$matches[1]&feed=$matches[2]\";s:32:\"events/categories/(.+?)/embed/?$\";s:49:\"index.php?event-categories=$matches[1]&embed=true\";s:44:\"events/categories/(.+?)/page/?([0-9]{1,})/?$\";s:56:\"index.php?event-categories=$matches[1]&paged=$matches[2]\";s:26:\"events/categories/(.+?)/?$\";s:38:\"index.php?event-categories=$matches[1]\";s:37:\"locations/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"locations/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"locations/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"locations/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"locations/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"locations/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"locations/([^/]+)/embed/?$\";s:41:\"index.php?location=$matches[1]&embed=true\";s:30:\"locations/([^/]+)/trackback/?$\";s:35:\"index.php?location=$matches[1]&tb=1\";s:50:\"locations/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?location=$matches[1]&feed=$matches[2]\";s:45:\"locations/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?location=$matches[1]&feed=$matches[2]\";s:38:\"locations/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?location=$matches[1]&paged=$matches[2]\";s:45:\"locations/([^/]+)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?location=$matches[1]&cpage=$matches[2]\";s:34:\"locations/([^/]+)(?:/([0-9]+))?/?$\";s:47:\"index.php?location=$matches[1]&page=$matches[2]\";s:26:\"locations/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"locations/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"locations/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"locations/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"locations/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"locations/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"events/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"events/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"events/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"events/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"events/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"events/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"events/([^/]+)/embed/?$\";s:38:\"index.php?event=$matches[1]&embed=true\";s:27:\"events/([^/]+)/trackback/?$\";s:32:\"index.php?event=$matches[1]&tb=1\";s:47:\"events/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?event=$matches[1]&feed=$matches[2]\";s:42:\"events/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?event=$matches[1]&feed=$matches[2]\";s:35:\"events/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?event=$matches[1]&paged=$matches[2]\";s:42:\"events/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?event=$matches[1]&cpage=$matches[2]\";s:31:\"events/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?event=$matches[1]&page=$matches[2]\";s:23:\"events/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"events/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"events/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"events/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"events/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"events/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"events-recurring/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"events-recurring/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"events-recurring/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"events-recurring/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"events-recurring/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"events-recurring/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"events-recurring/([^/]+)/embed/?$\";s:48:\"index.php?event-recurring=$matches[1]&embed=true\";s:37:\"events-recurring/([^/]+)/trackback/?$\";s:42:\"index.php?event-recurring=$matches[1]&tb=1\";s:45:\"events-recurring/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?event-recurring=$matches[1]&paged=$matches[2]\";s:52:\"events-recurring/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?event-recurring=$matches[1]&cpage=$matches[2]\";s:41:\"events-recurring/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?event-recurring=$matches[1]&page=$matches[2]\";s:33:\"events-recurring/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"events-recurring/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"events-recurring/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"events-recurring/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"events-recurring/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"events-recurring/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=15&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:10:{i:0;s:55:\"contact-form-7-datepicker/contact-form-7-datepicker.php\";i:1;s:36:\"contact-form-7/wp-contact-form-7.php\";i:2;s:23:\"debug-bar/debug-bar.php\";i:3;s:25:\"duplicator/duplicator.php\";i:4;s:62:\"featured-image-admin-thumb-fiat/featured-image-admin-thumb.php\";i:5;s:23:\"loco-translate/loco.php\";i:6;s:27:\"mail-subscribe-list/sml.php\";i:7;s:41:\"meta-box-show-hide/meta-box-show-hide.php\";i:8;s:21:\"meta-box/meta-box.php\";i:9;s:37:\"post-types-order/post-types-order.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:5:{i:0;s:93:\"/home/staniecko/domains/testuj.website/public_html/bnb/wp-content/themes/bodynbrain/style.css\";i:1;s:94:\"/home/staniecko/domains/testuj.website/public_html/bnb/wp-content/themes/bodynbrain/footer.php\";i:2;s:106:\"/home/staniecko/domains/testuj.website/public_html/bnb/wp-content/themes/bodynbrain/inc/theme_supports.php\";i:3;s:94:\"/home/staniecko/domains/testuj.website/public_html/bnb/wp-content/themes/bodynbrain/header.php\";i:4;s:115:\"/home/staniecko/domains/testuj.website/public_html/bnb/wp-content/themes/bodynbrain/inc/landing_page_meta_boxes.php\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "bodynbrain", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "bodynbrain", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_whitelist", "1", "yes");
INSERT INTO `wp_options` VALUES("43", "blacklist_keys", "", "no");
INSERT INTO `wp_options` VALUES("44", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("48", "db_version", "38590", "yes");
INSERT INTO `wp_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("73", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_text", "a:3:{i:2;a:4:{s:5:\"title\";s:22:\"Skontaktuj się z nami\";s:4:\"text\";s:294:\"Ola - <a href=\"tel:887 362 809\">887 362 809</a>\r\n\r\nPete - <a href=\"tel:536 238 346\">536 238 346</a>\r\n\r\nMail: <a href=\"mailto:centrum@bodynbrain.pl\">centrum@bodynbrain.pl</a>\r\n\r\nSkype: <a href=\"skype:oprach?add\">oprach</a>\r\n\r\nNr konta bankowego: 90 2490 0005 0000 4500 5187 2903 (Alior Bank)\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:3;a:4:{s:5:\"title\";s:13:\"NAPISZ DO NAS\";s:4:\"text\";s:40:\"[contact-form-7 id=\"67\" title=\"Kontakt\"]\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("81", "uninstall_plugins", "a:3:{s:26:\"easy-appointments/main.php\";a:2:{i:0;s:15:\"EasyAppointment\";i:1;s:9:\"uninstall\";}s:51:\"bookly-responsive-appointment-booking-tool/main.php\";a:2:{i:0;s:21:\"BooklyLite\\Lib\\Plugin\";i:1;s:9:\"uninstall\";}s:25:\"subscriber/subscriber.php\";s:17:\"sbscrbr_uninstall\";}", "no");
INSERT INTO `wp_options` VALUES("82", "timezone_string", "", "yes");
INSERT INTO `wp_options` VALUES("83", "page_for_posts", "274", "yes");
INSERT INTO `wp_options` VALUES("84", "page_on_front", "15", "yes");
INSERT INTO `wp_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("91", "initial_db_version", "38590", "yes");
INSERT INTO `wp_options` VALUES("92", "wp_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:85:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:14:\"publish_events\";b:1;s:20:\"delete_others_events\";b:1;s:18:\"edit_others_events\";b:1;s:22:\"manage_others_bookings\";b:1;s:24:\"publish_recurring_events\";b:1;s:30:\"delete_others_recurring_events\";b:1;s:28:\"edit_others_recurring_events\";b:1;s:17:\"publish_locations\";b:1;s:23:\"delete_others_locations\";b:1;s:16:\"delete_locations\";b:1;s:21:\"edit_others_locations\";b:1;s:23:\"delete_event_categories\";b:1;s:21:\"edit_event_categories\";b:1;s:15:\"manage_bookings\";b:1;s:19:\"upload_event_images\";b:1;s:13:\"delete_events\";b:1;s:11:\"edit_events\";b:1;s:19:\"read_private_events\";b:1;s:23:\"delete_recurring_events\";b:1;s:21:\"edit_recurring_events\";b:1;s:14:\"edit_locations\";b:1;s:22:\"read_private_locations\";b:1;s:21:\"read_others_locations\";b:1;s:10:\"loco_admin\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:57:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:14:\"publish_events\";b:1;s:20:\"delete_others_events\";b:1;s:18:\"edit_others_events\";b:1;s:22:\"manage_others_bookings\";b:1;s:24:\"publish_recurring_events\";b:1;s:30:\"delete_others_recurring_events\";b:1;s:28:\"edit_others_recurring_events\";b:1;s:17:\"publish_locations\";b:1;s:23:\"delete_others_locations\";b:1;s:16:\"delete_locations\";b:1;s:21:\"edit_others_locations\";b:1;s:23:\"delete_event_categories\";b:1;s:21:\"edit_event_categories\";b:1;s:15:\"manage_bookings\";b:1;s:19:\"upload_event_images\";b:1;s:13:\"delete_events\";b:1;s:11:\"edit_events\";b:1;s:19:\"read_private_events\";b:1;s:23:\"delete_recurring_events\";b:1;s:21:\"edit_recurring_events\";b:1;s:14:\"edit_locations\";b:1;s:22:\"read_private_locations\";b:1;s:21:\"read_others_locations\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:20:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:15:\"manage_bookings\";b:1;s:19:\"upload_event_images\";b:1;s:13:\"delete_events\";b:1;s:11:\"edit_events\";b:1;s:19:\"read_private_events\";b:1;s:23:\"delete_recurring_events\";b:1;s:21:\"edit_recurring_events\";b:1;s:14:\"edit_locations\";b:1;s:22:\"read_private_locations\";b:1;s:21:\"read_others_locations\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:15:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:15:\"manage_bookings\";b:1;s:19:\"upload_event_images\";b:1;s:13:\"delete_events\";b:1;s:11:\"edit_events\";b:1;s:19:\"read_private_events\";b:1;s:23:\"delete_recurring_events\";b:1;s:21:\"edit_recurring_events\";b:1;s:14:\"edit_locations\";b:1;s:22:\"read_private_locations\";b:1;s:21:\"read_others_locations\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:15:\"manage_bookings\";b:1;s:19:\"upload_event_images\";b:1;s:13:\"delete_events\";b:1;s:11:\"edit_events\";b:1;s:19:\"read_private_events\";b:1;s:23:\"delete_recurring_events\";b:1;s:21:\"edit_recurring_events\";b:1;s:14:\"edit_locations\";b:1;s:22:\"read_private_locations\";b:1;s:21:\"read_others_locations\";b:1;}}s:10:\"translator\";a:2:{s:4:\"name\";s:10:\"Translator\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:10:\"loco_admin\";b:1;}}s:18:\"sbscrbr_subscriber\";a:2:{s:4:\"name\";s:15:\"Mail Subscriber\";s:12:\"capabilities\";a:3:{s:4:\"read\";b:1;s:10:\"edit_posts\";b:0;s:12:\"delete_posts\";b:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("93", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("94", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("95", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("96", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("97", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("98", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("99", "sidebars_widgets", "a:5:{s:18:\"orphaned_widgets_1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:19:\"wp_inactive_widgets\";a:0:{}s:12:\"contact_left\";a:1:{i:0;s:6:\"text-2\";}s:13:\"contact_right\";a:1:{i:0;s:6:\"text-3\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("100", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("101", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("102", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("103", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("105", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("106", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "cron", "a:6:{i:1513190903;a:1:{s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1513204937;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1513248922;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1513249416;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1513266338;a:1:{s:29:\"newsletter_extension_versions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("109", "theme_mods_twentyseventeen", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1507200992;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("114", "WPLANG", "pl_PL", "yes");
INSERT INTO `wp_options` VALUES("126", "can_compress_scripts", "0", "no");
INSERT INTO `wp_options` VALUES("139", "current_theme", "Body\'n\'brain", "yes");
INSERT INTO `wp_options` VALUES("140", "theme_mods_bodynbrain", "a:3:{i:0;b:0;s:18:\"custom_css_post_id\";i:-1;s:18:\"nav_menu_locations\";a:2:{s:9:\"main_menu\";i:2;s:11:\"footer_menu\";i:2;}}", "yes");
INSERT INTO `wp_options` VALUES("141", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("147", "recently_activated", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("214", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("223", "wpcf7", "a:2:{s:7:\"version\";s:3:\"4.9\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1508184284;s:7:\"version\";s:3:\"4.9\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "yes");
INSERT INTO `wp_options` VALUES("238", "duplicator_version_plugin", "1.2.26", "yes");
INSERT INTO `wp_options` VALUES("241", "duplicator_settings", "a:10:{s:7:\"version\";s:6:\"1.2.26\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:20:\"storage_htaccess_off\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("285", "newsletter_logger_secret", "0ac160b3", "yes");
INSERT INTO `wp_options` VALUES("286", "newsletter_dismissed", "a:2:{s:6:\"wpmail\";i:1;s:15:\"newsletter-page\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("287", "newsletter_main_first_install_time", "1509205507", "no");
INSERT INTO `wp_options` VALUES("288", "newsletter_main", "a:13:{s:11:\"return_path\";N;s:8:\"reply_to\";N;s:12:\"sender_email\";s:29:\"newsletter@bnb.testuj.website\";s:11:\"sender_name\";s:12:\"Body\'n\'Brain\";s:6:\"editor\";s:1:\"0\";s:13:\"scheduler_max\";s:3:\"100\";s:9:\"phpmailer\";s:1:\"0\";s:7:\"api_key\";s:10:\"83ee65288d\";s:12:\"contract_key\";s:0:\"\";s:9:\"log_level\";s:1:\"0\";s:5:\"debug\";s:1:\"0\";s:3:\"css\";s:0:\"\";s:25:\"content_transfer_encoding\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("289", "newsletter_main_smtp", "a:7:{s:7:\"enabled\";i:0;s:4:\"host\";s:0:\"\";s:4:\"user\";s:0:\"\";s:4:\"pass\";s:0:\"\";s:4:\"port\";i:25;s:6:\"secure\";s:0:\"\";s:12:\"ssl_insecure\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("290", "newsletter_main_version", "1.3.2", "yes");
INSERT INTO `wp_options` VALUES("291", "newsletter_subscription_first_install_time", "1509205507", "no");
INSERT INTO `wp_options` VALUES("292", "newsletter", "a:31:{s:14:\"noconfirmation\";s:1:\"0\";s:9:\"antiflood\";s:2:\"10\";s:12:\"profile_text\";s:189:\"<p>{profile_form}</p>\r\n<p>If you change your email address, a confirmation email will be sent to activate it.</p>\r\n<p><a href=\"{unsubscription_confirm_url}\">Cancel your subscription</a></p>\";s:21:\"profile_email_changed\";s:123:\"Your email has been changed, an activation email has been sent. Please follow the instructions to activate the new address.\";s:13:\"profile_error\";s:147:\"Your email is not valid or already in use by another subscriber or another generic error has been found. Check your data or contact the site owner.\";s:10:\"error_text\";s:173:\"<p>This subscription can\'t be completed, sorry. The email address is blocked or already subscribed. You should contact the owner to unlock that email address. Thank you.</p>\";s:17:\"subscription_text\";s:26:\"<p>{subscription_form}</p>\";s:17:\"confirmation_text\";s:136:\"<p>Zapisałeś się do newslettera. Za kilka minut otrzymasz wiadomość, która zawierać będzie link potwierdzający zapisanie. </p>\";s:20:\"confirmation_subject\";s:38:\"Potwierdź subskrypcję - {blog_title}\";s:21:\"confirmation_tracking\";s:0:\"\";s:20:\"confirmation_message\";s:670:\"<p>Witaj na mojej liście mailingowej,</p>\r\n<p>Aby dokończyć rejestrację kliknij w poniższy link lub wklej go bezpośrednio do paska adresu przeglądarki.<br /><br /><a href=\"{subscription_confirm_url}\"><strong>{subscription_confirm_url}</strong></a><br /><br /></p>\r\n<p>Jeśli masz jakieś uwagi lub pytania prześlij je do mnie. Z pewnością na nie odpowiem.</p>\r\n<p>Jeśli chcesz się wypisać z newslettera kliknij  <a href=\"{unsubscription_url}\"><strong>{unsubscription_url}</strong></a> </p>\r\n<p>Pozdrawiam,<br />Ola Mason</p>\r\n<p>Zignoruj tę wiadomość jeśli to nie Ty zapisałeś/aś się na moją listę.<br /> <a href=\"{blog_url}\">{blog_url}</a></p>\";s:14:\"confirmed_text\";s:115:\"<p>Witaj,</p>\r\n<p>Twoja subskrypcja została potwierdzona.</p>\r\n<p>Pozdrawiam<br />Ola Mason</p>\r\n<p>{blog_url}</p>\";s:17:\"confirmed_subject\";s:22:\"Welcome aboard, {name}\";s:17:\"confirmed_message\";s:280:\"<p>This message confirms your subscription to the {blog_title} newsletter.</p>\r\n<p>Thank you!<br /> <a href=\"{blog_url}\">{blog_url}</a></p>\r\n<p>To unsubscribe, <a href=\"{unsubscription_url}\">click here</a>. To change subscriber options, <a href=\"{profile_url}\">click here</a>.</p>\";s:18:\"confirmed_tracking\";s:0:\"\";s:19:\"unsubscription_text\";s:111:\"<p>Please confirm that you want to unsubscribe by <a href=\'{unsubscription_confirm_url}\'>clicking here</a>.</p>\";s:25:\"unsubscription_error_text\";s:118:\"<p>The subscriber was not found, it probably has already been removed. No further actions are required. Thank you.</p>\";s:17:\"unsubscribed_text\";s:53:\"<p>Your subscription has been deleted. Thank you.</p>\";s:20:\"unsubscribed_subject\";s:8:\"Goodbye!\";s:20:\"unsubscribed_message\";s:195:\"<p>This message confirms that you have unsubscribed from the {blog_title} newsletter.</p>\n<p>You\'re welcome to sign up again anytime.</p>\n<p>Thank you!<br>\n<a href=\'{blog_url}\'>{blog_url}</a></p>\";s:4:\"page\";s:3:\"103\";s:6:\"notify\";s:1:\"1\";s:12:\"notify_email\";s:21:\"centrum@bodynbrain.pl\";s:3:\"css\";s:0:\"\";s:15:\"antibot_disable\";s:1:\"0\";s:16:\"confirmation_url\";s:0:\"\";s:13:\"confirmed_url\";s:0:\"\";s:18:\"confirmed_disabled\";s:1:\"1\";s:11:\"profile_url\";s:0:\"\";s:13:\"profile_saved\";s:0:\"\";s:3:\"url\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("293", "newsletter_profile", "a:206:{s:5:\"email\";s:18:\"Twój adres e-mail\";s:11:\"email_error\";s:25:\"Adres jest nieprawidłowy\";s:4:\"name\";s:22:\"Twoje imię i nazwisko\";s:10:\"name_error\";s:15:\"Uzupełnij pole\";s:11:\"name_status\";s:1:\"2\";s:10:\"name_rules\";s:1:\"1\";s:7:\"surname\";s:9:\"Last name\";s:13:\"surname_error\";s:28:\"The last name is not correct\";s:14:\"surname_status\";s:1:\"0\";s:10:\"sex_status\";s:1:\"0\";s:3:\"sex\";s:3:\"I\'m\";s:7:\"privacy\";s:100:\"Oświadczam, iż zapoznałem się z Polityką Prywatności i akceptuję jej wszystkie postanowienia.\";s:13:\"privacy_error\";s:78:\"Aby zapisać się do newslettera musisz zaakceptować politykę prywatności.\";s:14:\"privacy_status\";s:1:\"1\";s:11:\"privacy_url\";s:21:\"/polityka-prywatnosci\";s:9:\"subscribe\";s:15:\"Zapisuje się >\";s:4:\"save\";s:6:\"Zapisz\";s:12:\"title_female\";s:4:\"Mrs.\";s:10:\"title_male\";s:3:\"Mr.\";s:10:\"title_none\";s:4:\"Dear\";s:8:\"sex_male\";s:3:\"Man\";s:10:\"sex_female\";s:5:\"Woman\";s:8:\"sex_none\";s:4:\"None\";s:6:\"list_1\";s:0:\"\";s:13:\"list_1_status\";i:0;s:14:\"list_1_checked\";i:0;s:6:\"list_2\";s:0:\"\";s:13:\"list_2_status\";i:0;s:14:\"list_2_checked\";i:0;s:6:\"list_3\";s:0:\"\";s:13:\"list_3_status\";i:0;s:14:\"list_3_checked\";i:0;s:6:\"list_4\";s:0:\"\";s:13:\"list_4_status\";i:0;s:14:\"list_4_checked\";i:0;s:6:\"list_5\";s:0:\"\";s:13:\"list_5_status\";i:0;s:14:\"list_5_checked\";i:0;s:6:\"list_6\";s:0:\"\";s:13:\"list_6_status\";i:0;s:14:\"list_6_checked\";i:0;s:6:\"list_7\";s:0:\"\";s:13:\"list_7_status\";i:0;s:14:\"list_7_checked\";i:0;s:6:\"list_8\";s:0:\"\";s:13:\"list_8_status\";i:0;s:14:\"list_8_checked\";i:0;s:6:\"list_9\";s:0:\"\";s:13:\"list_9_status\";i:0;s:14:\"list_9_checked\";i:0;s:7:\"list_10\";s:0:\"\";s:14:\"list_10_status\";i:0;s:15:\"list_10_checked\";i:0;s:7:\"list_11\";s:0:\"\";s:14:\"list_11_status\";i:0;s:15:\"list_11_checked\";i:0;s:7:\"list_12\";s:0:\"\";s:14:\"list_12_status\";i:0;s:15:\"list_12_checked\";i:0;s:7:\"list_13\";s:0:\"\";s:14:\"list_13_status\";i:0;s:15:\"list_13_checked\";i:0;s:7:\"list_14\";s:0:\"\";s:14:\"list_14_status\";i:0;s:15:\"list_14_checked\";i:0;s:7:\"list_15\";s:0:\"\";s:14:\"list_15_status\";i:0;s:15:\"list_15_checked\";i:0;s:7:\"list_16\";s:0:\"\";s:14:\"list_16_status\";i:0;s:15:\"list_16_checked\";i:0;s:7:\"list_17\";s:0:\"\";s:14:\"list_17_status\";i:0;s:15:\"list_17_checked\";i:0;s:7:\"list_18\";s:0:\"\";s:14:\"list_18_status\";i:0;s:15:\"list_18_checked\";i:0;s:7:\"list_19\";s:0:\"\";s:14:\"list_19_status\";i:0;s:15:\"list_19_checked\";i:0;s:7:\"list_20\";s:0:\"\";s:14:\"list_20_status\";i:0;s:15:\"list_20_checked\";i:0;s:16:\"profile_1_status\";s:1:\"0\";s:9:\"profile_1\";s:0:\"\";s:14:\"profile_1_type\";s:4:\"text\";s:21:\"profile_1_placeholder\";s:0:\"\";s:15:\"profile_1_rules\";s:1:\"0\";s:17:\"profile_1_options\";s:0:\"\";s:16:\"profile_2_status\";s:1:\"0\";s:9:\"profile_2\";s:0:\"\";s:14:\"profile_2_type\";s:4:\"text\";s:21:\"profile_2_placeholder\";s:0:\"\";s:15:\"profile_2_rules\";s:1:\"0\";s:17:\"profile_2_options\";s:0:\"\";s:16:\"profile_3_status\";s:1:\"0\";s:9:\"profile_3\";s:0:\"\";s:14:\"profile_3_type\";s:4:\"text\";s:21:\"profile_3_placeholder\";s:0:\"\";s:15:\"profile_3_rules\";s:1:\"0\";s:17:\"profile_3_options\";s:0:\"\";s:16:\"profile_4_status\";s:1:\"0\";s:9:\"profile_4\";s:0:\"\";s:14:\"profile_4_type\";s:4:\"text\";s:21:\"profile_4_placeholder\";s:0:\"\";s:15:\"profile_4_rules\";s:1:\"0\";s:17:\"profile_4_options\";s:0:\"\";s:16:\"profile_5_status\";s:1:\"0\";s:9:\"profile_5\";s:0:\"\";s:14:\"profile_5_type\";s:4:\"text\";s:21:\"profile_5_placeholder\";s:0:\"\";s:15:\"profile_5_rules\";s:1:\"0\";s:17:\"profile_5_options\";s:0:\"\";s:16:\"profile_6_status\";s:1:\"0\";s:9:\"profile_6\";s:0:\"\";s:14:\"profile_6_type\";s:4:\"text\";s:21:\"profile_6_placeholder\";s:0:\"\";s:15:\"profile_6_rules\";s:1:\"0\";s:17:\"profile_6_options\";s:0:\"\";s:16:\"profile_7_status\";s:1:\"0\";s:9:\"profile_7\";s:0:\"\";s:14:\"profile_7_type\";s:4:\"text\";s:21:\"profile_7_placeholder\";s:0:\"\";s:15:\"profile_7_rules\";s:1:\"0\";s:17:\"profile_7_options\";s:0:\"\";s:16:\"profile_8_status\";s:1:\"0\";s:9:\"profile_8\";s:0:\"\";s:14:\"profile_8_type\";s:4:\"text\";s:21:\"profile_8_placeholder\";s:0:\"\";s:15:\"profile_8_rules\";s:1:\"0\";s:17:\"profile_8_options\";s:0:\"\";s:16:\"profile_9_status\";s:1:\"0\";s:9:\"profile_9\";s:0:\"\";s:14:\"profile_9_type\";s:4:\"text\";s:21:\"profile_9_placeholder\";s:0:\"\";s:15:\"profile_9_rules\";s:1:\"0\";s:17:\"profile_9_options\";s:0:\"\";s:17:\"profile_10_status\";s:1:\"0\";s:10:\"profile_10\";s:0:\"\";s:15:\"profile_10_type\";s:4:\"text\";s:22:\"profile_10_placeholder\";s:0:\"\";s:16:\"profile_10_rules\";s:1:\"0\";s:18:\"profile_10_options\";s:0:\"\";s:17:\"profile_11_status\";s:1:\"0\";s:10:\"profile_11\";s:0:\"\";s:15:\"profile_11_type\";s:4:\"text\";s:22:\"profile_11_placeholder\";s:0:\"\";s:16:\"profile_11_rules\";s:1:\"0\";s:18:\"profile_11_options\";s:0:\"\";s:17:\"profile_12_status\";s:1:\"0\";s:10:\"profile_12\";s:0:\"\";s:15:\"profile_12_type\";s:4:\"text\";s:22:\"profile_12_placeholder\";s:0:\"\";s:16:\"profile_12_rules\";s:1:\"0\";s:18:\"profile_12_options\";s:0:\"\";s:17:\"profile_13_status\";s:1:\"0\";s:10:\"profile_13\";s:0:\"\";s:15:\"profile_13_type\";s:4:\"text\";s:22:\"profile_13_placeholder\";s:0:\"\";s:16:\"profile_13_rules\";s:1:\"0\";s:18:\"profile_13_options\";s:0:\"\";s:17:\"profile_14_status\";s:1:\"0\";s:10:\"profile_14\";s:0:\"\";s:15:\"profile_14_type\";s:4:\"text\";s:22:\"profile_14_placeholder\";s:0:\"\";s:16:\"profile_14_rules\";s:1:\"0\";s:18:\"profile_14_options\";s:0:\"\";s:17:\"profile_15_status\";s:1:\"0\";s:10:\"profile_15\";s:0:\"\";s:15:\"profile_15_type\";s:4:\"text\";s:22:\"profile_15_placeholder\";s:0:\"\";s:16:\"profile_15_rules\";s:1:\"0\";s:18:\"profile_15_options\";s:0:\"\";s:17:\"profile_16_status\";s:1:\"0\";s:10:\"profile_16\";s:0:\"\";s:15:\"profile_16_type\";s:4:\"text\";s:22:\"profile_16_placeholder\";s:0:\"\";s:16:\"profile_16_rules\";s:1:\"0\";s:18:\"profile_16_options\";s:0:\"\";s:17:\"profile_17_status\";s:1:\"0\";s:10:\"profile_17\";s:0:\"\";s:15:\"profile_17_type\";s:4:\"text\";s:22:\"profile_17_placeholder\";s:0:\"\";s:16:\"profile_17_rules\";s:1:\"0\";s:18:\"profile_17_options\";s:0:\"\";s:17:\"profile_18_status\";s:1:\"0\";s:10:\"profile_18\";s:0:\"\";s:15:\"profile_18_type\";s:4:\"text\";s:22:\"profile_18_placeholder\";s:0:\"\";s:16:\"profile_18_rules\";s:1:\"0\";s:18:\"profile_18_options\";s:0:\"\";s:17:\"profile_19_status\";s:1:\"0\";s:10:\"profile_19\";s:0:\"\";s:15:\"profile_19_type\";s:4:\"text\";s:22:\"profile_19_placeholder\";s:0:\"\";s:16:\"profile_19_rules\";s:1:\"0\";s:18:\"profile_19_options\";s:0:\"\";s:17:\"profile_20_status\";s:1:\"0\";s:10:\"profile_20\";s:0:\"\";s:15:\"profile_20_type\";s:4:\"text\";s:22:\"profile_20_placeholder\";s:0:\"\";s:16:\"profile_20_rules\";s:1:\"0\";s:18:\"profile_20_options\";s:0:\"\";s:13:\"surname_rules\";s:1:\"0\";s:9:\"sex_rules\";s:1:\"0\";s:13:\"profile_error\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("294", "newsletter_subscription_lists", "a:60:{s:6:\"list_1\";s:0:\"\";s:13:\"list_1_status\";i:0;s:14:\"list_1_checked\";i:0;s:6:\"list_2\";s:0:\"\";s:13:\"list_2_status\";i:0;s:14:\"list_2_checked\";i:0;s:6:\"list_3\";s:0:\"\";s:13:\"list_3_status\";i:0;s:14:\"list_3_checked\";i:0;s:6:\"list_4\";s:0:\"\";s:13:\"list_4_status\";i:0;s:14:\"list_4_checked\";i:0;s:6:\"list_5\";s:0:\"\";s:13:\"list_5_status\";i:0;s:14:\"list_5_checked\";i:0;s:6:\"list_6\";s:0:\"\";s:13:\"list_6_status\";i:0;s:14:\"list_6_checked\";i:0;s:6:\"list_7\";s:0:\"\";s:13:\"list_7_status\";i:0;s:14:\"list_7_checked\";i:0;s:6:\"list_8\";s:0:\"\";s:13:\"list_8_status\";i:0;s:14:\"list_8_checked\";i:0;s:6:\"list_9\";s:0:\"\";s:13:\"list_9_status\";i:0;s:14:\"list_9_checked\";i:0;s:7:\"list_10\";s:0:\"\";s:14:\"list_10_status\";i:0;s:15:\"list_10_checked\";i:0;s:7:\"list_11\";s:0:\"\";s:14:\"list_11_status\";i:0;s:15:\"list_11_checked\";i:0;s:7:\"list_12\";s:0:\"\";s:14:\"list_12_status\";i:0;s:15:\"list_12_checked\";i:0;s:7:\"list_13\";s:0:\"\";s:14:\"list_13_status\";i:0;s:15:\"list_13_checked\";i:0;s:7:\"list_14\";s:0:\"\";s:14:\"list_14_status\";i:0;s:15:\"list_14_checked\";i:0;s:7:\"list_15\";s:0:\"\";s:14:\"list_15_status\";i:0;s:15:\"list_15_checked\";i:0;s:7:\"list_16\";s:0:\"\";s:14:\"list_16_status\";i:0;s:15:\"list_16_checked\";i:0;s:7:\"list_17\";s:0:\"\";s:14:\"list_17_status\";i:0;s:15:\"list_17_checked\";i:0;s:7:\"list_18\";s:0:\"\";s:14:\"list_18_status\";i:0;s:15:\"list_18_checked\";i:0;s:7:\"list_19\";s:0:\"\";s:14:\"list_19_status\";i:0;s:15:\"list_19_checked\";i:0;s:7:\"list_20\";s:0:\"\";s:14:\"list_20_status\";i:0;s:15:\"list_20_checked\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("295", "newsletter_subscription_template", "a:2:{s:7:\"enabled\";i:0;s:8:\"template\";s:1846:\"<!DOCTYPE html>\n<html>\n    <head>\n        <!-- General styles, not used by all email clients -->\n        <style type=\"text/css\" media=\"all\">\n            a {\n                text-decoration: none;\n                color: #0088cc;\n            }\n        </style>\n    </head>\n    \n    <!-- KEEP THE TAMPLE SIMPLE: THOSE ARE SERVICE MESSAGES. -->\n    <body style=\"margin: 0;\">\n        <!-- Top title with dark background #333, font color #fff, font size 32px -->\n        <table style=\"background-color: #333; width: 100{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}; color: #fff; font-size: 32px\">\n            <tr>\n                <td style=\"padding: 25px; text-align: center\">\n                    {blog_title}\n                </td>\n            </tr>\n        </table>\n\n        <!-- Main table 100{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77} wide with background color #eee -->    \n        <table style=\"background-color: #eee; width: 100{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77};\">\n            <tr>\n                <td align=\"center\"  style=\"padding: 15px;\">\n\n                    <!-- Content table with backgdound color #fff, width 500px -->\n                    <table style=\"background-color: #fff; max-width: 600px; width: 100{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}; border: 1px solid #ddd;\">\n                        <tr>\n                            <td style=\"padding: 15px; font-size: 16px; font-family: sans-serif\">\n                                <!-- The {message} tag is replaced with one of confirmation, welcome or goodbye messages -->\n                                <!-- Messages content can be configured on Newsletter List Building panels --> \n\n                                {message}\n                                \n                                <!-- Signature if not already added to single messages (surround with <p>) -->\n\n                            </td>\n                        </tr>\n                    </table>\n\n                </td>\n            </tr>\n        </table>\n\n    </body>\n</html>\";}", "no");
INSERT INTO `wp_options` VALUES("296", "newsletter_subscription_version", "2.0.3", "yes");
INSERT INTO `wp_options` VALUES("297", "newsletter_emails_first_install_time", "1509205507", "no");
INSERT INTO `wp_options` VALUES("298", "newsletter_emails", "a:1:{s:5:\"theme\";s:7:\"default\";}", "yes");
INSERT INTO `wp_options` VALUES("299", "newsletter_emails_theme_default", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("300", "newsletter_emails_version", "1.1.5", "yes");
INSERT INTO `wp_options` VALUES("301", "newsletter_users_first_install_time", "1509205508", "no");
INSERT INTO `wp_options` VALUES("302", "newsletter_users", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("303", "newsletter_users_version", "1.1.4", "yes");
INSERT INTO `wp_options` VALUES("304", "newsletter_statistics_first_install_time", "1509205508", "no");
INSERT INTO `wp_options` VALUES("305", "newsletter_statistics", "a:1:{s:3:\"key\";s:32:\"696c484feea9b0e758ea19af32919342\";}", "yes");
INSERT INTO `wp_options` VALUES("306", "newsletter_statistics_version", "1.1.8", "yes");
INSERT INTO `wp_options` VALUES("307", "newsletter_install_time", "1509205508", "no");
INSERT INTO `wp_options` VALUES("308", "widget_newsletterwidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("309", "widget_newsletterwidgetminimal", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("312", "newsletter_diagnostic_cron_calls", "a:100:{i:0;i:1509206144;i:1;i:1509206494;i:2;i:1509206774;i:3;i:1509207073;i:4;i:1509207364;i:5;i:1509207638;i:6;i:1509208000;i:7;i:1509208242;i:8;i:1509208538;i:9;i:1509208841;i:10;i:1509209205;i:11;i:1509209447;i:12;i:1509209808;i:13;i:1509210050;i:14;i:1509210359;i:15;i:1509210670;i:16;i:1509210949;i:17;i:1509211280;i:18;i:1509211577;i:19;i:1509270460;i:20;i:1509270460;i:21;i:1509270640;i:22;i:1509270940;i:23;i:1509271291;i:24;i:1509271379;i:25;i:1509271569;i:26;i:1509271874;i:27;i:1509272237;i:28;i:1509272459;i:29;i:1509272778;i:30;i:1509273074;i:31;i:1509281106;i:32;i:1509281118;i:33;i:1509281180;i:34;i:1509281473;i:35;i:1509281740;i:36;i:1509282054;i:37;i:1509282360;i:38;i:1509282659;i:39;i:1509282941;i:40;i:1509283161;i:41;i:1509283247;i:42;i:1509283539;i:43;i:1509283843;i:44;i:1509284164;i:45;i:1509284464;i:46;i:1509284750;i:47;i:1509285058;i:48;i:1509285342;i:49;i:1509285648;i:50;i:1509285951;i:51;i:1509286275;i:52;i:1509286539;i:53;i:1509286842;i:54;i:1509287141;i:55;i:1509287444;i:56;i:1509287745;i:57;i:1509288045;i:58;i:1509288354;i:59;i:1509288647;i:60;i:1509288975;i:61;i:1509289349;i:62;i:1509289539;i:63;i:1509289839;i:64;i:1509290141;i:65;i:1509290451;i:66;i:1510156852;i:67;i:1510157183;i:68;i:1510157443;i:69;i:1510157797;i:70;i:1510158096;i:71;i:1510158338;i:72;i:1510158724;i:73;i:1510158970;i:74;i:1510159291;i:75;i:1510159554;i:76;i:1510159860;i:77;i:1510160149;i:78;i:1510160452;i:79;i:1510160739;i:80;i:1510161050;i:81;i:1510161338;i:82;i:1510161654;i:83;i:1510162034;i:84;i:1510162275;i:85;i:1510162615;i:86;i:1510162857;i:87;i:1510163220;i:88;i:1510163462;i:89;i:1510163825;i:90;i:1510164067;i:91;i:1510164430;i:92;i:1510164652;i:93;i:1510164942;i:94;i:1510165239;i:95;i:1510165551;i:96;i:1510165868;i:97;i:1510166149;i:98;i:1510166451;i:99;i:1510166740;}", "no");
INSERT INTO `wp_options` VALUES("315", "newsletter_main_log_level", "0", "yes");
INSERT INTO `wp_options` VALUES("316", "newsletter_log_level", "0", "yes");
INSERT INTO `wp_options` VALUES("317", "newsletter_extension_versions", "a:30:{i:0;O:8:\"stdClass\":2:{s:2:\"id\";s:2:\"23\";s:7:\"version\";s:5:\"2.0.0\";}i:1;O:8:\"stdClass\":2:{s:2:\"id\";s:2:\"48\";s:7:\"version\";s:5:\"4.1.4\";}i:2;O:8:\"stdClass\":2:{s:2:\"id\";s:2:\"50\";s:7:\"version\";s:5:\"4.1.6\";}i:3;O:8:\"stdClass\":2:{s:2:\"id\";s:2:\"49\";s:7:\"version\";s:5:\"4.0.0\";}i:4;O:8:\"stdClass\":2:{s:2:\"id\";s:2:\"51\";s:7:\"version\";s:5:\"4.1.0\";}i:5;O:8:\"stdClass\":2:{s:2:\"id\";s:2:\"52\";s:7:\"version\";s:5:\"4.0.3\";}i:6;O:8:\"stdClass\":2:{s:2:\"id\";s:2:\"53\";s:7:\"version\";s:5:\"2.2.0\";}i:7;O:8:\"stdClass\":2:{s:2:\"id\";s:2:\"58\";s:7:\"version\";s:5:\"4.0.1\";}i:8;O:8:\"stdClass\":2:{s:2:\"id\";s:2:\"54\";s:7:\"version\";s:5:\"4.0.5\";}i:9;O:8:\"stdClass\":2:{s:2:\"id\";s:2:\"55\";s:7:\"version\";s:5:\"4.0.3\";}i:10;O:8:\"stdClass\":2:{s:2:\"id\";s:2:\"56\";s:7:\"version\";s:5:\"2.2.0\";}i:11;O:8:\"stdClass\":2:{s:2:\"id\";s:2:\"59\";s:7:\"version\";s:5:\"2.0.0\";}i:12;O:8:\"stdClass\":2:{s:2:\"id\";s:2:\"60\";s:7:\"version\";s:5:\"1.1.0\";}i:13;O:8:\"stdClass\":2:{s:2:\"id\";s:2:\"61\";s:7:\"version\";s:5:\"4.0.9\";}i:14;O:8:\"stdClass\":2:{s:2:\"id\";s:2:\"62\";s:7:\"version\";s:5:\"4.1.6\";}i:15;O:8:\"stdClass\":2:{s:2:\"id\";s:2:\"63\";s:7:\"version\";s:5:\"1.2.2\";}i:16;O:8:\"stdClass\":2:{s:2:\"id\";s:2:\"64\";s:7:\"version\";s:9:\"2.0.0 pro\";}i:17;O:8:\"stdClass\":2:{s:2:\"id\";s:2:\"65\";s:7:\"version\";s:5:\"4.0.5\";}i:18;O:8:\"stdClass\":2:{s:2:\"id\";s:2:\"66\";s:7:\"version\";s:5:\"1.0.2\";}i:19;O:8:\"stdClass\":2:{s:2:\"id\";s:2:\"67\";s:7:\"version\";s:5:\"1.0.4\";}i:20;O:8:\"stdClass\":2:{s:2:\"id\";s:2:\"69\";s:7:\"version\";s:5:\"1.0.1\";}i:21;O:8:\"stdClass\":2:{s:2:\"id\";s:2:\"68\";s:7:\"version\";s:5:\"1.0.2\";}i:22;O:8:\"stdClass\":2:{s:2:\"id\";s:2:\"70\";s:7:\"version\";s:5:\"1.0.4\";}i:23;O:8:\"stdClass\":2:{s:2:\"id\";s:2:\"71\";s:7:\"version\";s:5:\"1.0.2\";}i:24;O:8:\"stdClass\":2:{s:2:\"id\";s:2:\"72\";s:7:\"version\";s:5:\"1.0.1\";}i:25;O:8:\"stdClass\":2:{s:2:\"id\";s:2:\"73\";s:7:\"version\";s:5:\"1.0.4\";}i:26;O:8:\"stdClass\":2:{s:2:\"id\";s:2:\"74\";s:7:\"version\";s:5:\"1.0.0\";}i:27;O:8:\"stdClass\":2:{s:2:\"id\";s:2:\"75\";s:7:\"version\";s:5:\"1.0.3\";}i:28;O:8:\"stdClass\":2:{s:2:\"id\";s:2:\"76\";s:7:\"version\";s:5:\"1.0.1\";}i:29;O:8:\"stdClass\":2:{s:2:\"id\";s:2:\"77\";s:7:\"version\";s:5:\"1.0.0\";}}", "no");
INSERT INTO `wp_options` VALUES("376", "email-subscribers", "2.9", "yes");
INSERT INTO `wp_options` VALUES("377", "ig_es_fromname", "Body &amp; Brain", "yes");
INSERT INTO `wp_options` VALUES("378", "ig_es_fromemail", "vccw@example.com", "yes");
INSERT INTO `wp_options` VALUES("379", "ig_es_emailtype", "WP HTML MAIL", "yes");
INSERT INTO `wp_options` VALUES("380", "ig_es_notifyadmin", "YES", "yes");
INSERT INTO `wp_options` VALUES("381", "ig_es_adminemail", "vccw@example.com", "yes");
INSERT INTO `wp_options` VALUES("382", "ig_es_admin_new_sub_subject", "Body &amp; Brain - New email subscription", "yes");
INSERT INTO `wp_options` VALUES("383", "ig_es_admin_new_sub_content", "Hi Admin,\r\n\r\nCongratulations! You have a new subscriber.\r\n\r\nName : {{NAME}}\r\nEmail: {{EMAIL}}\r\nGroup: {{GROUP}}\r\n\r\nHave a nice day :)\r\nBody &amp; Brain", "yes");
INSERT INTO `wp_options` VALUES("384", "ig_es_welcomeemail", "YES", "yes");
INSERT INTO `wp_options` VALUES("385", "ig_es_welcomesubject", "Body &amp; Brain - Welcome!", "yes");
INSERT INTO `wp_options` VALUES("386", "ig_es_welcomecontent", "Hi {{NAME}},\r\n\r\nThank you for subscribing to Body &amp; Brain.\r\n\r\nWe are glad to have you onboard.\r\n\r\nBest,\r\nBody &amp; Brain\r\n\r\nGot subscribed to Body &amp; Brain by mistake? Click <a href=\'{{LINK}}\'>here</a> to unsubscribe.", "yes");
INSERT INTO `wp_options` VALUES("387", "ig_es_optintype", "Double Opt In", "yes");
INSERT INTO `wp_options` VALUES("388", "ig_es_confirmsubject", "Body &amp; Brain - Please confirm your subscription", "yes");
INSERT INTO `wp_options` VALUES("389", "ig_es_confirmcontent", "Hi {{NAME}},\r\n\r\nWe have received a subscription request from this email address. Please confirm it by <a href=\'{{LINK}}\'>clicking here</a>.\r\n\r\nIf you still cannot subscribe, please copy this link and paste it in your browser :\r\n{{LINK}} \r\n\r\nThank You\r\nBody &amp; Brain", "yes");
INSERT INTO `wp_options` VALUES("390", "ig_es_optinlink", "http://bnb.testuj.website/?es=optin&db={{DBID}}&email={{EMAIL}}&guid={{GUID}}", "yes");
INSERT INTO `wp_options` VALUES("391", "ig_es_unsublink", "http://bnb.testuj.website/?es=unsubscribe&db={{DBID}}&email={{EMAIL}}&guid={{GUID}}", "yes");
INSERT INTO `wp_options` VALUES("392", "ig_es_unsubcontent", "No longer interested in emails from Body &amp; Brain?. Please <a href=\'{{LINK}}\'>click here</a> to unsubscribe", "yes");
INSERT INTO `wp_options` VALUES("393", "ig_es_unsubtext", "Thank You, You have been successfully unsubscribed. You will no longer hear from us.", "yes");
INSERT INTO `wp_options` VALUES("394", "ig_es_successmsg", "You have been successfully subscribed.", "yes");
INSERT INTO `wp_options` VALUES("395", "ig_es_suberror", "Oops.. Your request couldn\'t be completed. This email address seems to be already subscribed / blocked.", "yes");
INSERT INTO `wp_options` VALUES("396", "ig_es_unsuberror", "Oops.. There was some technical error. Please try again later or contact us.", "yes");
INSERT INTO `wp_options` VALUES("397", "ig_es_sample_data_imported", "yes", "yes");
INSERT INTO `wp_options` VALUES("400", "widget_email-subscribers", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("401", "ig_es_sync_wp_users", "s:4:\"b:0;\";", "yes");
INSERT INTO `wp_options` VALUES("402", "current_sa_email_subscribers_db_version", "3.4.0", "yes");
INSERT INTO `wp_options` VALUES("403", "ig_es_update_v_3_3_4_date", "2017-10-28", "yes");
INSERT INTO `wp_options` VALUES("422", "booking_activation_process", "Off", "yes");
INSERT INTO `wp_options` VALUES("423", "booking_admin_cal_count", "2", "yes");
INSERT INTO `wp_options` VALUES("424", "booking_skin", "/css/skins/traditional.css", "yes");
INSERT INTO `wp_options` VALUES("425", "booking_num_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("426", "booking_sort_order", "", "yes");
INSERT INTO `wp_options` VALUES("427", "booking_default_toolbar_tab", "filter", "yes");
INSERT INTO `wp_options` VALUES("428", "booking_listing_default_view_mode", "vm_calendar", "yes");
INSERT INTO `wp_options` VALUES("429", "booking_view_days_num", "90", "yes");
INSERT INTO `wp_options` VALUES("430", "booking_max_monthes_in_calendar", "1y", "yes");
INSERT INTO `wp_options` VALUES("431", "booking_client_cal_count", "1", "yes");
INSERT INTO `wp_options` VALUES("432", "booking_start_day_weeek", "0", "yes");
INSERT INTO `wp_options` VALUES("433", "booking_title_after_reservation", "Dziękujemy za rezerwację.  Wyślemy potwierdzenie twojej resjestracji najszybciej jak to możliwe.", "yes");
INSERT INTO `wp_options` VALUES("434", "booking_title_after_reservation_time", "7000", "yes");
INSERT INTO `wp_options` VALUES("435", "booking_type_of_thank_you_message", "message", "yes");
INSERT INTO `wp_options` VALUES("436", "booking_thank_you_page_URL", "/thank-you", "yes");
INSERT INTO `wp_options` VALUES("437", "booking_is_use_autofill_4_logged_user", "Off", "yes");
INSERT INTO `wp_options` VALUES("438", "booking_date_format", "M jS Y", "yes");
INSERT INTO `wp_options` VALUES("439", "booking_date_view_type", "short", "yes");
INSERT INTO `wp_options` VALUES("440", "booking_is_delete_if_deactive", "Off", "yes");
INSERT INTO `wp_options` VALUES("441", "booking_dif_colors_approval_pending", "On", "yes");
INSERT INTO `wp_options` VALUES("442", "booking_is_use_hints_at_admin_panel", "On", "yes");
INSERT INTO `wp_options` VALUES("443", "booking_is_not_load_bs_script_in_client", "Off", "yes");
INSERT INTO `wp_options` VALUES("444", "booking_is_not_load_bs_script_in_admin", "Off", "yes");
INSERT INTO `wp_options` VALUES("445", "booking_is_load_js_css_on_specific_pages", "Off", "yes");
INSERT INTO `wp_options` VALUES("446", "booking_is_show_system_debug_log", "Off", "yes");
INSERT INTO `wp_options` VALUES("447", "booking_pages_for_load_js_css", "", "yes");
INSERT INTO `wp_options` VALUES("448", "booking_type_of_day_selections", "multiple", "yes");
INSERT INTO `wp_options` VALUES("449", "booking_form_is_using_bs_css", "On", "yes");
INSERT INTO `wp_options` VALUES("450", "booking_form_format_type", "vertical", "yes");
INSERT INTO `wp_options` VALUES("451", "booking_form_field_active1", "On", "yes");
INSERT INTO `wp_options` VALUES("452", "booking_form_field_required1", "On", "yes");
INSERT INTO `wp_options` VALUES("453", "booking_form_field_label1", "First Name", "yes");
INSERT INTO `wp_options` VALUES("454", "booking_form_field_active2", "On", "yes");
INSERT INTO `wp_options` VALUES("455", "booking_form_field_required2", "On", "yes");
INSERT INTO `wp_options` VALUES("456", "booking_form_field_label2", "Last Name", "yes");
INSERT INTO `wp_options` VALUES("457", "booking_form_field_active3", "On", "yes");
INSERT INTO `wp_options` VALUES("458", "booking_form_field_required3", "On", "yes");
INSERT INTO `wp_options` VALUES("459", "booking_form_field_label3", "Email", "yes");
INSERT INTO `wp_options` VALUES("460", "booking_form_field_active4", "On", "yes");
INSERT INTO `wp_options` VALUES("461", "booking_form_field_required4", "Off", "yes");
INSERT INTO `wp_options` VALUES("462", "booking_form_field_label4", "Phone", "yes");
INSERT INTO `wp_options` VALUES("463", "booking_form_field_active5", "On", "yes");
INSERT INTO `wp_options` VALUES("464", "booking_form_field_required5", "Off", "yes");
INSERT INTO `wp_options` VALUES("465", "booking_form_field_label5", "Details", "yes");
INSERT INTO `wp_options` VALUES("466", "booking_form_field_active6", "Off", "yes");
INSERT INTO `wp_options` VALUES("467", "booking_form_field_required6", "Off", "yes");
INSERT INTO `wp_options` VALUES("468", "booking_form_field_label6", "Visitors", "yes");
INSERT INTO `wp_options` VALUES("469", "booking_form_field_values6", "1\n2\n3\n4", "yes");
INSERT INTO `wp_options` VALUES("470", "booking_is_days_always_available", "Off", "yes");
INSERT INTO `wp_options` VALUES("471", "booking_check_on_server_if_dates_free", "Off", "yes");
INSERT INTO `wp_options` VALUES("472", "booking_unavailable_days_num_from_today", "0", "yes");
INSERT INTO `wp_options` VALUES("473", "booking_unavailable_day0", "Off", "yes");
INSERT INTO `wp_options` VALUES("474", "booking_unavailable_day1", "Off", "yes");
INSERT INTO `wp_options` VALUES("475", "booking_unavailable_day2", "Off", "yes");
INSERT INTO `wp_options` VALUES("476", "booking_unavailable_day3", "Off", "yes");
INSERT INTO `wp_options` VALUES("477", "booking_unavailable_day4", "Off", "yes");
INSERT INTO `wp_options` VALUES("478", "booking_unavailable_day5", "Off", "yes");
INSERT INTO `wp_options` VALUES("479", "booking_unavailable_day6", "Off", "yes");
INSERT INTO `wp_options` VALUES("480", "booking_menu_position", "top", "yes");
INSERT INTO `wp_options` VALUES("481", "booking_user_role_booking", "editor", "yes");
INSERT INTO `wp_options` VALUES("482", "booking_user_role_addbooking", "editor", "yes");
INSERT INTO `wp_options` VALUES("483", "booking_user_role_resources", "editor", "yes");
INSERT INTO `wp_options` VALUES("484", "booking_user_role_settings", "administrator", "yes");
INSERT INTO `wp_options` VALUES("485", "booking_is_email_reservation_adress", "On", "yes");
INSERT INTO `wp_options` VALUES("486", "booking_email_reservation_adress", "&quot;Booking system&quot; &lt;vccw@example.com&gt;", "yes");
INSERT INTO `wp_options` VALUES("487", "booking_email_reservation_from_adress", "[visitoremail]", "yes");
INSERT INTO `wp_options` VALUES("488", "booking_email_reservation_subject", "Nowa rezerwacja", "yes");
INSERT INTO `wp_options` VALUES("489", "booking_email_reservation_content", "Musisz potwierdzić nową rezerwację [bookingtype] dla: [dates]&lt;br/&gt;&lt;br/&gt; Szczegółowe dane osób:&lt;br/&gt; [content]&lt;br/&gt;&lt;br/&gt; Obecnie nowa rezerwacja czeka na zatwierdzenie. Proszę odwiedzić panel moderacji [moderatelink]&lt;br/&gt;&lt;br/&gt;Dziękuję, Body &amp;amp; Brain&lt;br/&gt;[siteurl]", "yes");
INSERT INTO `wp_options` VALUES("490", "booking_is_email_newbookingbyperson_adress", "Off", "yes");
INSERT INTO `wp_options` VALUES("491", "booking_email_newbookingbyperson_adress", "&quot;Booking system&quot; &lt;vccw@example.com&gt;", "yes");
INSERT INTO `wp_options` VALUES("492", "booking_email_newbookingbyperson_subject", "Nowa rezerwacja", "yes");
INSERT INTO `wp_options` VALUES("493", "booking_email_newbookingbyperson_content", "Rezerwacja [bookingtype] dla: [dates] jest przetwarzana! Wyślemy potwierdzenie na email. &lt;br/&gt;&lt;br/&gt;[content]&lt;br/&gt;&lt;br/&gt; Dziękuję Body &amp;amp; Brain&lt;br/&gt;[siteurl]", "yes");
INSERT INTO `wp_options` VALUES("494", "booking_is_email_approval_adress", "On", "yes");
INSERT INTO `wp_options` VALUES("495", "booking_is_email_approval_send_copy_to_admin", "Off", "yes");
INSERT INTO `wp_options` VALUES("496", "booking_email_approval_adress", "&quot;Booking system&quot; &lt;vccw@example.com&gt;", "yes");
INSERT INTO `wp_options` VALUES("497", "booking_email_approval_subject", "Twoja rezerwacja została zatwierdzona", "yes");
INSERT INTO `wp_options` VALUES("498", "booking_email_approval_content", "Rezerwacja [bookingtype] dla: [dates] została zaakceptowana. &lt;br/&gt;&lt;br/&gt;[content]&lt;br/&gt;&lt;br/&gt; Dziękujemy, Body &amp;amp; Brain&lt;br/&gt;[siteurl]", "yes");
INSERT INTO `wp_options` VALUES("499", "booking_is_email_deny_adress", "On", "yes");
INSERT INTO `wp_options` VALUES("500", "booking_is_email_deny_send_copy_to_admin", "Off", "yes");
INSERT INTO `wp_options` VALUES("501", "booking_email_deny_adress", "&quot;Booking system&quot; &lt;vccw@example.com&gt;", "yes");
INSERT INTO `wp_options` VALUES("502", "booking_email_deny_subject", "Twoja rezerwacja została odrzucona", "yes");
INSERT INTO `wp_options` VALUES("503", "booking_email_deny_content", "Rezerwacja [bookingtype] dla: [dates] została anulowana. &lt;br/&gt;[denyreason]&lt;br/&gt;&lt;br/&gt;[content]&lt;br/&gt;&lt;br/&gt; Dziękujemy, Body &amp;amp; Brain&lt;br/&gt;[siteurl]", "yes");
INSERT INTO `wp_options` VALUES("504", "booking_widget_title", "Formulasz rezerwacji", "yes");
INSERT INTO `wp_options` VALUES("505", "booking_widget_show", "booking_form", "yes");
INSERT INTO `wp_options` VALUES("506", "booking_widget_type", "1", "yes");
INSERT INTO `wp_options` VALUES("507", "booking_widget_calendar_count", "1", "yes");
INSERT INTO `wp_options` VALUES("508", "booking_widget_last_field", "", "yes");
INSERT INTO `wp_options` VALUES("509", "booking_wpdev_copyright_adminpanel", "On", "yes");
INSERT INTO `wp_options` VALUES("510", "booking_is_show_powered_by_notice", "On", "yes");
INSERT INTO `wp_options` VALUES("511", "booking_is_use_captcha", "Off", "yes");
INSERT INTO `wp_options` VALUES("512", "booking_is_show_legend", "Off", "yes");
INSERT INTO `wp_options` VALUES("513", "booking_legend_is_show_item_available", "On", "yes");
INSERT INTO `wp_options` VALUES("514", "booking_legend_text_for_item_available", "Dostępne", "yes");
INSERT INTO `wp_options` VALUES("515", "booking_legend_is_show_item_pending", "On", "yes");
INSERT INTO `wp_options` VALUES("516", "booking_legend_text_for_item_pending", "W oczekinwaniu", "yes");
INSERT INTO `wp_options` VALUES("517", "booking_legend_is_show_item_approved", "On", "yes");
INSERT INTO `wp_options` VALUES("518", "booking_legend_text_for_item_approved", "Wynajęte", "yes");
INSERT INTO `wp_options` VALUES("519", "booking_legend_is_show_numbers", "On", "yes");
INSERT INTO `wp_options` VALUES("520", "booking_email_new_admin", "a:15:{s:7:\"enabled\";s:2:\"On\";s:2:\"to\";s:16:\"vccw@example.com\";s:7:\"to_name\";s:14:\"Booking system\";s:4:\"from\";s:16:\"vccw@example.com\";s:9:\"from_name\";s:14:\"Booking system\";s:7:\"subject\";s:15:\"Nowa rezerwacja\";s:7:\"content\";s:275:\"Musisz potwierdzić nową rezerwację [bookingtype] dla: [dates]<br/><br/> Szczegółowe dane osób:<br/> [content]<br/><br/> Obecnie nowa rezerwacja czeka na zatwierdzenie. Proszę odwiedzić panel moderacji [moderatelink]<br/><br/>Dziękuję, Body &amp; Brain<br/>[siteurl]\";s:14:\"header_content\";s:0:\"\";s:14:\"footer_content\";s:0:\"\";s:13:\"template_file\";s:5:\"plain\";s:10:\"base_color\";s:7:\"#557da1\";s:16:\"background_color\";s:7:\"#f5f5f5\";s:10:\"body_color\";s:7:\"#fdfdfd\";s:10:\"text_color\";s:7:\"#505050\";s:18:\"email_content_type\";s:4:\"html\";}", "yes");
INSERT INTO `wp_options` VALUES("521", "booking_email_new_visitor", "a:13:{s:7:\"enabled\";s:2:\"On\";s:4:\"from\";s:16:\"vccw@example.com\";s:9:\"from_name\";s:14:\"Booking system\";s:7:\"subject\";s:15:\"Nowa rezerwacja\";s:7:\"content\";s:161:\"Rezerwacja [bookingtype] dla: [dates] jest przetwarzana! Wyślemy potwierdzenie na email. <br/><br/>[content]<br/><br/> Dziękuję Body &amp; Brain<br/>[siteurl]\";s:14:\"header_content\";s:0:\"\";s:14:\"footer_content\";s:0:\"\";s:13:\"template_file\";s:5:\"plain\";s:10:\"base_color\";s:7:\"#557da1\";s:16:\"background_color\";s:7:\"#f5f5f5\";s:10:\"body_color\";s:7:\"#fdfdfd\";s:10:\"text_color\";s:7:\"#505050\";s:18:\"email_content_type\";s:4:\"html\";}", "yes");
INSERT INTO `wp_options` VALUES("522", "booking_email_approved", "a:14:{s:7:\"enabled\";s:2:\"On\";s:13:\"copy_to_admin\";s:3:\"Off\";s:4:\"from\";s:16:\"vccw@example.com\";s:9:\"from_name\";s:14:\"Booking system\";s:7:\"subject\";s:38:\"Twoja rezerwacja została zatwierdzona\";s:7:\"content\";s:135:\"Rezerwacja [bookingtype] dla: [dates] została zaakceptowana. <br/><br/>[content]<br/><br/> Dziękujemy, Body &amp; Brain<br/>[siteurl]\";s:14:\"header_content\";s:0:\"\";s:14:\"footer_content\";s:0:\"\";s:13:\"template_file\";s:5:\"plain\";s:10:\"base_color\";s:7:\"#557da1\";s:16:\"background_color\";s:7:\"#f5f5f5\";s:10:\"body_color\";s:7:\"#fdfdfd\";s:10:\"text_color\";s:7:\"#505050\";s:18:\"email_content_type\";s:4:\"html\";}", "yes");
INSERT INTO `wp_options` VALUES("523", "booking_email_deleted", "a:14:{s:7:\"enabled\";s:2:\"On\";s:13:\"copy_to_admin\";s:3:\"Off\";s:4:\"from\";s:16:\"vccw@example.com\";s:9:\"from_name\";s:14:\"Booking system\";s:7:\"subject\";s:35:\"Twoja rezerwacja została odrzucona\";s:7:\"content\";s:148:\"Rezerwacja [bookingtype] dla: [dates] została anulowana. <br/>[denyreason]<br/><br/>[content]<br/><br/> Dziękujemy, Body &amp; Brain<br/>[siteurl]\";s:14:\"header_content\";s:0:\"\";s:14:\"footer_content\";s:0:\"\";s:13:\"template_file\";s:5:\"plain\";s:10:\"base_color\";s:7:\"#557da1\";s:16:\"background_color\";s:7:\"#f5f5f5\";s:10:\"body_color\";s:7:\"#fdfdfd\";s:10:\"text_color\";s:7:\"#505050\";s:18:\"email_content_type\";s:4:\"html\";}", "yes");
INSERT INTO `wp_options` VALUES("524", "booking_email_deny", "a:14:{s:7:\"enabled\";s:2:\"On\";s:13:\"copy_to_admin\";s:3:\"Off\";s:4:\"from\";s:16:\"vccw@example.com\";s:9:\"from_name\";s:14:\"Booking system\";s:7:\"subject\";s:35:\"Twoja rezerwacja została odrzucona\";s:7:\"content\";s:148:\"Rezerwacja [bookingtype] dla: [dates] została anulowana. <br/>[denyreason]<br/><br/>[content]<br/><br/> Dziękujemy, Body &amp; Brain<br/>[siteurl]\";s:14:\"header_content\";s:0:\"\";s:14:\"footer_content\";s:0:\"\";s:13:\"template_file\";s:5:\"plain\";s:10:\"base_color\";s:7:\"#557da1\";s:16:\"background_color\";s:7:\"#f5f5f5\";s:10:\"body_color\";s:7:\"#fdfdfd\";s:10:\"text_color\";s:7:\"#505050\";s:18:\"email_content_type\";s:4:\"html\";}", "yes");
INSERT INTO `wp_options` VALUES("525", "booking_email_trash", "a:14:{s:7:\"enabled\";s:2:\"On\";s:13:\"copy_to_admin\";s:3:\"Off\";s:4:\"from\";s:16:\"vccw@example.com\";s:9:\"from_name\";s:14:\"Booking system\";s:7:\"subject\";s:35:\"Twoja rezerwacja została odrzucona\";s:7:\"content\";s:148:\"Rezerwacja [bookingtype] dla: [dates] została anulowana. <br/>[denyreason]<br/><br/>[content]<br/><br/> Dziękujemy, Body &amp; Brain<br/>[siteurl]\";s:14:\"header_content\";s:0:\"\";s:14:\"footer_content\";s:0:\"\";s:13:\"template_file\";s:5:\"plain\";s:10:\"base_color\";s:7:\"#557da1\";s:16:\"background_color\";s:7:\"#f5f5f5\";s:10:\"body_color\";s:7:\"#fdfdfd\";s:10:\"text_color\";s:7:\"#505050\";s:18:\"email_content_type\";s:4:\"html\";}", "yes");
INSERT INTO `wp_options` VALUES("526", "booking_form", "[calendar]\n<div class=\"standard-form\">\n     <p>First Name*:<br />[text* name]</p>\n     <p>Last Name*:<br />[text* secondname]</p>\n     <p>Email*:<br />[email* email]</p>\n     <p>Phone:<br />[text phone]</p>\n     <p>Details:<br />[textarea details]</p>\n     <p>[captcha]</p>\n     <p>[submit class:btn \"Send\"]</p>\n</div>\n", "yes");
INSERT INTO `wp_options` VALUES("527", "booking_form_show", "<div style=\"text-align:left;word-wrap: break-word;\">\n  <strong>First Name</strong>: <span class=\"fieldvalue\">[name]</span><br/>\n  <strong>Last Name</strong>: <span class=\"fieldvalue\">[secondname]</span><br/>\n  <strong>Email</strong>: <span class=\"fieldvalue\">[email]</span><br/>\n  <strong>Phone</strong>: <span class=\"fieldvalue\">[phone]</span><br/>\n  <strong>Details</strong>: <span class=\"fieldvalue\">[details]</span><br/>\n</div>", "yes");
INSERT INTO `wp_options` VALUES("528", "booking_form_visual", "a:9:{i:0;a:2:{s:4:\"type\";s:8:\"calendar\";s:10:\"obligatory\";s:2:\"On\";}i:1;a:6:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:4:\"name\";s:10:\"obligatory\";s:3:\"Off\";s:6:\"active\";s:2:\"On\";s:8:\"required\";s:2:\"On\";s:5:\"label\";s:10:\"First Name\";}i:2;a:6:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:10:\"secondname\";s:10:\"obligatory\";s:3:\"Off\";s:6:\"active\";s:2:\"On\";s:8:\"required\";s:2:\"On\";s:5:\"label\";s:9:\"Last Name\";}i:3;a:6:{s:4:\"type\";s:5:\"email\";s:4:\"name\";s:5:\"email\";s:10:\"obligatory\";s:2:\"On\";s:6:\"active\";s:2:\"On\";s:8:\"required\";s:2:\"On\";s:5:\"label\";s:5:\"Email\";}i:4;a:7:{s:4:\"type\";s:6:\"select\";s:4:\"name\";s:8:\"visitors\";s:10:\"obligatory\";s:3:\"Off\";s:6:\"active\";s:3:\"Off\";s:8:\"required\";s:3:\"Off\";s:5:\"label\";s:8:\"Visitors\";s:5:\"value\";s:7:\"1\n2\n3\n4\";}i:5;a:6:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:5:\"phone\";s:10:\"obligatory\";s:3:\"Off\";s:6:\"active\";s:2:\"On\";s:8:\"required\";s:3:\"Off\";s:5:\"label\";s:5:\"Phone\";}i:6;a:6:{s:4:\"type\";s:8:\"textarea\";s:4:\"name\";s:7:\"details\";s:10:\"obligatory\";s:3:\"Off\";s:6:\"active\";s:2:\"On\";s:8:\"required\";s:3:\"Off\";s:5:\"label\";s:7:\"Details\";}i:7;a:6:{s:4:\"type\";s:7:\"captcha\";s:4:\"name\";s:7:\"captcha\";s:10:\"obligatory\";s:2:\"On\";s:6:\"active\";s:3:\"Off\";s:8:\"required\";s:2:\"On\";s:5:\"label\";s:0:\"\";}i:8;a:6:{s:4:\"type\";s:6:\"submit\";s:4:\"name\";s:6:\"submit\";s:10:\"obligatory\";s:2:\"On\";s:6:\"active\";s:2:\"On\";s:8:\"required\";s:2:\"On\";s:5:\"label\";s:7:\"Wyślij\";}}", "yes");
INSERT INTO `wp_options` VALUES("529", "booking_gcal_feed", "", "yes");
INSERT INTO `wp_options` VALUES("530", "booking_gcal_events_from", "month-start", "yes");
INSERT INTO `wp_options` VALUES("531", "booking_gcal_events_from_offset", "", "yes");
INSERT INTO `wp_options` VALUES("532", "booking_gcal_events_from_offset_type", "", "yes");
INSERT INTO `wp_options` VALUES("533", "booking_gcal_events_until", "any", "yes");
INSERT INTO `wp_options` VALUES("534", "booking_gcal_events_until_offset", "", "yes");
INSERT INTO `wp_options` VALUES("535", "booking_gcal_events_until_offset_type", "", "yes");
INSERT INTO `wp_options` VALUES("536", "booking_gcal_events_max", "25", "yes");
INSERT INTO `wp_options` VALUES("537", "booking_gcal_api_key", "", "yes");
INSERT INTO `wp_options` VALUES("538", "booking_gcal_timezone", "", "yes");
INSERT INTO `wp_options` VALUES("539", "booking_gcal_is_send_email", "Off", "yes");
INSERT INTO `wp_options` VALUES("540", "booking_gcal_auto_import_is_active", "Off", "yes");
INSERT INTO `wp_options` VALUES("541", "booking_gcal_auto_import_time", "24", "yes");
INSERT INTO `wp_options` VALUES("542", "booking_gcal_events_form_fields", "s:101:\"a:3:{s:5:\"title\";s:9:\"text^name\";s:11:\"description\";s:16:\"textarea^details\";s:5:\"where\";s:5:\"text^\";}\";", "yes");
INSERT INTO `wp_options` VALUES("543", "booking_version_num", "8.0.1", "yes");
INSERT INTO `wp_options` VALUES("546", "widget_bookingwidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("547", "booking_activation_redirect_for_version", "8.0.1", "yes");
INSERT INTO `wp_options` VALUES("555", "wpdevart_booking_version", "1.6.6", "no");
INSERT INTO `wp_options` VALUES("556", "widget_wpdevart_bc_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("596", "bookly_data_loaded", "1", "yes");
INSERT INTO `wp_options` VALUES("597", "bookly_db_version", "13.1", "yes");
INSERT INTO `wp_options` VALUES("598", "bookly_installation_time", "1509281118", "yes");
INSERT INTO `wp_options` VALUES("599", "bookly_grace_start", "1510490718", "yes");
INSERT INTO `wp_options` VALUES("600", "bookly_envato_purchase_code", "", "yes");
INSERT INTO `wp_options` VALUES("601", "bookly_enabled", "1", "yes");
INSERT INTO `wp_options` VALUES("602", "bookly_app_color", "#f4662f", "yes");
INSERT INTO `wp_options` VALUES("603", "bookly_app_required_employee", "0", "yes");
INSERT INTO `wp_options` VALUES("604", "bookly_app_show_blocked_timeslots", "0", "yes");
INSERT INTO `wp_options` VALUES("605", "bookly_app_show_calendar", "0", "yes");
INSERT INTO `wp_options` VALUES("606", "bookly_app_show_day_one_column", "0", "yes");
INSERT INTO `wp_options` VALUES("607", "bookly_app_show_progress_tracker", "1", "yes");
INSERT INTO `wp_options` VALUES("608", "bookly_app_staff_name_with_price", "1", "yes");
INSERT INTO `wp_options` VALUES("609", "bookly_api_server_error_time", "0", "yes");
INSERT INTO `wp_options` VALUES("610", "bookly_l10n_button_apply", "Apply", "yes");
INSERT INTO `wp_options` VALUES("611", "bookly_l10n_button_back", "Back", "yes");
INSERT INTO `wp_options` VALUES("612", "bookly_l10n_button_book_more", "Book More", "yes");
INSERT INTO `wp_options` VALUES("613", "bookly_l10n_button_next", "Next", "yes");
INSERT INTO `wp_options` VALUES("614", "bookly_l10n_info_cart_step", "Below you can find a list of services selected for booking.\nClick BOOK MORE if you want to add more services.", "yes");
INSERT INTO `wp_options` VALUES("615", "bookly_l10n_info_complete_step", "Thank you! Your booking is complete. An email with details of your booking has been sent to you.", "yes");
INSERT INTO `wp_options` VALUES("616", "bookly_l10n_info_coupon", "The total price for the booking is {total_price}.", "yes");
INSERT INTO `wp_options` VALUES("617", "bookly_l10n_info_details_step", "You selected a booking for {service_name} by {staff_name} at {service_time} on {service_date}. The price for the service is {service_price}.\nPlease provide your details in the form below to proceed with booking.", "yes");
INSERT INTO `wp_options` VALUES("618", "bookly_l10n_info_details_step_guest", "", "yes");
INSERT INTO `wp_options` VALUES("619", "bookly_l10n_info_payment_step", "Please tell us how you would like to pay: ", "yes");
INSERT INTO `wp_options` VALUES("620", "bookly_l10n_info_service_step", "Please select service: ", "yes");
INSERT INTO `wp_options` VALUES("621", "bookly_l10n_info_time_step", "Below you can find a list of available time slots for {service_name} by {staff_name}.\nClick on a time slot to proceed with booking.", "yes");
INSERT INTO `wp_options` VALUES("622", "bookly_l10n_label_category", "Category", "yes");
INSERT INTO `wp_options` VALUES("623", "bookly_l10n_label_ccard_code", "Card Security Code", "yes");
INSERT INTO `wp_options` VALUES("624", "bookly_l10n_label_ccard_expire", "Expiration Date", "yes");
INSERT INTO `wp_options` VALUES("625", "bookly_l10n_label_ccard_number", "Credit Card Number", "yes");
INSERT INTO `wp_options` VALUES("626", "bookly_l10n_label_coupon", "Coupon", "yes");
INSERT INTO `wp_options` VALUES("627", "bookly_l10n_label_email", "Email", "yes");
INSERT INTO `wp_options` VALUES("628", "bookly_l10n_label_employee", "Employee", "yes");
INSERT INTO `wp_options` VALUES("629", "bookly_l10n_label_finish_by", "Finish by", "yes");
INSERT INTO `wp_options` VALUES("630", "bookly_l10n_label_name", "Name", "yes");
INSERT INTO `wp_options` VALUES("631", "bookly_l10n_label_number_of_persons", "Number of persons", "yes");
INSERT INTO `wp_options` VALUES("632", "bookly_l10n_label_pay_ccard", "I will pay now with Credit Card", "yes");
INSERT INTO `wp_options` VALUES("633", "bookly_l10n_label_pay_locally", "I will pay locally", "yes");
INSERT INTO `wp_options` VALUES("634", "bookly_l10n_label_pay_mollie", "I will pay now with Mollie", "yes");
INSERT INTO `wp_options` VALUES("635", "bookly_l10n_label_pay_paypal", "I will pay now with PayPal", "yes");
INSERT INTO `wp_options` VALUES("636", "bookly_l10n_label_phone", "Phone", "yes");
INSERT INTO `wp_options` VALUES("637", "bookly_l10n_label_select_date", "I\'m available on or after", "yes");
INSERT INTO `wp_options` VALUES("638", "bookly_l10n_label_service", "Service", "yes");
INSERT INTO `wp_options` VALUES("639", "bookly_l10n_label_start_from", "Start from", "yes");
INSERT INTO `wp_options` VALUES("640", "bookly_l10n_option_category", "Select category", "yes");
INSERT INTO `wp_options` VALUES("641", "bookly_l10n_option_employee", "Any", "yes");
INSERT INTO `wp_options` VALUES("642", "bookly_l10n_option_service", "Select service", "yes");
INSERT INTO `wp_options` VALUES("643", "bookly_l10n_required_email", "Please tell us your email", "yes");
INSERT INTO `wp_options` VALUES("644", "bookly_l10n_required_employee", "Please select an employee", "yes");
INSERT INTO `wp_options` VALUES("645", "bookly_l10n_required_name", "Please tell us your name", "yes");
INSERT INTO `wp_options` VALUES("646", "bookly_l10n_required_phone", "Please tell us your phone", "yes");
INSERT INTO `wp_options` VALUES("647", "bookly_l10n_required_service", "Please select a service", "yes");
INSERT INTO `wp_options` VALUES("648", "bookly_l10n_step_cart", "Cart", "yes");
INSERT INTO `wp_options` VALUES("649", "bookly_l10n_step_details", "Details", "yes");
INSERT INTO `wp_options` VALUES("650", "bookly_l10n_step_done", "Done", "yes");
INSERT INTO `wp_options` VALUES("651", "bookly_l10n_step_payment", "Payment", "yes");
INSERT INTO `wp_options` VALUES("652", "bookly_l10n_step_service", "Service", "yes");
INSERT INTO `wp_options` VALUES("653", "bookly_l10n_step_time", "Time", "yes");
INSERT INTO `wp_options` VALUES("654", "bookly_cart_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("655", "bookly_cart_show_columns", "a:6:{s:7:\"service\";a:1:{s:4:\"show\";i:1;}s:4:\"date\";a:1:{s:4:\"show\";i:1;}s:4:\"time\";a:1:{s:4:\"show\";i:1;}s:8:\"employee\";a:1:{s:4:\"show\";i:1;}s:5:\"price\";a:1:{s:4:\"show\";i:1;}s:7:\"deposit\";a:1:{s:4:\"show\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("656", "bookly_co_logo_attachment_id", "", "yes");
INSERT INTO `wp_options` VALUES("657", "bookly_co_name", "", "yes");
INSERT INTO `wp_options` VALUES("658", "bookly_co_address", "", "yes");
INSERT INTO `wp_options` VALUES("659", "bookly_co_phone", "", "yes");
INSERT INTO `wp_options` VALUES("660", "bookly_co_website", "", "yes");
INSERT INTO `wp_options` VALUES("661", "bookly_cst_create_account", "0", "yes");
INSERT INTO `wp_options` VALUES("662", "bookly_cst_new_account_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("663", "bookly_cst_phone_default_country", "auto", "yes");
INSERT INTO `wp_options` VALUES("664", "bookly_cst_default_country_code", "", "yes");
INSERT INTO `wp_options` VALUES("665", "bookly_cst_cancel_action", "cancel", "yes");
INSERT INTO `wp_options` VALUES("666", "bookly_cst_combined_notifications", "0", "yes");
INSERT INTO `wp_options` VALUES("667", "bookly_custom_fields", "[{\"type\":\"textarea\",\"label\":\"Notes\",\"required\":false,\"id\":1,\"services\":[]}]", "yes");
INSERT INTO `wp_options` VALUES("668", "bookly_custom_fields_per_service", "0", "yes");
INSERT INTO `wp_options` VALUES("669", "bookly_email_sender", "vccw@example.com", "yes");
INSERT INTO `wp_options` VALUES("670", "bookly_email_sender_name", "Body &amp; Brain", "yes");
INSERT INTO `wp_options` VALUES("671", "bookly_email_send_as", "html", "yes");
INSERT INTO `wp_options` VALUES("672", "bookly_email_reply_to_customers", "1", "yes");
INSERT INTO `wp_options` VALUES("673", "bookly_gc_client_id", "", "yes");
INSERT INTO `wp_options` VALUES("674", "bookly_gc_client_secret", "", "yes");
INSERT INTO `wp_options` VALUES("675", "bookly_gc_event_title", "{service_name}", "yes");
INSERT INTO `wp_options` VALUES("676", "bookly_gc_limit_events", "50", "yes");
INSERT INTO `wp_options` VALUES("677", "bookly_gc_two_way_sync", "1", "yes");
INSERT INTO `wp_options` VALUES("678", "bookly_lite_uninstall_remove_bookly_data", "0", "yes");
INSERT INTO `wp_options` VALUES("679", "bookly_gen_time_slot_length", "15", "yes");
INSERT INTO `wp_options` VALUES("680", "bookly_gen_service_duration_as_slot_length", "0", "yes");
INSERT INTO `wp_options` VALUES("681", "bookly_gen_default_appointment_status", "approved", "yes");
INSERT INTO `wp_options` VALUES("682", "bookly_gen_min_time_prior_booking", "0", "yes");
INSERT INTO `wp_options` VALUES("683", "bookly_gen_min_time_prior_cancel", "0", "yes");
INSERT INTO `wp_options` VALUES("684", "bookly_gen_approve_page_url", "http://bnb.testuj.website", "yes");
INSERT INTO `wp_options` VALUES("685", "bookly_gen_cancel_page_url", "http://bnb.testuj.website", "yes");
INSERT INTO `wp_options` VALUES("686", "bookly_gen_cancel_denied_page_url", "http://bnb.testuj.website", "yes");
INSERT INTO `wp_options` VALUES("687", "bookly_gen_max_days_for_booking", "365", "yes");
INSERT INTO `wp_options` VALUES("688", "bookly_gen_use_client_time_zone", "0", "yes");
INSERT INTO `wp_options` VALUES("689", "bookly_gen_final_step_url", "", "yes");
INSERT INTO `wp_options` VALUES("690", "bookly_gen_allow_staff_edit_profile", "1", "yes");
INSERT INTO `wp_options` VALUES("691", "bookly_gen_link_assets_method", "enqueue", "yes");
INSERT INTO `wp_options` VALUES("692", "bookly_cron_reminder_times", "a:3:{s:16:\"client_follow_up\";i:21;s:15:\"client_reminder\";i:18;s:12:\"staff_agenda\";i:18;}", "yes");
INSERT INTO `wp_options` VALUES("693", "bookly_grace_notifications", "a:3:{s:6:\"bookly\";s:1:\"0\";s:7:\"add-ons\";i:0;s:4:\"sent\";s:1:\"0\";}", "yes");
INSERT INTO `wp_options` VALUES("694", "bookly_grace_hide_admin_notice_time", "0", "yes");
INSERT INTO `wp_options` VALUES("695", "bookly_sms_token", "", "yes");
INSERT INTO `wp_options` VALUES("696", "bookly_sms_administrator_phone", "", "yes");
INSERT INTO `wp_options` VALUES("697", "bookly_sms_notify_low_balance", "1", "yes");
INSERT INTO `wp_options` VALUES("698", "bookly_sms_notify_weekly_summary", "1", "yes");
INSERT INTO `wp_options` VALUES("699", "bookly_sms_notify_weekly_summary_sent", "43", "yes");
INSERT INTO `wp_options` VALUES("700", "bookly_wc_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("701", "bookly_wc_product", "", "yes");
INSERT INTO `wp_options` VALUES("702", "bookly_l10n_wc_cart_info_name", "Appointment", "yes");
INSERT INTO `wp_options` VALUES("703", "bookly_l10n_wc_cart_info_value", "Date: {appointment_date}\nTime: {appointment_time}\nService: {service_name}", "yes");
INSERT INTO `wp_options` VALUES("704", "bookly_bh_monday_start", "08:00", "yes");
INSERT INTO `wp_options` VALUES("705", "bookly_bh_monday_end", "18:00", "yes");
INSERT INTO `wp_options` VALUES("706", "bookly_bh_tuesday_start", "08:00", "yes");
INSERT INTO `wp_options` VALUES("707", "bookly_bh_tuesday_end", "18:00", "yes");
INSERT INTO `wp_options` VALUES("708", "bookly_bh_wednesday_start", "08:00", "yes");
INSERT INTO `wp_options` VALUES("709", "bookly_bh_wednesday_end", "18:00", "yes");
INSERT INTO `wp_options` VALUES("710", "bookly_bh_thursday_end", "18:00", "yes");
INSERT INTO `wp_options` VALUES("711", "bookly_bh_thursday_start", "08:00", "yes");
INSERT INTO `wp_options` VALUES("712", "bookly_bh_friday_start", "08:00", "yes");
INSERT INTO `wp_options` VALUES("713", "bookly_bh_friday_end", "18:00", "yes");
INSERT INTO `wp_options` VALUES("714", "bookly_bh_saturday_start", "", "yes");
INSERT INTO `wp_options` VALUES("715", "bookly_bh_saturday_end", "", "yes");
INSERT INTO `wp_options` VALUES("716", "bookly_bh_sunday_start", "", "yes");
INSERT INTO `wp_options` VALUES("717", "bookly_bh_sunday_end", "", "yes");
INSERT INTO `wp_options` VALUES("718", "bookly_pmt_currency", "USD", "yes");
INSERT INTO `wp_options` VALUES("719", "bookly_pmt_coupons", "0", "yes");
INSERT INTO `wp_options` VALUES("720", "bookly_pmt_local", "1", "yes");
INSERT INTO `wp_options` VALUES("721", "bookly_pmt_paypal", "disabled", "yes");
INSERT INTO `wp_options` VALUES("722", "bookly_pmt_paypal_sandbox", "0", "yes");
INSERT INTO `wp_options` VALUES("723", "bookly_pmt_paypal_api_password", "", "yes");
INSERT INTO `wp_options` VALUES("724", "bookly_pmt_paypal_api_signature", "", "yes");
INSERT INTO `wp_options` VALUES("725", "bookly_pmt_paypal_api_username", "", "yes");
INSERT INTO `wp_options` VALUES("726", "bookly_pmt_paypal_id", "", "yes");
INSERT INTO `wp_options` VALUES("727", "bookly_pmt_authorize_net", "disabled", "yes");
INSERT INTO `wp_options` VALUES("728", "bookly_pmt_authorize_net_api_login_id", "", "yes");
INSERT INTO `wp_options` VALUES("729", "bookly_pmt_authorize_net_transaction_key", "", "yes");
INSERT INTO `wp_options` VALUES("730", "bookly_pmt_authorize_net_sandbox", "0", "yes");
INSERT INTO `wp_options` VALUES("731", "bookly_pmt_stripe", "disabled", "yes");
INSERT INTO `wp_options` VALUES("732", "bookly_pmt_stripe_publishable_key", "", "yes");
INSERT INTO `wp_options` VALUES("733", "bookly_pmt_stripe_secret_key", "", "yes");
INSERT INTO `wp_options` VALUES("734", "bookly_pmt_2checkout", "disabled", "yes");
INSERT INTO `wp_options` VALUES("735", "bookly_pmt_2checkout_api_secret_word", "", "yes");
INSERT INTO `wp_options` VALUES("736", "bookly_pmt_2checkout_api_seller_id", "", "yes");
INSERT INTO `wp_options` VALUES("737", "bookly_pmt_2checkout_sandbox", "0", "yes");
INSERT INTO `wp_options` VALUES("738", "bookly_pmt_payu_latam", "disabled", "yes");
INSERT INTO `wp_options` VALUES("739", "bookly_pmt_payu_latam_api_account_id", "", "yes");
INSERT INTO `wp_options` VALUES("740", "bookly_pmt_payu_latam_api_key", "", "yes");
INSERT INTO `wp_options` VALUES("741", "bookly_pmt_payu_latam_api_merchant_id", "", "yes");
INSERT INTO `wp_options` VALUES("742", "bookly_pmt_payu_latam_sandbox", "0", "yes");
INSERT INTO `wp_options` VALUES("743", "bookly_pmt_payson", "disabled", "yes");
INSERT INTO `wp_options` VALUES("744", "bookly_pmt_payson_api_agent_id", "", "yes");
INSERT INTO `wp_options` VALUES("745", "bookly_pmt_payson_api_key", "", "yes");
INSERT INTO `wp_options` VALUES("746", "bookly_pmt_payson_api_receiver_email", "", "yes");
INSERT INTO `wp_options` VALUES("747", "bookly_pmt_payson_fees_payer", "PRIMARYRECEIVER", "yes");
INSERT INTO `wp_options` VALUES("748", "bookly_pmt_payson_funding", "a:1:{i:0;s:10:\"CREDITCARD\";}", "yes");
INSERT INTO `wp_options` VALUES("749", "bookly_pmt_payson_sandbox", "0", "yes");
INSERT INTO `wp_options` VALUES("750", "bookly_pmt_mollie", "disabled", "yes");
INSERT INTO `wp_options` VALUES("751", "bookly_pmt_mollie_api_key", "", "yes");
INSERT INTO `wp_options` VALUES("761", "bap_plugin_options", "a:4:{s:14:\"plugin_version\";s:5:\"0.6.2\";s:5:\"email\";s:0:\"\";s:20:\"cart-expiration-time\";i:5;s:15:\"currency-symbol\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("762", "bap_email_new_order_admin", "a:2:{s:7:\"subject\";s:25:\"New booking <total_price>\";s:7:\"message\";s:180:\"<first_name> <last_name> has booked:<br/>\r\n<places>\r\n\r\n<br/><br/>\r\nOrder details:<br/>\r\nEmail - <email><br/>\r\nPhone - <phone><br/>\r\nUnique order ID - <code><br/>\r\nStatus - <status>\";}", "yes");
INSERT INTO `wp_options` VALUES("763", "bap_email_new_order_user", "a:2:{s:7:\"subject\";s:25:\"You\'ve just booked places\";s:7:\"message\";s:148:\"<strong>Your order (#<code>):</strong><br/>\r\nName - <first_name> <last_name><br/>\r\nEmail - <email><br/>\r\nPhone - <phone><br/>\r\n\r\n<br/><br/>\r\nRegards\";}", "yes");
INSERT INTO `wp_options` VALUES("774", "widget_em_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("775", "widget_em_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("776", "dbem_events_page", "111", "yes");
INSERT INTO `wp_options` VALUES("777", "dbem_locations_page", "112", "yes");
INSERT INTO `wp_options` VALUES("778", "dbem_categories_page", "113", "yes");
INSERT INTO `wp_options` VALUES("779", "dbem_tags_page", "114", "yes");
INSERT INTO `wp_options` VALUES("780", "dbem_my_bookings_page", "115", "yes");
INSERT INTO `wp_options` VALUES("781", "dbem_hello_to_user", "1", "yes");
INSERT INTO `wp_options` VALUES("782", "dbem_time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("783", "dbem_date_format", "d/m/Y", "yes");
INSERT INTO `wp_options` VALUES("784", "dbem_date_format_js", "dd/mm/yy", "yes");
INSERT INTO `wp_options` VALUES("785", "dbem_dates_separator", " - ", "yes");
INSERT INTO `wp_options` VALUES("786", "dbem_times_separator", " - ", "yes");
INSERT INTO `wp_options` VALUES("787", "dbem_default_category", "0", "yes");
INSERT INTO `wp_options` VALUES("788", "dbem_default_location", "0", "yes");
INSERT INTO `wp_options` VALUES("789", "dbem_events_default_orderby", "event_start_date,event_start_time,event_name", "yes");
INSERT INTO `wp_options` VALUES("790", "dbem_events_default_order", "ASC", "yes");
INSERT INTO `wp_options` VALUES("791", "dbem_events_default_limit", "10", "yes");
INSERT INTO `wp_options` VALUES("792", "dbem_search_form_submit", "Szukaj", "yes");
INSERT INTO `wp_options` VALUES("793", "dbem_search_form_advanced", "1", "yes");
INSERT INTO `wp_options` VALUES("794", "dbem_search_form_advanced_hidden", "1", "yes");
INSERT INTO `wp_options` VALUES("795", "dbem_search_form_advanced_show", "Pokaż zaawansowane szukanie", "yes");
INSERT INTO `wp_options` VALUES("796", "dbem_search_form_advanced_hide", "Ukryj zaawansowane szukanie", "yes");
INSERT INTO `wp_options` VALUES("797", "dbem_search_form_text", "1", "yes");
INSERT INTO `wp_options` VALUES("798", "dbem_search_form_text_label", "Szukaj", "yes");
INSERT INTO `wp_options` VALUES("799", "dbem_search_form_geo", "1", "yes");
INSERT INTO `wp_options` VALUES("800", "dbem_search_form_geo_label", "W pobliżu...", "yes");
INSERT INTO `wp_options` VALUES("801", "dbem_search_form_geo_units", "1", "yes");
INSERT INTO `wp_options` VALUES("802", "dbem_search_form_geo_units_label", "W ciągu", "yes");
INSERT INTO `wp_options` VALUES("803", "dbem_search_form_geo_unit_default", "mi", "yes");
INSERT INTO `wp_options` VALUES("804", "dbem_search_form_geo_distance_default", "25", "yes");
INSERT INTO `wp_options` VALUES("805", "dbem_search_form_geo_distance_options", "5,10,25,50,100", "yes");
INSERT INTO `wp_options` VALUES("806", "dbem_search_form_dates", "1", "yes");
INSERT INTO `wp_options` VALUES("807", "dbem_search_form_dates_label", "Daty", "yes");
INSERT INTO `wp_options` VALUES("808", "dbem_search_form_dates_separator", "a:", "yes");
INSERT INTO `wp_options` VALUES("809", "dbem_search_form_categories", "1", "yes");
INSERT INTO `wp_options` VALUES("810", "dbem_search_form_categories_label", "Wszystkie kategorie", "yes");
INSERT INTO `wp_options` VALUES("811", "dbem_search_form_category_label", "Kategoria", "yes");
INSERT INTO `wp_options` VALUES("812", "dbem_search_form_countries", "1", "yes");
INSERT INTO `wp_options` VALUES("813", "dbem_search_form_default_country", "", "yes");
INSERT INTO `wp_options` VALUES("814", "dbem_search_form_countries_label", "Wszystkie kraje", "yes");
INSERT INTO `wp_options` VALUES("815", "dbem_search_form_country_label", "Państwo", "yes");
INSERT INTO `wp_options` VALUES("816", "dbem_search_form_regions", "1", "yes");
INSERT INTO `wp_options` VALUES("817", "dbem_search_form_regions_label", "Wszystkie regiony", "yes");
INSERT INTO `wp_options` VALUES("818", "dbem_search_form_region_label", "Region", "yes");
INSERT INTO `wp_options` VALUES("819", "dbem_search_form_states", "1", "yes");
INSERT INTO `wp_options` VALUES("820", "dbem_search_form_states_label", "Wszystkie stany", "yes");
INSERT INTO `wp_options` VALUES("821", "dbem_search_form_state_label", "Stan/Kraj", "yes");
INSERT INTO `wp_options` VALUES("822", "dbem_search_form_towns", "0", "yes");
INSERT INTO `wp_options` VALUES("823", "dbem_search_form_towns_label", "Wszystkie miasta/miejscowości", "yes");
INSERT INTO `wp_options` VALUES("824", "dbem_search_form_town_label", "Miejscowość", "yes");
INSERT INTO `wp_options` VALUES("825", "dbem_events_form_editor", "1", "yes");
INSERT INTO `wp_options` VALUES("826", "dbem_events_form_reshow", "1", "yes");
INSERT INTO `wp_options` VALUES("827", "dbem_events_form_result_success", "Dodałeś wydarzenie. Zostanie ono opublikowane gdy tylko administrator je zweryfikuje.", "yes");
INSERT INTO `wp_options` VALUES("828", "dbem_events_form_result_success_updated", "Udało się zaktualizować wydarzenie. Po akceptacji administratora zostanie ono zaktualizowane w serwisie.", "yes");
INSERT INTO `wp_options` VALUES("829", "dbem_events_anonymous_submissions", "0", "yes");
INSERT INTO `wp_options` VALUES("830", "dbem_events_anonymous_user", "0", "yes");
INSERT INTO `wp_options` VALUES("831", "dbem_events_anonymous_result_success", "Dodałeś wydarzenie. Zostanie ono opublikowane gdy tylko administrator je zweryfikuje.", "yes");
INSERT INTO `wp_options` VALUES("832", "dbem_event_submitted_email_admin", "", "yes");
INSERT INTO `wp_options` VALUES("833", "dbem_event_submitted_email_subject", "Wydarzenie oczekuje na zatwierdzenie.", "yes");
INSERT INTO `wp_options` VALUES("834", "dbem_event_submitted_email_body", "Nowe wydarzenie zostało zgłoszone pomyślnie przez #_CONTACTNAME.\n\rImię : #_EVENTNAME \n\rData : #_EVENTDATES \n\rGodzina : #_EVENTTIMES \n\rPrzejdź do http://bnb.testuj.website/wp-admin/post.php?action=edit&post=#_EVENTPOSTID aby sprawdzić to wydarzenie przed zatwierdzeniem.\n\r\n\r-------------------------------\n\rPowered by Events Manager - http://wp-events-plugin.com", "yes");
INSERT INTO `wp_options` VALUES("835", "dbem_event_resubmitted_email_subject", "Przesłane ponownie wydarzenie oczekuje na zatwierdzenie.", "yes");
INSERT INTO `wp_options` VALUES("836", "dbem_event_resubmitted_email_body", "Poprzednio opublikowane wydarzenie zostało zmodyfikowane przez #_CONTACTNAME. To wydarzenie jest teraz nieopublikowane i oczekujące na Twoją akceptację.\n\rImię : #_EVENTNAME \n\rData : #_EVENTDATES \n\rGodzina : #_EVENTTIMES \n\rPrzejdź do http://bnb.testuj.website/wp-admin/post.php?action=edit&post=#_EVENTPOSTID by sprawdzić to wydarzenie przed zatwierdzeniem.\n\r\n\r-------------------------------\n\rPowered by Events Manager - http://wp-events-plugin.com", "yes");
INSERT INTO `wp_options` VALUES("837", "dbem_event_published_email_subject", "Wydarzenie opublikowane - #_EVENTNAME", "yes");
INSERT INTO `wp_options` VALUES("838", "dbem_event_published_email_body", "Nowe wydarzenie zostało opublikowane przez #_CONTACTNAME.\n\rImię : #_EVENTNAME \n\rData : #_EVENTDATES \n\rGodzina : #_EVENTTIMES \n\rEdytuj wydarzenie - http://bnb.testuj.website/wp-admin/post.php?action=edit&post=#_EVENTPOSTID \n\r Zobacz wydarzenie - #_EVENTURL\n\r\n\r-------------------------------\n\rPowered by Events Manager - http://wp-events-plugin.com", "yes");
INSERT INTO `wp_options` VALUES("839", "dbem_event_approved_email_subject", "Wydarzenie zatwierdzone - #_EVENTNAME", "yes");
INSERT INTO `wp_options` VALUES("840", "dbem_event_approved_email_body", "Witaj #_CONTACTNAME, \n\rTwoje wydarzenie #_EVENTNAME w dniu #_EVENTDATES zostało zaakceptowane.\n\rMożesz zobaczyć Twoje wydarzenie tutaj: #_EVENTURL\n\r\n\r-------------------------------\n\rPowered by Events Manager - http://wp-events-plugin.com", "yes");
INSERT INTO `wp_options` VALUES("841", "dbem_event_reapproved_email_subject", "Wydarzenie zatwierdzone - #_EVENTNAME", "yes");
INSERT INTO `wp_options` VALUES("842", "dbem_event_reapproved_email_body", "Witaj #_CONTACTNAME, \n\rTwoje wydarzenie #_EVENTNAME w dniu #_EVENTDATES zostało zaakceptowane.\n\rMożesz zobaczyć Twoje wydarzenie tutaj: #_EVENTURL\n\r\n\r-------------------------------\n\rPowered by Events Manager - http://wp-events-plugin.com", "yes");
INSERT INTO `wp_options` VALUES("843", "dbem_events_page_title", "Wydarzenia", "yes");
INSERT INTO `wp_options` VALUES("844", "dbem_events_page_scope", "future", "yes");
INSERT INTO `wp_options` VALUES("845", "dbem_events_page_search_form", "1", "yes");
INSERT INTO `wp_options` VALUES("846", "dbem_event_list_item_format_header", "<table class=\"events-table\" >\r\n    <thead>\r\n        <tr>\r\n			<th class=\"event-time\" scope=\"col\">Data/Czas</th>\r\n			<th class=\"event-description\" scope=\"col\">Wydarzenie</th>\r\n		</tr>\r\n   	</thead>\r\n    <tbody>", "yes");
INSERT INTO `wp_options` VALUES("847", "dbem_event_list_item_format", "<tr>\r\n			<td>\r\n                #_EVENTDATES<br/>\r\n                #_EVENTTIMES\r\n            </td>\r\n            <td>\r\n                #_EVENTLINK\r\n                {has_location}<br/><i>#_LOCATIONNAME, #_LOCATIONTOWN #_LOCATIONSTATE</i>{/has_location}\r\n            </td>\r\n        </tr>", "yes");
INSERT INTO `wp_options` VALUES("848", "dbem_event_list_item_format_footer", "</tbody></table>", "yes");
INSERT INTO `wp_options` VALUES("849", "dbem_event_list_groupby", "0", "yes");
INSERT INTO `wp_options` VALUES("850", "dbem_event_list_groupby_format", "", "yes");
INSERT INTO `wp_options` VALUES("851", "dbem_event_list_groupby_header_format", "<h2>#s</h2>", "yes");
INSERT INTO `wp_options` VALUES("852", "dbem_display_calendar_in_events_page", "0", "yes");
INSERT INTO `wp_options` VALUES("853", "dbem_single_event_format", "<div style=\"float:right; margin:0px 0px 15px 15px;\">#_LOCATIONMAP</div>\r\n<p>\r\n	<strong>Data/Czas</strong><br/>\r\n	Date(s) - #_EVENTDATES<br /><i>#_EVENTTIMES</i>\r\n</p>\r\n{has_location}\r\n<p>\r\n	<strong>Lokalizacja</strong><br/>\r\n	#_LOCATIONLINK\r\n</p>\r\n{/has_location}\r\n<p>\r\n	<strong>Kategorie</strong>\r\n	#_CATEGORIES\r\n</p>\r\n<br style=\"clear:both\" />\r\n#_EVENTNOTES\r\n{has_bookings}\r\n<h3>Bookings</h3>\r\n#_BOOKINGFORM\r\n{/has_bookings}", "yes");
INSERT INTO `wp_options` VALUES("854", "dbem_event_excerpt_format", "#_EVENTDATES @ #_EVENTTIMES - #_EVENTEXCERPT", "yes");
INSERT INTO `wp_options` VALUES("855", "dbem_event_excerpt_alt_format", "#_EVENTDATES @ #_EVENTTIMES - #_EVENTEXCERPT{55}", "yes");
INSERT INTO `wp_options` VALUES("856", "dbem_event_page_title_format", "#_EVENTNAME", "yes");
INSERT INTO `wp_options` VALUES("857", "dbem_event_all_day_message", "Całodniowe", "yes");
INSERT INTO `wp_options` VALUES("858", "dbem_no_events_message", "Nie Wydarzenia", "yes");
INSERT INTO `wp_options` VALUES("859", "dbem_locations_default_orderby", "location_name", "yes");
INSERT INTO `wp_options` VALUES("860", "dbem_locations_default_order", "ASC", "yes");
INSERT INTO `wp_options` VALUES("861", "dbem_locations_default_limit", "10", "yes");
INSERT INTO `wp_options` VALUES("862", "dbem_locations_page_title", "Wydarzenie Lokalizacje", "yes");
INSERT INTO `wp_options` VALUES("863", "dbem_locations_page_search_form", "1", "yes");
INSERT INTO `wp_options` VALUES("864", "dbem_no_locations_message", "Nie Lokalizacje", "yes");
INSERT INTO `wp_options` VALUES("865", "dbem_location_default_country", "", "yes");
INSERT INTO `wp_options` VALUES("866", "dbem_location_list_item_format_header", "<ul class=\"em-locations-list\">", "yes");
INSERT INTO `wp_options` VALUES("867", "dbem_location_list_item_format", "<li>#_LOCATIONLINK<ul><li>#_LOCATIONFULLLINE</li></ul></li>", "yes");
INSERT INTO `wp_options` VALUES("868", "dbem_location_list_item_format_footer", "</ul>", "yes");
INSERT INTO `wp_options` VALUES("869", "dbem_location_page_title_format", "#_LOCATIONNAME", "yes");
INSERT INTO `wp_options` VALUES("870", "dbem_single_location_format", "<div style=\"float:right; margin:0px 0px 15px 15px;\">#_LOCATIONMAP</div>\r\n<p>\r\n	<strong>Adres</strong><br/>\r\n	#_LOCATIONADDRESS<br/>\r\n	#_LOCATIONTOWN<br/>\r\n	#_LOCATIONSTATE<br/>\r\n	#_LOCATIONREGION<br/>\r\n	#_LOCATIONPOSTCODE<br/>\r\n	#_LOCATIONCOUNTRY\r\n</p>\r\n<br style=\"clear:both\" />\r\n#_LOCATIONNOTES\r\n\r\n<h3>Najbliższe wydarzenia</h3>\r\n<p>#_LOCATIONNEXTEVENTS</p>", "yes");
INSERT INTO `wp_options` VALUES("871", "dbem_location_excerpt_format", "#_LOCATIONEXCERPT", "yes");
INSERT INTO `wp_options` VALUES("872", "dbem_location_excerpt_alt_format", "#_LOCATIONEXCERPT{55}", "yes");
INSERT INTO `wp_options` VALUES("873", "dbem_location_no_events_message", "<li>W najbliższym czasie nie odbywają się tutaj żadne wydarzenia</li>", "yes");
INSERT INTO `wp_options` VALUES("874", "dbem_location_event_list_item_header_format", "<ul>", "yes");
INSERT INTO `wp_options` VALUES("875", "dbem_location_event_list_item_format", "<li>#_EVENTLINK - #_EVENTDATES - #_EVENTTIMES</li>", "yes");
INSERT INTO `wp_options` VALUES("876", "dbem_location_event_list_item_footer_format", "</ul>", "yes");
INSERT INTO `wp_options` VALUES("877", "dbem_location_event_list_limit", "20", "yes");
INSERT INTO `wp_options` VALUES("878", "dbem_location_event_single_format", "#_EVENTLINK - #_EVENTDATES - #_EVENTTIMES", "yes");
INSERT INTO `wp_options` VALUES("879", "dbem_location_no_event_message", "W najbliższym czasie nie odbywają się tutaj żadne wydarzenia", "yes");
INSERT INTO `wp_options` VALUES("880", "dbem_categories_default_limit", "10", "yes");
INSERT INTO `wp_options` VALUES("881", "dbem_categories_default_orderby", "name", "yes");
INSERT INTO `wp_options` VALUES("882", "dbem_categories_default_order", "ASC", "yes");
INSERT INTO `wp_options` VALUES("883", "dbem_categories_list_item_format_header", "<ul class=\"em-categories-list\">", "yes");
INSERT INTO `wp_options` VALUES("884", "dbem_categories_list_item_format", "<li>#_CATEGORYLINK</li>", "yes");
INSERT INTO `wp_options` VALUES("885", "dbem_categories_list_item_format_footer", "</ul>", "yes");
INSERT INTO `wp_options` VALUES("886", "dbem_no_categories_message", "Nie Kategorie", "yes");
INSERT INTO `wp_options` VALUES("887", "dbem_category_page_title_format", "#_CATEGORYNAME", "yes");
INSERT INTO `wp_options` VALUES("888", "dbem_category_page_format", "#_CATEGORYNOTES<h3>Najbliższe wydarzenia</h3>#_CATEGORYNEXTEVENTS", "yes");
INSERT INTO `wp_options` VALUES("889", "dbem_category_no_events_message", "<li>Brak wydarzeń w tej kategorii</li>", "yes");
INSERT INTO `wp_options` VALUES("890", "dbem_category_event_list_item_header_format", "<ul>", "yes");
INSERT INTO `wp_options` VALUES("891", "dbem_category_event_list_item_format", "<li>#_EVENTLINK - #_EVENTDATES - #_EVENTTIMES</li>", "yes");
INSERT INTO `wp_options` VALUES("892", "dbem_category_event_list_item_footer_format", "</ul>", "yes");
INSERT INTO `wp_options` VALUES("893", "dbem_category_event_list_limit", "20", "yes");
INSERT INTO `wp_options` VALUES("894", "dbem_category_event_single_format", "#_EVENTLINK - #_EVENTDATES - #_EVENTTIMES", "yes");
INSERT INTO `wp_options` VALUES("895", "dbem_category_no_event_message", "Brak wydarzeń w tej kategorii", "yes");
INSERT INTO `wp_options` VALUES("896", "dbem_category_default_color", "#a8d144", "yes");
INSERT INTO `wp_options` VALUES("897", "dbem_tags_default_limit", "10", "yes");
INSERT INTO `wp_options` VALUES("898", "dbem_tags_default_orderby", "name", "yes");
INSERT INTO `wp_options` VALUES("899", "dbem_tags_default_order", "ASC", "yes");
INSERT INTO `wp_options` VALUES("900", "dbem_tags_list_item_format_header", "<ul class=\"em-tags-list\">", "yes");
INSERT INTO `wp_options` VALUES("901", "dbem_tags_list_item_format", "<li>#_TAGLINK</li>", "yes");
INSERT INTO `wp_options` VALUES("902", "dbem_tags_list_item_format_footer", "</ul>", "yes");
INSERT INTO `wp_options` VALUES("903", "dbem_no_tags_message", "Nie Tagi", "yes");
INSERT INTO `wp_options` VALUES("904", "dbem_tag_page_title_format", "#_TAGNAME", "yes");
INSERT INTO `wp_options` VALUES("905", "dbem_tag_page_format", "<h3>Najbliższe wydarzenia</h3>#_TAGNEXTEVENTS", "yes");
INSERT INTO `wp_options` VALUES("906", "dbem_tag_no_events_message", "<li>Brak wydarzeń z tym tagiem</li>", "yes");
INSERT INTO `wp_options` VALUES("907", "dbem_tag_event_list_item_header_format", "<ul class=\"em-tags-list\">", "yes");
INSERT INTO `wp_options` VALUES("908", "dbem_tag_event_list_item_format", "<li>#_EVENTLINK - #_EVENTDATES - #_EVENTTIMES</li>", "yes");
INSERT INTO `wp_options` VALUES("909", "dbem_tag_event_list_item_footer_format", "</ul>", "yes");
INSERT INTO `wp_options` VALUES("910", "dbem_tag_event_single_format", "#_EVENTLINK - #_EVENTDATES - #_EVENTTIMES", "yes");
INSERT INTO `wp_options` VALUES("911", "dbem_tag_no_event_message", "Brak wydarzeń z tym tagiem", "yes");
INSERT INTO `wp_options` VALUES("912", "dbem_tag_event_list_limit", "20", "yes");
INSERT INTO `wp_options` VALUES("913", "dbem_rss_limit", "0", "yes");
INSERT INTO `wp_options` VALUES("914", "dbem_rss_scope", "future", "yes");
INSERT INTO `wp_options` VALUES("915", "dbem_rss_main_title", "Body &amp; Brain - Wydarzenia", "yes");
INSERT INTO `wp_options` VALUES("916", "dbem_rss_main_description", "Body &amp; Brain - Wydarzenia", "yes");
INSERT INTO `wp_options` VALUES("917", "dbem_rss_description_format", "#_EVENTDATES - #_EVENTTIMES <br/>#_LOCATIONNAME <br/>#_LOCATIONADDRESS <br/>#_LOCATIONTOWN", "yes");
INSERT INTO `wp_options` VALUES("918", "dbem_rss_title_format", "#_EVENTNAME", "yes");
INSERT INTO `wp_options` VALUES("919", "dbem_rss_order", "ASC", "yes");
INSERT INTO `wp_options` VALUES("920", "dbem_rss_orderby", "event_start_date,event_start_time,event_name", "yes");
INSERT INTO `wp_options` VALUES("921", "em_rss_pubdate", "Sun, 29 Oct 2017 12:55:48 +0000", "yes");
INSERT INTO `wp_options` VALUES("922", "dbem_ical_limit", "0", "yes");
INSERT INTO `wp_options` VALUES("923", "dbem_ical_scope", "future", "yes");
INSERT INTO `wp_options` VALUES("924", "dbem_ical_description_format", "#_EVENTNAME", "yes");
INSERT INTO `wp_options` VALUES("925", "dbem_ical_real_description_format", "#_EVENTEXCERPT", "yes");
INSERT INTO `wp_options` VALUES("926", "dbem_ical_location_format", "#_LOCATIONNAME, #_LOCATIONFULLLINE, #_LOCATIONCOUNTRY", "yes");
INSERT INTO `wp_options` VALUES("927", "dbem_gmap_is_active", "1", "yes");
INSERT INTO `wp_options` VALUES("928", "dbem_google_maps_browser_key", "", "yes");
INSERT INTO `wp_options` VALUES("929", "dbem_map_default_width", "400px", "yes");
INSERT INTO `wp_options` VALUES("930", "dbem_map_default_height", "300px", "yes");
INSERT INTO `wp_options` VALUES("931", "dbem_location_baloon_format", "<strong>#_LOCATIONNAME</strong><br/>#_LOCATIONADDRESS - #_LOCATIONTOWN<br/><a href=\"#_LOCATIONPAGEURL\">Wydarzenia</a>", "yes");
INSERT INTO `wp_options` VALUES("932", "dbem_map_text_format", "<strong>#_LOCATIONNAME</strong><p>#_LOCATIONADDRESS</p><p>#_LOCATIONTOWN</p>", "yes");
INSERT INTO `wp_options` VALUES("933", "dbem_email_disable_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("934", "dbem_rsvp_mail_port", "465", "yes");
INSERT INTO `wp_options` VALUES("935", "dbem_smtp_host", "localhost", "yes");
INSERT INTO `wp_options` VALUES("936", "dbem_mail_sender_name", "", "yes");
INSERT INTO `wp_options` VALUES("937", "dbem_rsvp_mail_send_method", "wp_mail", "yes");
INSERT INTO `wp_options` VALUES("938", "dbem_rsvp_mail_SMTPAuth", "1", "yes");
INSERT INTO `wp_options` VALUES("939", "dbem_smtp_html", "1", "yes");
INSERT INTO `wp_options` VALUES("940", "dbem_smtp_html_br", "1", "yes");
INSERT INTO `wp_options` VALUES("941", "dbem_image_max_width", "700", "yes");
INSERT INTO `wp_options` VALUES("942", "dbem_image_max_height", "700", "yes");
INSERT INTO `wp_options` VALUES("943", "dbem_image_min_width", "50", "yes");
INSERT INTO `wp_options` VALUES("944", "dbem_image_min_height", "50", "yes");
INSERT INTO `wp_options` VALUES("945", "dbem_image_max_size", "204800", "yes");
INSERT INTO `wp_options` VALUES("946", "dbem_list_date_title", "Wydarzenia - #j #M #y", "yes");
INSERT INTO `wp_options` VALUES("947", "dbem_full_calendar_month_format", "M Y", "yes");
INSERT INTO `wp_options` VALUES("948", "dbem_full_calendar_event_format", "<li>#_EVENTLINK</li>", "yes");
INSERT INTO `wp_options` VALUES("949", "dbem_full_calendar_long_events", "0", "yes");
INSERT INTO `wp_options` VALUES("950", "dbem_full_calendar_initials_length", "0", "yes");
INSERT INTO `wp_options` VALUES("951", "dbem_full_calendar_abbreviated_weekdays", "1", "yes");
INSERT INTO `wp_options` VALUES("952", "dbem_display_calendar_day_single_yes", "1", "yes");
INSERT INTO `wp_options` VALUES("953", "dbem_small_calendar_month_format", "M Y", "yes");
INSERT INTO `wp_options` VALUES("954", "dbem_small_calendar_event_title_format", "#_EVENTNAME", "yes");
INSERT INTO `wp_options` VALUES("955", "dbem_small_calendar_event_title_separator", ", ", "yes");
INSERT INTO `wp_options` VALUES("956", "dbem_small_calendar_initials_length", "1", "yes");
INSERT INTO `wp_options` VALUES("957", "dbem_small_calendar_abbreviated_weekdays", "", "yes");
INSERT INTO `wp_options` VALUES("958", "dbem_small_calendar_long_events", "0", "yes");
INSERT INTO `wp_options` VALUES("959", "dbem_display_calendar_order", "ASC", "yes");
INSERT INTO `wp_options` VALUES("960", "dbem_display_calendar_orderby", "event_name,event_start_time", "yes");
INSERT INTO `wp_options` VALUES("961", "dbem_display_calendar_events_limit", "3", "yes");
INSERT INTO `wp_options` VALUES("962", "dbem_display_calendar_events_limit_msg", "więcej...", "yes");
INSERT INTO `wp_options` VALUES("963", "dbem_calendar_direct_links", "1", "yes");
INSERT INTO `wp_options` VALUES("964", "dbem_require_location", "0", "yes");
INSERT INTO `wp_options` VALUES("965", "dbem_locations_enabled", "1", "yes");
INSERT INTO `wp_options` VALUES("966", "dbem_use_select_for_locations", "0", "yes");
INSERT INTO `wp_options` VALUES("967", "dbem_attributes_enabled", "1", "yes");
INSERT INTO `wp_options` VALUES("968", "dbem_recurrence_enabled", "1", "yes");
INSERT INTO `wp_options` VALUES("969", "dbem_rsvp_enabled", "1", "yes");
INSERT INTO `wp_options` VALUES("970", "dbem_categories_enabled", "1", "yes");
INSERT INTO `wp_options` VALUES("971", "dbem_tags_enabled", "1", "yes");
INSERT INTO `wp_options` VALUES("972", "dbem_placeholders_custom", "", "yes");
INSERT INTO `wp_options` VALUES("973", "dbem_location_attributes_enabled", "1", "yes");
INSERT INTO `wp_options` VALUES("974", "dbem_location_placeholders_custom", "", "yes");
INSERT INTO `wp_options` VALUES("975", "dbem_bookings_registration_disable", "0", "yes");
INSERT INTO `wp_options` VALUES("976", "dbem_bookings_registration_disable_user_emails", "0", "yes");
INSERT INTO `wp_options` VALUES("977", "dbem_bookings_approval", "1", "yes");
INSERT INTO `wp_options` VALUES("978", "dbem_bookings_approval_reserved", "0", "yes");
INSERT INTO `wp_options` VALUES("979", "dbem_bookings_approval_overbooking", "0", "yes");
INSERT INTO `wp_options` VALUES("980", "dbem_bookings_double", "0", "yes");
INSERT INTO `wp_options` VALUES("981", "dbem_bookings_user_cancellation", "1", "yes");
INSERT INTO `wp_options` VALUES("982", "dbem_bookings_currency", "USD", "yes");
INSERT INTO `wp_options` VALUES("983", "dbem_bookings_currency_decimal_point", ",", "yes");
INSERT INTO `wp_options` VALUES("984", "dbem_bookings_currency_thousands_sep", "&nbsp;", "yes");
INSERT INTO `wp_options` VALUES("985", "dbem_bookings_currency_format", "@#", "yes");
INSERT INTO `wp_options` VALUES("986", "dbem_bookings_tax", "0", "yes");
INSERT INTO `wp_options` VALUES("987", "dbem_bookings_tax_auto_add", "0", "yes");
INSERT INTO `wp_options` VALUES("988", "dbem_bookings_submit_button", "Wyślij zgłoszenie", "yes");
INSERT INTO `wp_options` VALUES("989", "dbem_bookings_login_form", "1", "yes");
INSERT INTO `wp_options` VALUES("990", "dbem_bookings_anonymous", "1", "yes");
INSERT INTO `wp_options` VALUES("991", "dbem_bookings_form_max", "20", "yes");
INSERT INTO `wp_options` VALUES("992", "dbem_bookings_form_msg_disabled", "Rezerwacje on-line na to wydarzenie nie są dostępne.", "yes");
INSERT INTO `wp_options` VALUES("993", "dbem_bookings_form_msg_closed", "Rezerwacje na to wydarzenie są już niedostępne.", "yes");
INSERT INTO `wp_options` VALUES("994", "dbem_bookings_form_msg_full", "To wydarzenie jest już w całości zarezerwowane.", "yes");
INSERT INTO `wp_options` VALUES("995", "dbem_bookings_form_msg_attending", "Wybierasz się na to wydarzenie.", "yes");
INSERT INTO `wp_options` VALUES("996", "dbem_bookings_form_msg_bookings_link", "Zarządzaj swoimi rezerwacjami.", "yes");
INSERT INTO `wp_options` VALUES("997", "dbem_booking_warning_cancel", "Na pewno anulować Twoją rezerwację?", "yes");
INSERT INTO `wp_options` VALUES("998", "dbem_booking_feedback_cancelled", "Rezerwacja Odwołane", "yes");
INSERT INTO `wp_options` VALUES("999", "dbem_booking_feedback_pending", "Rezerwacja dokonana pomyślnie, oczekuje na zatwierdzenie (wiadomość email zostanie wysłana po zatwierdzeniu).", "yes");
INSERT INTO `wp_options` VALUES("1000", "dbem_booking_feedback", "Rezerwacja dokonana pomyślnie.", "yes");
INSERT INTO `wp_options` VALUES("1001", "dbem_booking_feedback_full", "Rezerwacja nie jest możliwa. Brak wystarczającej ilości miejsc.", "yes");
INSERT INTO `wp_options` VALUES("1002", "dbem_booking_feedback_log_in", "Zaloguj sie lub zarejestruj, aby dokonać rezerwacji.", "yes");
INSERT INTO `wp_options` VALUES("1003", "dbem_booking_feedback_nomail", "Nie udało sie wysłać wiadomości e-mail do Ciebie i osoby zarządzającej wydarzeniem. Niemniej rezerwacja jest odnotowana w systemie. Prosimy skontaktować się bezpośrednio z organizatorem i dać znać o tym problemie. Przepraszamy za ten błąd.", "yes");
INSERT INTO `wp_options` VALUES("1004", "dbem_booking_feedback_error", "Nie mozna dokonać rezerwacji.:", "yes");
INSERT INTO `wp_options` VALUES("1005", "dbem_booking_feedback_email_exists", "Ten e-mail jest już w naszym systemie. Zaloguj się, aby dokonać rezerwacji.", "yes");
INSERT INTO `wp_options` VALUES("1006", "dbem_booking_feedback_new_user", "Nowe konto użytkownika zostało utworzone. Prosze sprawdzić swoją skrzynkę odbiorczą, aby uzyskać dane do logowania. ", "yes");
INSERT INTO `wp_options` VALUES("1007", "dbem_booking_feedback_reg_error", "Wystąpił problem podczas tworzenia nowego konta użytkownika. Proszę skontaktować się z administratorem strony.", "yes");
INSERT INTO `wp_options` VALUES("1008", "dbem_booking_feedback_already_booked", "Już zarejestrowałeś się na to wydarzenie.", "yes");
INSERT INTO `wp_options` VALUES("1009", "dbem_booking_feedback_min_space", "Musisz wybrać ilość miejsc, aby je zarezerwować.", "yes");
INSERT INTO `wp_options` VALUES("1010", "dbem_booking_feedback_spaces_limit", "Nie możesz zarezerwować więcej niż {b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}d miejsc na to wydarzenie.", "yes");
INSERT INTO `wp_options` VALUES("1011", "dbem_booking_button_msg_book", "Zarezerwuj", "yes");
INSERT INTO `wp_options` VALUES("1012", "dbem_booking_button_msg_booking", "Rezerwuję...", "yes");
INSERT INTO `wp_options` VALUES("1013", "dbem_booking_button_msg_booked", "Rezerwacja wysłana", "yes");
INSERT INTO `wp_options` VALUES("1014", "dbem_booking_button_msg_already_booked", "Już zarezerwowane", "yes");
INSERT INTO `wp_options` VALUES("1015", "dbem_booking_button_msg_error", "Rezerwacja - błąd. Spróbuj ponownie?", "yes");
INSERT INTO `wp_options` VALUES("1016", "dbem_booking_button_msg_full", "Wyprzedane", "yes");
INSERT INTO `wp_options` VALUES("1017", "dbem_booking_button_msg_closed", "Rezerwacja Zamknięta", "yes");
INSERT INTO `wp_options` VALUES("1018", "dbem_booking_button_msg_cancel", "Anuluj", "yes");
INSERT INTO `wp_options` VALUES("1019", "dbem_booking_button_msg_canceling", "Anulowanie...", "yes");
INSERT INTO `wp_options` VALUES("1020", "dbem_booking_button_msg_cancelled", "Odwołane", "yes");
INSERT INTO `wp_options` VALUES("1021", "dbem_booking_button_msg_cancel_error", "Anulacja - błąd. Spróbuj ponownie?", "yes");
INSERT INTO `wp_options` VALUES("1022", "dbem_bookings_notify_admin", "0", "yes");
INSERT INTO `wp_options` VALUES("1023", "dbem_bookings_contact_email", "1", "yes");
INSERT INTO `wp_options` VALUES("1024", "dbem_bookings_contact_email_pending_subject", "Rezerwacja w trakcie", "yes");
INSERT INTO `wp_options` VALUES("1025", "dbem_bookings_contact_email_pending_body", "Rezerwacja jest oczekująca :\n\r#_EVENTNAME - #_EVENTDATES @ #_EVENTTIMES\n\rAktualnie zarezerwowane są #_BOOKEDSPACES miejsca, dostępnych jest #_AVAILABLESPACES.\n\rSZCZEGółY REZERWACJI\n\rNazwa : #_BOOKINGNAME\nEmail : #_BOOKINGEMAIL\n\r#_BOOKINGSUMMARY\n\r\n\rPowered by Events Manager - http://wp-events-plugin.com", "yes");
INSERT INTO `wp_options` VALUES("1026", "dbem_bookings_contact_email_confirmed_subject", "Rezerwacja potwierdzona", "yes");
INSERT INTO `wp_options` VALUES("1027", "dbem_bookings_contact_email_confirmed_body", "Rezerwacja jest zatwierdzona :\n\r#_EVENTNAME - #_EVENTDATES @ #_EVENTTIMES\n\rAktualnie zarezerwowane są #_BOOKEDSPACES miejsca, dostępnych jest #_AVAILABLESPACES.\n\rSZCZEGółY REZERWACJI\n\rNazwa : #_BOOKINGNAME\nEmail : #_BOOKINGEMAIL\n\r#_BOOKINGSUMMARY\n\r\n\rPowered by Events Manager - http://wp-events-plugin.com", "yes");
INSERT INTO `wp_options` VALUES("1028", "dbem_bookings_contact_email_rejected_subject", "Rezerwacja odrzucona", "yes");
INSERT INTO `wp_options` VALUES("1029", "dbem_bookings_contact_email_rejected_body", "Rezerwacja jest odrzucona :\n\r#_EVENTNAME - #_EVENTDATES @ #_EVENTTIMES\n\rAktualnie zarezerwowane są #_BOOKEDSPACES miejsca, dostępnych jest #_AVAILABLESPACES.\n\rSZCZEGółY REZERWACJI\n\rNazwa : #_BOOKINGNAME\nEmail : #_BOOKINGEMAIL\n\r#_BOOKINGSUMMARY\n\r\n\rPowered by Events Manager - http://wp-events-plugin.com", "yes");
INSERT INTO `wp_options` VALUES("1030", "dbem_bookings_contact_email_cancelled_subject", "Rezerwacja anulowana", "yes");
INSERT INTO `wp_options` VALUES("1031", "dbem_bookings_contact_email_cancelled_body", "Rezerwacja jest odwołane :\n\r#_EVENTNAME - #_EVENTDATES @ #_EVENTTIMES\n\rAktualnie zarezerwowane są #_BOOKEDSPACES miejsca, dostępnych jest #_AVAILABLESPACES.\n\rSZCZEGółY REZERWACJI\n\rNazwa : #_BOOKINGNAME\nEmail : #_BOOKINGEMAIL\n\r#_BOOKINGSUMMARY\n\r\n\rPowered by Events Manager - http://wp-events-plugin.com", "yes");
INSERT INTO `wp_options` VALUES("1032", "dbem_bookings_email_pending_subject", "Rezerwacja w trakcie", "yes");
INSERT INTO `wp_options` VALUES("1033", "dbem_bookings_email_pending_body", "Witaj #_BOOKINGNAME, \n\rWysłałeś prośbę o zarezerwowanie #_BOOKINGSPACES miesc(a) na #_EVENTNAME.\n\rKiedy : #_EVENTDATES @ #_EVENTTIMES\n\rGdzie : #_LOCATIONNAME - #_LOCATIONFULLLINE\n\rTwoja prośba aktualnie oczekuje na zatwierdzenie przez naszych administratorów. Potwierdzenie rezerwacji zostanie wysłane automatycznie po jej zaakceptowaniu.\n\rPozdrawiamy,\n\r#_CONTACTNAME\n\r\n\r-------------------------------\n\rPowered by Events Manager - http://wp-events-plugin.com", "yes");
INSERT INTO `wp_options` VALUES("1034", "dbem_bookings_email_rejected_subject", "Rezerwacja odrzucona", "yes");
INSERT INTO `wp_options` VALUES("1035", "dbem_bookings_email_rejected_body", "Witaj #_BOOKINGNAME, \n\rTwoja prośba o zarezerwowanie #_BOOKINGSPACES miejsc na #_EVENTNAME w dniu #_EVENTDATES została odrzucona.\n\rPozdrawiamy,\n\r#_CONTACTNAME\n\r\n\r-------------------------------\n\rPowered by Events Manager - http://wp-events-plugin.com", "yes");
INSERT INTO `wp_options` VALUES("1036", "dbem_bookings_email_confirmed_subject", "Rezerwacja potwierdzona", "yes");
INSERT INTO `wp_options` VALUES("1037", "dbem_bookings_email_confirmed_body", "Witaj #_BOOKINGNAME, \n\r Udało Ci się poprawnie zarezerwować #_BOOKINGSPACES miejsc(e) na #_EVENTNAME.\n\r Kiedy:#_EVENTDATES @ #_EVENTTIMES\n\rGdzie: #_LOCATIONNAME - #_LOCATIONFULLLINE\n\rPozdrawiamy,\n\r#_CONTACTNAME\n\r\n\r-------------------------------\n\rPowered by Events Manager - http://wp-events-plugin.com", "yes");
INSERT INTO `wp_options` VALUES("1038", "dbem_bookings_email_cancelled_subject", "Rezerwacja anulowana", "yes");
INSERT INTO `wp_options` VALUES("1039", "dbem_bookings_email_cancelled_body", "Witaj #_BOOKINGNAME, \n\rTwoja rezerwacja #_BOOKINGSPACES miejsc(a) na #_EVENTNAME w dniu #_EVENTDATES została anulowana.\n\rPozdrawiamy,\n\r#_CONTACTNAME\n\r\n\r-------------------------------\n\rPowered by Events Manager - http://wp-events-plugin.com", "yes");
INSERT INTO `wp_options` VALUES("1040", "dbem_bookings_email_registration_subject", "[Body & Brain] Twoja nazwa użytkownika i hasło", "yes");
INSERT INTO `wp_options` VALUES("1041", "dbem_bookings_email_registration_body", "Konto zostało pomyślnie utworzone na Body & Brain\n\rMożesz zalogowac się na naszej stronie tutaj: http://bnb.testuj.website/wp-login.php\n\rNazwa użytkownika : {b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}username{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}\n\rHasło : {b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}password{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}\n\rAby zobaczyć Twoje rezerwacje, wejdź do http://bnb.testuj.website/wydarzenia/moje-rezerwacje/ po zalogowaniu.", "yes");
INSERT INTO `wp_options` VALUES("1042", "dbem_bookings_tickets_orderby", "ticket_price DESC, ticket_name ASC", "yes");
INSERT INTO `wp_options` VALUES("1043", "dbem_bookings_tickets_priority", "0", "yes");
INSERT INTO `wp_options` VALUES("1044", "dbem_bookings_tickets_show_unavailable", "0", "yes");
INSERT INTO `wp_options` VALUES("1045", "dbem_bookings_tickets_show_loggedout", "1", "yes");
INSERT INTO `wp_options` VALUES("1046", "dbem_bookings_tickets_single", "0", "yes");
INSERT INTO `wp_options` VALUES("1047", "dbem_bookings_tickets_single_form", "0", "yes");
INSERT INTO `wp_options` VALUES("1048", "dbem_bookings_my_title_format", "Moje rezerwacje", "yes");
INSERT INTO `wp_options` VALUES("1049", "dbem_bp_events_list_format_header", "<ul class=\"em-events-list\">", "yes");
INSERT INTO `wp_options` VALUES("1050", "dbem_bp_events_list_format", "<li>#_EVENTLINK - #_EVENTDATES - #_EVENTTIMES<ul><li>#_LOCATIONLINK - #_LOCATIONADDRESS, #_LOCATIONTOWN</li></ul></li>", "yes");
INSERT INTO `wp_options` VALUES("1051", "dbem_bp_events_list_format_footer", "</ul>", "yes");
INSERT INTO `wp_options` VALUES("1052", "dbem_bp_events_list_none_format", "<p class=\"em-events-list\">Brak wydarzeń</p>", "yes");
INSERT INTO `wp_options` VALUES("1053", "dbem_css_editors", "1", "yes");
INSERT INTO `wp_options` VALUES("1054", "dbem_css_rsvp", "1", "yes");
INSERT INTO `wp_options` VALUES("1055", "dbem_css_rsvpadmin", "1", "yes");
INSERT INTO `wp_options` VALUES("1056", "dbem_css_evlist", "1", "yes");
INSERT INTO `wp_options` VALUES("1057", "dbem_css_search", "1", "yes");
INSERT INTO `wp_options` VALUES("1058", "dbem_css_loclist", "1", "yes");
INSERT INTO `wp_options` VALUES("1059", "dbem_css_catlist", "1", "yes");
INSERT INTO `wp_options` VALUES("1060", "dbem_css_taglist", "1", "yes");
INSERT INTO `wp_options` VALUES("1061", "dbem_cp_events_slug", "events", "yes");
INSERT INTO `wp_options` VALUES("1062", "dbem_cp_locations_slug", "locations", "yes");
INSERT INTO `wp_options` VALUES("1063", "dbem_taxonomy_category_slug", "events/categories", "yes");
INSERT INTO `wp_options` VALUES("1064", "dbem_taxonomy_tag_slug", "events/tags", "yes");
INSERT INTO `wp_options` VALUES("1065", "dbem_cp_events_template", "", "yes");
INSERT INTO `wp_options` VALUES("1066", "dbem_cp_events_body_class", "", "yes");
INSERT INTO `wp_options` VALUES("1067", "dbem_cp_events_post_class", "", "yes");
INSERT INTO `wp_options` VALUES("1068", "dbem_cp_events_formats", "1", "yes");
INSERT INTO `wp_options` VALUES("1069", "dbem_cp_events_has_archive", "1", "yes");
INSERT INTO `wp_options` VALUES("1070", "dbem_events_default_archive_orderby", "_start_ts", "yes");
INSERT INTO `wp_options` VALUES("1071", "dbem_events_default_archive_order", "ASC", "yes");
INSERT INTO `wp_options` VALUES("1072", "dbem_events_archive_scope", "past", "yes");
INSERT INTO `wp_options` VALUES("1073", "dbem_cp_events_archive_formats", "1", "yes");
INSERT INTO `wp_options` VALUES("1074", "dbem_cp_events_excerpt_formats", "1", "yes");
INSERT INTO `wp_options` VALUES("1075", "dbem_cp_events_search_results", "0", "yes");
INSERT INTO `wp_options` VALUES("1076", "dbem_cp_events_custom_fields", "0", "yes");
INSERT INTO `wp_options` VALUES("1077", "dbem_cp_events_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("1078", "dbem_cp_locations_template", "", "yes");
INSERT INTO `wp_options` VALUES("1079", "dbem_cp_locations_body_class", "", "yes");
INSERT INTO `wp_options` VALUES("1080", "dbem_cp_locations_post_class", "", "yes");
INSERT INTO `wp_options` VALUES("1081", "dbem_cp_locations_formats", "1", "yes");
INSERT INTO `wp_options` VALUES("1082", "dbem_cp_locations_has_archive", "1", "yes");
INSERT INTO `wp_options` VALUES("1083", "dbem_locations_default_archive_orderby", "title", "yes");
INSERT INTO `wp_options` VALUES("1084", "dbem_locations_default_archive_order", "ASC", "yes");
INSERT INTO `wp_options` VALUES("1085", "dbem_cp_locations_archive_formats", "1", "yes");
INSERT INTO `wp_options` VALUES("1086", "dbem_cp_locations_excerpt_formats", "1", "yes");
INSERT INTO `wp_options` VALUES("1087", "dbem_cp_locations_search_results", "0", "yes");
INSERT INTO `wp_options` VALUES("1088", "dbem_cp_locations_custom_fields", "0", "yes");
INSERT INTO `wp_options` VALUES("1089", "dbem_cp_locations_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("1090", "dbem_cp_categories_formats", "1", "yes");
INSERT INTO `wp_options` VALUES("1091", "dbem_categories_default_archive_orderby", "event_start_date,event_start_time,event_name", "yes");
INSERT INTO `wp_options` VALUES("1092", "dbem_categories_default_archive_order", "ASC", "yes");
INSERT INTO `wp_options` VALUES("1093", "dbem_cp_tags_formats", "1", "yes");
INSERT INTO `wp_options` VALUES("1094", "dbem_tags_default_archive_orderby", "event_start_date,event_start_time,event_name", "yes");
INSERT INTO `wp_options` VALUES("1095", "dbem_tags_default_archive_order", "ASC", "yes");
INSERT INTO `wp_options` VALUES("1096", "dbem_disable_thumbnails", "", "yes");
INSERT INTO `wp_options` VALUES("1097", "dbem_feedback_reminder", "1509281748", "yes");
INSERT INTO `wp_options` VALUES("1098", "dbem_time_24h", "1", "yes");
INSERT INTO `wp_options` VALUES("1099", "dbem_credits", "1", "yes");
INSERT INTO `wp_options` VALUES("1100", "dbem_version", "5.7", "yes");
INSERT INTO `wp_options` VALUES("1101", "widget_em_locations_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1138", "loco_settings", "a:3:{s:1:\"c\";s:18:\"Loco_data_Settings\";s:1:\"v\";i:0;s:1:\"d\";a:10:{s:7:\"version\";s:6:\"2.0.16\";s:8:\"gen_hash\";b:0;s:9:\"use_fuzzy\";b:1;s:11:\"num_backups\";i:1;s:9:\"pot_alias\";a:3:{i:0;s:10:\"default.po\";i:1;s:8:\"en_US.po\";i:2;s:5:\"en.po\";}s:9:\"php_alias\";a:2:{i:0;s:3:\"php\";i:1;s:4:\"twig\";}s:10:\"fs_persist\";b:0;s:12:\"max_php_size\";s:4:\"100K\";s:11:\"po_utf8_bom\";b:0;s:8:\"po_width\";s:2:\"79\";}}", "yes");
INSERT INTO `wp_options` VALUES("1141", "_transient_loco_po_e086345c22ffb87fdaa4be4d6b5f0cdc", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:58:\"plugins/booking-calendar/languages/booking-calendar-lin.po\";s:5:\"bytes\";i:38640;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:424;s:1:\"p\";i:19;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1142", "_transient_loco_po_d40f7a5304a54204f8e5c4dbdcc03317", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:57:\"plugins/booking-calendar/languages/booking-calendar-el.po\";s:5:\"bytes\";i:32995;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:361;s:1:\"p\";i:44;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1143", "_transient_loco_po_5dbc9b616703b9794eabb20544f05305", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:57:\"plugins/booking-calendar/languages/booking-calendar-ga.po\";s:5:\"bytes\";i:32933;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:361;s:1:\"p\";i:44;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1144", "_transient_loco_po_59cb2509a718dbaacfb99fe7e20808ec", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:60:\"plugins/booking-calendar/languages/booking-calendar-da_DK.po\";s:5:\"bytes\";i:39099;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:424;s:1:\"p\";i:73;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1145", "_transient_loco_po_5987209f9f0f2a57dc855fc47d88181f", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:60:\"plugins/booking-calendar/languages/booking-calendar-bg_BG.po\";s:5:\"bytes\";i:51548;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:361;s:1:\"p\";i:361;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1146", "_transient_loco_po_f2d3be26dfcfd194d16cd57a474ef0fa", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:57:\"plugins/booking-calendar/languages/booking-calendar-et.po\";s:5:\"bytes\";i:32896;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:361;s:1:\"p\";i:44;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1147", "_transient_loco_po_4986737db9c0bb7e7a0e6cfc029cb3c3", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:60:\"plugins/booking-calendar/languages/booking-calendar-hu_HU.po\";s:5:\"bytes\";i:39218;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:424;s:1:\"p\";i:74;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1148", "_transient_loco_po_0471d05ab67ce0e32eda3d42857591f8", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:57:\"plugins/booking-calendar/languages/booking-calendar-eu.po\";s:5:\"bytes\";i:38483;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:424;s:1:\"p\";i:19;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1149", "_transient_loco_po_92ffe850c58af3bbd2651200ce7444b8", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:60:\"plugins/booking-calendar/languages/booking-calendar-de_DE.po\";s:5:\"bytes\";i:38715;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:424;s:1:\"p\";i:63;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1150", "_transient_loco_po_f38a4ebc15ac62eb2831bf92c3cdc728", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:60:\"plugins/booking-calendar/languages/booking-calendar-it_IT.po\";s:5:\"bytes\";i:39437;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:424;s:1:\"p\";i:95;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1151", "_transient_loco_po_71379f39aa353f157076f8f00f3b6e97", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:57:\"plugins/booking-calendar/languages/booking-calendar-ca.po\";s:5:\"bytes\";i:43811;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:361;s:1:\"p\";i:361;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1152", "_transient_loco_po_10847c631a7ebf03ebf74ad3b7790c51", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:57:\"plugins/booking-calendar/languages/booking-calendar-kk.po\";s:5:\"bytes\";i:38581;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:424;s:1:\"p\";i:19;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1153", "_transient_loco_po_5f8e22e7ce1289034e888d9d573276c8", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:57:\"plugins/booking-calendar/languages/booking-calendar-cy.po\";s:5:\"bytes\";i:38486;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:424;s:1:\"p\";i:19;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1154", "_transient_loco_po_785710164d075cda661048c910d2487e", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:60:\"plugins/booking-calendar/languages/booking-calendar-cs_CZ.po\";s:5:\"bytes\";i:49651;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:424;s:1:\"p\";i:424;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1155", "_transient_loco_po_0a2dba1b8146548c9fba16651ac8116a", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:57:\"plugins/booking-calendar/languages/booking-calendar-gd.po\";s:5:\"bytes\";i:38558;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:424;s:1:\"p\";i:19;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1156", "_transient_loco_po_1e8efa75dd18fbaceca2fd7ed8878375", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:60:\"plugins/booking-calendar/languages/booking-calendar-me_ME.po\";s:5:\"bytes\";i:38462;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:424;s:1:\"p\";i:19;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1157", "_transient_loco_po_438267f89cf791762ff7ae8dbda04d85", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:60:\"plugins/booking-calendar/languages/booking-calendar-he_IL.po\";s:5:\"bytes\";i:38411;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:424;s:1:\"p\";i:8;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1158", "_transient_loco_po_211080baffbe6d88b1340f15572a2900", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:57:\"plugins/booking-calendar/languages/booking-calendar-lv.po\";s:5:\"bytes\";i:38502;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:424;s:1:\"p\";i:19;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1159", "_transient_loco_po_b7ae06be62dbbd7de18333e510a9979e", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:60:\"plugins/booking-calendar/languages/booking-calendar-zh_CN.po\";s:5:\"bytes\";i:33110;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:365;s:1:\"p\";i:72;s:1:\"f\";i:2;}}}", "yes");
INSERT INTO `wp_options` VALUES("1160", "_transient_loco_po_7d5fe12210fa92ad60f9ddf7185f28f3", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:60:\"plugins/booking-calendar/languages/booking-calendar-fr_FR.po\";s:5:\"bytes\";i:39506;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:424;s:1:\"p\";i:90;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1161", "_transient_loco_po_9437a7946ab29995c31959b6760bc198", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:60:\"plugins/booking-calendar/languages/booking-calendar-nl_NL.po\";s:5:\"bytes\";i:32914;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:361;s:1:\"p\";i:49;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1162", "_transient_loco_po_e478cdaa4779427c5d062fbe327f75b1", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:60:\"plugins/booking-calendar/languages/booking-calendar-bs_BA.po\";s:5:\"bytes\";i:38463;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:424;s:1:\"p\";i:19;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1163", "_transient_loco_po_afe54a2656aa295a04535e9cc9458ef3", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:60:\"plugins/booking-calendar/languages/booking-calendar-tr_TR.po\";s:5:\"bytes\";i:38532;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:424;s:1:\"p\";i:44;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1164", "_transient_loco_po_d00d5e7a022e9561a3f7d552776b174a", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:60:\"plugins/booking-calendar/languages/booking-calendar-pt_BR.po\";s:5:\"bytes\";i:38493;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:424;s:1:\"p\";i:19;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1165", "_transient_loco_po_2021a0a7b96ca7bdbd9b15f03ad6f365", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:60:\"plugins/booking-calendar/languages/booking-calendar-sr_RS.po\";s:5:\"bytes\";i:39525;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:424;s:1:\"p\";i:66;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1166", "_transient_loco_po_e1b9584b78dca4a87d1a5ff67cf0ef79", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:60:\"plugins/booking-calendar/languages/booking-calendar-ru_RU.po\";s:5:\"bytes\";i:40325;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:424;s:1:\"p\";i:97;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1167", "_transient_loco_po_bcd4345c2f49c66f0f3876f062d7b2de", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:57:\"plugins/booking-calendar/languages/booking-calendar-sq.po\";s:5:\"bytes\";i:38467;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:424;s:1:\"p\";i:19;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1168", "_transient_loco_po_3cf7928d5a1045480c52fe0117df403c", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:60:\"plugins/booking-calendar/languages/booking-calendar-sv_SE.po\";s:5:\"bytes\";i:38566;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:424;s:1:\"p\";i:47;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1169", "_transient_loco_po_9764740e24365b302c39747635e9c4c4", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:57:\"plugins/booking-calendar/languages/booking-calendar-fi.po\";s:5:\"bytes\";i:32905;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:361;s:1:\"p\";i:44;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1170", "_transient_loco_po_f933ba35e32d636ae0ce7ec24cedc0ce", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:60:\"plugins/booking-calendar/languages/booking-calendar-sl_SI.po\";s:5:\"bytes\";i:32871;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:361;s:1:\"p\";i:44;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1171", "_transient_loco_po_7ee53b691217ca53efbe60e5f44a5d90", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:60:\"plugins/booking-calendar/languages/booking-calendar-ro_RO.po\";s:5:\"bytes\";i:32884;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:361;s:1:\"p\";i:44;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1172", "_transient_loco_po_50cba1c75643908f93709e7f7d04be8f", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:57:\"plugins/booking-calendar/languages/booking-calendar-mn.po\";s:5:\"bytes\";i:38763;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:424;s:1:\"p\";i:19;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1173", "_transient_loco_po_6620e7291159877ff3bc538ca9b11310", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:57:\"plugins/booking-calendar/languages/booking-calendar-hr.po\";s:5:\"bytes\";i:38551;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:424;s:1:\"p\";i:44;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1174", "_transient_loco_po_caf529cbebebbc09e93cc399274cc2ef", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:61:\"plugins/booking-calendar/languages/booking-calendar-haw_US.po\";s:5:\"bytes\";i:38479;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:424;s:1:\"p\";i:19;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1175", "_transient_loco_po_962cbb2c60ad5bcedb924c2dec204736", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:60:\"plugins/booking-calendar/languages/booking-calendar-mk_MK.po\";s:5:\"bytes\";i:38591;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:424;s:1:\"p\";i:21;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1176", "_transient_loco_po_aa8499007cb00ba1721279722bb0f464", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:58:\"plugins/booking-calendar/languages/booking-calendar-ceb.po\";s:5:\"bytes\";i:38467;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:424;s:1:\"p\";i:19;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1177", "_transient_loco_po_bdfe134917504e11e354ef4611d5c9cb", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:61:\"plugins/booking-calendar/languages/booking-calendarr-da_DK.po\";s:5:\"bytes\";i:39079;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:424;s:1:\"p\";i:71;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1178", "_transient_loco_po_7c1bdbbf354916efd85907553326c316", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:54:\"plugins/booking-calendar/languages/booking-calendar.po\";s:5:\"bytes\";i:38340;s:5:\"mtime\";i:1509281974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:424;s:1:\"p\";i:0;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1179", "loco_recent", "a:3:{s:1:\"c\";s:21:\"Loco_data_RecentItems\";s:1:\"v\";i:0;s:1:\"d\";a:1:{s:6:\"bundle\";a:1:{s:44:\"plugin.booking-calendar/booking_calendar.php\";i:1509284590;}}}", "no");
INSERT INTO `wp_options` VALUES("1180", "_transient_loco_po_bf487c43bc244b50258446ba188c2777", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:55:\"plugins/booking-calendar/languages/booking-calendar.pot\";s:5:\"bytes\";i:38277;s:5:\"mtime\";i:1509284082;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:430;s:1:\"p\";i:0;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("1194", "newsletter_diagnostic_cron_data", "a:3:{s:4:\"mean\";d:9604.9599999999991268850862979888916015625;s:3:\"max\";i:866401;s:3:\"min\";i:12;}", "no");
INSERT INTO `wp_options` VALUES("1212", "widget_wpsimplebookingcalendar_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1216", "wp-simple-booking-calendar-options", "a:1:{s:9:\"calendars\";a:1:{i:1;a:4:{s:12:\"calendarName\";s:18:\"Rezerwacja terminu\";s:12:\"calendarJson\";s:2:\"[]\";s:11:\"dateCreated\";i:1509286593;s:12:\"dateModified\";i:1509286593;}}}", "yes");
INSERT INTO `wp_options` VALUES("1222", "appointments_salt", "1780675413", "yes");
INSERT INTO `wp_options` VALUES("1223", "app_db_version", "2.2.2.2", "yes");
INSERT INTO `wp_options` VALUES("1224", "widget_appointments_services", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1225", "widget_appointments_service_providers", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1226", "widget_appointments_monthly_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1227", "app_last_update", "1509287043", "yes");
INSERT INTO `wp_options` VALUES("1228", "appointments_options", "a:57:{s:8:\"min_time\";i:30;s:19:\"additional_min_time\";s:0:\"\";s:14:\"admin_min_time\";s:0:\"\";s:15:\"app_lower_limit\";i:0;s:9:\"app_limit\";i:365;s:10:\"clear_time\";i:60;s:9:\"spam_time\";i:0;s:12:\"auto_confirm\";s:2:\"no\";s:22:\"allow_worker_selection\";s:2:\"no\";s:20:\"allow_worker_confirm\";s:2:\"no\";s:14:\"allow_overwork\";s:2:\"no\";s:20:\"allow_overwork_break\";s:2:\"no\";s:17:\"dummy_assigned_to\";i:0;s:13:\"app_page_type\";s:7:\"monthly\";s:17:\"accept_api_logins\";s:0:\"\";s:15:\"facebook-app_id\";s:0:\"\";s:14:\"twitter-app_id\";s:0:\"\";s:18:\"twitter-app_secret\";s:0:\"\";s:11:\"show_legend\";s:3:\"yes\";s:4:\"gcal\";s:3:\"yes\";s:13:\"gcal_location\";s:0:\"\";s:14:\"gcal_overwrite\";b:0;s:9:\"color_set\";i:1;s:10:\"free_color\";s:6:\"48c048\";s:10:\"busy_color\";s:6:\"ffffff\";s:17:\"notpossible_color\";s:6:\"ffffff\";s:19:\"make_an_appointment\";s:0:\"\";s:8:\"ask_name\";s:1:\"1\";s:9:\"ask_email\";s:1:\"1\";s:9:\"ask_phone\";s:1:\"1\";s:11:\"ask_address\";s:0:\"\";s:8:\"ask_city\";s:0:\"\";s:8:\"ask_note\";s:0:\"\";s:14:\"additional_css\";s:40:\".entry-content td{border:none;width:50{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}}\";s:16:\"payment_required\";s:2:\"no\";s:15:\"percent_deposit\";s:0:\"\";s:13:\"fixed_deposit\";s:0:\"\";s:8:\"currency\";s:3:\"USD\";s:4:\"mode\";s:7:\"sandbox\";s:14:\"merchant_email\";s:0:\"\";s:6:\"return\";i:1;s:14:\"login_required\";s:2:\"no\";s:17:\"send_confirmation\";s:3:\"yes\";s:17:\"send_notification\";s:2:\"no\";s:13:\"send_reminder\";s:3:\"yes\";s:13:\"reminder_time\";s:2:\"24\";s:20:\"send_reminder_worker\";s:3:\"yes\";s:20:\"reminder_time_worker\";s:1:\"4\";s:20:\"confirmation_subject\";s:32:\"Confirmation of your Appointment\";s:20:\"confirmation_message\";s:236:\"Dear CLIENT,\n\nWe are pleased to confirm your appointment for SITE_NAME.\n\nHere are the appointment details:\nRequested service: SERVICE\nDate and time: DATE_TIME\n\nSERVICE_PROVIDER will assist you for this service.\n\nKind regards,\nSITE_NAME\n\";s:16:\"reminder_subject\";s:29:\"Reminder for your Appointment\";s:16:\"reminder_message\";s:243:\"Dear CLIENT,\n\nWe would like to remind you of your appointment with SITE_NAME.\n\nHere are your appointment details:\nRequested service: SERVICE\nDate and time: DATE_TIME\n\nSERVICE_PROVIDER will assist you for this service.\n\nKind regards,\nSITE_NAME\n\";s:10:\"log_emails\";s:3:\"yes\";s:12:\"allow_cancel\";s:2:\"no\";s:11:\"cancel_page\";i:0;s:10:\"thank_page\";i:0;s:25:\"keep_options_on_uninstall\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("1229", "app_admin_notices", "a:1:{s:8:\"1-7-gcal\";a:1:{s:3:\"cap\";s:14:\"manage_options\";}}", "yes");
INSERT INTO `wp_options` VALUES("1238", "cf7dp_ui_theme", "smoothness", "yes");
INSERT INTO `wp_options` VALUES("1244", "cfdb7_view_install_date", "2017-10-29 14:40:23", "yes");
INSERT INTO `wp_options` VALUES("1290", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:28:\"wordpress@bnb.testuj.website\";s:7:\"version\";s:5:\"4.8.4\";s:9:\"timestamp\";i:1512051293;}", "no");
INSERT INTO `wp_options` VALUES("1340", "widget_wp_subscribe", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1354", "sbscrbr_options", "a:48:{s:21:\"plugin_option_version\";s:5:\"1.3.7\";s:13:\"first_install\";i:1510161125;s:22:\"suggest_feature_banner\";i:1;s:23:\"display_settings_notice\";i:1;s:10:\"form_label\";s:0:\"\";s:16:\"form_placeholder\";s:6:\"E-mail\";s:19:\"form_checkbox_label\";s:11:\"unsubscribe\";s:17:\"form_button_label\";s:9:\"Subscribe\";s:11:\"bad_request\";s:31:\"System error. Please try later.\";s:11:\"empty_email\";s:28:\"Please enter e-mail address.\";s:13:\"invalid_email\";s:38:\"You must enter a valid e-mail address.\";s:16:\"not_exists_email\";s:35:\"This e-mail address does not exist.\";s:16:\"cannot_get_email\";s:42:\"Your e-mail information cannot be located.\";s:17:\"cannot_send_email\";s:57:\"Unable to send the e-mail at this time. Please try later.\";s:15:\"error_subscribe\";s:53:\"Error occurred during registration. Please try later.\";s:14:\"done_subscribe\";s:26:\"Thank you for subscribing!\";s:17:\"already_subscribe\";s:42:\"This e-mail address is already subscribed.\";s:16:\"denied_subscribe\";s:53:\"Sorry, but your request to subscribe has been denied.\";s:19:\"already_unsubscribe\";s:35:\"You have successfully unsubscribed.\";s:23:\"check_email_unsubscribe\";s:41:\"An unsubscribe link has been sent to you.\";s:22:\"not_exists_unsubscribe\";s:82:\"Unsubscribe link failed. We respect your wishes. Please contact us to let us know.\";s:16:\"done_unsubscribe\";s:35:\"You have successfully unsubscribed.\";s:10:\"email_user\";i:1;s:12:\"email_custom\";a:1:{i:0;s:28:\"wordpress@bnb.testuj.website\";}s:8:\"to_email\";s:6:\"custom\";s:16:\"from_custom_name\";s:16:\"Body &amp; Brain\";s:10:\"from_email\";s:28:\"wordpress@bnb.testuj.website\";s:13:\"admin_message\";i:1;s:21:\"admin_message_subject\";s:14:\"New subscriber\";s:25:\"subscribe_message_subject\";s:23:\"Thanks for registration\";s:27:\"unsubscribe_message_subject\";s:19:\"Link to unsubscribe\";s:18:\"admin_message_text\";s:61:\"User with e-mail {user_email} has subscribed to a newsletter.\";s:22:\"subscribe_message_text\";s:173:\"Thanks for registration. To change data of your profile go to {profile_page}\n If you want to unsubscribe from the newsletter from our site go to the link \n{unsubscribe_link}\";s:24:\"unsubscribe_message_text\";s:227:\"Dear user. At your request, we send you a link to unsubscribe from our email messages. To unsubscribe please use the link below. If you change your mind, you can just ignore this letter.\nLink to unsubscribe:\n {unsubscribe_link}\";s:24:\"admin_message_use_sender\";i:0;s:32:\"admin_message_sender_template_id\";s:0:\"\";s:28:\"subscribe_message_use_sender\";i:0;s:36:\"subscribe_message_sender_template_id\";s:0:\"\";s:30:\"unsubscribe_message_use_sender\";i:0;s:38:\"unsubscribe_message_sender_template_id\";s:0:\"\";s:21:\"unsubscribe_link_text\";s:106:\"If you want to unsubscribe from the newsletter from our site go to the following link: \n{unsubscribe_link}\";s:12:\"delete_users\";i:0;s:12:\"contact_form\";i:0;s:19:\"shortcode_link_type\";s:3:\"url\";s:13:\"shortcode_url\";s:25:\"http://bnb.testuj.website\";s:20:\"hide_premium_options\";a:0:{}s:17:\"plugin_db_version\";s:3:\"1.0\";s:19:\"go_settings_counter\";i:6;}", "yes");
INSERT INTO `wp_options` VALUES("1355", "widget_sbscrbr_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1356", "bstwbsftwppdtplgns_options", "a:1:{s:8:\"bws_menu\";a:1:{s:7:\"version\";a:1:{s:25:\"subscriber/subscriber.php\";s:5:\"2.1.1\";}}}", "yes");
INSERT INTO `wp_options` VALUES("1396", "sml_subscribe_widget_title", "", "yes");
INSERT INTO `wp_options` VALUES("1397", "sml_subscribe_widget_prepend", "", "yes");
INSERT INTO `wp_options` VALUES("1398", "sml_subscribe_widget_jsthanks", "0", "yes");
INSERT INTO `wp_options` VALUES("1399", "sml_subscribe_widget_thankyou", "", "yes");
INSERT INTO `wp_options` VALUES("1400", "sml_subscribe_widget_showname", "", "yes");
INSERT INTO `wp_options` VALUES("1401", "sml_subscribe_widget_nametxt", "", "yes");
INSERT INTO `wp_options` VALUES("1402", "sml_subscribe_widget_nameholder", "", "yes");
INSERT INTO `wp_options` VALUES("1403", "sml_subscribe_widget_emailtxt", "", "yes");
INSERT INTO `wp_options` VALUES("1404", "sml_subscribe_widget_emailholder", "", "yes");
INSERT INTO `wp_options` VALUES("1405", "sml_subscribe_widget_showsubmit", "", "yes");
INSERT INTO `wp_options` VALUES("1406", "sml_subscribe_widget_submittxt", "", "yes");
INSERT INTO `wp_options` VALUES("1619", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1621", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/pl_PL/wordpress-4.9.1.zip\";s:6:\"locale\";s:5:\"pl_PL\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/pl_PL/wordpress-4.9.1.zip\";s:10:\"no_content\";b:0;s:11:\"new_bundled\";b:0;s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.9.1\";s:7:\"version\";s:5:\"4.9.1\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1513178614;s:15:\"version_checked\";s:5:\"4.9.1\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("1728", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("1735", "_site_transient_timeout_browser_ead856262e4f0221ec6c4a08aee66ec2", "1513584770", "no");
INSERT INTO `wp_options` VALUES("1736", "_site_transient_browser_ead856262e4f0221ec6c4a08aee66ec2", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"62.0.3202.62\";s:8:\"platform\";s:5:\"Linux\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("1791", "_transient_timeout_plugin_slugs", "1513179578", "no");
INSERT INTO `wp_options` VALUES("1792", "_transient_plugin_slugs", "a:13:{i:0;s:19:\"akismet/akismet.php\";i:1;s:36:\"contact-form-7/wp-contact-form-7.php\";i:2;s:55:\"contact-form-7-datepicker/contact-form-7-datepicker.php\";i:3;s:23:\"debug-bar/debug-bar.php\";i:4;s:25:\"duplicator/duplicator.php\";i:5;s:62:\"featured-image-admin-thumb-fiat/featured-image-admin-thumb.php\";i:6;s:9:\"hello.php\";i:7;s:23:\"loco-translate/loco.php\";i:8;s:27:\"mail-subscribe-list/sml.php\";i:9;s:21:\"meta-box/meta-box.php\";i:10;s:41:\"meta-box-show-hide/meta-box-show-hide.php\";i:11;s:21:\"newsletter/plugin.php\";i:12;s:37:\"post-types-order/post-types-order.php\";}", "no");
INSERT INTO `wp_options` VALUES("1793", "cpto_options", "a:7:{s:23:\"show_reorder_interfaces\";a:4:{s:4:\"post\";s:4:\"hide\";s:10:\"attachment\";s:4:\"hide\";s:12:\"testimonials\";s:4:\"hide\";s:6:\"slider\";s:4:\"show\";}s:8:\"autosort\";i:1;s:9:\"adminsort\";i:1;s:18:\"use_query_ASC_DESC\";s:0:\"\";s:17:\"archive_drag_drop\";i:1;s:10:\"capability\";s:14:\"manage_options\";s:21:\"navigation_sort_apply\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1794", "CPT_configured", "TRUE", "yes");
INSERT INTO `wp_options` VALUES("1802", "_site_transient_timeout_browser_cb0f25941c7ee58acd15fece4d84c18b", "1513691427", "no");
INSERT INTO `wp_options` VALUES("1803", "_site_transient_browser_cb0f25941c7ee58acd15fece4d84c18b", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"62.0.3202.94\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("1815", "_site_transient_timeout_theme_roots", "1513180415", "no");
INSERT INTO `wp_options` VALUES("1816", "_site_transient_theme_roots", "a:5:{s:10:\"bodynbrain\";s:7:\"/themes\";s:3:\"dev\";s:7:\"/themes\";s:13:\"twentyfifteen\";s:7:\"/themes\";s:15:\"twentyseventeen\";s:7:\"/themes\";s:13:\"twentysixteen\";s:7:\"/themes\";}", "no");
INSERT INTO `wp_options` VALUES("1817", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1513178620;s:7:\"checked\";a:4:{s:10:\"bodynbrain\";s:0:\"\";s:13:\"twentyfifteen\";s:3:\"1.8\";s:15:\"twentyseventeen\";s:3:\"1.3\";s:13:\"twentysixteen\";s:3:\"1.3\";}s:8:\"response\";a:3:{s:13:\"twentyfifteen\";a:4:{s:5:\"theme\";s:13:\"twentyfifteen\";s:11:\"new_version\";s:3:\"1.9\";s:3:\"url\";s:43:\"https://wordpress.org/themes/twentyfifteen/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/theme/twentyfifteen.1.9.zip\";}s:15:\"twentyseventeen\";a:4:{s:5:\"theme\";s:15:\"twentyseventeen\";s:11:\"new_version\";s:3:\"1.4\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentyseventeen/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentyseventeen.1.4.zip\";}s:13:\"twentysixteen\";a:4:{s:5:\"theme\";s:13:\"twentysixteen\";s:11:\"new_version\";s:3:\"1.4\";s:3:\"url\";s:43:\"https://wordpress.org/themes/twentysixteen/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/theme/twentysixteen.1.4.zip\";}}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("1818", "_site_transient_update_plugins", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1513178618;s:8:\"response\";a:6:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":11:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"4.0.1\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.4.0.1.zip\";s:5:\"icons\";a:3:{s:2:\"1x\";s:59:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=969272\";s:2:\"2x\";s:59:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=969272\";s:7:\"default\";s:59:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=969272\";}s:7:\"banners\";a:2:{s:2:\"1x\";s:61:\"https://ps.w.org/akismet/assets/banner-772x250.jpg?rev=479904\";s:7:\"default\";s:61:\"https://ps.w.org/akismet/assets/banner-772x250.jpg?rev=479904\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"4.9.1\";s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":11:{s:2:\"id\";s:28:\"w.org/plugins/contact-form-7\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:5:\"4.9.2\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.9.2.zip\";s:5:\"icons\";a:3:{s:2:\"1x\";s:66:\"https://ps.w.org/contact-form-7/assets/icon-128x128.png?rev=984007\";s:2:\"2x\";s:66:\"https://ps.w.org/contact-form-7/assets/icon-256x256.png?rev=984007\";s:7:\"default\";s:66:\"https://ps.w.org/contact-form-7/assets/icon-256x256.png?rev=984007\";}s:7:\"banners\";a:3:{s:2:\"2x\";s:69:\"https://ps.w.org/contact-form-7/assets/banner-1544x500.png?rev=860901\";s:2:\"1x\";s:68:\"https://ps.w.org/contact-form-7/assets/banner-772x250.png?rev=880427\";s:7:\"default\";s:69:\"https://ps.w.org/contact-form-7/assets/banner-1544x500.png?rev=860901\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"4.9.1\";s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":11:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"1.2.30\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.1.2.30.zip\";s:5:\"icons\";a:3:{s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=1298463\";s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=1298463\";s:7:\"default\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=1298463\";}s:7:\"banners\";a:2:{s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=1645055\";s:7:\"default\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=1645055\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"4.9.1\";s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:23:\"loco-translate/loco.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:28:\"w.org/plugins/loco-translate\";s:4:\"slug\";s:14:\"loco-translate\";s:6:\"plugin\";s:23:\"loco-translate/loco.php\";s:11:\"new_version\";s:6:\"2.0.17\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/loco-translate/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/loco-translate.2.0.17.zip\";s:5:\"icons\";a:3:{s:2:\"1x\";s:67:\"https://ps.w.org/loco-translate/assets/icon-128x128.png?rev=1000676\";s:2:\"2x\";s:67:\"https://ps.w.org/loco-translate/assets/icon-256x256.png?rev=1000676\";s:7:\"default\";s:67:\"https://ps.w.org/loco-translate/assets/icon-256x256.png?rev=1000676\";}s:7:\"banners\";a:2:{s:2:\"1x\";s:68:\"https://ps.w.org/loco-translate/assets/banner-772x250.jpg?rev=745046\";s:7:\"default\";s:68:\"https://ps.w.org/loco-translate/assets/banner-772x250.jpg?rev=745046\";}s:11:\"banners_rtl\";a:0:{}s:14:\"upgrade_notice\";s:54:\"<ul>\n<li>Various bug fixes and improvements</li>\n</ul>\";s:6:\"tested\";s:5:\"4.9.1\";s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:21:\"meta-box/meta-box.php\";O:8:\"stdClass\":11:{s:2:\"id\";s:22:\"w.org/plugins/meta-box\";s:4:\"slug\";s:8:\"meta-box\";s:6:\"plugin\";s:21:\"meta-box/meta-box.php\";s:11:\"new_version\";s:6:\"4.12.6\";s:3:\"url\";s:39:\"https://wordpress.org/plugins/meta-box/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/meta-box.4.12.6.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:61:\"https://ps.w.org/meta-box/assets/icon-128x128.png?rev=1100915\";s:7:\"default\";s:61:\"https://ps.w.org/meta-box/assets/icon-128x128.png?rev=1100915\";}s:7:\"banners\";a:2:{s:2:\"1x\";s:63:\"https://ps.w.org/meta-box/assets/banner-772x250.png?rev=1626382\";s:7:\"default\";s:63:\"https://ps.w.org/meta-box/assets/banner-772x250.png?rev=1626382\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"4.9.1\";s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:21:\"newsletter/plugin.php\";O:8:\"stdClass\":11:{s:2:\"id\";s:24:\"w.org/plugins/newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:6:\"plugin\";s:21:\"newsletter/plugin.php\";s:11:\"new_version\";s:5:\"5.1.7\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/newsletter/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/newsletter.5.1.7.zip\";s:5:\"icons\";a:3:{s:2:\"1x\";s:63:\"https://ps.w.org/newsletter/assets/icon-128x128.png?rev=1160467\";s:2:\"2x\";s:63:\"https://ps.w.org/newsletter/assets/icon-256x256.png?rev=1052028\";s:7:\"default\";s:63:\"https://ps.w.org/newsletter/assets/icon-256x256.png?rev=1052028\";}s:7:\"banners\";a:3:{s:2:\"2x\";s:66:\"https://ps.w.org/newsletter/assets/banner-1544x500.png?rev=1052027\";s:2:\"1x\";s:65:\"https://ps.w.org/newsletter/assets/banner-772x250.png?rev=1052027\";s:7:\"default\";s:66:\"https://ps.w.org/newsletter/assets/banner-1544x500.png?rev=1052027\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"4.9.1\";s:13:\"compatibility\";O:8:\"stdClass\":0:{}}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:6:{s:55:\"contact-form-7-datepicker/contact-form-7-datepicker.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:39:\"w.org/plugins/contact-form-7-datepicker\";s:4:\"slug\";s:25:\"contact-form-7-datepicker\";s:6:\"plugin\";s:55:\"contact-form-7-datepicker/contact-form-7-datepicker.php\";s:11:\"new_version\";s:5:\"2.6.0\";s:3:\"url\";s:56:\"https://wordpress.org/plugins/contact-form-7-datepicker/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/contact-form-7-datepicker.zip\";s:5:\"icons\";a:0:{}s:7:\"banners\";a:0:{}s:11:\"banners_rtl\";a:0:{}}s:23:\"debug-bar/debug-bar.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:23:\"w.org/plugins/debug-bar\";s:4:\"slug\";s:9:\"debug-bar\";s:6:\"plugin\";s:23:\"debug-bar/debug-bar.php\";s:11:\"new_version\";s:3:\"0.9\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/debug-bar/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/debug-bar.0.9.zip\";s:5:\"icons\";a:0:{}s:7:\"banners\";a:3:{s:2:\"2x\";s:65:\"https://ps.w.org/debug-bar/assets/banner-1544x500.png?rev=1365496\";s:2:\"1x\";s:64:\"https://ps.w.org/debug-bar/assets/banner-772x250.png?rev=1365496\";s:7:\"default\";s:65:\"https://ps.w.org/debug-bar/assets/banner-1544x500.png?rev=1365496\";}s:11:\"banners_rtl\";a:0:{}}s:62:\"featured-image-admin-thumb-fiat/featured-image-admin-thumb.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:45:\"w.org/plugins/featured-image-admin-thumb-fiat\";s:4:\"slug\";s:31:\"featured-image-admin-thumb-fiat\";s:6:\"plugin\";s:62:\"featured-image-admin-thumb-fiat/featured-image-admin-thumb.php\";s:11:\"new_version\";s:5:\"1.4.3\";s:3:\"url\";s:62:\"https://wordpress.org/plugins/featured-image-admin-thumb-fiat/\";s:7:\"package\";s:80:\"https://downloads.wordpress.org/plugin/featured-image-admin-thumb-fiat.1.4.4.zip\";s:5:\"icons\";a:0:{}s:7:\"banners\";a:2:{s:2:\"1x\";s:85:\"https://ps.w.org/featured-image-admin-thumb-fiat/assets/banner-772x250.jpg?rev=969070\";s:7:\"default\";s:85:\"https://ps.w.org/featured-image-admin-thumb-fiat/assets/banner-772x250.jpg?rev=969070\";}s:11:\"banners_rtl\";a:0:{}}s:9:\"hello.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:25:\"w.org/plugins/hello-dolly\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/hello-dolly.1.6.zip\";s:5:\"icons\";a:3:{s:2:\"1x\";s:63:\"https://ps.w.org/hello-dolly/assets/icon-128x128.jpg?rev=969907\";s:2:\"2x\";s:63:\"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=969907\";s:7:\"default\";s:63:\"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=969907\";}s:7:\"banners\";a:2:{s:2:\"1x\";s:65:\"https://ps.w.org/hello-dolly/assets/banner-772x250.png?rev=478342\";s:7:\"default\";s:65:\"https://ps.w.org/hello-dolly/assets/banner-772x250.png?rev=478342\";}s:11:\"banners_rtl\";a:0:{}}s:27:\"mail-subscribe-list/sml.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:33:\"w.org/plugins/mail-subscribe-list\";s:4:\"slug\";s:19:\"mail-subscribe-list\";s:6:\"plugin\";s:27:\"mail-subscribe-list/sml.php\";s:11:\"new_version\";s:5:\"2.1.3\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/mail-subscribe-list/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/mail-subscribe-list.2.1.3.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:72:\"https://ps.w.org/mail-subscribe-list/assets/icon-128x128.png?rev=1158481\";s:7:\"default\";s:72:\"https://ps.w.org/mail-subscribe-list/assets/icon-128x128.png?rev=1158481\";}s:7:\"banners\";a:2:{s:2:\"1x\";s:73:\"https://ps.w.org/mail-subscribe-list/assets/banner-772x250.png?rev=672352\";s:7:\"default\";s:73:\"https://ps.w.org/mail-subscribe-list/assets/banner-772x250.png?rev=672352\";}s:11:\"banners_rtl\";a:0:{}}s:37:\"post-types-order/post-types-order.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:30:\"w.org/plugins/post-types-order\";s:4:\"slug\";s:16:\"post-types-order\";s:6:\"plugin\";s:37:\"post-types-order/post-types-order.php\";s:11:\"new_version\";s:7:\"1.9.3.5\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/post-types-order/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/post-types-order.1.9.3.5.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:69:\"https://ps.w.org/post-types-order/assets/icon-128x128.png?rev=1226428\";s:7:\"default\";s:69:\"https://ps.w.org/post-types-order/assets/icon-128x128.png?rev=1226428\";}s:7:\"banners\";a:3:{s:2:\"2x\";s:72:\"https://ps.w.org/post-types-order/assets/banner-1544x500.png?rev=1675574\";s:2:\"1x\";s:71:\"https://ps.w.org/post-types-order/assets/banner-772x250.png?rev=1429949\";s:7:\"default\";s:72:\"https://ps.w.org/post-types-order/assets/banner-1544x500.png?rev=1675574\";}s:11:\"banners_rtl\";a:0:{}}}}", "no");
INSERT INTO `wp_options` VALUES("1819", "_site_transient_timeout_community-events-9ef6f93271f99c053b3b9921aeb640bd", "1513221824", "no");
INSERT INTO `wp_options` VALUES("1820", "_site_transient_community-events-9ef6f93271f99c053b3b9921aeb640bd", "a:2:{s:8:\"location\";a:1:{s:2:\"ip\";s:11:\"91.239.36.0\";}s:6:\"events\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("1821", "_transient_timeout_feed_a421d6f32723068ab074a40017a9e1f9", "1513221825", "no");
INSERT INTO `wp_options` VALUES("1822", "_transient_feed_a421d6f32723068ab074a40017a9e1f9", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Polska\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://pl.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"\n	Sat, 04 Nov 2017 00:38:44 +0000	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"pl-PL\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=5.0-alpha-42387\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"WordPress 4.8.3 – Wydanie poprawiające bezpieczeństwo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://pl.wordpress.org/2017/10/31/wordpress-4-8-3-wydanie-poprawiajace-bezpieczenstwo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://pl.wordpress.org/2017/10/31/wordpress-4-8-3-wydanie-poprawiajace-bezpieczenstwo/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 31 Oct 2017 11:26:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:15:\"Bezpieczeństwo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Wydanie\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://pl.wordpress.org/?p=1289\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:475:\"WordPress 4.8.3 jest już dostępny. To wydanie poprawia bezpieczeństwo we wszystkich poprzednich wersjach systemu. Zalecane jest natychmiastowe przeprowadzenie aktualizacji. WordPress w wersji 4.8.2 i wcześniejszych jest podatny na problem z $wpdb-&#62;prepare(), który może prowadzić do tworzenia nieoczekiwanych i niebezpiecznych zapytań, umożliwiających potencjalny atak metodą SQL injection (SQLi). Rdzeń systemu nie jest bezpośrednio podatny na ten [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"Krzysztof Trynkiewicz (Sukces Strony)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1522:\"<p>WordPress 4.8.3 jest już dostępny. <strong>To wydanie poprawia bezpieczeństwo</strong> we wszystkich poprzednich wersjach systemu. Zalecane jest natychmiastowe przeprowadzenie aktualizacji.</p>\n<p><span id=\"more-1289\"></span></p>\n<p>WordPress w wersji 4.8.2 i wcześniejszych jest podatny na problem z <code>$wpdb-&gt;prepare()</code>, który może prowadzić do tworzenia nieoczekiwanych i niebezpiecznych zapytań, umożliwiających potencjalny atak metodą SQL injection (SQLi). Rdzeń systemu nie jest bezpośrednio podatny na ten problem, ale dodaliśmy dodatkowe zabezpieczenia, by wtyczki i motywy nie mogły go przypadkowo powodować. Problem zgłosił <a href=\"https://twitter.com/ircmaxell\">Anthony Ferrara</a>.</p>\n<p>To wydanie WordPressa zmienia zachowanie funkcji <code>esc_sql()</code>. Różnica nie będzie istotna dla większości programistów. Zachęcamy do <a href=\"https://make.wordpress.org/core/2017/10/31/changed-behaviour-of-esc_sql-in-wordpress-4-8-3/\">przeczytania informacji dla deweloperów</a>.</p>\n<p>Dziękujemy zgłaszającemu za <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">odpowiedzialne ujawnienie</a> problemu z bezpieczeństwem.</p>\n<p><a href=\"https://pl.wordpress.org/\">Pobierz WordPressa 4.8.3</a> lub udaj się do sekcji Kokpit → Aktualizacje panelu administracyjnego i po prostu kliknij przycisk „Zaktualizuj teraz”. Witryny, które obsługują automatyczne aktualizacje, rozpoczęły już ich przeprowadzanie.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://pl.wordpress.org/2017/10/31/wordpress-4-8-3-wydanie-poprawiajace-bezpieczenstwo/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.9 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://pl.wordpress.org/2017/10/12/wordpress-4-9-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://pl.wordpress.org/2017/10/12/wordpress-4-9-beta-2/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 Oct 2017 07:03:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Wersje testowe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://pl.wordpress.org/?p=1235\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:433:\"WordPress 4.9 Beta 2 jest już dostępny! Oprogramowanie jest wciąż w fazie tworzenia, dlatego nie zalecamy jego używania w witrynie produkcyjnej. Zastanów się nad środowiskiem testowym i tam sprawdzaj do woli. Aby przetestować WordPress 4.9, wypróbuj wtyczkę WordPress Beta Tester (regularnie aktualizuje one do  &#8222;krawych nocnych wydań&#8221;) albo pobierz wersję beta (zip). Więcej informacji na temat [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Marcin Pietrzak\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1781:\"<p>WordPress 4.9 Beta 2 jest już dostępny!</p>\n<p><strong>Oprogramowanie jest wciąż w fazie tworzenia</strong>, dlatego nie zalecamy jego używania w witrynie produkcyjnej. Zastanów się nad środowiskiem testowym i tam sprawdzaj do woli. Aby przetestować WordPress 4.9, wypróbuj wtyczkę <a href=\"https://pl.wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> (regularnie aktualizuje one do  &#8222;krawych nocnych wydań&#8221;) albo <a href=\"https://wordpress.org/wordpress-4.9-beta2.zip\">pobierz wersję beta</a> (zip).</p>\n<p>Więcej informacji na temat tego, co nowego w wersji 4.9, znajdziesz w blogu we wpisie <a href=\"https://wordpress.org/news/2017/10/wordpress-4-9-beta-1/\">Beta 1</a> (po angielsku). Od tego czasu dokonaliśmy <a href=\"https://core.trac.wordpress.org/log/trunk/?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=41846&amp;stop_rev=41777&amp;limit=100&amp;sfp_email=&amp;sfph_mail=\">70 zmian</a> w wersji Beta 2.</p>\n<p><a href=\"https://translate.wordpress.org/locale/pl/default/wp/dev\">Pomóż nam przetłumaczyć WordPress na język polski</a>!</p>\n<p><strong>Jeśli widzisz błąd</strong>, napisz wiadomość na forum <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta</a>. Jeżeli coś nie działa, to chcielibyśm się tego dowiedzieć właśnie do ciebie! Jeśli czujesz się na siłach, żeby napisać raport zawierający opis jak powtórzyć błąd to  skorzystaj z serwisu <a href=\"https://make.wordpress.org/core/reports/\">WordPress Trac</a>. Na nim też znajdziesz <a href=\"https://core.trac.wordpress.org/tickets/major\">listę znanych błędów</a>.</p>\n<p><em>Przetestujmy razem:</em><br />\n<em> edytowanie kodu, przełączniki tematyczne,</em><br />\n<em> widgety, harmonogramowanie.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://pl.wordpress.org/2017/10/12/wordpress-4-9-beta-2/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WordPress 4.8.2 – Wydanie poprawiające bezpieczeństwo i błędy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://pl.wordpress.org/2017/09/22/wordpress-4-8-2-wydanie-poprawiajace-bezpieczenstwo-i-bledy/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"https://pl.wordpress.org/2017/09/22/wordpress-4-8-2-wydanie-poprawiajace-bezpieczenstwo-i-bledy/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Sep 2017 11:37:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:15:\"Bezpieczeństwo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Wydanie\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://pl.wordpress.org/?p=1213\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:476:\"WordPress 4.8.2 jest już dostępny. Wersja poprawia bezpieczeństwo wszystkich poprzednich wersji i zdecydowanie zachęcamy do natychmiastowej aktualizacji witryn. WordPress w wersji 4.8.1 i starsze mają następujące problemy z bezpieczeństwem: $wpdb-&#62; prepare() mogło tworzyć nieoczekiwane i niebezpieczne zapytania prowadzące do potencjalnego wstrzyknięcia kod SQL (SQLi). Core WordPressa nie jest bezpośrednio narażony na ten problem, ale poprawiono [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Marcin Pietrzak\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3051:\"<p>WordPress 4.8.2 jest już dostępny. Wersja <strong>poprawia bezpieczeństwo</strong> wszystkich poprzednich wersji i zdecydowanie zachęcamy do natychmiastowej aktualizacji witryn.</p>\n<p>WordPress w wersji 4.8.1 i starsze mają następujące problemy z bezpieczeństwem:</p>\n<ol>\n<li><strong>$wpdb-&gt; prepare()</strong> mogło tworzyć nieoczekiwane i niebezpieczne zapytania prowadzące do potencjalnego wstrzyknięcia kod SQL (SQLi). Core WordPressa nie jest bezpośrednio narażony na ten problem, ale poprawiono proces tworzenia zapytań aby zapobiegać podatności we wtyczkach i motywach. Zgłoszone przez <a href=\"https://hackerone.com/slavco\">Slavco</a></li>\n<li>Wykryto podatność na cross-site scripting (XSS) w używaniu oEmbed. Zgłoszone przez xknown zespołu ds. Zabezpieczeń WordPress.</li>\n<li>W edytorze wizualnym wykryto lukę w zabezpieczeniach skryptów przed cross-site scripting (XSS) Zgłoszone przez <a href=\"https://twitter.com/brutelogic\">Rodolfo Assis (@brutelogic)</a> Sucuri Security.</li>\n<li>W kodzie do rozpakowywania wykryto lukę w zabezpieczeniach ścieżki do pliku. Zgłoszone przez <a href=\"https://hackerone.com/noxrnet\">Alex Chapman (noxrnet)</a>.</li>\n<li>W edytorze wtyczek wykryto luka w zabezpieczeniach cross-site scripting (XSS). Zgłoszone przez 陈瑞琦 (Chen Ruiqi).</li>\n<li>Na ekranie użytkownika i terminach edycji zostały wykryte otwarte przekierowanie. Zgłoszone przez <a href=\"https://hackerone.com/ysx\">Yasin Soliman (ysx)</a>.</li>\n<li>Odkryto lukę w zabezpieczeniach ścieżki na ekranie personalizacji witryny. Zgłoszone przez Weston Ruter z zespołu ds. Bezpieczeństwa WordPress.</li>\n<li>Wykryto podatność na cross-site scripting (XSS)  w nazwach szablonów. Zgłoszone przez <a href=\"https://hackerone.com/sikic\">Luka (sikic)</a>.</li>\n<li>Wykryto podatność na cross-site scripting (XSS) w linkach modalnych. Zgłoszone przez <a href=\"https://hackerone.com/qasuar\">Anas Roubi (qasuar)</a>.</li>\n</ol>\n<p>Dziękujemy zgłaszającym za praktykowanie <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">odpowiedzialnego ujawnienia (en)</a>.</p>\n<p>Oprócz powyższych kwestii związanych z bezpieczeństwem, WordPress 4.8.2 zawiera 6 poprawek utrzymaniowych serii 4.8. Więcej informacji można znaleźć w <a href=\"https://codex.wordpress.org/Version_4.8.2\">notce wydania wersji (en)</a> oraz na <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=4.8.2&amp;group=component&amp;col=id&amp;col=summary&amp;col=component&amp;col=status&amp;col=owner&amp;col=type&amp;col=priority&amp;col=keywords&amp;order=priority\">liście zmian</a>.</p>\n<p><a href=\"https://pl.wordpress.org/wordpress-4.8.2-pl_PL.zip\">Pobierz WordPress 4.8.2</a> lub przejdź do Panel → Aktualizacje i kliknij przycisk &#8222;Aktualizuj teraz&#8221;. Strony obsługujące automatyczne aktualizacje w tle już zaczynają aktualizować się do wersji 4.8.2.</p>\n<p>Dziękujemy wszystkim, którzy przyczynili się do wydania 4.8.2.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"https://pl.wordpress.org/2017/09/22/wordpress-4-8-2-wydanie-poprawiajace-bezpieczenstwo-i-bledy/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"Zrób jedną rzecz i zmień przyszłość WordCampa\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://pl.wordpress.org/2017/06/15/zrob-cos-dla-wordpressa/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://pl.wordpress.org/2017/06/15/zrob-cos-dla-wordpressa/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 15 Jun 2017 04:11:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Wydarzenia\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://pl.wordpress.org/?p=977\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:435:\"Ósmy polski WordCamp już za nami. Polska społeczność rozrasta się z roku na rok, co bardzo cieszy, ale niejednokrotnie stanowi wyzwanie dla organizatorów spotkań. Chcemy lepiej odpowiadać na potrzeby polskich twórców i użytkowników WordPressa. Dlatego przygotowaliśmy krótką ankietę na temat WordCampa. Chcemy poznać Was lepiej, dowiedzieć się, kim jesteście i jakie macie oczekiwania względem kolejnych [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Katarzyna Gajewska\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:815:\"<p>Ósmy polski WordCamp już za nami. Polska społeczność rozrasta się z roku na rok, co bardzo cieszy, ale niejednokrotnie stanowi wyzwanie dla organizatorów spotkań.</p>\n<p>Chcemy lepiej odpowiadać na potrzeby polskich twórców i użytkowników WordPressa. Dlatego przygotowaliśmy krótką ankietę na temat WordCampa. Chcemy poznać Was lepiej, dowiedzieć się, kim jesteście i jakie macie oczekiwania względem kolejnych edycji WordCampa w Polsce. Wypełnienie ankiety nie zajmie Wam więcej niż 5 minut.</p>\n<p><a href=\"https://goo.gl/forms/VPY4xtO9KF6fuDnm1\" target=\"_blank\" rel=\"noopener\"><strong>Wypełnij ankietę na temat polskiej społeczności WordPressowej</strong></a>.</p>\n<p>Dziękujemy Wam za wypełnienie ankiety!</p>\n<p><em>Organizatorzy polskich WordUpów i WordCamp Polska</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://pl.wordpress.org/2017/06/15/zrob-cos-dla-wordpressa/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WordPress 4.7.5 – Wydanie poprawiające bezpieczeństwo i błędy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://pl.wordpress.org/2017/05/17/wordpress-4-7-5-wydanie-poprawiajace-bezpieczenstwo-i-bledy/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"https://pl.wordpress.org/2017/05/17/wordpress-4-7-5-wydanie-poprawiajace-bezpieczenstwo-i-bledy/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 17 May 2017 00:14:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Wydanie\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://pl.wordpress.org/?p=907\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:490:\"WordPress 4.7.5 jest już dostępny. To wydanie poprawia bezpieczeństwo we wszystkich poprzednich wersjach systemu. Zalecane jest natychmiastowe przeprowadzenie aktualizacji. WordPress w wersji 4.7.4 i wcześniejszych posiada sześć problemów z bezpieczeństwem: Niewystarczająca weryfikacja przekierowań w klasie HTTP. Zgłosił to Ronni Skansing. Niewłaściwa obsługa wartości danych meta wpisów w API XML-RPC. Zgłosił to Sam Thomas. Brak sprawdzania uprawnień dla [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"Krzysztof Trynkiewicz (Sukces Strony)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2591:\"<p>WordPress 4.7.5 jest już dostępny. <strong>To wydanie poprawia bezpieczeństwo</strong> we wszystkich poprzednich wersjach systemu. Zalecane jest natychmiastowe przeprowadzenie aktualizacji.</p>\n<p><span id=\"more-907\"></span></p>\n<p>WordPress w wersji 4.7.4 i wcześniejszych posiada sześć problemów z bezpieczeństwem:</p>\n<ol>\n<li>Niewystarczająca weryfikacja przekierowań w klasie HTTP. Zgłosił to <a href=\"https://dk.linkedin.com/in/ronni-skansing-36143b65\">Ronni Skansing</a>.</li>\n<li>Niewłaściwa obsługa wartości danych meta wpisów w API XML-RPC. Zgłosił to <a href=\"https://hackerone.com/jazzy2fives\">Sam Thomas</a>.</li>\n<li>Brak sprawdzania uprawnień dla danych meta wpisów w API XML-RPC. Zgłosił to <a href=\"https://profiles.wordpress.org/vortfu\">Ben Bidner</a> z Zespołu Bezpieczeństwa WordPressa.</li>\n<li>Podatność typu Cross Site Request Forgery (CRSF) została wykryta w formularzu zapytania o dane dostępu do systemu plików. Zgłosił to <a href=\"https://twitter.com/yorickkoster\">Yorick Koster</a>.</li>\n<li>Wykryto podatność typu cross-site scripting (XSS). Objawia się podczas próby wgrania bardzo dużych plików. Zgłosił to <a href=\"https://dk.linkedin.com/in/ronni-skansing-36143b65\">Ronni Skansing</a>.</li>\n<li>Wykryto podatność typu cross-site scripting (XSS). Ma ona związek z mechanizmem Personalizacji witryn. Zgłosił to <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a> z Zespołu Bezpieczeństwa WordPressa.</li>\n</ol>\n<p>Dziękujemy zgłaszającym za <a href=\"https://make.wordpress.org/core/handbook/reporting-security-vulnerabilities/\">odpowiedzialne ujawnienie</a> problemów z bezpieczeństwem.</p>\n<p>Oprócz powyższych problemów z bezpieczeństwem, WordPress 4.7.5 naprawia także 3 błędy z wersji 4.7. Więcej informacji można znaleźć w <a href=\"https://codex.wordpress.org/Version_4.7.5\">notatkach do wydania</a> oraz <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=4.7.5&amp;group=component&amp;col=id&amp;col=summary&amp;col=component&amp;col=status&amp;col=owner&amp;col=type&amp;col=priority&amp;col=keywords&amp;order=priority\">liście przeprowadzonych zmian</a>.</p>\n<p><a href=\"https://pl.wordpress.org/\">Pobierz WordPressa 4.7.5</a> lub udaj się do sekcji Kokpit → Aktualizacje panelu administracyjnego i po prostu kliknij przycisk „Zaktualizuj teraz”. Witryny, które obsługują automatyczne aktualizacje, rozpoczęły już ich przeprowadzanie.</p>\n<p>Dziękujemy wszystkim, którzy przyczynili się do powstania wersji 4.7.5.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"https://pl.wordpress.org/2017/05/17/wordpress-4-7-5-wydanie-poprawiajace-bezpieczenstwo-i-bledy/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"6\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WordPress 4.7.4 – Wydanie poprawiające bezpieczeństwo i błędy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://pl.wordpress.org/2017/04/20/wordpress-4-7-4-wydanie-poprawiajace-bezpieczenstwo-i-bledy/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"https://pl.wordpress.org/2017/04/20/wordpress-4-7-4-wydanie-poprawiajace-bezpieczenstwo-i-bledy/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Apr 2017 18:42:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Wydanie\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://pl.wordpress.org/?p=858\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:490:\"Po niemal 60 milionach pobrań WordPressa 4.7 z radością ogłaszamy dostępność wersji 4.7.4 &#8211; wydania poprawiającego błędy i bezpieczeństwo. Wydanie to zawiera 47 poprawek błędów oraz usprawnień. W szczególności naprawiony został brak kompatybilności między nadchodzącą wersją przeglądarki Chrome i edytorem wizualnym, jak również poprawiono braki w spójności obsługi mediów, a także wprowadzono dalsze ulepszenia API REST. Więcej informacji [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"Krzysztof Trynkiewicz (Sukces Strony)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4736:\"<p>Po niemal 60 milionach pobrań WordPressa 4.7 z radością ogłaszamy dostępność wersji 4.7.4 &#8211; <strong>wydania poprawiającego błędy i bezpieczeństwo.</strong></p>\n<p><span id=\"more-858\"></span></p>\n<p>Wydanie to zawiera 47 poprawek błędów oraz usprawnień. W szczególności naprawiony został brak kompatybilności między nadchodzącą wersją przeglądarki Chrome i edytorem wizualnym, jak również poprawiono braki w spójności obsługi mediów, a także wprowadzono dalsze ulepszenia API REST. Więcej informacji można znaleźć w <a href=\"https://codex.wordpress.org/Version_4.7.4\">notatkach do wydania</a> oraz <a href=\"https://core.trac.wordpress.org/log/branches/4.7?rev=40487&amp;stop_rev=40224\">liście przeprowadzonych zmian</a>.</p>\n<p><a href=\"https://pl.wordpress.org/\">Pobierz WordPressa 4.7.4</a> lub udaj się do sekcji <strong>Kokpit → Aktualizacje</strong> panelu administracyjnego i po prostu kliknij przycisk „Zaktualizuj teraz”. Witryny, które obsługują automatyczne aktualizacje, rozpoczęły już ich przeprowadzanie.</p>\n<p>Dziękujemy wszystkim, którzy przyczynili się do powstania wersji 4.7.4:<br />\n<a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/aussieguy123/\">aussieguy123</a>, <a href=\"https://profiles.wordpress.org/blobfolio/\">Blobfolio</a>, <a href=\"https://profiles.wordpress.org/boldwater/\">boldwater</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/bor0/\">Boro Sitnikovski</a>, <a href=\"https://profiles.wordpress.org/chesio/\">chesio</a>, <a href=\"https://profiles.wordpress.org/curdin/\">Curdin Krummenacher</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a>, <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a>, <a href=\"https://profiles.wordpress.org/davidakennedy/\">David A. Kennedy</a>, <a href=\"https://profiles.wordpress.org/davidbenton/\">davidbenton</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling (ocean90)</a>, <a href=\"https://profiles.wordpress.org/eclev91/\">eclev91</a>, <a href=\"https://profiles.wordpress.org/iseulde/\">Ella Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/ghosttoast/\">Gustave F. Gerhardt</a>, <a href=\"https://profiles.wordpress.org/ig_communitysites/\">ig_communitysites</a>, <a href=\"https://profiles.wordpress.org/jnylen0/\">James Nylen</a>, <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/karinedo/\">karinedo</a>, <a href=\"https://profiles.wordpress.org/lukasbesch/\">lukasbesch</a>, <a href=\"https://profiles.wordpress.org/maguiar/\">maguiar</a>, <a href=\"https://profiles.wordpress.org/matheusgimenez/\">MatheusGimenez</a>, <a href=\"https://profiles.wordpress.org/mboynes/\">Matthew Boynes</a>, <a href=\"https://profiles.wordpress.org/mattwiebe/\">Matt Wiebe</a>, <a href=\"https://profiles.wordpress.org/mayurk/\">Mayur Keshwani</a>, <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/delawski/\">Piotr Delawski</a>, <a href=\"https://profiles.wordpress.org/pratikshrestha/\">Pratik Shrestha</a>, <a href=\"https://profiles.wordpress.org/programmin/\">programmin</a>, <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/sagarkbhatt/\">sagarkbhatt</a>, <a href=\"https://profiles.wordpress.org/sagarprajapati/\">Sagar Prajapati</a>, <a href=\"https://profiles.wordpress.org/sboisvert/\">sboisvert</a>, <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a>, <a href=\"https://profiles.wordpress.org/timmydcrawford/\">Timmy Crawford</a>, <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a> oraz <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"https://pl.wordpress.org/2017/04/20/wordpress-4-7-4-wydanie-poprawiajace-bezpieczenstwo-i-bledy/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"WordCamp Lublin 2017 zaprasza!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://pl.wordpress.org/2017/03/22/wordcamp-lublin-2017-zaprasza/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://pl.wordpress.org/2017/03/22/wordcamp-lublin-2017-zaprasza/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Mar 2017 13:27:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Wydarzenia\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://pl.wordpress.org/?p=760\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:423:\"W dniach 2-4 czerwca br. odbędzie się kolejna edycja polskiego WordCampa &#8211; konferencji poświęconej WordPressowi. Tym razem programiści, koderzy, blogerzy i inne osoby korzystające na co dzień z WordPressa spotkają się w Lublinie. W ramach konferencji odbędą się: 2 czerwca: contributor day Contributor Day to specjalne spotkanie podczas którego każdy będzie miał możliwość dołączenia do [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Marcin Pietrzak\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1614:\"<p>W dniach 2-4 czerwca br. odbędzie się kolejna edycja polskiego WordCampa &#8211; konferencji poświęconej WordPressowi. Tym razem programiści, koderzy, blogerzy i inne osoby korzystające na co dzień z WordPressa spotkają się w Lublinie.</p>\n<p>W ramach konferencji odbędą się:</p>\n<h2>2 czerwca: contributor day</h2>\n<p><a href=\"https://2017.lublin.wordcamp.org/czym-jest-contributor-day/\">Contributor Day</a> to specjalne spotkanie podczas którego każdy będzie miał możliwość dołączenia do osób tworzących zarówno WordPressa jak i powiązanych z nim projektów. Oznacza to również, że będzie to świetna okazja do wspólnej pracy nad polskimi tłumaczeniami.</p>\n<h2>3-4 czerwca: prelekcje i warsztaty</h2>\n<p>Podczas prezentacji i warsztatów będzie można nabyć solidną porcję wiedzy od najlepszych ekspertów WordPressa z kraju i z zagranicy. Dodatkowo, uczestnicy będą mogli wziąć udział w specjalnie przygotowanej grze konferencyjnej oraz wieczornej imprezie integracyjnej.</p>\n<p>WordCamp organizowany jest przez społeczność WordPressa, w tym także przez Ciebie! Jeśli chciałbyś pomóc &#8211; wystąpić na scenie, poprowadzić warsztaty lub zostać sponsorem koniecznie daj znać:</p>\n<ul>\n<li><a href=\"https://2017.lublin.wordcamp.org/zostan-prelegentem/\">zgłoszenia prelegentów i osób prowadzących warsztaty</a></li>\n<li><a href=\"https://2017.lublin.wordcamp.org/zostan-sponsorem/\">zgłoszenia sponsorów</a></li>\n</ul>\n<p>Po więcej informacji zapraszamy na oficjalną stronę: <a href=\"https://2017.lublin.wordcamp.org/\">WordCamp Lublin 2017</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://pl.wordpress.org/2017/03/22/wordcamp-lublin-2017-zaprasza/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WordPress 4.7.3 – Wydanie poprawiające bezpieczeństwo i błędy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://pl.wordpress.org/2017/03/07/wordpress-4-7-3-wydanie/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://pl.wordpress.org/2017/03/07/wordpress-4-7-3-wydanie/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 Mar 2017 07:29:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:15:\"Bezpieczeństwo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Wydanie\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://pl.wordpress.org/?p=753\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:474:\"WordPress 4.7.3 jest już dostępny. Wersja poprawia bezpieczeństwo we wszystkich poprzednich wersjach, a my zachęcamy do niezwłocznej aktualizacji witryn. WordPress 4.7.2 oraz wcześniejsze posiadają sześć podatności: Cross-site scripting (XSS) za pomocą metadanych plików multimedialnych. Zgłoszone przez Chris Andrè Dale, Yorick Koster, and Simon P. Briggs. Znaki kontrolne mogą oszukać walidacji adresu URL przekierowania. Zgłoszone przez Daniel [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Marcin Pietrzak\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6307:\"<p>WordPress 4.7.3 jest już dostępny. Wersja poprawia <strong>bezpieczeństwo</strong> we wszystkich poprzednich wersjach, a my zachęcamy do niezwłocznej aktualizacji witryn.</p>\n<p>WordPress 4.7.2 oraz wcześniejsze posiadają sześć podatności:</p>\n<ol>\n<li>Cross-site scripting (XSS) za pomocą metadanych plików multimedialnych. Zgłoszone przez <a href=\"https://www.securesolutions.no/\">Chris Andrè Dale</a>, <a href=\"https://twitter.com/yorickkoster\">Yorick Koster</a>, and Simon P. Briggs.</li>\n<li>Znaki kontrolne mogą oszukać walidacji adresu URL przekierowania. Zgłoszone przez <a href=\"http://www.danielchatfield.com/\">Daniel Chatfield</a>.</li>\n<li>Pliki niezwiązane z wtyczką, mogą być usuwane korzystając z funkcjonalności usunięcia wtyczki. Zgłoszone przez <a href=\"http://b.360.cn/\">xuliang</a>.</li>\n<li>Cross-site scripting (XSS) za pośrednictwem adresu URL YouTube. Zgłoszone przez <a href=\"https://twitter.com/marcs0h\">Marc Montpas</a>.</li>\n<li>Cross-site scripting (XSS) poprzez nazwę taksonomii. Zgłoszone przez <a href=\"https://profiles.wordpress.org/deltamgm2\">Delta</a>.</li>\n<li>Cross-site request forgery (CSRF) w Press This! co prowadzi do nadmiernego wykorzystania zasobów serwera. Zgłoszone przez Sipke Mellema.</li>\n</ol>\n<p>Dziękujemy raportującym za głoszenia zgodne z praktyką <a href=\"//make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">odpowiedzialnego ujawniania</a> (tekst po angielsku).</p>\n<p>W uzupełnieniu do powyższych kwestii bezpieczeństwa, WordPress 4.7.3 zawiera 39 poprawek serwisowych dla serii 4.7. Aby uzyskać więcej informacji, zobacz <a href=\"https://codex.wordpress.org/Version_4.7.3\">informacje o wydaniu</a> (tekst po angielsku) oraz zapoznaj się z <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=4.7.3&amp;group=component&amp;col=id&amp;col=summary&amp;col=component&amp;col=status&amp;col=owner&amp;col=type&amp;col=priority&amp;col=keywords&amp;order=priority\">listą zmian</a>.</p>\n<p><a href=\"https://pl.wordpress.org/\">Pobierz WordPress 4.7.3</a> lub przejdź do kokpitu → Aktualizacje i kliknij „Zaktualizuj teraz”. Witryny które obsługują automatyczne aktualizacje powinny już być uaktualnione do WordPressa 4.7.3.</p>\n<p>Dziekujemy wszystkim, którzy dołożyli się do wydania 4.7.3: <a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/asalce/\">asalce</a>, <a href=\"https://profiles.wordpress.org/blobfolio/\">blobfolio</a>, <a href=\"https://profiles.wordpress.org/gitlost/\">bonger</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/bor0/\">Boro Sitnikovski</a>, <a href=\"https://profiles.wordpress.org/bradyvercher/\">Brady Vercher</a>, <a href=\"https://profiles.wordpress.org/drrobotnik/\">Brandon Lavigne</a>, <a href=\"https://profiles.wordpress.org/bhargavbhandari90/\">Bunty</a>, <a href=\"https://profiles.wordpress.org/ccprog/\">ccprog</a>, <a href=\"https://profiles.wordpress.org/ketuchetan/\">chetansatasiya</a>, <a href=\"https://profiles.wordpress.org/davidakennedy/\">David A. Kennedy</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dhanendran/\">Dhanendran</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling (ocean90)</a>, <a href=\"https://profiles.wordpress.org/drivingralle/\">Drivingralle</a>, <a href=\"https://profiles.wordpress.org/iseulde/\">Ella Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/ipstenu/\">Ipstenu (Mika Epstein)</a>, <a href=\"https://profiles.wordpress.org/jnylen0/\">James Nylen</a>, <a href=\"https://profiles.wordpress.org/jazbek/\">jazbek</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jpry/\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Dwan</a>, <a href=\"https://profiles.wordpress.org/markoheijnen/\">Marko Heijnen</a>, <a href=\"https://profiles.wordpress.org/matheusgimenez/\">MatheusGimenez</a>, <a href=\"https://profiles.wordpress.org/mnelson4/\">Mike Nelson</a>, <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a>, <a href=\"https://profiles.wordpress.org/codegeass/\">Muhammet Arslan</a>, <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a>, <a href=\"https://profiles.wordpress.org/pavelevap/\">pavelevap</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/reldev/\">reldev</a>, <a href=\"https://profiles.wordpress.org/sanchothefat/\">Robert O’Rourke</a>, <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a>, <a href=\"https://profiles.wordpress.org/sanketparmar/\">Sanket Parmar</a>, <a href=\"https://profiles.wordpress.org/seanchayes/\">Sean Hayes</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/triplejumper12/\">triplejumper12</a>, <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a>, and <a href=\"https://profiles.wordpress.org/wpfo/\">wpfo</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://pl.wordpress.org/2017/03/07/wordpress-4-7-3-wydanie/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"WordPress 4.7.2 – Wydanie poprawiające bezpieczeństwo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://pl.wordpress.org/2017/01/29/wordpress-4-7-2-wydanie-poprawiajace-bezpieczenstwo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"https://pl.wordpress.org/2017/01/29/wordpress-4-7-2-wydanie-poprawiajace-bezpieczenstwo/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 29 Jan 2017 08:46:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:15:\"Bezpieczeństwo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Wydanie\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://pl.wordpress.org/?p=739\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:483:\"WordPress 4.7.2 jest już dostępny. Wersja poprawia bezpieczeństwo we wszystkich poprzednich wersjach, a my zachęcamy do niezwłocznej aktualizacji witryn. WordPress 4.7.1 oraz wcześniejsze wersje posiadają następujące podaności: Interfejs użytkownika służący do przypisywania taksonomii w &#8222;Press This&#8221; jest widoczny dla użytkowników, którzy nie mają uprawnień, aby go używać. Zgłoszone przez Davida Herrera Alley Interactive. Klasa WP_Query [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Marcin Pietrzak\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1642:\"<p>WordPress 4.7.2 jest już dostępny. Wersja <strong>poprawia bezpieczeństwo</strong> we wszystkich poprzednich wersjach, a my zachęcamy do niezwłocznej aktualizacji witryn.</p>\n<p>WordPress 4.7.1 oraz wcześniejsze wersje posiadają następujące podaności:</p>\n<ol>\n<li>Interfejs użytkownika służący do przypisywania taksonomii w &#8222;Press This&#8221; jest widoczny dla użytkowników, którzy nie mają uprawnień, aby go używać. Zgłoszone przez Davida Herrera <a href=\"https://www.alleyinteractive.com/\">Alley Interactive</a>.</li>\n<li>Klasa <code>WP_Query</code> jest podatna na SQL injection (SQLi) podczas przetwarzania niebezpiecznych danych. Sam WordPress nie jest bezpośrednio narażony na ten problem, ale dodaliśmy zabezpieczenie, aby zapobiec przypadkowemu użycia podaności we wtyczkach i motywach. Zgłoszone przez <a href=\"https://github.com/mjangda\">Mo Jangda</a> (batmoo).</li>\n<li>Podatność cross-site scripting (XSS) została odkryta w tabeli z listą wpisów. Zgłoszone przez <a href=\"https://iandunn.name/\">Ian Dunn</a> z WordPress Security Team.</li>\n</ol>\n<p>Dziękujemy raportującym za głoszenia zgodne z praktyką <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">odpowiedzialnego ujawniania</a> (tekst po angielsku).</p>\n<p><a href=\"https://pl.wordpress.org/\">Pobierz WordPress 4.7.2</a> lub przejdź do kokpitu → Aktualizacje i kliknij &#8222;Zaktualizuj teraz&#8221;. Witryny które obsługują automatyczne aktualizacje powinny już być uaktualnione do WordPressa 4.7.2.</p>\n<p>Dziękujemy wszystkim, którzy przyczynili się do 4.7.2.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://pl.wordpress.org/2017/01/29/wordpress-4-7-2-wydanie-poprawiajace-bezpieczenstwo/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"WordPress 4.5.2 – Wydanie poprawiające bezpieczeństwo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://pl.wordpress.org/2016/05/12/wordpress-4-5-2-wydanie-poprawiajace-bezpieczenstwo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"https://pl.wordpress.org/2016/05/12/wordpress-4-5-2-wydanie-poprawiajace-bezpieczenstwo/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 May 2016 11:04:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:15:\"Bezpieczeństwo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Wydanie\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://pl.wordpress.org/?p=718\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:435:\"WordPress 4.5.2 jest już dostępny. To wydanie poprawia bezpieczeństwo we wszystkich poprzednich wersjach systemu. Zalecane jest natychmiastowe przeprowadzenie aktualizacji. WordPress w wersjach 4.5.1 i wcześniejszych jest podatny na atak metodą SOME przez błąd bezpieczeństwa w Plupload – zewnętrznej bibliotece, której WordPress używa do wgrywania plików. WordPress w wersjach 4.2 do 4.5.1 jest podatny na atak [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"Krzysztof Trynkiewicz (Sukces Strony)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2085:\"<p>WordPress 4.5.2 jest już dostępny. <strong>To wydanie poprawia bezpieczeństwo</strong> we wszystkich poprzednich wersjach systemu. Zalecane jest natychmiastowe przeprowadzenie aktualizacji.</p>\n<p><span id=\"more-718\"></span></p>\n<p>WordPress w wersjach 4.5.1 i wcześniejszych jest podatny na atak metodą <abbr title=\"Same-Origin Method Execution\">SOME</abbr> przez błąd bezpieczeństwa w Plupload – zewnętrznej bibliotece, której WordPress używa do wgrywania plików. WordPress w wersjach 4.2 do 4.5.1 jest podatny na atak metodą reflected XSS przez użycie specjalnie spreparowanych adresów URI dla MediaElement.js – zewnętrznej biblioteki, używanej przez odtwarzacze mediów. Biblioteki MediaElement.js i Plupload także zostały zaktualizowane przez ich autorów w celu poprawienia tych błędów bezpieczeństwa.</p>\n<p>Obydwa problemy zostały wykryli i zgłosili: Mario Heiderich, Masato Kinugawa i Filedescriptor z <a href=\"https://cure53.de/\">Cure53</a>. Dziękujemy zespołowi za <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">odpowiedzialne ujawnienie</a> tych problemów, a także zespołom bibliotek Plupload i MediaElement.js za ścisłą współpracę z nami w celu usunięcia tych błędów.</p>\n<p><a href=\"https://wordpress.org/download/\">Pobierz WordPressa 4.5.2</a> lub udaj się do sekcji Kokpit → Aktualizacje panelu administracyjnego i po prostu kliknij przycisk „Zaktualizuj teraz”. Witryny, które obsługują automatyczne aktualizacje, rozpoczęły już ich przeprowadzanie.</p>\n<p>Informujemy także, że publiczny rozgłos uzyskały ostatnio problemy bezpieczeństwa wykryte w bibliotece przetwarzającej obrazy ImageMagick, używanej przez wielu dostawców hostingowych, którą może wykorzystywać również WordPress. Nasze aktualne stanowisko na temat tych problemów oraz zalecenia można poznać <a href=\"https://make.wordpress.org/core/2016/05/06/imagemagick-vulnerability-information/\">czytając ten wpis na blogu o tworzeniu rdzenia systemu</a> (w języku angielskim).</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://pl.wordpress.org/2016/05/12/wordpress-4-5-2-wydanie-poprawiajace-bezpieczenstwo/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"12\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:30:\"https://pl.wordpress.org/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:8:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 13 Dec 2017 15:23:44 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Sat, 04 Nov 2017 00:38:44 GMT\";s:4:\"link\";s:61:\"<https://pl.wordpress.org/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 250\";}}s:5:\"build\";s:14:\"20171016212101\";}", "no");
INSERT INTO `wp_options` VALUES("1823", "_transient_timeout_feed_mod_a421d6f32723068ab074a40017a9e1f9", "1513221825", "no");
INSERT INTO `wp_options` VALUES("1824", "_transient_feed_mod_a421d6f32723068ab074a40017a9e1f9", "1513178625", "no");
INSERT INTO `wp_options` VALUES("1825", "_transient_timeout_dash_v2_5ed7e1a5d79caaf375d35c33f6782653", "1513221825", "no");
INSERT INTO `wp_options` VALUES("1826", "_transient_dash_v2_5ed7e1a5d79caaf375d35c33f6782653", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://pl.wordpress.org/2017/10/31/wordpress-4-8-3-wydanie-poprawiajace-bezpieczenstwo/\'>WordPress 4.8.3 – Wydanie poprawiające bezpieczeństwo</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://pl.wordpress.org/2017/10/31/wordpress-4-8-3-wydanie-poprawiajace-bezpieczenstwo/\'>WordPress 4.8.3 – Wydanie poprawiające bezpieczeństwo</a></li><li><a class=\'rsswidget\' href=\'https://pl.wordpress.org/2017/10/12/wordpress-4-9-beta-2/\'>WordPress 4.9 Beta 2</a></li><li><a class=\'rsswidget\' href=\'https://pl.wordpress.org/2017/09/22/wordpress-4-8-2-wydanie-poprawiajace-bezpieczenstwo-i-bledy/\'>WordPress 4.8.2 – Wydanie poprawiające bezpieczeństwo i błędy</a></li></ul></div>", "no");
INSERT INTO `wp_options` VALUES("1827", "duplicator_ui_view_state", "a:4:{s:22:\"dup-pack-storage-panel\";s:1:\"0\";s:22:\"dup-pack-archive-panel\";s:1:\"1\";s:24:\"dup-pack-installer-panel\";s:1:\"0\";s:19:\"dup-pack-build-try1\";s:1:\"1\";}", "yes");
INSERT INTO `wp_options` VALUES("1828", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-12-13 15:48:32\";s:7:\"Version\";s:6:\"1.2.26\";s:9:\"VersionWP\";s:5:\"4.9.1\";s:9:\"VersionDB\";s:7:\"10.1.24\";s:10:\"VersionPHP\";s:6:\"5.6.32\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:18:\"20171213_bodybrain\";s:4:\"Hash\";s:32:\"14c6a9d352bb378e2463171213154832\";s:8:\"NameHash\";s:51:\"20171213_bodybrain_14c6a9d352bb378e2463171213154832\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:71:\"/home/staniecko/domains/testuj.website/public_html/bnb/wp-snapshots/tmp\";s:8:\"StoreURL\";s:39:\"http://bnb.testuj.website/wp-snapshots/\";s:8:\"ScanFile\";s:61:\"20171213_bodybrain_14c6a9d352bb378e2463171213154832_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":18:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:54:\"/home/staniecko/domains/testuj.website/public_html/bnb\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-12-13 15:48:32\";s:7:\"Version\";s:6:\"1.2.26\";s:9:\"VersionWP\";s:5:\"4.9.1\";s:9:\"VersionDB\";s:7:\"10.1.24\";s:10:\"VersionPHP\";s:6:\"5.6.32\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:18:\"20171213_bodybrain\";s:4:\"Hash\";s:32:\"14c6a9d352bb378e2463171213154832\";s:8:\"NameHash\";s:51:\"20171213_bodybrain_14c6a9d352bb378e2463171213154832\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:71:\"/home/staniecko/domains/testuj.website/public_html/bnb/wp-snapshots/tmp\";s:8:\"StoreURL\";s:39:\"http://bnb.testuj.website/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";r:57;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:10:\"\0*\0Package\";r:57;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:63:\"/home/staniecko/domains/testuj.website/public_html/bnb/wp-admin\";i:1;s:73:\"/home/staniecko/domains/testuj.website/public_html/bnb/wp-content/uploads\";i:2;s:75:\"/home/staniecko/domains/testuj.website/public_html/bnb/wp-content/languages\";i:3;s:73:\"/home/staniecko/domains/testuj.website/public_html/bnb/wp-content/plugins\";i:4;s:72:\"/home/staniecko/domains/testuj.website/public_html/bnb/wp-content/themes\";i:5;s:66:\"/home/staniecko/domains/testuj.website/public_html/bnb/wp-includes\";}}s:9:\"Installer\";r:79;s:8:\"Database\";r:87;}", "yes");

/* INSERT TABLE DATA: wp_postmeta */
INSERT INTO `wp_postmeta` VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("2", "6", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3", "6", "_edit_lock", "1512980730:1");
INSERT INTO `wp_postmeta` VALUES("4", "6", "landing_page_section-active-1", "1");
INSERT INTO `wp_postmeta` VALUES("5", "6", "landing_page_section-active-1a", "1");
INSERT INTO `wp_postmeta` VALUES("6", "6", "landing_page_section-active-2", "1");
INSERT INTO `wp_postmeta` VALUES("7", "6", "landing_page_healinglife", "1");
INSERT INTO `wp_postmeta` VALUES("8", "6", "landing_page_section-active-2a", "1");
INSERT INTO `wp_postmeta` VALUES("9", "6", "landing_page_slide-title", "a:3:{i:0;s:18:\"INDYWIDUALNA SESJA\";i:1;s:8:\"WARSZTAT\";i:2;s:18:\"KIJEK HEALING LIFE\";}");
INSERT INTO `wp_postmeta` VALUES("10", "6", "landing_page_slide-desc", "a:3:{i:0;s:131:\"Na spotkaniu otrzymasz masaż uzdrawiający i poznasz zasady, jak wykonać go samemu. \r\nSesja trwa 1,5 godziny i kosztuje 150 zł. \";i:1;s:167:\"Podczas warsztatu połączysz umysł ze swoim ciałem.\r\nDoświadczysz Uzdrawiania przez Pępek i dowiesz się, jak wykonywać masaż najbliższym.\r\nInwestycja 420 zł.\";i:2;s:232:\"Zamawiając kijek Healing Life otrzymasz polskie opracowanie autora tej metody Ilchi Lee. \r\nNasze centrum jest jedynym w Polsce licencjonowanym dystrybutorem oryginalnego kijka zamawianego dla Was prosto z Korei. Inwestycja 390 zł.\";}");
INSERT INTO `wp_postmeta` VALUES("11", "7", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("12", "7", "_edit_lock", "1512384584:1");
INSERT INTO `wp_postmeta` VALUES("13", "8", "_wp_attached_file", "2017/10/dla_firm_banner_1920x589-1.jpg");
INSERT INTO `wp_postmeta` VALUES("14", "8", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:587;s:4:\"file\";s:38:\"2017/10/dla_firm_banner_1920x589-1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:38:\"dla_firm_banner_1920x589-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"dla_firm_banner_1920x589-1-300x92.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:92;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:38:\"dla_firm_banner_1920x589-1-768x235.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:39:\"dla_firm_banner_1920x589-1-1024x313.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:313;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("15", "6", "landing_page_page-title", "Uzdrawianie przez pępek");
INSERT INTO `wp_postmeta` VALUES("16", "6", "landing_page_page-subtitle", "To najnowsza naturalna metoda uzdrawiania ciała, umysłu i emocji.");
INSERT INTO `wp_postmeta` VALUES("18", "6", "landing_page_section-title-1", "Czy wiesz, że poprzez masaż jednego punktu możesz uzdrowić całe ciało?");
INSERT INTO `wp_postmeta` VALUES("19", "6", "landing_page_date", "<p>Pępek to miejsce, w którym żyje tysiące drobnoustrojów. Jest to centralny punkt ciała, za którym znajdują się jelita, główne naczynia krwionośne, ważne węzły chłonne, tryliony bakterii, silna linia obronna układu odpornościowego, a co najważniejsze – nasz drugi mózg – jelitowy układ nerwowy.</p>\n");
INSERT INTO `wp_postmeta` VALUES("20", "6", "landing_page_place", "<p>Zaraz za pępkiem odbywa się produkcja hormonów szczęścia i radości. Aż 90{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77} serotoniny i 50{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77} dopaminy wytwarzane jest w jelitach. Badania udowodniły, że obniżony poziom serotoniny i dopaminy wpływają na nasze samopoczucie emocjonalne, a depresja zwiększa ryzyko wystąpienia choroby Alzheimera aż o 65{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}.</p>\n");
INSERT INTO `wp_postmeta` VALUES("21", "6", "landing_page_section-1a-title", "Dowiedz się więcej na temat metody");
INSERT INTO `wp_postmeta` VALUES("22", "6", "landing_page_section-1a-desc", "<h1 style=\"text-align: center;\"><strong>12 Korzyści z Uzdrawiania przez Pępek</strong></h1>\n<h2 style=\"text-align: left;\"><strong>1. LEPSZA CYRKULACJA KRWI</strong></h2>\n<p style=\"text-align: left;\">Uzdrawianie Pępkiem promuje cyrkulację krwi poprzez stymulację organów w jamie brzusznej, które kumulują ok. 30 – 40{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77} krwi. Technika ta wspomaga też lepszą cyrkulację w aorcie brzusznej  oraz w żyle dolnej głównej, które znajdują się za pępkiem. Powtarzające ruchy rozgrzewają brzuch, skłaniając naczynia krwionośne do rozszerzania się, co pozwala większej ilości krwi przez nie przepłynąć.</p>\n<h2 style=\"text-align: left;\"><strong>2. WYŻSZA TEMPERATURA CIAŁA</strong></h2>\n<p style=\"text-align: left;\">Możesz niemal natychmiast poczuć, że ciało od brzucha w dół do stop robi się ciepłe, kiedy wykonujesz ćwiczenie Uzdrawiania Pępkiem. Podnoszenie temperatury ciała wspomaga metabolizm oraz wzmacnia system odpornościowy, a także funkcje oczyszczające organizmu.</p>\n<h2 style=\"text-align: left;\"><strong>3. LEPSZE TRAWIENIE I WYDALANIE</strong></h2>\n<p style=\"text-align: left;\">Jelitowy układ nerwowy jest stymulowany. Promuje to lepszą perystaltykę jelit, co w efekcie daje nam lepsze trawienie i łatwe, płynne wydalanie.</p>\n<h2 style=\"text-align: left;\"><strong>4. ULGA DLA STAWÓW</strong></h2>\n<p style=\"text-align: left;\">Brzuch jest połączony ze stawami w miednicy poprzez powięzi mięśniowe i naczynia krwionośnie. W trakcie wykonywania techniki Uzdrawiania Pępkiem spięcia w powięziach są rozluźniane, co pozwala lepiej wyrównać ciało, poprawiając ogólną elastyczność i usuwając ból, który wynika z niepoprawnej postawy ciała.</p>\n<h2 style=\"text-align: left;\"><strong>5. ODPORNOŚĆ I DETOX</strong></h2>\n<p style=\"text-align: left;\">Węzły chłonne skoncentrowane wokół pępka są stymulowane, co poprawia cyrkulację płynu limfatycznego, który jest zaangażowany w poziom odporności i wydalanie toksyn i odpadków. Także, jelitowy ekosystem staje się zdrowszy, dzięki czemu podnosi się aktywność całego układu odpornościowego i bakteryjnego.</p>\n<h2 style=\"text-align: left;\"><strong>6. ZWIĘKSZENIE FIZYCZNEJ AKTYWNOŚCI</strong></h2>\n<p style=\"text-align: left;\">Dostarczenie tlenu i środków odżywczych do całego ciała jest ulepszone poprzez cyrkulację krwi I głębokie oddechy. Dlatego też energia witalna w brzuchu zaczyna cyrkulować w całym ciele, poprawiając aktywność fizyczną całego organizmu.</p>\n<h2 style=\"text-align: left;\"><strong>7. CZYSTA GŁOWA I LESZPA KONCENTRACJA</strong></h2>\n<p style=\"text-align: left;\">Cyrkulacja krwi oraz głębokie oddychanie dostarczając dużą ilość tlenu do mózgu a energia wody z nerek płynie do głowy, ochładzając ją. W efekcie uzyskujemy umysłową jasność i lepszą wizję.</p>\n<h2 style=\"text-align: left;\"><strong>8. RELAKS DLA CIAŁA I UMYSŁU</strong></h2>\n<p style=\"text-align: left;\">Koncentrując się na wydechu w trakcie wykonywania techniki Uzdrawiania Pępkiem wzmacniamy układ przywspółczulny, odpowiedzialny za odpoczynek i lepsze trawienie. Wykonując Uzdrawianie Pępkiem całe ciało i umysł się relaksują i doładowują energią.</p>\n<h2 style=\"text-align: left;\"><strong>9. ROZWÓJ FIZYCZNEGO I PSYCHICZNEGO ZDROWIA</strong></h2>\n<p style=\"text-align: left;\">Ponad 90{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77} serotoniny (hormonu szczęścia) jest produkowane w jelitach. Technika Uzdrawiania Pępkiem poprawia nastrój i daje poczucie zdrowia i spełnienia.</p>\n<h2 style=\"text-align: left;\"><strong>10. LŚNIĄCA I GŁADKA SKÓRA</strong></h2>\n<p style=\"text-align: left;\">Poprawa ogólnej cyrkulacji systemów krwionośnego, limfatycznego, nerwowego i trawiennego, a także poprawa odporności i układu wydalniczego, wpływa na przyspieszenie wydalania odpadków i toksyn z organizmu, dzięki czemu skóra odbudowuje się szybciej i staje się bardziej lśniąca i gładka.</p>\n<h2 style=\"text-align: left;\"><strong>11. WZMOCNIENIE WIĘZI RODZINNYCH</strong></h2>\n<p style=\"text-align: left;\">Technika Uzdrawiania Pępkiem pozwala lepiej zadbać o zdrowie swoje i swojej rodziny. Gdy nawzajem członkowie rodziny wykonują na sobie tę technikę, energia pomiędzy nimi oczyszcza się, a rodzinne więzy stają się bardziej naturalne, silniejsze i bliższe.</p>\n<h2 style=\"text-align: left;\"><strong>12. WIĘKSZA RÓWNOWAGA</strong></h2>\n<p style=\"text-align: left;\">Poprzez skupienie umysłu na pępku (centrum ciała) stan umysłu staje się bardziej zrównoważony i wyśrodkowany.</p>\n");
INSERT INTO `wp_postmeta` VALUES("23", "6", "landing_page_section-title-2", "W jaki sposób wykonywać masaż");
INSERT INTO `wp_postmeta` VALUES("24", "6", "landing_page_price", "<p>Masaż pępka można wykonywać palcami lub specjalnie do tego zaprojektowanym masażerem tzw. Kijkiem Healing Life.</p>\n<h1>CZYM JEST KIJEK HEALING LIFE</h1>\n<p>Kijek <em>Healing Life </em>to ergonomicznie zaprojektowane narzędzie, aby efektywnie stymulować końcówki nerwów, tkanki, mięśnie i organy zlokalizowane wokół pępka. To wielofunkcyjne narzędzie do masażu. Posiada cztery końcówki o różnej długości i grubości, które mogą być używane do różnych technik masażu pępka, jak i całego ciała. Materiał, który został zawarty w kijku <em>Healing Life</em> to Hantoryum.</p>\n<p><strong>Czym jest Hantoryum?</strong></p>\n<p>Hantoryum jest związkiem zawierającym czerwoną glinkę i dokładnie wyselekcjonowane lecznicze minerały, takie jak zeolit, elwan i lessy. Substancje te ze względu na swe lecznicze właściwości są używane od tysięcy lat. Kiedy dochodzi do kontaktu ze skórą, naturalne właściwości materiału przenikają w głąb ciała i tu zaczyna się ich cudowne działanie.</p>\n<p>Zostało naukowo udowodnione, że Hantoryum emituje promieniowanie dalekiej podczerwieni (z ang. FIR). Są to naturalnie występujące, niewidoczne fale światła o leczniczym działaniu, o szczególnej długości fali, która dociera poprzez skórę w głąb ciała. Kiedy spędzasz czas na słońcu, doświadczasz uczucia wewnętrznego ciepła, relaksu i odmłodzenia. Jest to wynikiem emitowania dalekiej podczerwieni przez promienie słoneczne. Uzdrawiająca mata wykonana z Hantoryum zapewnia takie same wzmacniające korzyści, które możesz odczuć już zaledwie po kilku minutach.</p>\n");
INSERT INTO `wp_postmeta` VALUES("25", "6", "landing_page_section-2-btn", "Jak można nauczyć się tej metody?");
INSERT INTO `wp_postmeta` VALUES("26", "6", "landing_page_section-2a-title", "Jest kilka sposobów, aby nauczyć się metody Uzdrawiania przez Pępek");
INSERT INTO `wp_postmeta` VALUES("27", "6", "landing_page_section-2a-input-1", "<p>Umów się na indywidualną sesję uzdrawiania, aby doświadczyć korzyści płynących z metody masażu pępka. Już po pierwszej wizycie poczujesz duże odprężenie i rozluźnienie mięśni i organów. W trakcie masażu poprawi się też przepływ krwi i energii.</p>\n<p>&nbsp;</p>\n");
INSERT INTO `wp_postmeta` VALUES("28", "6", "landing_page_section-2a-input-2", "<p>Zapisz się na całodniowy warsztat, który odbywa się w naszym centrum raz w miesiącu. W trakcie warsztatu dogłębnie poznasz zasady uzdrawiania siebie i innych. Najbliższy warsztat Uzdrawiania przez Pępek odbędzie się w Rybniku 6 stycznia 2018.</p>\n<p>&nbsp;</p>\n");
INSERT INTO `wp_postmeta` VALUES("29", "6", "landing_page_section-2a-input-3", "<p>Zamów dla siebie kijek Healing Life wraz z opisem metody w języku polskim w formie e-book i samodzielnie masuj swój pępek. Rozpocznij swój osobisty trening wspierania zdrowia masażem Healing Life 3 razy dziennie po 5 minut.</p>\n<p>&nbsp;</p>\n");
INSERT INTO `wp_postmeta` VALUES("32", "6", "landing_page_footer-lp", "<h2 style=\"text-align: center;\">Zapraszam do kontaktu</h2>\n<p style=\"text-align: center;\">[bnb-btn class=\"btn btn-orange btn-big\" link=\"kontakt\" text=\"Napisz do nas\"]</p>\n<p style=\"text-align: center;\">Ola Mason - Instruktor Metody Uzdrawiania przez Pępek</p>\n<p style=\"text-align: center;\">Telefon 887 362 809</p>\n<p><img class=\"size-medium wp-image-193 aligncenter\" src=\"http://bnb.testuj.website/wp-content/uploads/2017/10/DSC_0392-300x169.jpg\" alt=\"\" width=\"300\" height=\"169\" /></p>\n<p style=\"text-align: center;\">[short-line]</p>\n<p style=\"text-align: center;\">Zobacz wideo - wywiad na temat metody Uzdrawianie przez Pepek:</p>\n<p>[video width=\"1280\" height=\"720\" mp4=\"http://bnb.testuj.website/wp-content/uploads/2017/10/Aleksandra-Mason-BODYBRAIN.mp4\"][/video]</p>\n<p>&nbsp;</p>\n");
INSERT INTO `wp_postmeta` VALUES("33", "10", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("34", "10", "_wp_page_template", "template-warsztaty.php");
INSERT INTO `wp_postmeta` VALUES("35", "10", "landing_page_section-active-1", "0");
INSERT INTO `wp_postmeta` VALUES("36", "10", "landing_page_section-active-1a", "1");
INSERT INTO `wp_postmeta` VALUES("37", "10", "landing_page_section-active-2", "0");
INSERT INTO `wp_postmeta` VALUES("38", "10", "landing_page_healinglife", "0");
INSERT INTO `wp_postmeta` VALUES("39", "10", "landing_page_section-active-2a", "1");
INSERT INTO `wp_postmeta` VALUES("40", "10", "landing_page_slide-title", "a:3:{i:0;s:10:\"Kim jestem\";i:1;s:13:\"Czego pragnę\";i:2;s:25:\"Odkrywam swój potencjał\";}");
INSERT INTO `wp_postmeta` VALUES("41", "10", "landing_page_slide-desc", "a:3:{i:0;s:141:\"Odpowiesz sobie na pytanie, kim jesteś naprawdę. Czym są myśli i emocje i jak z nimi pracować, aby wspierały one Ciebie i Twoje życie.\";i:1;s:165:\"Odkryjesz, czego pragniesz i jaki jest Twój życiowy cel. Dlaczego się urodziłem? Jaki sens ma życie? Na te pytania odpowiesz sobie w trakcie warsztatu Shimsung.\";i:2;s:126:\"Poczujesz całym sobą, jaki drzemie w Tobie potencjał. Uruchomisz pokłady kreatywności i odkryjesz w sobie prawdziwą Moc.\";}");
INSERT INTO `wp_postmeta` VALUES("42", "10", "_edit_lock", "1512473816:1");
INSERT INTO `wp_postmeta` VALUES("43", "12", "_wp_attached_file", "2017/10/wallpaper-bird-of-the-soul-type2-1366x768.jpg");
INSERT INTO `wp_postmeta` VALUES("44", "12", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1366;s:6:\"height\";i:768;s:4:\"file\";s:53:\"2017/10/wallpaper-bird-of-the-soul-type2-1366x768.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:53:\"wallpaper-bird-of-the-soul-type2-1366x768-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:53:\"wallpaper-bird-of-the-soul-type2-1366x768-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:53:\"wallpaper-bird-of-the-soul-type2-1366x768-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:54:\"wallpaper-bird-of-the-soul-type2-1366x768-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("45", "10", "landing_page_page-title", "Shimsung");
INSERT INTO `wp_postmeta` VALUES("46", "10", "landing_page_page-subtitle", "Uwolnij swój potencjał <br/>\r\nPoznaj swoje Prawdziwe Ja");
INSERT INTO `wp_postmeta` VALUES("48", "10", "landing_page_footer-lp", "<h2 style=\"text-align: center;\">Rozpocznij swoją życiową przygodę już teraz!</h2>\n<p style=\"text-align: center;\">Zadzwoń  <span style=\"color: #ff6200;\">887 362 809 </span></p>\n<p style=\"text-align: center;\"><img class=\"aligncenter wp-image-82 size-medium\" src=\"http://warsztaty.bodynbrain.pl/wp-content/uploads/2017/07/1499682696595-300x225.jpg\" alt=\"\" width=\"300\" height=\"225\" /></p>\n<p style=\"text-align: center;\">[short-line]</p>\n");
INSERT INTO `wp_postmeta` VALUES("49", "14", "_wp_attached_file", "2017/10/belly-button-healing-gut-cropped.png");
INSERT INTO `wp_postmeta` VALUES("50", "14", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1195;s:6:\"height\";i:681;s:4:\"file\";s:44:\"2017/10/belly-button-healing-gut-cropped.png\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:44:\"belly-button-healing-gut-cropped-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:44:\"belly-button-healing-gut-cropped-300x171.png\";s:5:\"width\";i:300;s:6:\"height\";i:171;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:44:\"belly-button-healing-gut-cropped-768x438.png\";s:5:\"width\";i:768;s:6:\"height\";i:438;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:45:\"belly-button-healing-gut-cropped-1024x584.png\";s:5:\"width\";i:1024;s:6:\"height\";i:584;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("51", "13", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("52", "13", "_wp_page_template", "template-warsztaty.php");
INSERT INTO `wp_postmeta` VALUES("53", "13", "landing_page_page-title", "Uzdrawianie przez pępek");
INSERT INTO `wp_postmeta` VALUES("54", "13", "landing_page_page-subtitle", "Czym jest uzdrawianie?<br/>\r\nJaką rolę gra pępek? <br/>\r\nDoświadcz poprawy zdrowia i samopoczucia w trakcie naszego warsztatu!");
INSERT INTO `wp_postmeta` VALUES("56", "13", "landing_page_section-active-1", "0");
INSERT INTO `wp_postmeta` VALUES("57", "13", "landing_page_section-active-1a", "1");
INSERT INTO `wp_postmeta` VALUES("58", "13", "landing_page_section-active-2", "1");
INSERT INTO `wp_postmeta` VALUES("59", "13", "landing_page_healinglife", "0");
INSERT INTO `wp_postmeta` VALUES("60", "13", "landing_page_section-active-2a", "1");
INSERT INTO `wp_postmeta` VALUES("61", "13", "landing_page_slide-title", "a:5:{i:0;s:18:\"Poprawa krążenia\";i:1;s:20:\"Większa odporność\";i:2;s:14:\"Usuwanie bólu\";i:3;s:20:\"Poprawa samopoczucia\";i:4;s:15:\"Spokojny umysł\";}");
INSERT INTO `wp_postmeta` VALUES("62", "13", "landing_page_slide-desc", "a:5:{i:0;s:136:\"Wokół pępka znajdują się główne naczynia krwionośne. Podczas warsztatu poczujesz dużą poprawę przepływu krwi w całym ciele.\";i:1;s:169:\"Duże węzły chłonne znajdujące się wokół pępka stymulowane są w ciągu warsztatu, dlatego po całym dniu treningu uzyskasz wzmocnienie układu odpornościowego.\";i:2;s:197:\"Przez linię pępka przechodzą główne linie powięzi. Dzięki masażowi pępka relaksujemy spięte mięśnie i tkanki w całym ciele i usuwamy blokady energetyczne, które ten ból spowodowały.\";i:3;s:162:\"W jelitach produkowane są hormony szczęścia i radości. W trakcie warsztatu Twoje samopoczucie znacznie się poprawi poprzez stymulację serotoniny i dopaminy.\";i:4;s:197:\"Zaraz za pępkiem znajduje się nerw błędny, który łączy organy z mózgiem. Na warsztacie dowiesz się, jak przez technikę Uzdrawiania przez Pępek można wpłynąć na swój stan psychiczny.\";}");
INSERT INTO `wp_postmeta` VALUES("63", "13", "_edit_lock", "1512472608:1");
INSERT INTO `wp_postmeta` VALUES("65", "13", "landing_page_footer-lp", "<h2 style=\"text-align: center;\">Więcej na temat techniki Uzdrawiania przez Pępek znajdziesz w zakładce <a href=\"http://bnb.testuj.website/warsztaty/uzdrawianie-przez-pepek-2/\">PĘPEK</a></h2>\n<h2 style=\"text-align: center;\">Zainteresowany udziałem? Zapraszamy serdecznie, skontaktuj się z nami już dziś!</h2>\n<p style=\"text-align: center;\">[bnb-btn class=\"btn btn-orange btn-big\" link=\"kontakt\" text=\"Napisz do nas\"]</p>\n<p style=\"text-align: center;\">Lub zapytaj o szczegóły, informacji udziela Manager Centrum Body and Brain</p>\n<p style=\"text-align: center;\">Aleksandra Mason <span style=\"color: #ff6200;\">887 362 809</span></p>\n<p style=\"text-align: center;\">[short-line]</p>\n");
INSERT INTO `wp_postmeta` VALUES("66", "15", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("67", "15", "_edit_lock", "1513086326:1");
INSERT INTO `wp_postmeta` VALUES("69", "15", "landing_page_section-active-1", "1");
INSERT INTO `wp_postmeta` VALUES("70", "15", "landing_page_section-active-1a", "1");
INSERT INTO `wp_postmeta` VALUES("71", "15", "landing_page_section-active-2", "1");
INSERT INTO `wp_postmeta` VALUES("72", "15", "landing_page_healinglife", "0");
INSERT INTO `wp_postmeta` VALUES("73", "15", "landing_page_section-active-2a", "1");
INSERT INTO `wp_postmeta` VALUES("74", "15", "landing_page_slide-title", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("75", "15", "landing_page_slide-desc", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("76", "15", "_wp_page_template", "template-home.php");
INSERT INTO `wp_postmeta` VALUES("77", "19", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("78", "19", "_edit_lock", "1507993578:1");
INSERT INTO `wp_postmeta` VALUES("79", "19", "testimonials_opinia", "<p>Od 5 lat męczyły mnie szumy w głowie, po położeniu się spać miałam w związku z tym duże problemy ze snem. Rano wstawałam zmęczona i cały dzień chodziłam zmęczona. Na zajęciach w Centrum Body and Brain w Rybniku nauczyłam się, jak poprawić swoje krążenie krwi. Na lekcje przychodzę regularnie raz w tygodniu, a w domu sama codziennie powtarzam ćwiczenia, szczególnie opukiwania i masaż przez pępek. Już po pierwszym miesiącu treningu w Centrum Body and Brain szumy w głowie prawie minęły, stały się prawie niewyczuwalne i nie przeszkadzają w spaniu. Rano wstaję wypoczęta. Pragnę także dodać, że przez 5 lat poszukiwałam pomocy u lekarzy, w tym u neurologa. Niestety lekarze nie byli w stanie mi pomóc. Trening Body and Brain polecam absolutnie każdemu.</p>\n");
INSERT INTO `wp_postmeta` VALUES("80", "20", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("81", "20", "_edit_lock", "1507992555:1");
INSERT INTO `wp_postmeta` VALUES("82", "20", "testimonials_zawod", "Nauczyciel");
INSERT INTO `wp_postmeta` VALUES("83", "20", "testimonials_opinia", "<p>Uczęszczam od maja 2016 roku i ćwiczę w Body and Brain. Mam poważną dyskopatię i w październiku 2016 roku miałam wyznaczoną operację w Jastrzębiu, mój lekarz twierdził, że jest niezbędna abym mogła funkcjonować bez bólu.</p>\n<p>Ćwiczenia Healing Life sprawiły, że ból jest dużo mniejszy i operacja została odwołana.<br />\nDodatkowo jestem spokojniejsza i mam więcej humoru, co z kolei cieszy mojego męża :)<br />\nTakże polecam wszystkim.</p>\n");
INSERT INTO `wp_postmeta` VALUES("84", "21", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("85", "21", "_edit_lock", "1510583867:1");
INSERT INTO `wp_postmeta` VALUES("86", "21", "testimonials_opinia", "<p>Chodziłam na różne gimnastyki i zawsze po ćwiczeniach czułam się zmęczona, ale tylko po tych zajęciach w centrum Body and Brain czuję się wypoczęta i pełna energii!</p>\n");
INSERT INTO `wp_postmeta` VALUES("87", "22", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("88", "22", "_edit_lock", "1507992381:1");
INSERT INTO `wp_postmeta` VALUES("89", "22", "testimonials_zawod", "Handlowiec");
INSERT INTO `wp_postmeta` VALUES("90", "22", "testimonials_opinia", "<p>Od momentu ćwiczeń z kijkiem Healing Lfe w Centrum Body and Brain moje ciśnienie krwi się unormowało. Mój lekarz potwierdził, że dzięki tej metodzie nie potrzebuję już brać tak dużej dawki leków. Naturalnie udało mi się przywrócić do mojego ciała harmonię i równowagę.</p>\n");
INSERT INTO `wp_postmeta` VALUES("91", "23", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("92", "23", "_edit_lock", "1507992337:1");
INSERT INTO `wp_postmeta` VALUES("93", "23", "testimonials_zawod", "Oddziały w Rybniku");
INSERT INTO `wp_postmeta` VALUES("94", "23", "testimonials_opinia", "<p>Bardzo pomocne w pracy i po pracy ćwiczenia na radzenie sobie ze stresem, rozluźnienie ciała i koncentrację umysłu. W naszej pracy dużo siedzimy, ćwiczenia pomagają rozluźnić kręgosłup i nadgarstki oraz barki. Umysł jest bardziej klarowny. - Manager oddziału WBK w Rybniku.</p>\n");
INSERT INTO `wp_postmeta` VALUES("95", "24", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("96", "24", "_edit_lock", "1507992317:1");
INSERT INTO `wp_postmeta` VALUES("97", "24", "testimonials_zawod", "Optyk ul. Kościelna 9 Rybnik");
INSERT INTO `wp_postmeta` VALUES("98", "24", "testimonials_opinia", "<p>Dzięki regularnej praktyce jogi w Rybniku w centrum Body and Brain czuję się bardziej szczęśliwa. Jestem bardziej otwarta na innych. Udało mi się załatwić wiele spraw, które wcześniej wydawały mi się trudne. Na ćwiczeniach zyskało moje ciało, które teraz jest bardziej wysportowane i giętkie. Wreszcie znalazłam coś, co mnie pochłonęło w 100{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}. Zmieniło się moje postrzeganie wielu rzeczy. Jestem bardzo wdzięczna. Dzięki<img title=\"heart\" src=\"http://www.bodynbrain.pl/cms/plugins/smiley/images/heart.gif\" alt=\"heart\" /></p>\n");
INSERT INTO `wp_postmeta` VALUES("99", "25", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("100", "25", "_edit_lock", "1507992282:1");
INSERT INTO `wp_postmeta` VALUES("101", "25", "testimonials_zawod", "Reżyser filmowy");
INSERT INTO `wp_postmeta` VALUES("102", "25", "testimonials_opinia", "<p>Po kilku miesiącach korzystania z oferty Body and Brain poczułam sie spokojniejsza i weselsza. Przestałam się przejmować większością rzeczy, na które nie mam i nie będę mieć wpływu. Regularna praktyka pozwoliła mi się skoncetrować na moich celach i oswoić się z problemami zdrowotnymi. Udało mi się zmienić pracę na lepszą oraz zacząć realizować swoje marzenie. Ćwiczenia są dostosowane do mojej kondycji i ogólnego samopoczucia a nauczyciele są zawsze pomocni i bardzo wspierający. Początkowo byłam nastawiona nieufnie, ale od jakigoś czasu nie umiem sobie wyborazic dobrego dnia bez jogi.</p>\n<p>Jak najbardziej polecam.<img title=\"yes\" src=\"http://www.bodynbrain.pl/cms/plugins/smiley/images/thumbs_up.gif\" alt=\"yes\" /></p>\n");
INSERT INTO `wp_postmeta` VALUES("103", "26", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("104", "26", "_edit_lock", "1507993660:1");
INSERT INTO `wp_postmeta` VALUES("105", "26", "testimonials_zawod", "Pielęgniarka");
INSERT INTO `wp_postmeta` VALUES("106", "26", "testimonials_opinia", "<p>Po 5 miesiącach regularnej praktyki jogi Body and Brain przeżyłam niesamowity moment, kiedy to mój mózg się dosłownie obudził. Cały ciężar myśli i emocji, jaki przez lata kumulował się w mojej głowie nagle znikł! Nie czułam się tak lekko, świeżo i pozytywnie od wielu lat. Moje zmysły się wyostrzyły, mój wzrok się poprawił, moja głowa po prostu jest lekka i pozytywna! Zmieniłam pracę, buduję swoje życie od nowa. Moje otoczenie zauważyło, że się zmieniam na lepsze. Dziękuję. <img title=\"wink\" src=\"http://www.bodynbrain.pl/cms/plugins/smiley/images/wink_smile.gif\" alt=\"wink\" /></p>\n");
INSERT INTO `wp_postmeta` VALUES("107", "23", "testimonials_opinia_krotka", "<p>Bardzo pomocne w pracy i po pracy ćwiczenia na radzenie sobie ze stresem, rozluźnienie ciała i koncentrację umysłu. W naszej pracy dużo siedzimy, ćwiczenia pomagają rozluźnić kręgosłup i nadgarstki oraz barki. Umysł jest bardziej klarowny.</p>\n");
INSERT INTO `wp_postmeta` VALUES("108", "19", "testimonials_opinia_krotka", "<p>Już po pierwszym miesiącu treningu w Centrum Body and Brain szumy w głowie prawie minęły, stały się prawie niewyczuwalne i nie przeszkadzają w spaniu. Rano wstaję wypoczęta.</p>\n");
INSERT INTO `wp_postmeta` VALUES("109", "20", "testimonials_opinia_krotka", "<p>Ćwiczenia Healing Life sprawiły, że ból kręgosłupa jest dużo mniejszy i operacja została odwołana.<br />\nDodatkowo jestem spokojniejsza i mam więcej humoru.</p>\n");
INSERT INTO `wp_postmeta` VALUES("110", "22", "testimonials_opinia_krotka", "<p>Od momentu ćwiczeń z kijkiem Healing Lfe w Centrum Body and Brain moje ciśnienie krwi się unormowało. Mój lekarz potwierdził, że dzięki tej metodzie nie potrzebuję już brać tak dużej dawki leków. Naturalnie udało mi się przywrócić do mojego ciała harmonię i równowagę</p>\n");
INSERT INTO `wp_postmeta` VALUES("111", "21", "testimonials_opinia_krotka", "<p>Chodziłam na różne gimnastyki i zawsze po ćwiczeniach czułam się zmęczona, ale tylko po tych zajęciach w centrum Body and Brain czuję się wypoczęta i pełna energii!</p>\n");
INSERT INTO `wp_postmeta` VALUES("112", "26", "testimonials_home_page_", "1");
INSERT INTO `wp_postmeta` VALUES("113", "25", "testimonials_home_page", "0");
INSERT INTO `wp_postmeta` VALUES("114", "21", "testimonials_home_page", "1");
INSERT INTO `wp_postmeta` VALUES("115", "19", "testimonials_home_page", "1");
INSERT INTO `wp_postmeta` VALUES("116", "20", "testimonials_home_page", "1");
INSERT INTO `wp_postmeta` VALUES("117", "22", "testimonials_home_page", "1");
INSERT INTO `wp_postmeta` VALUES("118", "23", "testimonials_home_page", "1");
INSERT INTO `wp_postmeta` VALUES("119", "1", "_edit_lock", "1510696638:1");
INSERT INTO `wp_postmeta` VALUES("120", "27", "_wp_attached_file", "2017/10/Anna_Switka_3_20150731195204.jpg");
INSERT INTO `wp_postmeta` VALUES("121", "27", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:100;s:6:\"height\";i:112;s:4:\"file\";s:40:\"2017/10/Anna_Switka_3_20150731195204.jpg\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("122", "26", "_thumbnail_id", "27");
INSERT INTO `wp_postmeta` VALUES("123", "26", "testimonials_home_page", "0");
INSERT INTO `wp_postmeta` VALUES("124", "28", "_wp_attached_file", "2017/10/Antosia_20161213203942.jpg");
INSERT INTO `wp_postmeta` VALUES("125", "28", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:132;s:6:\"height\";i:159;s:4:\"file\";s:34:\"2017/10/Antosia_20161213203942.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"Antosia_20161213203942-132x150.jpg\";s:5:\"width\";i:132;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"D6603\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1481659591\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"4.6\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:7:\"0.03125\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("126", "29", "_wp_attached_file", "2017/10/Aneta_Koterba_20160606123813.jpg");
INSERT INTO `wp_postmeta` VALUES("127", "29", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:217;s:6:\"height\";i:284;s:4:\"file\";s:40:\"2017/10/Aneta_Koterba_20160606123813.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:40:\"Aneta_Koterba_20160606123813-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"D6603\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1454711830\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"4.6\";s:3:\"iso\";s:3:\"250\";s:13:\"shutter_speed\";s:7:\"0.03125\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("128", "25", "_thumbnail_id", "29");
INSERT INTO `wp_postmeta` VALUES("129", "30", "_wp_attached_file", "2017/10/Karina_Adamczyk_20160606123532.jpg");
INSERT INTO `wp_postmeta` VALUES("130", "30", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:107;s:6:\"height\";i:168;s:4:\"file\";s:42:\"2017/10/Karina_Adamczyk_20160606123532.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:42:\"Karina_Adamczyk_20160606123532-107x150.jpg\";s:5:\"width\";i:107;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"D6603\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1465211365\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"4.6\";s:3:\"iso\";s:3:\"160\";s:13:\"shutter_speed\";s:7:\"0.03125\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("131", "24", "_thumbnail_id", "30");
INSERT INTO `wp_postmeta` VALUES("132", "24", "testimonials_home_page", "0");
INSERT INTO `wp_postmeta` VALUES("133", "31", "_wp_attached_file", "2017/10/bank-zachodni_20161108122234.jpg");
INSERT INTO `wp_postmeta` VALUES("134", "31", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:124;s:6:\"height\";i:71;s:4:\"file\";s:40:\"2017/10/bank-zachodni_20161108122234.jpg\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("135", "23", "_thumbnail_id", "31");
INSERT INTO `wp_postmeta` VALUES("136", "22", "_thumbnail_id", "28");
INSERT INTO `wp_postmeta` VALUES("137", "32", "_wp_attached_file", "2017/10/Eugenia_Krakowczyk_20161223124844.jpg");
INSERT INTO `wp_postmeta` VALUES("138", "32", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:162;s:6:\"height\";i:288;s:4:\"file\";s:45:\"2017/10/Eugenia_Krakowczyk_20161223124844.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:45:\"Eugenia_Krakowczyk_20161223124844-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"D6603\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1482496729\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"4.6\";s:3:\"iso\";s:3:\"500\";s:13:\"shutter_speed\";s:7:\"0.03125\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("139", "21", "_thumbnail_id", "32");
INSERT INTO `wp_postmeta` VALUES("140", "33", "_wp_attached_file", "2017/10/Sabina_Ficek_20170225130800.jpg");
INSERT INTO `wp_postmeta` VALUES("141", "33", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:140;s:6:\"height\";i:138;s:4:\"file\";s:39:\"2017/10/Sabina_Ficek_20170225130800.jpg\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("142", "20", "_thumbnail_id", "33");
INSERT INTO `wp_postmeta` VALUES("143", "34", "_wp_attached_file", "2017/10/Brygida_wwww_20171006143639.jpg");
INSERT INTO `wp_postmeta` VALUES("144", "34", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:121;s:6:\"height\";i:83;s:4:\"file\";s:39:\"2017/10/Brygida_wwww_20171006143639.jpg\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("145", "19", "_thumbnail_id", "34");
INSERT INTO `wp_postmeta` VALUES("149", "40", "_wp_attached_file", "2017/10/1_Dolaczenie_do_zespolu_09_2008_20150415125605.jpg");
INSERT INTO `wp_postmeta` VALUES("150", "40", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1300;s:6:\"height\";i:975;s:4:\"file\";s:58:\"2017/10/1_Dolaczenie_do_zespolu_09_2008_20150415125605.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:58:\"1_Dolaczenie_do_zespolu_09_2008_20150415125605-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:58:\"1_Dolaczenie_do_zespolu_09_2008_20150415125605-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:58:\"1_Dolaczenie_do_zespolu_09_2008_20150415125605-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:59:\"1_Dolaczenie_do_zespolu_09_2008_20150415125605-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.4\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"iPhone 4S\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1378922367\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"4.28\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:4:\"0.05\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("151", "41", "_wp_attached_file", "2017/10/2_ShimSung-Diploma_20150415125605.jpg");
INSERT INTO `wp_postmeta` VALUES("152", "41", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1300;s:6:\"height\";i:1005;s:4:\"file\";s:45:\"2017/10/2_ShimSung-Diploma_20150415125605.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:45:\"2_ShimSung-Diploma_20150415125605-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:45:\"2_ShimSung-Diploma_20150415125605-300x232.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:232;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:45:\"2_ShimSung-Diploma_20150415125605-768x594.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:594;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:46:\"2_ShimSung-Diploma_20150415125605-1024x792.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:792;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("153", "42", "_wp_attached_file", "2017/10/3_Initial-Awakening-Diploma-04_20150415125605.jpg");
INSERT INTO `wp_postmeta` VALUES("154", "42", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:939;s:6:\"height\";i:1300;s:4:\"file\";s:57:\"2017/10/3_Initial-Awakening-Diploma-04_20150415125605.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:57:\"3_Initial-Awakening-Diploma-04_20150415125605-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:57:\"3_Initial-Awakening-Diploma-04_20150415125605-217x300.jpg\";s:5:\"width\";i:217;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:58:\"3_Initial-Awakening-Diploma-04_20150415125605-768x1063.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1063;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:58:\"3_Initial-Awakening-Diploma-04_20150415125605-740x1024.jpg\";s:5:\"width\";i:740;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("155", "43", "_wp_attached_file", "2017/10/4_Human-Technogy-School-Diploma-05_20150415125605.jpg");
INSERT INTO `wp_postmeta` VALUES("156", "43", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1300;s:6:\"height\";i:985;s:4:\"file\";s:61:\"2017/10/4_Human-Technogy-School-Diploma-05_20150415125605.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:61:\"4_Human-Technogy-School-Diploma-05_20150415125605-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:61:\"4_Human-Technogy-School-Diploma-05_20150415125605-300x227.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:227;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:61:\"4_Human-Technogy-School-Diploma-05_20150415125605-768x582.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:582;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:62:\"4_Human-Technogy-School-Diploma-05_20150415125605-1024x776.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:776;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("157", "44", "_wp_attached_file", "2017/10/5_Chun_Hwa_07_2009_20150415125605.jpg");
INSERT INTO `wp_postmeta` VALUES("158", "44", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1300;s:6:\"height\";i:832;s:4:\"file\";s:45:\"2017/10/5_Chun_Hwa_07_2009_20150415125605.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:45:\"5_Chun_Hwa_07_2009_20150415125605-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:45:\"5_Chun_Hwa_07_2009_20150415125605-300x192.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:45:\"5_Chun_Hwa_07_2009_20150415125605-768x492.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:492;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:46:\"5_Chun_Hwa_07_2009_20150415125605-1024x655.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:655;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("159", "45", "_wp_attached_file", "2017/10/7_Do_tong_11_2012_20150415125605.jpg");
INSERT INTO `wp_postmeta` VALUES("160", "45", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1300;s:6:\"height\";i:975;s:4:\"file\";s:44:\"2017/10/7_Do_tong_11_2012_20150415125605.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:44:\"7_Do_tong_11_2012_20150415125605-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:44:\"7_Do_tong_11_2012_20150415125605-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:44:\"7_Do_tong_11_2012_20150415125605-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:45:\"7_Do_tong_11_2012_20150415125605-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.6\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"GT-S5830i\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1352656258\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"3.55\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:17:\"0.029411764705882\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("161", "46", "_wp_attached_file", "2017/10/8_Dahn-Master-Diploma-09_20150415125605.jpg");
INSERT INTO `wp_postmeta` VALUES("162", "46", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1300;s:6:\"height\";i:1005;s:4:\"file\";s:51:\"2017/10/8_Dahn-Master-Diploma-09_20150415125605.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:51:\"8_Dahn-Master-Diploma-09_20150415125605-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:51:\"8_Dahn-Master-Diploma-09_20150415125605-300x232.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:232;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:51:\"8_Dahn-Master-Diploma-09_20150415125605-768x594.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:594;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:52:\"8_Dahn-Master-Diploma-09_20150415125605-1024x792.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:792;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("163", "47", "_wp_attached_file", "2017/10/8_Dahn_master_Foto_09_2013_20150415125605.jpg");
INSERT INTO `wp_postmeta` VALUES("164", "47", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1300;s:6:\"height\";i:975;s:4:\"file\";s:53:\"2017/10/8_Dahn_master_Foto_09_2013_20150415125605.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:53:\"8_Dahn_master_Foto_09_2013_20150415125605-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:53:\"8_Dahn_master_Foto_09_2013_20150415125605-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:53:\"8_Dahn_master_Foto_09_2013_20150415125605-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:54:\"8_Dahn_master_Foto_09_2013_20150415125605-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("165", "48", "_wp_attached_file", "2017/10/A7CE52D49F6E16B2C5590BEC8038FB9EC7515FDD495EE06E01_pimgpsh_thumbnail_win_distr_20160313202517.jpg");
INSERT INTO `wp_postmeta` VALUES("166", "48", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:230;s:6:\"height\";i:164;s:4:\"file\";s:105:\"2017/10/A7CE52D49F6E16B2C5590BEC8038FB9EC7515FDD495EE06E01_pimgpsh_thumbnail_win_distr_20160313202517.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:105:\"A7CE52D49F6E16B2C5590BEC8038FB9EC7515FDD495EE06E01_pimgpsh_thumbnail_win_distr_20160313202517-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("167", "49", "_wp_attached_file", "2017/10/bellywand_20170607164716.jpg");
INSERT INTO `wp_postmeta` VALUES("168", "49", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:327;s:6:\"height\";i:245;s:4:\"file\";s:36:\"2017/10/bellywand_20170607164716.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"bellywand_20170607164716-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"bellywand_20170607164716-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("169", "50", "_wp_attached_file", "2017/10/joga_seniorAlw_20160310124945.jpg");
INSERT INTO `wp_postmeta` VALUES("170", "50", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2048;s:6:\"height\";i:1152;s:4:\"file\";s:41:\"2017/10/joga_seniorAlw_20160310124945.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"joga_seniorAlw_20160310124945-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"joga_seniorAlw_20160310124945-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:41:\"joga_seniorAlw_20160310124945-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:42:\"joga_seniorAlw_20160310124945-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("171", "51", "_wp_attached_file", "2017/10/joga_seniorAlw_20160310125208.jpg");
INSERT INTO `wp_postmeta` VALUES("172", "51", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2048;s:6:\"height\";i:1152;s:4:\"file\";s:41:\"2017/10/joga_seniorAlw_20160310125208.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"joga_seniorAlw_20160310125208-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"joga_seniorAlw_20160310125208-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:41:\"joga_seniorAlw_20160310125208-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:42:\"joga_seniorAlw_20160310125208-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("173", "52", "_wp_attached_file", "2017/10/joga_seniorAlw_20160313203109.jpg");
INSERT INTO `wp_postmeta` VALUES("174", "52", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2048;s:6:\"height\";i:1152;s:4:\"file\";s:41:\"2017/10/joga_seniorAlw_20160313203109.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"joga_seniorAlw_20160313203109-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"joga_seniorAlw_20160313203109-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:41:\"joga_seniorAlw_20160313203109-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:42:\"joga_seniorAlw_20160313203109-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("175", "53", "_wp_attached_file", "2017/10/Shimsung_2017_20170224161916.jpg");
INSERT INTO `wp_postmeta` VALUES("176", "53", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:768;s:4:\"file\";s:40:\"2017/10/Shimsung_2017_20170224161916.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:40:\"Shimsung_2017_20170224161916-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:40:\"Shimsung_2017_20170224161916-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:40:\"Shimsung_2017_20170224161916-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:41:\"Shimsung_2017_20170224161916-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("177", "54", "_wp_attached_file", "2017/10/WP_20160305_10_48_34_Rich_small_20160313213152.jpg");
INSERT INTO `wp_postmeta` VALUES("178", "54", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:58:\"2017/10/WP_20160305_10_48_34_Rich_small_20160313213152.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:58:\"WP_20160305_10_48_34_Rich_small_20160313213152-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:58:\"WP_20160305_10_48_34_Rich_small_20160313213152-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:58:\"WP_20160305_10_48_34_Rich_small_20160313213152-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:59:\"WP_20160305_10_48_34_Rich_small_20160313213152-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("179", "40", "_wp_attachment_image_alt", "Dołączenie do zespołu 2008");
INSERT INTO `wp_postmeta` VALUES("180", "41", "_wp_attachment_image_alt", "ShimSung 2009");
INSERT INTO `wp_postmeta` VALUES("181", "42", "_wp_attachment_image_alt", "Initial Awakening 2009");
INSERT INTO `wp_postmeta` VALUES("182", "43", "_wp_attachment_image_alt", "Human Technogy School 2009");
INSERT INTO `wp_postmeta` VALUES("183", "44", "_wp_attachment_image_alt", "Francja 2009");
INSERT INTO `wp_postmeta` VALUES("184", "45", "_wp_attachment_image_alt", "Do Tong Londyn 20012");
INSERT INTO `wp_postmeta` VALUES("185", "47", "_wp_attachment_image_alt", "Dahn Master Londyn 2013");
INSERT INTO `wp_postmeta` VALUES("186", "46", "_wp_attachment_image_alt", "Dahn Master Dyplom");
INSERT INTO `wp_postmeta` VALUES("187", "48", "_wp_attachment_image_alt", "Korea 2015");
INSERT INTO `wp_postmeta` VALUES("188", "54", "_wp_attachment_image_alt", "Rybnik 2016");
INSERT INTO `wp_postmeta` VALUES("189", "53", "_wp_attachment_image_alt", "Rybnik 2017 Warsztaty Rozwoju Osobistego");
INSERT INTO `wp_postmeta` VALUES("190", "49", "_wp_attachment_image_alt", "Healing Life KIJEK");
INSERT INTO `wp_postmeta` VALUES("226", "57", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("227", "57", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("228", "57", "_menu_item_object_id", "15");
INSERT INTO `wp_postmeta` VALUES("229", "57", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("230", "57", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("231", "57", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("232", "57", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("233", "57", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("235", "58", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("236", "58", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("237", "58", "_menu_item_object_id", "58");
INSERT INTO `wp_postmeta` VALUES("238", "58", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("239", "58", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("240", "58", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("241", "58", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("242", "58", "_menu_item_url", "#");
INSERT INTO `wp_postmeta` VALUES("244", "59", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("245", "59", "_menu_item_menu_item_parent", "58");
INSERT INTO `wp_postmeta` VALUES("246", "59", "_menu_item_object_id", "13");
INSERT INTO `wp_postmeta` VALUES("247", "59", "_menu_item_object", "warsztaty");
INSERT INTO `wp_postmeta` VALUES("248", "59", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("249", "59", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("250", "59", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("251", "59", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("253", "60", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("254", "60", "_menu_item_menu_item_parent", "58");
INSERT INTO `wp_postmeta` VALUES("255", "60", "_menu_item_object_id", "10");
INSERT INTO `wp_postmeta` VALUES("256", "60", "_menu_item_object", "warsztaty");
INSERT INTO `wp_postmeta` VALUES("257", "60", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("258", "60", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("259", "60", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("260", "60", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("262", "61", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("263", "61", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("264", "61", "_menu_item_object_id", "6");
INSERT INTO `wp_postmeta` VALUES("265", "61", "_menu_item_object", "warsztaty");
INSERT INTO `wp_postmeta` VALUES("266", "61", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("267", "61", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("268", "61", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("269", "61", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("270", "62", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("272", "62", "_edit_lock", "1508183662:1");
INSERT INTO `wp_postmeta` VALUES("273", "64", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("274", "64", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("275", "64", "_menu_item_object_id", "62");
INSERT INTO `wp_postmeta` VALUES("276", "64", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("277", "64", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("278", "64", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("279", "64", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("280", "64", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("282", "65", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("283", "65", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("284", "65", "_menu_item_object_id", "65");
INSERT INTO `wp_postmeta` VALUES("285", "65", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("286", "65", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("287", "65", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("288", "65", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("289", "65", "_menu_item_url", "/opinie");
INSERT INTO `wp_postmeta` VALUES("291", "62", "_wp_page_template", "template-contact.php");
INSERT INTO `wp_postmeta` VALUES("292", "66", "_form", "<div class=\'pole_all2\'>			\n			<div class=\'pole_opis_pop\'>Imię i nazwisko</div>\n			<div class=\'pole_pop\'>\n    [text* your-name class:pole_in_pop]\n</div></div>\n\n<div class=\'pole_all2\'>			\n			<div class=\'pole_opis_pop\'>Twój Email</div>\n			<div class=\'pole_pop\'>\n    [email* your-email class:pole_in_pop]\n</div></div>\n<div class=\'pole_all\'>		\n			<div class=\'pole_opis2_pop\'>Treść wiadomości</div>\n			</div>\n			\n			<div class=\'pole_all\'>\n			<div class=\'pole_area2_pop\'>\n    [textarea your-message class:pole_area_pop]\n</div>\n</div>\n[submit class:sprawdz_bt6 \"Wyślij wiadomość >\"]");
INSERT INTO `wp_postmeta` VALUES("293", "66", "_mail", "a:9:{s:6:\"active\";b:1;s:7:\"subject\";s:36:\"Welcome to the VCCW \"[your-subject]\"\";s:6:\"sender\";s:38:\"[your-name] <wordpress@bodynbrain.dev>\";s:9:\"recipient\";s:16:\"vccw@example.com\";s:4:\"body\";s:183:\"From: [your-name] <[your-email]>\nSubject: [your-subject]\n\nMessage Body:\n[your-message]\n\n-- \nThis e-mail was sent from a contact form on Welcome to the VCCW (http://bnb.testuj.website)\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `wp_postmeta` VALUES("294", "66", "_mail_2", "a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:36:\"Welcome to the VCCW \"[your-subject]\"\";s:6:\"sender\";s:46:\"Welcome to the VCCW <wordpress@bodynbrain.dev>\";s:9:\"recipient\";s:12:\"[your-email]\";s:4:\"body\";s:125:\"Message Body:\n[your-message]\n\n-- \nThis e-mail was sent from a contact form on Welcome to the VCCW (http://bnb.testuj.website)\";s:18:\"additional_headers\";s:26:\"Reply-To: vccw@example.com\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `wp_postmeta` VALUES("295", "66", "_messages", "a:23:{s:12:\"mail_sent_ok\";s:45:\"Thank you for your message. It has been sent.\";s:12:\"mail_sent_ng\";s:71:\"There was an error trying to send your message. Please try again later.\";s:16:\"validation_error\";s:61:\"One or more fields have an error. Please check and try again.\";s:4:\"spam\";s:71:\"There was an error trying to send your message. Please try again later.\";s:12:\"accept_terms\";s:69:\"You must accept the terms and conditions before sending your message.\";s:16:\"invalid_required\";s:22:\"The field is required.\";s:16:\"invalid_too_long\";s:22:\"The field is too long.\";s:17:\"invalid_too_short\";s:23:\"The field is too short.\";s:12:\"invalid_date\";s:29:\"The date format is incorrect.\";s:14:\"date_too_early\";s:44:\"The date is before the earliest one allowed.\";s:13:\"date_too_late\";s:41:\"The date is after the latest one allowed.\";s:13:\"upload_failed\";s:46:\"There was an unknown error uploading the file.\";s:24:\"upload_file_type_invalid\";s:49:\"You are not allowed to upload files of this type.\";s:21:\"upload_file_too_large\";s:20:\"The file is too big.\";s:23:\"upload_failed_php_error\";s:38:\"There was an error uploading the file.\";s:14:\"invalid_number\";s:29:\"The number format is invalid.\";s:16:\"number_too_small\";s:47:\"The number is smaller than the minimum allowed.\";s:16:\"number_too_large\";s:46:\"The number is larger than the maximum allowed.\";s:23:\"quiz_answer_not_correct\";s:36:\"The answer to the quiz is incorrect.\";s:17:\"captcha_not_match\";s:31:\"Your entered code is incorrect.\";s:13:\"invalid_email\";s:38:\"The e-mail address entered is invalid.\";s:11:\"invalid_url\";s:19:\"The URL is invalid.\";s:11:\"invalid_tel\";s:32:\"The telephone number is invalid.\";}");
INSERT INTO `wp_postmeta` VALUES("296", "66", "_additional_settings", "");
INSERT INTO `wp_postmeta` VALUES("297", "66", "_locale", "en_US");
INSERT INTO `wp_postmeta` VALUES("298", "67", "_form", "<div class=\'pole_all2\'>			\n			<div class=\'pole_opis_pop\'>Imię i nazwisko</div>\n			<div class=\'pole_pop\'>\n    [text* your-name class:pole_in_pop]\n</div></div>\n\n<div class=\'pole_all2\'>			\n			<div class=\'pole_opis_pop\'>Twój Email</div>\n			<div class=\'pole_pop\'>\n    [email* your-email class:pole_in_pop]\n</div></div>\n<div class=\'pole_all\'>		\n			<div class=\'pole_opis2_pop\'>Treść wiadomości</div>\n			</div>\n			\n			<div class=\'pole_all\'>\n			<div class=\'pole_area2_pop\'>\n    [textarea your-message class:pole_area_pop]\n</div>\n</div>\n[submit class:sprawdz_bt6 \"Wyślij wiadomość >\"]");
INSERT INTO `wp_postmeta` VALUES("299", "67", "_mail", "a:9:{s:6:\"active\";b:1;s:7:\"subject\";s:44:\"Wiadomość wysłana ze strony Bodynbrain.pl\";s:6:\"sender\";s:42:\"[your-name] <wordpress@bnb.testuj.website>\";s:9:\"recipient\";s:21:\"centrum@bodynbrain.pl\";s:4:\"body\";s:191:\"Nadawca: [your-name] <[your-email]>\n\nTreść wiadomości:\n[your-message]\n\n-- \nTa wiadomość została wysłana przez formularz kontaktowy na stronie Bodynbrain.pl (http://bnb.testuj.website).\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `wp_postmeta` VALUES("300", "67", "_mail_2", "a:9:{s:6:\"active\";b:1;s:7:\"subject\";s:34:\"Kopia wiadomości do Bodynbrain.pl\";s:6:\"sender\";s:44:\"Bodynbrain.pl <wordpress@bnb.testuj.website>\";s:9:\"recipient\";s:12:\"[your-email]\";s:4:\"body\";s:154:\"Treść wiadomości:\n[your-message]\n\n-- \nTa wiadomość została wysłana przez formularz kontaktowy na stronie Bodynbrain.pl (http://bnb.testuj.website).\";s:18:\"additional_headers\";s:31:\"Reply-To: centrum@bodynbrain.pl\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `wp_postmeta` VALUES("301", "67", "_messages", "a:23:{s:12:\"mail_sent_ok\";s:49:\"Twoja wiadomość została wysłana. Dziękujemy!\";s:12:\"mail_sent_ng\";s:80:\"Wystąpił problem z wysłaniem twojej wiadomości. Spróbuj ponownie później.\";s:16:\"validation_error\";s:98:\"Przynajmniej jedno pole jest błędnie wypełnione. Sprawdź wpisaną treść i spróbuj ponownie.\";s:4:\"spam\";s:80:\"Wystąpił problem z wysłaniem twojej wiadomości. Spróbuj ponownie później.\";s:12:\"accept_terms\";s:72:\"Musisz wyrazić zgodę na powyższe zapisy, aby móc wysłać formularz.\";s:16:\"invalid_required\";s:37:\"Wymagane jest wypełnienie tego pola.\";s:16:\"invalid_too_long\";s:39:\"Zawartość tego pola jest zbyt długa.\";s:17:\"invalid_too_short\";s:40:\"Zawartość tego pola jest zbyt krótka.\";s:12:\"invalid_date\";s:29:\"Format daty jest niepoprawny.\";s:14:\"date_too_early\";s:49:\"Data jest wcześniejsza, niż pierwsza dozwolona.\";s:13:\"date_too_late\";s:48:\"Data jest późniejsza, niż ostatnia dozwolona.\";s:13:\"upload_failed\";s:51:\"Podczas wgrywania pliku wystąpił nieznany błąd.\";s:24:\"upload_file_type_invalid\";s:39:\"Nie możesz wgrywać plików tego typu.\";s:21:\"upload_file_too_large\";s:25:\"Ten plik jest zbyt duży.\";s:23:\"upload_failed_php_error\";s:42:\"Wystąpił błąd podczas wgrywania pliku.\";s:14:\"invalid_number\";s:31:\"Format liczby jest niepoprawny.\";s:16:\"number_too_small\";s:52:\"Ta liczba jest mniejsza, niż minimalna dopuszczana.\";s:16:\"number_too_large\";s:54:\"Ta liczba jest większa, niż maksymalna dopuszczalna.\";s:23:\"quiz_answer_not_correct\";s:40:\"Odpowiedź w quizie jest nieprawidłowa.\";s:17:\"captcha_not_match\";s:32:\"Wpisany kod jest nieprawidłowy.\";s:13:\"invalid_email\";s:45:\"Wprowadzony adres e-mail jest nieprawidłowy.\";s:11:\"invalid_url\";s:42:\"Wprowadzony adres URL jest nieprawidłowy.\";s:11:\"invalid_tel\";s:47:\"Wprowadzony numer telefonu jest nieprawidłowy.\";}");
INSERT INTO `wp_postmeta` VALUES("302", "67", "_additional_settings", "");
INSERT INTO `wp_postmeta` VALUES("303", "67", "_locale", "pl_PL");
INSERT INTO `wp_postmeta` VALUES("307", "70", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("308", "70", "_edit_lock", "1510696717:1");
INSERT INTO `wp_postmeta` VALUES("309", "71", "_wp_attached_file", "2017/10/Kasia-Nim.jpg");
INSERT INTO `wp_postmeta` VALUES("310", "71", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:210;s:6:\"height\";i:374;s:4:\"file\";s:21:\"2017/10/Kasia-Nim.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"Kasia-Nim-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"Kasia-Nim-168x300.jpg\";s:5:\"width\";i:168;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("311", "70", "testimonials_zawod", "Optometrysta");
INSERT INTO `wp_postmeta` VALUES("312", "70", "testimonials_opinia", "<p>Udział w warsztacie to wyzwalające uczucie. Pozbyłam się negatywnych emocji, które we mnie siedziały. To było niesamowite uzdrowienie. Teraz czuję, że jestem wolna i mogę zrobić wszystko. Zdecydowanie poleciłabym warsztat, ponieważ każdy powinien doświadczyć wolności i zdać sobie sprawę jak nasze słowa i emocje wypływają na innych – jak kręgi na wodzie. - Alicja Śmiałek - właściciel optyk w Rybniku <a href=\"http://www.optykrybnik.pl\">http://www.optykrybnik.pl</a></p>\n");
INSERT INTO `wp_postmeta` VALUES("313", "70", "testimonials_opinia_krotka", "<p>To było niesamowite uzdrowienie. Teraz czuję, że jestem wolna i mogę zrobić wszystko.</p>\n");
INSERT INTO `wp_postmeta` VALUES("314", "70", "testimonials_home_page", "1");
INSERT INTO `wp_postmeta` VALUES("315", "72", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("317", "72", "_edit_lock", "1512379276:1");
INSERT INTO `wp_postmeta` VALUES("331", "77", "_wp_attached_file", "2017/10/Ola.jpg");
INSERT INTO `wp_postmeta` VALUES("332", "77", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:720;s:6:\"height\";i:720;s:4:\"file\";s:15:\"2017/10/Ola.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"Ola-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"Ola-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("333", "78", "_wp_attached_file", "2017/10/DSC_1152-e1508317583999.jpg");
INSERT INTO `wp_postmeta` VALUES("334", "78", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2160;s:6:\"height\";i:3840;s:4:\"file\";s:35:\"2017/10/DSC_1152-e1508317583999.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:35:\"DSC_1152-e1508317583999-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:35:\"DSC_1152-e1508317583999-169x300.jpg\";s:5:\"width\";i:169;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:36:\"DSC_1152-e1508317583999-768x1365.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1365;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:36:\"DSC_1152-e1508317583999-576x1024.jpg\";s:5:\"width\";i:576;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"D6603\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1456339334\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"4.6\";s:3:\"iso\";s:3:\"320\";s:13:\"shutter_speed\";s:7:\"0.03125\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"6\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("335", "78", "_wp_attachment_backup_sizes", "a:5:{s:9:\"full-orig\";a:3:{s:5:\"width\";i:3840;s:6:\"height\";i:2160;s:4:\"file\";s:12:\"DSC_1152.jpg\";}s:14:\"thumbnail-orig\";a:4:{s:4:\"file\";s:20:\"DSC_1152-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"medium-orig\";a:4:{s:4:\"file\";s:20:\"DSC_1152-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:17:\"medium_large-orig\";a:4:{s:4:\"file\";s:20:\"DSC_1152-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"large-orig\";a:4:{s:4:\"file\";s:21:\"DSC_1152-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}}");
INSERT INTO `wp_postmeta` VALUES("337", "70", "_thumbnail_id", "138");
INSERT INTO `wp_postmeta` VALUES("347", "82", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("348", "82", "_edit_lock", "1512386734:1");
INSERT INTO `wp_postmeta` VALUES("349", "82", "_wp_page_template", "template-warsztaty.php");
INSERT INTO `wp_postmeta` VALUES("350", "82", "landing_page_section-active-1", "1");
INSERT INTO `wp_postmeta` VALUES("351", "82", "landing_page_section-active-1a", "0");
INSERT INTO `wp_postmeta` VALUES("352", "82", "landing_page_section-active-2", "1");
INSERT INTO `wp_postmeta` VALUES("353", "82", "landing_page_healinglife", "0");
INSERT INTO `wp_postmeta` VALUES("354", "82", "landing_page_section-active-2a", "0");
INSERT INTO `wp_postmeta` VALUES("355", "82", "landing_page_slide-title", "a:3:{i:0;s:1:\"a\";i:1;s:1:\"b\";i:2;s:1:\"c\";}");
INSERT INTO `wp_postmeta` VALUES("356", "82", "landing_page_slide-desc", "a:3:{i:0;s:3:\"aaa\";i:1;s:3:\"bbb\";i:2;s:3:\"ccc\";}");
INSERT INTO `wp_postmeta` VALUES("361", "83", "_wp_attached_file", "2017/10/DSC_0001_w_20170525125122.jpg");
INSERT INTO `wp_postmeta` VALUES("362", "83", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:576;s:4:\"file\";s:37:\"2017/10/DSC_0001_w_20170525125122.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:37:\"DSC_0001_w_20170525125122-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"DSC_0001_w_20170525125122-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:37:\"DSC_0001_w_20170525125122-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:38:\"DSC_0001_w_20170525125122-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("363", "84", "_wp_attached_file", "2017/10/DSC_0002_w_20170525125214.jpg");
INSERT INTO `wp_postmeta` VALUES("364", "84", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:576;s:4:\"file\";s:37:\"2017/10/DSC_0002_w_20170525125214.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:37:\"DSC_0002_w_20170525125214-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"DSC_0002_w_20170525125214-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:37:\"DSC_0002_w_20170525125214-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:38:\"DSC_0002_w_20170525125214-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("365", "85", "_wp_attached_file", "2017/10/DSC_0003_w_20170525125302.jpg");
INSERT INTO `wp_postmeta` VALUES("366", "85", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:576;s:4:\"file\";s:37:\"2017/10/DSC_0003_w_20170525125302.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:37:\"DSC_0003_w_20170525125302-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"DSC_0003_w_20170525125302-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:37:\"DSC_0003_w_20170525125302-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:38:\"DSC_0003_w_20170525125302-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("367", "86", "_wp_attached_file", "2017/10/DSC_0004_w_20170525125345.jpg");
INSERT INTO `wp_postmeta` VALUES("368", "86", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:576;s:4:\"file\";s:37:\"2017/10/DSC_0004_w_20170525125345.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:37:\"DSC_0004_w_20170525125345-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"DSC_0004_w_20170525125345-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:37:\"DSC_0004_w_20170525125345-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:38:\"DSC_0004_w_20170525125345-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("369", "87", "_wp_attached_file", "2017/10/DSC_2360_w_20170525125452.jpg");
INSERT INTO `wp_postmeta` VALUES("370", "87", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:576;s:4:\"file\";s:37:\"2017/10/DSC_2360_w_20170525125452.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:37:\"DSC_2360_w_20170525125452-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"DSC_2360_w_20170525125452-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:37:\"DSC_2360_w_20170525125452-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:38:\"DSC_2360_w_20170525125452-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("371", "88", "_wp_attached_file", "2017/10/DSC_2379_w_20170525124411.jpg");
INSERT INTO `wp_postmeta` VALUES("372", "88", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:432;s:6:\"height\";i:768;s:4:\"file\";s:37:\"2017/10/DSC_2379_w_20170525124411.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:37:\"DSC_2379_w_20170525124411-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"DSC_2379_w_20170525124411-169x300.jpg\";s:5:\"width\";i:169;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("388", "90", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("389", "90", "_edit_lock", "1512387484:1");
INSERT INTO `wp_postmeta` VALUES("390", "91", "_wp_attached_file", "2017/10/grafik.jpg");
INSERT INTO `wp_postmeta` VALUES("391", "91", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1396;s:6:\"height\";i:583;s:4:\"file\";s:18:\"2017/10/grafik.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"grafik-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"grafik-300x125.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:18:\"grafik-768x321.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:321;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:19:\"grafik-1024x428.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:428;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("392", "92", "_wp_attached_file", "2017/10/3-seg.png");
INSERT INTO `wp_postmeta` VALUES("393", "92", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1518;s:6:\"height\";i:1022;s:4:\"file\";s:17:\"2017/10/3-seg.png\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"3-seg-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"3-seg-300x202.png\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:17:\"3-seg-768x517.png\";s:5:\"width\";i:768;s:6:\"height\";i:517;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:18:\"3-seg-1024x689.png\";s:5:\"width\";i:1024;s:6:\"height\";i:689;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("394", "90", "_wp_page_template", "landing-page.php");
INSERT INTO `wp_postmeta` VALUES("395", "90", "landing_page_section-active-1", "1");
INSERT INTO `wp_postmeta` VALUES("396", "90", "landing_page_section-active-1a", "1");
INSERT INTO `wp_postmeta` VALUES("397", "90", "landing_page_section-active-2", "1");
INSERT INTO `wp_postmeta` VALUES("398", "90", "landing_page_healinglife", "0");
INSERT INTO `wp_postmeta` VALUES("399", "90", "landing_page_section-active-2a", "0");
INSERT INTO `wp_postmeta` VALUES("400", "90", "landing_page_slide-title", "a:6:{i:0;s:13:\"poniedziałek\";i:1;s:6:\"wtorek\";i:2;s:6:\"środa\";i:3;s:7:\"cwartek\";i:4;s:7:\"piątek\";i:5;s:6:\"sobota\";}");
INSERT INTO `wp_postmeta` VALUES("401", "90", "landing_page_slide-desc", "a:6:{i:0;s:122:\"Witalność: koncentracja na brzuchu w celu wzmocnienia układu odpornościowego, poziomu energii i ogólnego samopoczucia\";i:1;s:72:\"Rozciąganie: poprawa mobilności, przepływu energii i komfortu w ciele\";i:2;s:98:\"Wibracje: życie jest wibracją! Głęboka wibracja, która pobudza Twoje ciało i uspokaja umysł\";i:3;s:184:\"Qi Gong i Dahn MuDo. Połącz swoje ciało i umysł. Popraw wewnętrzną równowagę, postawę i koncentrację. Popraw swoje fizyczne ciało i połącz wewnętrzną energię z naturą.\";i:4;s:135:\"Spokojny umysł. Popraw ostrość i połącz się tu i teraz. Uspokój swój umysł i odstresowanie poprzez proste sprawdzone techniki.\";i:5;s:178:\"Regeneracja. Naładuj baterię. Ta specjalna lekcja koncentruje się na budowaniu wewnętrznej rezerwy energii, aby poradzić sobie z intensywnym życiem. Relaks i rewitalizacja.\";}");
INSERT INTO `wp_postmeta` VALUES("411", "95", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("412", "95", "_edit_lock", "1512385663:1");
INSERT INTO `wp_postmeta` VALUES("413", "96", "_wp_attached_file", "2017/10/Szkola_20171005100641.jpg");
INSERT INTO `wp_postmeta` VALUES("414", "96", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1876;s:6:\"height\";i:1133;s:4:\"file\";s:33:\"2017/10/Szkola_20171005100641.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"Szkola_20171005100641-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"Szkola_20171005100641-300x181.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:181;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:33:\"Szkola_20171005100641-768x464.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:464;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:34:\"Szkola_20171005100641-1024x618.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:618;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("415", "95", "_wp_page_template", "template-warsztaty.php");
INSERT INTO `wp_postmeta` VALUES("416", "95", "landing_page_section-active-1", "1");
INSERT INTO `wp_postmeta` VALUES("417", "95", "landing_page_section-active-1a", "1");
INSERT INTO `wp_postmeta` VALUES("418", "95", "landing_page_section-active-2", "1");
INSERT INTO `wp_postmeta` VALUES("419", "95", "landing_page_healinglife", "0");
INSERT INTO `wp_postmeta` VALUES("420", "95", "landing_page_section-active-2a", "1");
INSERT INTO `wp_postmeta` VALUES("421", "95", "landing_page_slide-title", "a:3:{i:0;s:1:\"x\";i:1;s:1:\"y\";i:2;s:1:\"z\";}");
INSERT INTO `wp_postmeta` VALUES("422", "95", "landing_page_slide-desc", "a:3:{i:0;s:13:\"zdrowe ciało\";i:1;s:11:\"zero stresu\";i:2;s:12:\"zimna głowa\";}");
INSERT INTO `wp_postmeta` VALUES("435", "6", "_wp_page_template", "template-dla-firm.php");
INSERT INTO `wp_postmeta` VALUES("438", "100", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("439", "100", "_edit_lock", "1509205825:1");
INSERT INTO `wp_postmeta` VALUES("443", "103", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("445", "103", "_edit_lock", "1512333948:1");
INSERT INTO `wp_postmeta` VALUES("447", "106", "es_template_type", "Post Notification");
INSERT INTO `wp_postmeta` VALUES("448", "107", "es_template_type", "Newsletter");
INSERT INTO `wp_postmeta` VALUES("449", "108", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("450", "108", "_edit_lock", "1513092949:1");
INSERT INTO `wp_postmeta` VALUES("457", "121", "_form", "<div class=\"form_left\">\n						<div class=\"nag_form_l\">Twoje imię i nazwisko</div>\n						<div class=\"pole_form_l\">[text* your-name class:field_form_l]</div>\n</div>\n<div class=\"form_right\">\n						<div class=\"nag_form_l\">Twój adres email</div>\n						<div class=\"pole_form_l\">[email* your-email class:field_form_l]</div>\n</div>\n<div class=\"form_left3\">\n						<div class=\"nag_form_l\">Telefon</div>\n						<div class=\"pole_form_l\">    [text* your-phone class:field_form_l]</div>\n</div>\n<div class=\"form_right3\">\n						<div class=\"nag_form_l\">Wybierz termin spotkania</div>\n						<div class=\"pole_form_l\">[date* your-date date-format:mm/dd/yy first-day:1 class:field_form_l]</div>\n</div>\n<div class=\"form_reg\">[acceptance acceptance-519] Oświadczam, iż zapoznałem się z <a href=\"/polityka-prywatnosci\" class=\"link_pp\" target=\"_blank\">Polityką Prywatności</a> i akceptuję jej wszystkie postanowienia.\n</div>\n<div class=\'guzik_pop\'><button type=\'submit\' class=\'sprawdz_bt6\'>Rezerwuję termin <i class=\'fa fa-angle-right\' style=\'margin-left: 3px;\'></i></button><div class=\"wypisz\">W celu ustalenia szczegółów skontaktuję się z Tobą mailowo lub telefonicznie.</div></div>");
INSERT INTO `wp_postmeta` VALUES("458", "121", "_mail", "a:9:{s:6:\"active\";b:1;s:7:\"subject\";s:33:\"Body & Brain - Rezerwacja terminu\";s:6:\"sender\";s:42:\"[your-name] <wordpress@bnb.testuj.website>\";s:9:\"recipient\";s:21:\"centrum@bodynbrain.pl\";s:4:\"body\";s:208:\"Nadawca: [your-name] <[your-email]>\nTelefon: [your-phone]\n\nData spotkania: [your-date]\n\n-- \nTa wiadomość została wysłana przez formularz kontaktowy na stronie Body &amp; Brain (http://bnb.testuj.website).\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `wp_postmeta` VALUES("459", "121", "_mail_2", "a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:31:\"Body & Brain - \"[your-subject]\"\";s:6:\"sender\";s:43:\"Body & Brain <wordpress@bnb.testuj.website>\";s:9:\"recipient\";s:12:\"[your-email]\";s:4:\"body\";s:157:\"Treść wiadomości:\n[your-message]\n\n-- \nTa wiadomość została wysłana przez formularz kontaktowy na stronie Body &amp; Brain (http://bnb.testuj.website).\";s:18:\"additional_headers\";s:38:\"Reply-To: wordpress@bnb.testuj.website\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `wp_postmeta` VALUES("460", "121", "_messages", "a:23:{s:12:\"mail_sent_ok\";s:58:\"Twoja propozycja spotkania została wysłana. Dziękujemy!\";s:12:\"mail_sent_ng\";s:80:\"Wystąpił problem z wysłaniem twojej wiadomości. Spróbuj ponownie później.\";s:16:\"validation_error\";s:98:\"Przynajmniej jedno pole jest błędnie wypełnione. Sprawdź wpisaną treść i spróbuj ponownie.\";s:4:\"spam\";s:80:\"Wystąpił problem z wysłaniem twojej wiadomości. Spróbuj ponownie później.\";s:12:\"accept_terms\";s:72:\"Musisz wyrazić zgodę na powyższe zapisy, aby móc wysłać formularz.\";s:16:\"invalid_required\";s:37:\"Wymagane jest wypełnienie tego pola.\";s:16:\"invalid_too_long\";s:39:\"Zawartość tego pola jest zbyt długa.\";s:17:\"invalid_too_short\";s:40:\"Zawartość tego pola jest zbyt krótka.\";s:13:\"upload_failed\";s:51:\"Podczas wgrywania pliku wystąpił nieznany błąd.\";s:24:\"upload_file_type_invalid\";s:39:\"Nie możesz wgrywać plików tego typu.\";s:21:\"upload_file_too_large\";s:25:\"Ten plik jest zbyt duży.\";s:23:\"upload_failed_php_error\";s:42:\"Wystąpił błąd podczas wgrywania pliku.\";s:14:\"invalid_number\";s:31:\"Format liczby jest niepoprawny.\";s:16:\"number_too_small\";s:52:\"Ta liczba jest mniejsza, niż minimalna dopuszczana.\";s:16:\"number_too_large\";s:54:\"Ta liczba jest większa, niż maksymalna dopuszczalna.\";s:23:\"quiz_answer_not_correct\";s:40:\"Odpowiedź w quizie jest nieprawidłowa.\";s:17:\"captcha_not_match\";s:32:\"Wpisany kod jest nieprawidłowy.\";s:13:\"invalid_email\";s:45:\"Wprowadzony adres e-mail jest nieprawidłowy.\";s:11:\"invalid_url\";s:42:\"Wprowadzony adres URL jest nieprawidłowy.\";s:11:\"invalid_tel\";s:47:\"Wprowadzony numer telefonu jest nieprawidłowy.\";s:16:\"invalid_datetime\";s:31:\"Invalid date and time supplied.\";s:12:\"invalid_date\";s:29:\"Format daty jest niepoprawny.\";s:12:\"invalid_time\";s:22:\"Invalid time supplied.\";}");
INSERT INTO `wp_postmeta` VALUES("461", "121", "_additional_settings", "");
INSERT INTO `wp_postmeta` VALUES("462", "121", "_locale", "pl_PL");
INSERT INTO `wp_postmeta` VALUES("464", "15", "home_o-nas-tresc", "Body and Brain to połączenie tradycyjnych technik łączenia ciała i umysłu tj. joga, tai chi i medytacja z najnowocześniejszymi technikami wspierania zdrowia czyli Uzdrawianie przez Pępek czy Wibracje Fal Mózgowych.");
INSERT INTO `wp_postmeta` VALUES("466", "15", "home_oferta-tresc", "Na zajęcia zapraszamy codziennie. Uczestnicząc z nami w treningu zbudujesz witalność i odporność, uwolnisz stres i przywrócisz naturalny rytm i równowagę w ciele i umyśle.");
INSERT INTO `wp_postmeta` VALUES("467", "15", "home_spotkanie-tresc", "Aby dołączyć do grupy, umów się na indywidualne spotkanie. W trakcie wizyty dowiesz się, które ćwiczenia najlepiej będą odpowiadały Twoim potrzebom i jak najlepiej skorzystać z oferty.");
INSERT INTO `wp_postmeta` VALUES("471", "124", "_wp_attached_file", "2017/10/ola-mason.jpg");
INSERT INTO `wp_postmeta` VALUES("472", "124", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:300;s:6:\"height\";i:157;s:4:\"file\";s:21:\"2017/10/ola-mason.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"ola-mason-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"ola-mason-300x157.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:157;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("473", "125", "_wp_attached_file", "2017/10/oferta.jpg");
INSERT INTO `wp_postmeta` VALUES("474", "125", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:300;s:6:\"height\";i:157;s:4:\"file\";s:18:\"2017/10/oferta.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"oferta-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"oferta-300x157.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:157;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:16:\"Andres Rodriguez\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("475", "126", "_wp_attached_file", "2017/10/ola-mason-spotkanie.jpg");
INSERT INTO `wp_postmeta` VALUES("476", "126", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:300;s:6:\"height\";i:157;s:4:\"file\";s:31:\"2017/10/ola-mason-spotkanie.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"ola-mason-spotkanie-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"ola-mason-spotkanie-300x157.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:157;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("480", "127", "_wp_attached_file", "2017/10/grafik-1.jpg");
INSERT INTO `wp_postmeta` VALUES("481", "127", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1396;s:6:\"height\";i:583;s:4:\"file\";s:20:\"2017/10/grafik-1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"grafik-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"grafik-1-300x125.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"grafik-1-768x321.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:321;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"grafik-1-1024x428.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:428;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("488", "130", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("489", "130", "_edit_lock", "1510166588:1");
INSERT INTO `wp_postmeta` VALUES("491", "132", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("492", "132", "_edit_lock", "1510166660:1");
INSERT INTO `wp_postmeta` VALUES("497", "130", "_wp_page_template", "page-newsletter.php");
INSERT INTO `wp_postmeta` VALUES("498", "132", "_wp_page_template", "page-newsletter.php");
INSERT INTO `wp_postmeta` VALUES("499", "138", "_wp_attached_file", "2017/10/Alicja-Smialek.jpg");
INSERT INTO `wp_postmeta` VALUES("500", "138", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:340;s:6:\"height\";i:227;s:4:\"file\";s:26:\"2017/10/Alicja-Smialek.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"Alicja-Smialek-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"Alicja-Smialek-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("501", "140", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("502", "140", "_edit_lock", "1510478826:1");
INSERT INTO `wp_postmeta` VALUES("503", "141", "_wp_attached_file", "2017/11/Lila-Golik.jpg");
INSERT INTO `wp_postmeta` VALUES("504", "141", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:165;s:6:\"height\";i:190;s:4:\"file\";s:22:\"2017/11/Lila-Golik.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"Lila-Golik-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("505", "140", "_thumbnail_id", "141");
INSERT INTO `wp_postmeta` VALUES("506", "140", "testimonials_zawod", "Bizneswoman");
INSERT INTO `wp_postmeta` VALUES("507", "140", "testimonials_opinia", "<p>„Trening  Pępka podziałał na mnie uzdrawiająco. Zrozumiałam wiele rzeczy związanych z moim ciałem. Odkryłam wiele blokad, nad którymi muszę teraz pracować. Warsztaty w Body and Brain polecam każdemu, niezależnie od jego chorób i samopoczucia.  Warsztaty Body and Brain mówią, jak w inny niekonwencjonalny sposób uleczyć swoje ciało i duszę. Nauczają o naszym ciele, a właściwie o całej nasze istocie.”</p>\n<p>- Lila Golik, właściciel pensjonatu w Koniakowie <a href=\"http://www.narozcesciu.pl/\">http://www.narozcesciu.pl/</a></p>\n");
INSERT INTO `wp_postmeta` VALUES("508", "140", "testimonials_opinia_krotka", "<p>Trening  Pępka podziałał na mnie uzdrawiająco. Zrozumiałam wiele rzeczy związanych z moim ciałem.</p>\n");
INSERT INTO `wp_postmeta` VALUES("509", "140", "testimonials_home_page", "1");
INSERT INTO `wp_postmeta` VALUES("510", "70", "_oembed_756501452d05603e9c1536aa1764c356", "<blockquote class=\"wp-embedded-content\" data-secret=\"m8DoBTktrH\"><a href=\"http://www.optykrybnik.pl/\">START</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" style=\"position: absolute; clip: rect(1px, 1px, 1px, 1px);\" src=\"http://www.optykrybnik.pl/embed/#?secret=m8DoBTktrH\" data-secret=\"m8DoBTktrH\" width=\"500\" height=\"282\" title=\"&#8222;START&#8221; &#8212; OptykRybnik.pl | Optyk - Optometrysta - Rybnik | okulary, soczewki, badanie wzroku\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>");
INSERT INTO `wp_postmeta` VALUES("511", "70", "_oembed_time_756501452d05603e9c1536aa1764c356", "1510478981");
INSERT INTO `wp_postmeta` VALUES("512", "142", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("513", "142", "_edit_lock", "1510479027:1");
INSERT INTO `wp_postmeta` VALUES("514", "143", "_wp_attached_file", "2017/11/Wojciech-Pieczkowski.jpg");
INSERT INTO `wp_postmeta` VALUES("515", "143", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:281;s:6:\"height\";i:188;s:4:\"file\";s:32:\"2017/11/Wojciech-Pieczkowski.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"Wojciech-Pieczkowski-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("516", "142", "_thumbnail_id", "143");
INSERT INTO `wp_postmeta` VALUES("517", "142", "testimonials_zawod", "Lekarz, Chirurg");
INSERT INTO `wp_postmeta` VALUES("518", "142", "testimonials_opinia", "<p>Bezwarunkowo polecam każdemu. Przeżycie warsztatów Body and Brain czyni człowieka bardziej świadomego swojego człowieczeństwa. To najlepsze warsztaty, w jakich miałem okazję wziąć udział.</p>\n");
INSERT INTO `wp_postmeta` VALUES("519", "142", "testimonials_opinia_krotka", "<p>To najlepsze warsztaty, w jakich miałem okazję wziąć udział.</p>\n");
INSERT INTO `wp_postmeta` VALUES("520", "142", "testimonials_home_page", "1");
INSERT INTO `wp_postmeta` VALUES("521", "144", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("522", "144", "_edit_lock", "1510479125:1");
INSERT INTO `wp_postmeta` VALUES("523", "145", "_wp_attached_file", "2017/11/Elwira-Skutek.jpg");
INSERT INTO `wp_postmeta` VALUES("524", "145", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:250;s:6:\"height\";i:211;s:4:\"file\";s:25:\"2017/11/Elwira-Skutek.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"Elwira-Skutek-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("525", "144", "_thumbnail_id", "145");
INSERT INTO `wp_postmeta` VALUES("526", "144", "testimonials_zawod", "Nauczyciel");
INSERT INTO `wp_postmeta` VALUES("527", "144", "testimonials_opinia", "<p>„Dopiero po treningu Uzdrawiania przez Pępek zdałam sobie sprawę, że czytanie książek bez realnej praktyki tego, co jest w nich zawarte nie daje efektów. Trening Power Brain wypełnia lukę, którą zawsze czułam. Po przeczytaniu innych książek zawsze miałam niedosyt i pytanie: co dalej, jak ja mam to wprowadzić w życie? Teraz nie mam takiego pytania, ponieważ trenując Power Brain wszystko staje się klarowne. Wykorzystuję wiedzę Power Brain w moim życiu osobistym oraz zawodowym jako nauczyciel młodzieży niepełnosprawnej umysłowo”</p>\n<p>- Elwira Skutek, Nauczyciel w Szkole Specjalnej</p>\n");
INSERT INTO `wp_postmeta` VALUES("528", "144", "testimonials_opinia_krotka", "<p>Wykorzystuję cenną wiedzę Power Brain w moim życiu osobistym oraz zawodowym jako nauczyciel młodzieży niepełnosprawnej umysłowo.</p>\n");
INSERT INTO `wp_postmeta` VALUES("529", "144", "testimonials_home_page", "1");
INSERT INTO `wp_postmeta` VALUES("539", "147", "_wp_attached_file", "2017/10/Grafik-listopad.jpg");
INSERT INTO `wp_postmeta` VALUES("540", "147", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2005;s:6:\"height\";i:1140;s:4:\"file\";s:27:\"2017/10/Grafik-listopad.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"Grafik-listopad-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"Grafik-listopad-300x171.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:171;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:27:\"Grafik-listopad-768x437.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:437;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:28:\"Grafik-listopad-1024x582.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:582;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("541", "148", "_wp_attached_file", "2017/10/Grafik-2017-NEW-Jesien.jpg");
INSERT INTO `wp_postmeta` VALUES("542", "148", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1583;s:6:\"height\";i:351;s:4:\"file\";s:34:\"2017/10/Grafik-2017-NEW-Jesien.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"Grafik-2017-NEW-Jesien-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"Grafik-2017-NEW-Jesien-300x67.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:67;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:34:\"Grafik-2017-NEW-Jesien-768x170.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:35:\"Grafik-2017-NEW-Jesien-1024x227.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:227;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("543", "82", "landing_page_page-title", "Masaż Uzdrawiający");
INSERT INTO `wp_postmeta` VALUES("544", "82", "landing_page_page-subtitle", "Nie czekaj na innych. Już teraz daj sobie uwagę i miłość.");
INSERT INTO `wp_postmeta` VALUES("552", "151", "_wp_attached_file", "2017/10/wallpaper-bird-of-the-soul-1600x1200-3.jpg");
INSERT INTO `wp_postmeta` VALUES("553", "151", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1600;s:6:\"height\";i:1200;s:4:\"file\";s:50:\"2017/10/wallpaper-bird-of-the-soul-1600x1200-3.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:50:\"wallpaper-bird-of-the-soul-1600x1200-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:50:\"wallpaper-bird-of-the-soul-1600x1200-3-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:50:\"wallpaper-bird-of-the-soul-1600x1200-3-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:51:\"wallpaper-bird-of-the-soul-1600x1200-3-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("556", "10", "landing_page_date", "<h2>Termin</h2>\n<p>7 - 8 Kwietnia 2018</p>\n<p>&nbsp;</p>\n");
INSERT INTO `wp_postmeta` VALUES("558", "10", "landing_page_place", "<h2>Miejsce</h2>\n<p>Centrum Body and Brain</p>\n<p>Rybnik ul. Sobieskiego 19a</p>\n");
INSERT INTO `wp_postmeta` VALUES("564", "10", "landing_page_price", "<p style=\"text-align: center;\">Shimsung oznacza \"otwórz serce\". Przez dwa dni, krok po kroku, mamy okazję wejść głębiej w swój wewnętrzny świat, aby móc dotrzeć do samego sedna - do swojej duszy i aby móc jej wysłuchać - czego pragnę? jak mam żyć?</p>\n<p style=\"text-align: center;\">Warsztat Shimsung to głębokie doznanie wysokiego poziomu uzdrawiającej energii. Na warsztat zapraszamy każdą osobę, która czuje, że nie jest sobą i która chciałaby poznać siebie lepiej.</p>\n<p style=\"text-align: center;\">Podczas treningu odpowiesz sobie na pytania: kim jestem? czego ja chcę? A także zbudujesz poziom energii wystarczający do realizacji swoich marzeń i planów.</p>\n<p>&nbsp;</p>\n");
INSERT INTO `wp_postmeta` VALUES("566", "10", "landing_page_section-title-2", "Jak będzie wyglądał warsztat?");
INSERT INTO `wp_postmeta` VALUES("572", "152", "_wp_attached_file", "2017/10/DSC_0095.jpg");
INSERT INTO `wp_postmeta` VALUES("573", "152", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:3840;s:6:\"height\";i:2160;s:4:\"file\";s:20:\"2017/10/DSC_0095.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"DSC_0095-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"DSC_0095-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"DSC_0095-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"DSC_0095-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"D6603\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1499530501\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"4.6\";s:3:\"iso\";s:3:\"800\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("574", "153", "_wp_attached_file", "2017/10/1499682662389.jpg");
INSERT INTO `wp_postmeta` VALUES("575", "153", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1962;s:6:\"height\";i:1472;s:4:\"file\";s:25:\"2017/10/1499682662389.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"1499682662389-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"1499682662389-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"1499682662389-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"1499682662389-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("576", "154", "_wp_attached_file", "2017/10/1499682661190.jpg");
INSERT INTO `wp_postmeta` VALUES("577", "154", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1962;s:6:\"height\";i:1472;s:4:\"file\";s:25:\"2017/10/1499682661190.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"1499682661190-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"1499682661190-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"1499682661190-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"1499682661190-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("578", "155", "_wp_attached_file", "2017/10/1499682680823.jpg");
INSERT INTO `wp_postmeta` VALUES("579", "155", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1962;s:6:\"height\";i:1472;s:4:\"file\";s:25:\"2017/10/1499682680823.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"1499682680823-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"1499682680823-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"1499682680823-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"1499682680823-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("580", "156", "_wp_attached_file", "2017/10/1499682676529.jpg");
INSERT INTO `wp_postmeta` VALUES("581", "156", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1962;s:6:\"height\";i:1472;s:4:\"file\";s:25:\"2017/10/1499682676529.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"1499682676529-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"1499682676529-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"1499682676529-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"1499682676529-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("582", "157", "_wp_attached_file", "2017/10/1499682677807.jpg");
INSERT INTO `wp_postmeta` VALUES("583", "157", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1962;s:6:\"height\";i:1472;s:4:\"file\";s:25:\"2017/10/1499682677807.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"1499682677807-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"1499682677807-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"1499682677807-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"1499682677807-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("615", "13", "landing_page_date", "<h2>Termin</h2>\n<p>6 stycznia 2018</p>\n<p>10.00 - 17.00</p>\n");
INSERT INTO `wp_postmeta` VALUES("616", "13", "landing_page_place", "<h2>Miejsce</h2>\n<p>Centrum Body and Brain</p>\n<p>Rybnik ul. Sobieskiego 19a</p>\n");
INSERT INTO `wp_postmeta` VALUES("618", "158", "_wp_attached_file", "2017/10/1499682600946.jpg");
INSERT INTO `wp_postmeta` VALUES("619", "158", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1962;s:6:\"height\";i:1472;s:4:\"file\";s:25:\"2017/10/1499682600946.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"1499682600946-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"1499682600946-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"1499682600946-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"1499682600946-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("620", "90", "landing_page_page-title", "Zajęcia grupowe");
INSERT INTO `wp_postmeta` VALUES("621", "90", "landing_page_page-subtitle", "Liczba miejsc nieograniczona");
INSERT INTO `wp_postmeta` VALUES("623", "159", "_wp_attached_file", "2017/10/maxresdefault.jpg");
INSERT INTO `wp_postmeta` VALUES("624", "159", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:25:\"2017/10/maxresdefault.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"maxresdefault-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"maxresdefault-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"maxresdefault-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"maxresdefault-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("626", "90", "landing_page_section-title-1", "każdego dnia coś innego");
INSERT INTO `wp_postmeta` VALUES("627", "90", "landing_page_date", "<p>Od poniedziałku do czwartku: 10.00, 17.30 i 19.00.</p>\n<p>W piątek o 10:00 i 17:30</p>\n<p><span style=\"text-decoration: underline;\"><strong>Specjalna lekcja dla seniorów w piątek o 12:00</strong></span></p>\n<p>Konieczna rezerwacja miejsca.</p>\n");
INSERT INTO `wp_postmeta` VALUES("628", "90", "landing_page_footer-lp", "<p>tylko u nas!</p>\n");
INSERT INTO `wp_postmeta` VALUES("629", "160", "_wp_attached_file", "2017/10/bluebear_1280_1020.jpg");
INSERT INTO `wp_postmeta` VALUES("630", "160", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:1022;s:4:\"file\";s:30:\"2017/10/bluebear_1280_1020.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"bluebear_1280_1020-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"bluebear_1280_1020-300x240.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:30:\"bluebear_1280_1020-768x613.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:613;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:31:\"bluebear_1280_1020-1024x818.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:818;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.8\";s:6:\"credit\";s:25:\"Sylvie Bouchard - Fotolia\";s:6:\"camera\";s:6:\"C750UZ\";s:7:\"caption\";s:67:\"Close-up of a swimming polar bear underwater looking at the camera.\";s:17:\"created_timestamp\";s:10:\"1074697266\";s:9:\"copyright\";s:25:\"Sylvie Bouchard - Fotolia\";s:12:\"focal_length\";s:3:\"6.3\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:5:\"0.005\";s:5:\"title\";s:30:\"Polar bear underwater close-up\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:1:{i:0;s:64:\"Polar bear, mammal, animal, water, ice, cold, Arctic,swim,moveme\";}}}");
INSERT INTO `wp_postmeta` VALUES("631", "95", "landing_page_page-title", "ZDAJ MATURĘ BEZ STRESU");
INSERT INTO `wp_postmeta` VALUES("632", "95", "landing_page_page-subtitle", "Tylko z nami uda Ci się przejść przez egamin maturalny z pełną koncentracją i wewnętrznym spokojem.");
INSERT INTO `wp_postmeta` VALUES("634", "161", "_wp_attached_file", "2017/10/DSC_1152-1.jpg");
INSERT INTO `wp_postmeta` VALUES("635", "161", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:3840;s:6:\"height\";i:2160;s:4:\"file\";s:22:\"2017/10/DSC_1152-1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"DSC_1152-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"DSC_1152-1-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"DSC_1152-1-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"DSC_1152-1-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"D6603\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1456339334\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"4.6\";s:3:\"iso\";s:3:\"320\";s:13:\"shutter_speed\";s:7:\"0.03125\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"6\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("637", "95", "landing_page_date", "<p>W KAŻDĄ ŚRODĘ o 15.15</p>\n");
INSERT INTO `wp_postmeta` VALUES("638", "95", "landing_page_place", "<p>SZKOŁA RYBNIK</p>\n");
INSERT INTO `wp_postmeta` VALUES("639", "95", "landing_page_teacher", "Pete Mason");
INSERT INTO `wp_postmeta` VALUES("650", "162", "_wp_attached_file", "2017/10/IMG_6288.jpg");
INSERT INTO `wp_postmeta` VALUES("651", "162", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:3264;s:6:\"height\";i:2448;s:4:\"file\";s:20:\"2017/10/IMG_6288.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_6288-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_6288-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"IMG_6288-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"IMG_6288-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:8:\"iPhone 6\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1510482807\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"4.15\";s:3:\"iso\";s:2:\"32\";s:13:\"shutter_speed\";s:18:\"0.0017211703958692\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("656", "163", "_wp_attached_file", "2017/10/DSC_0938.jpg");
INSERT INTO `wp_postmeta` VALUES("657", "163", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:3840;s:6:\"height\";i:2160;s:4:\"file\";s:20:\"2017/10/DSC_0938.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"DSC_0938-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"DSC_0938-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"DSC_0938-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"DSC_0938-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"D6603\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1448129384\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"4.6\";s:3:\"iso\";s:3:\"125\";s:13:\"shutter_speed\";s:7:\"0.03125\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("662", "164", "_wp_attached_file", "2017/10/autumn.jpg");
INSERT INTO `wp_postmeta` VALUES("663", "164", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:659;s:4:\"file\";s:18:\"2017/10/autumn.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"autumn-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"autumn-300x198.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:198;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:18:\"autumn-768x506.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:506;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("664", "165", "_wp_attached_file", "2017/10/3-segmenty.jpg");
INSERT INTO `wp_postmeta` VALUES("665", "165", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1518;s:6:\"height\";i:1022;s:4:\"file\";s:22:\"2017/10/3-segmenty.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"3-segmenty-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"3-segmenty-300x202.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"3-segmenty-768x517.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:517;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"3-segmenty-1024x689.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:689;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("671", "6", "landing_page_column-2", "<p>Wykonując technikę uzdrawiania przez pępek stymulujemy nerw błędny, który jest bezpośrednim połączeniem organów z mózgiem. Masując pępek włączamy tzw. układ przywspółczulny, który reguluje funkcje odpowiadające za trawienie i odpoczynek. Stymulując pępek poprawiamy też czujność i pamięć.</p>\n");
INSERT INTO `wp_postmeta` VALUES("680", "166", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("681", "166", "_edit_lock", "1512386866:1");
INSERT INTO `wp_postmeta` VALUES("682", "166", "_wp_page_template", "template-warsztaty.php");
INSERT INTO `wp_postmeta` VALUES("683", "166", "landing_page_page-title", "Tytuł Warsztatu");
INSERT INTO `wp_postmeta` VALUES("684", "166", "landing_page_page-subtitle", "Krótki opis warsztatu");
INSERT INTO `wp_postmeta` VALUES("686", "166", "landing_page_section-active-1", "1");
INSERT INTO `wp_postmeta` VALUES("687", "166", "landing_page_section-title-1", "Szczegóły warsztatu");
INSERT INTO `wp_postmeta` VALUES("688", "166", "landing_page_date", "<p>kolumna pierwsza<br />\ndata</p>\n");
INSERT INTO `wp_postmeta` VALUES("689", "166", "landing_page_column-2", "<p><img class=\" wp-image-77 aligncenter\" src=\"http://bnb.testuj.website/wp-content/uploads/2017/10/Ola-300x300.jpg\" alt=\"\" width=\"146\" height=\"146\" /></p>\n<p style=\"text-align: center;\">kolumna druga<br />\nProwadzący warsztaty</p>\n");
INSERT INTO `wp_postmeta` VALUES("690", "166", "landing_page_place", "<p>Kolumna trzecia<br />\nadres warsztatów</p>\n");
INSERT INTO `wp_postmeta` VALUES("691", "166", "landing_page_section-active-1a", "1");
INSERT INTO `wp_postmeta` VALUES("692", "166", "landing_page_section-1a-title", "Tytuł sekcji 2");
INSERT INTO `wp_postmeta` VALUES("693", "166", "landing_page_section-1a-desc", "<p>Opis warsztatu</p>\n<ul>\n<li>lorem ipsum</li>\n<li>lorem ipsum</li>\n<li>lorem ipsum</li>\n</ul>\n");
INSERT INTO `wp_postmeta` VALUES("694", "166", "landing_page_section-active-2", "1");
INSERT INTO `wp_postmeta` VALUES("695", "166", "landing_page_section-title-2", "Sekcja z tłem");
INSERT INTO `wp_postmeta` VALUES("696", "166", "landing_page_price", "<p>Lorem ipsum dolor sit amet enim. Etiam ullamcorper. Suspendisse a pellentesque dui, non felis. Maecenas malesuada elit lectus felis, malesuada ultricies. Curabitur et ligula. Ut molestie a, ultricies porta urna. Vestibulum commodo volutpat a, convallis ac, laoreet enim.</p>\n");
INSERT INTO `wp_postmeta` VALUES("698", "166", "landing_page_healinglife", "0");
INSERT INTO `wp_postmeta` VALUES("699", "166", "landing_page_section-2-btn", "Sprawdź szczegóły");
INSERT INTO `wp_postmeta` VALUES("700", "166", "landing_page_section-active-2a", "1");
INSERT INTO `wp_postmeta` VALUES("701", "166", "landing_page_section-2a-title", "Sekcja z trzema polami");
INSERT INTO `wp_postmeta` VALUES("702", "166", "landing_page_section-2a-input-1", "<p>Lorem ipusm 1</p>\n");
INSERT INTO `wp_postmeta` VALUES("703", "166", "landing_page_section-2a-input-2", "<p>Lorem ipusm 2</p>\n");
INSERT INTO `wp_postmeta` VALUES("704", "166", "landing_page_section-2a-input-3", "<p>Lorem ipusm 3</p>\n");
INSERT INTO `wp_postmeta` VALUES("705", "166", "landing_page_slide-title", "a:4:{i:0;s:8:\"slider 1\";i:1;s:8:\"slider 2\";i:2;s:8:\"slider 3\";i:3;s:8:\"slider 4\";}");
INSERT INTO `wp_postmeta` VALUES("706", "166", "landing_page_slide-desc", "a:4:{i:0;s:175:\"Lorem ipsum dolor sit amet enim. Etiam ullamcorper. Suspendisse a pellentesque dui, non felis. Maecenas malesuada elit lectus felis, malesuada ultricies. Curabitur et ligula. \";i:1;s:175:\"Lorem ipsum dolor sit amet enim. Etiam ullamcorper. Suspendisse a pellentesque dui, non felis. Maecenas malesuada elit lectus felis, malesuada ultricies. Curabitur et ligula. \";i:2;s:174:\"Lorem ipsum dolor sit amet enim. Etiam ullamcorper. Suspendisse a pellentesque dui, non felis. Maecenas malesuada elit lectus felis, malesuada ultricies. Curabitur et ligula.\";i:3;s:175:\"Lorem ipsum dolor sit amet enim. Etiam ullamcorper. Suspendisse a pellentesque dui, non felis. Maecenas malesuada elit lectus felis, malesuada ultricies. Curabitur et ligula. \";}");
INSERT INTO `wp_postmeta` VALUES("707", "166", "landing_page_footer-lp", "<h2 style=\"text-align: center;\">Skorzystaj ze specjalnej oferty jesiennej!</h2>\n<h2 style=\"text-align: center;\">Teraz tylko 390 zł netto za 2 godzinne szkolenie!</h2>\n<p style=\"text-align: center;\"><a class=\"btn btn-orange btn-big\" href=\"http://bnb.testuj.website/kontakt\">NAPISZ DO NAS<i class=\"fa fa-angle-right\"></i></a></p>\n<p style=\"text-align: center;\">Umów się ze mną  na spotkanie. Chętnie poznam Twoje potrzeby oraz oczekiwania i przygotuję najlepszy na rynku trening radzenia sobie ze stresem i negatywnymi skutkami wykonywanej pracy.</p>\n<p style=\"text-align: center;\">Telefon 887 362 809</p>\n<p><img class=\"alignnone wp-image-79 size-medium aligncenter\" src=\"http://warsztaty.bodynbrain.pl/wp-content/uploads/2017/06/DSC3814_edytowany-1-200x300.jpg\" alt=\"\" width=\"200\" height=\"300\" /></p>\n");
INSERT INTO `wp_postmeta` VALUES("717", "167", "_wp_attached_file", "2017/11/03_dla_firm_02.jpg");
INSERT INTO `wp_postmeta` VALUES("718", "167", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:576;s:4:\"file\";s:26:\"2017/11/03_dla_firm_02.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"03_dla_firm_02-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"03_dla_firm_02-300x90.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:90;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"03_dla_firm_02-768x230.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:27:\"03_dla_firm_02-1024x307.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:307;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("721", "168", "_wp_attached_file", "2017/11/plama_czakry.png");
INSERT INTO `wp_postmeta` VALUES("722", "168", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:533;s:6:\"height\";i:471;s:4:\"file\";s:24:\"2017/11/plama_czakry.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"plama_czakry-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"plama_czakry-300x265.png\";s:5:\"width\";i:300;s:6:\"height\";i:265;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("725", "169", "_wp_attached_file", "2017/11/bnb.testuj.website_warsztaty_testowy-warsztat_.png");
INSERT INTO `wp_postmeta` VALUES("726", "169", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1836;s:6:\"height\";i:488;s:4:\"file\";s:58:\"2017/11/bnb.testuj.website_warsztaty_testowy-warsztat_.png\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:58:\"bnb.testuj.website_warsztaty_testowy-warsztat_-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:57:\"bnb.testuj.website_warsztaty_testowy-warsztat_-300x80.png\";s:5:\"width\";i:300;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:58:\"bnb.testuj.website_warsztaty_testowy-warsztat_-768x204.png\";s:5:\"width\";i:768;s:6:\"height\";i:204;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:59:\"bnb.testuj.website_warsztaty_testowy-warsztat_-1024x272.png\";s:5:\"width\";i:1024;s:6:\"height\";i:272;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("727", "166", "landing_page_main-img", "164");
INSERT INTO `wp_postmeta` VALUES("728", "166", "landing_page_section-2-bg", "169");
INSERT INTO `wp_postmeta` VALUES("731", "7", "_wp_page_template", "template-warsztaty.php");
INSERT INTO `wp_postmeta` VALUES("732", "7", "landing_page_page-title", "We have fun");
INSERT INTO `wp_postmeta` VALUES("733", "7", "landing_page_main-img", "96");
INSERT INTO `wp_postmeta` VALUES("734", "7", "landing_page_section-active-1", "1");
INSERT INTO `wp_postmeta` VALUES("735", "7", "landing_page_section-title-1", "Exercise");
INSERT INTO `wp_postmeta` VALUES("736", "7", "landing_page_date", "<p>Yes</p>\n");
INSERT INTO `wp_postmeta` VALUES("737", "7", "landing_page_column-2", "<p>we</p>\n");
INSERT INTO `wp_postmeta` VALUES("738", "7", "landing_page_place", "<p>do</p>\n");
INSERT INTO `wp_postmeta` VALUES("739", "7", "landing_page_section-active-1a", "1");
INSERT INTO `wp_postmeta` VALUES("740", "7", "landing_page_section-1a-title", "Exercise");
INSERT INTO `wp_postmeta` VALUES("741", "7", "landing_page_section-1a-desc", "<p>Fit body, fit brain</p>\n");
INSERT INTO `wp_postmeta` VALUES("742", "7", "landing_page_section-active-2", "1");
INSERT INTO `wp_postmeta` VALUES("743", "7", "landing_page_section-title-2", "Controlled Breathing");
INSERT INTO `wp_postmeta` VALUES("744", "7", "landing_page_price", "<p>Breathe out first, pause, breathe in</p>\n");
INSERT INTO `wp_postmeta` VALUES("745", "7", "landing_page_healinglife", "0");
INSERT INTO `wp_postmeta` VALUES("746", "7", "landing_page_section-active-2a", "1");
INSERT INTO `wp_postmeta` VALUES("747", "7", "landing_page_section-2a-title", "Creativity");
INSERT INTO `wp_postmeta` VALUES("748", "7", "landing_page_section-2a-input-1", "<p>Focus</p>\n");
INSERT INTO `wp_postmeta` VALUES("749", "7", "landing_page_section-2a-input-2", "<p>Imagine</p>\n");
INSERT INTO `wp_postmeta` VALUES("750", "7", "landing_page_section-2a-input-3", "<p>Act</p>\n");
INSERT INTO `wp_postmeta` VALUES("751", "7", "landing_page_slide-title", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("752", "7", "landing_page_slide-desc", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("757", "176", "_wp_attached_file", "2017/10/Ilchi-Lee_bbh-book.jpg");
INSERT INTO `wp_postmeta` VALUES("758", "176", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:190;s:6:\"height\";i:250;s:4:\"file\";s:30:\"2017/10/Ilchi-Lee_bbh-book.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"Ilchi-Lee_bbh-book-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("765", "179", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("766", "179", "_wp_trash_meta_time", "1511386131");
INSERT INTO `wp_postmeta` VALUES("767", "181", "_wp_attached_file", "2017/10/DSC_0316.jpg");
INSERT INTO `wp_postmeta` VALUES("768", "181", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1080;s:4:\"file\";s:20:\"2017/10/DSC_0316.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"DSC_0316-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"DSC_0316-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"DSC_0316-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"DSC_0316-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"D6603\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1507886229\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"1.81\";s:3:\"iso\";s:3:\"800\";s:13:\"shutter_speed\";s:5:\"0.125\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("769", "182", "_wp_attached_file", "2017/10/bnbjoga1.jpg");
INSERT INTO `wp_postmeta` VALUES("770", "182", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:180;s:6:\"height\";i:180;s:4:\"file\";s:20:\"2017/10/bnbjoga1.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"bnbjoga1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("783", "183", "_wp_attached_file", "2017/10/spotkanie.jpg");
INSERT INTO `wp_postmeta` VALUES("784", "183", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:700;s:6:\"height\";i:420;s:4:\"file\";s:21:\"2017/10/spotkanie.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"spotkanie-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"spotkanie-300x180.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("789", "184", "_wp_attached_file", "2017/10/free-body-brain-yoga-belly-button-healing-19.png");
INSERT INTO `wp_postmeta` VALUES("790", "184", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"file\";s:56:\"2017/10/free-body-brain-yoga-belly-button-healing-19.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:56:\"free-body-brain-yoga-belly-button-healing-19-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:56:\"free-body-brain-yoga-belly-button-healing-19-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("795", "185", "_wp_attached_file", "2017/10/free-body-brain-yoga-belly-button-healing-19-1.png");
INSERT INTO `wp_postmeta` VALUES("796", "185", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:268;s:4:\"file\";s:58:\"2017/10/free-body-brain-yoga-belly-button-healing-19-1.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:58:\"free-body-brain-yoga-belly-button-healing-19-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:58:\"free-body-brain-yoga-belly-button-healing-19-1-300x161.png\";s:5:\"width\";i:300;s:6:\"height\";i:161;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("801", "186", "_wp_attached_file", "2017/10/free-body-brain-yoga-belly-button-healing-19-2.png");
INSERT INTO `wp_postmeta` VALUES("802", "186", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:250;s:6:\"height\";i:134;s:4:\"file\";s:58:\"2017/10/free-body-brain-yoga-belly-button-healing-19-2.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:58:\"free-body-brain-yoga-belly-button-healing-19-2-150x134.png\";s:5:\"width\";i:150;s:6:\"height\";i:134;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("807", "187", "_wp_attached_file", "2017/10/spotkanie.jpg2_.jpg");
INSERT INTO `wp_postmeta` VALUES("808", "187", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:250;s:6:\"height\";i:250;s:4:\"file\";s:27:\"2017/10/spotkanie.jpg2_.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"spotkanie.jpg2_-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("813", "15", "home_o-nas-zdjecie", "182");
INSERT INTO `wp_postmeta` VALUES("814", "15", "home_oferta-zdjecie", "186");
INSERT INTO `wp_postmeta` VALUES("815", "15", "home_oferta-grafik", "148");
INSERT INTO `wp_postmeta` VALUES("816", "15", "home_spotkanie-zdjecie", "187");
INSERT INTO `wp_postmeta` VALUES("823", "188", "_wp_attached_file", "2017/10/drugi-mózg.jpg");
INSERT INTO `wp_postmeta` VALUES("824", "188", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:302;s:6:\"height\";i:167;s:4:\"file\";s:23:\"2017/10/drugi-mózg.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"drugi-mózg-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"drugi-mózg-300x166.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:166;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("827", "189", "_wp_attached_file", "2017/10/THIRD-EYE-BBH.jpg");
INSERT INTO `wp_postmeta` VALUES("828", "189", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:800;s:6:\"height\";i:389;s:4:\"file\";s:25:\"2017/10/THIRD-EYE-BBH.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"THIRD-EYE-BBH-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"THIRD-EYE-BBH-300x146.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"THIRD-EYE-BBH-768x373.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:373;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("831", "190", "_wp_attached_file", "2017/10/IMG_5436-e1511441932781.jpg");
INSERT INTO `wp_postmeta` VALUES("832", "190", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:917;s:4:\"file\";s:35:\"2017/10/IMG_5436-e1511441932781.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_5436-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_5436-300x275.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:275;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"IMG_5436-768x704.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:704;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"IMG_5436-1024x939.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:939;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"1.8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:12:\"Canon EOS 5D\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1468089907\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"85\";s:3:\"iso\";s:3:\"320\";s:13:\"shutter_speed\";s:6:\"0.0008\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("833", "191", "_wp_attached_file", "2017/10/IMG_5436-1-e1511441959567.jpg");
INSERT INTO `wp_postmeta` VALUES("836", "190", "_wp_attachment_backup_sizes", "a:3:{s:9:\"full-orig\";a:3:{s:5:\"width\";i:3176;s:6:\"height\";i:2912;s:4:\"file\";s:12:\"IMG_5436.jpg\";}s:18:\"full-1511441901357\";a:3:{s:5:\"width\";i:1900;s:6:\"height\";i:1742;s:4:\"file\";s:27:\"IMG_5436-e1511441858407.jpg\";}s:18:\"full-1511441932781\";a:3:{s:5:\"width\";i:1000;s:6:\"height\";i:917;s:4:\"file\";s:27:\"IMG_5436-e1511441901357.jpg\";}}");
INSERT INTO `wp_postmeta` VALUES("837", "191", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1500;s:6:\"height\";i:1375;s:4:\"file\";s:37:\"2017/10/IMG_5436-1-e1511441959567.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"IMG_5436-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"IMG_5436-1-300x275.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:275;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"IMG_5436-1-768x704.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:704;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"IMG_5436-1-1024x939.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:939;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"1.8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:12:\"Canon EOS 5D\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1468089907\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"85\";s:3:\"iso\";s:3:\"320\";s:13:\"shutter_speed\";s:6:\"0.0008\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("842", "191", "_wp_attachment_backup_sizes", "a:1:{s:9:\"full-orig\";a:3:{s:5:\"width\";i:3176;s:6:\"height\";i:2912;s:4:\"file\";s:14:\"IMG_5436-1.jpg\";}}");
INSERT INTO `wp_postmeta` VALUES("853", "193", "_wp_attached_file", "2017/10/DSC_0392.jpg");
INSERT INTO `wp_postmeta` VALUES("854", "193", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:3840;s:6:\"height\";i:2160;s:4:\"file\";s:20:\"2017/10/DSC_0392.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"DSC_0392-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"DSC_0392-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"DSC_0392-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"DSC_0392-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"D6603\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1511281427\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"4.6\";s:3:\"iso\";s:4:\"1250\";s:13:\"shutter_speed\";s:6:\"0.0625\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("883", "194", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("884", "194", "_wp_trash_meta_time", "1511515379");
INSERT INTO `wp_postmeta` VALUES("885", "197", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("886", "197", "_edit_lock", "1511515766:1");
INSERT INTO `wp_postmeta` VALUES("887", "197", "_wp_trash_meta_status", "draft");
INSERT INTO `wp_postmeta` VALUES("888", "197", "_wp_trash_meta_time", "1511515890");
INSERT INTO `wp_postmeta` VALUES("889", "197", "_wp_desired_post_slug", "");
INSERT INTO `wp_postmeta` VALUES("890", "199", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("891", "199", "_edit_lock", "1512391664:1");
INSERT INTO `wp_postmeta` VALUES("892", "199", "_wp_page_template", "template-dla-firm.php");
INSERT INTO `wp_postmeta` VALUES("893", "199", "landing_page_page-title", "Body & Brain Polska");
INSERT INTO `wp_postmeta` VALUES("894", "199", "landing_page_page-subtitle", "Wypełnia Nas Radość Dzielenia Się ");
INSERT INTO `wp_postmeta` VALUES("895", "199", "landing_page_section-active-1", "1");
INSERT INTO `wp_postmeta` VALUES("896", "199", "landing_page_section-title-1", "Nasza Misja i Wizja");
INSERT INTO `wp_postmeta` VALUES("897", "199", "landing_page_date", "<p>W każdym z nas drzemie nieograniczony potencjał. Każdy człowiek, bez względu na wiek czy możliwości fizyczne, ma dostęp do mocy tworzenia, kreacji i przywracania swojego naturalnego stanu, jakim jest zdrowie, radość i spełnienie.</p>\n");
INSERT INTO `wp_postmeta` VALUES("898", "199", "landing_page_section-active-1a", "1");
INSERT INTO `wp_postmeta` VALUES("899", "199", "landing_page_section-1a-title", "Założyciel");
INSERT INTO `wp_postmeta` VALUES("900", "199", "landing_page_section-1a-desc", "<p style=\"text-align: center;\">Założycielem Body and Brain, jak i twórcą techniki Uzdrawiania przez Pępek jest Ilchi Lee. Z pochodzenia Koreańczyk, znany na całym świecie autor ponad 4o książek z tematyki uzdrawiania ciała i umysłu. Ilchi Lee przez 37 lat swojego życia stworzył liczne metody treningowe, które polecane są przez największe autorytety np. Dr Emeran Mayer, Dr Emanuel Pastreich czy Don Miguel Ruiz. Więcej na temat samego Ilchi Lee: <a href=\"http://www.ilchi.com\">www.ilchi.com</a></p>\n<p><img class=\" wp-image-176 aligncenter\" src=\"http://bnb.testuj.website/wp-content/uploads/2017/10/Ilchi-Lee_bbh-book.jpg\" alt=\"\" width=\"128\" height=\"168\" /></p>\n");
INSERT INTO `wp_postmeta` VALUES("901", "199", "landing_page_section-active-2", "0");
INSERT INTO `wp_postmeta` VALUES("902", "199", "landing_page_healinglife", "0");
INSERT INTO `wp_postmeta` VALUES("903", "199", "landing_page_section-active-2a", "1");
INSERT INTO `wp_postmeta` VALUES("904", "199", "landing_page_section-2a-title", "Poznaj zespół");
INSERT INTO `wp_postmeta` VALUES("905", "199", "landing_page_section-2a-input-1", "<p style=\"text-align: center;\"><img class=\"wp-image-223 aligncenter\" src=\"http://bnb.testuj.website/wp-content/uploads/2017/11/DSC_0333-—-kopia-300x243.jpg\" alt=\"\" width=\"91\" height=\"74\" /><strong>Ola Mason</strong><br />\nMoim poczuciem spełnienia jest widok uśmiechniętych i pełnych energii ludzi, którzy po spotkaniu ze mną wracają do domu, aby dzielić się dobrymi wibracjami z innymi.</p>\n");
INSERT INTO `wp_postmeta` VALUES("906", "199", "landing_page_section-2a-input-2", "<p style=\"text-align: center;\"><img class=\"wp-image-224 aligncenter\" src=\"http://bnb.testuj.website/wp-content/uploads/2017/11/DSC_0334-—-kopia-300x242.jpg\" alt=\"\" width=\"91\" height=\"74\" /><strong>Pete Mason<br />\n</strong>Prowadzenie treningu Qi Gong i  sesji coachingowych to moja największa pasja. Współpraca ze mną to także odblokowanie i usprawnianie języka angielskiego.</p>\n<p>&nbsp;</p>\n");
INSERT INTO `wp_postmeta` VALUES("907", "199", "landing_page_section-2a-input-3", "<p style=\"text-align: center;\"><img class=\"wp-image-225 aligncenter\" src=\"http://bnb.testuj.website/wp-content/uploads/2017/11/DSC_0316-—-kopia-220x300.jpg\" alt=\"\" width=\"60\" height=\"82\" /><strong>Lila Golik<br />\n</strong>Moją wizją jest żyć długo będąc zdrowa i pełna sił. Prowadzenie zajęć w Centrum Body and Brain jest moim najlepszym treningiem dla ciała i umysłu.</p>\n<p>&nbsp;</p>\n");
INSERT INTO `wp_postmeta` VALUES("908", "199", "landing_page_slide-title", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("909", "199", "landing_page_slide-desc", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("910", "199", "landing_page_column-2", "<p>Naszą rolą jest pomoc i wspieranie każdej osoby, która do nas się zgłosi. Naszym celem jest edukacja, w jaki sposób samemu można kreować swoje życiowe warunki, bez względu na otoczenie. Pomagamy pokonywać limity, które stoją na drodze do szczęścia i spełnienia.</p>\n");
INSERT INTO `wp_postmeta` VALUES("911", "199", "landing_page_place", "<p>Pragniemy, aby energia, która nas otacza i krąży w każdym z nas była czysta i pozytywna. Dlatego każdego dnia prężnie i aktywnie trenujemy, podnosimy swoje kwalifikacje i poziom energii. Nasze motto: \"Aby móc pomagać innym, najpierw trzeba pokonać swoje limity\".</p>\n");
INSERT INTO `wp_postmeta` VALUES("912", "199", "landing_page_footer-lp", "<p>Witajcie w naszym Centrum. Czekamy na Ciebie.</p>\n");
INSERT INTO `wp_postmeta` VALUES("913", "199", "landing_page_section-title-2", "O nas");
INSERT INTO `wp_postmeta` VALUES("914", "199", "landing_page_price", "<p>Nasze Centrum Body and Brain w Rybniku to miejsce, gdzie można odkryć niezwykły potencjał, jaki znajduje się w każdym z nas. Oferujemy jogę dla ciała i mózgu, lekcje ki gong, osobiste uzdrawianie i coaching oraz warsztaty rozwojowe. Wszystkie zostały zaprojektowane tak, aby każdy uczestnik mógł nie tylko odczuć poprawę kondycji psycho-fizycznej, ale aby mógł także odkryć w sobie moc do kreowania swojego zdrowia, szczęścia i spokoju.</p>\n");
INSERT INTO `wp_postmeta` VALUES("933", "82", "landing_page_section-title-2", "Method");
INSERT INTO `wp_postmeta` VALUES("934", "82", "landing_page_price", "<h2 style=\"text-align: center;\">Hwal Gong tłumaczy się na \"dawanie miłości\".</h2>\n<h2 style=\"text-align: center;\">Ten relaksujący masaż wykorzystuje tradycyjny masaż połączony z akupresurą i technikami wibracji z naszej praktyki.</h2>\n<h2 style=\"text-align: center;\">Idealny prezent dla kogoś, kogo kochasz.</h2>\n");
INSERT INTO `wp_postmeta` VALUES("942", "82", "landing_page_date", "<p>Daily</p>\n");
INSERT INTO `wp_postmeta` VALUES("943", "82", "landing_page_column-2", "<p>Ola and Pete</p>\n");
INSERT INTO `wp_postmeta` VALUES("944", "82", "landing_page_place", "<p>Body and brain centre of natural health</p>\n");
INSERT INTO `wp_postmeta` VALUES("951", "95", "landing_page_main-img", "160");
INSERT INTO `wp_postmeta` VALUES("952", "95", "landing_page_teacher-img", "161");
INSERT INTO `wp_postmeta` VALUES("962", "2", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("963", "2", "_wp_trash_meta_time", "1511521508");
INSERT INTO `wp_postmeta` VALUES("964", "2", "_wp_desired_post_slug", "sample-page");
INSERT INTO `wp_postmeta` VALUES("965", "114", "_edit_lock", "1511521415:1");
INSERT INTO `wp_postmeta` VALUES("966", "90", "landing_page_main-img", "158");
INSERT INTO `wp_postmeta` VALUES("967", "90", "landing_page_column-2", "<h2 style=\"text-align: center;\"><strong>Aleksandra Wonja Nim</strong></h2>\n<h2 style=\"text-align: center;\"><strong>Pete Nim</strong></h2>\n<h2 style=\"text-align: center;\"><strong>Lila Healer Nim</strong></h2>\n");
INSERT INTO `wp_postmeta` VALUES("968", "90", "landing_page_place", "<h2 style=\"text-align: center;\">Zwykłe lekcje odbywają się w</h2>\n<h2 style=\"text-align: center;\">Centrum Body &amp; Brain</h2>\n<p>&nbsp;</p>\n");
INSERT INTO `wp_postmeta` VALUES("969", "90", "landing_page_section-title-2", "Co dają ci nasze lekcje?");
INSERT INTO `wp_postmeta` VALUES("970", "90", "landing_page_price", "<h2 style=\"text-align: center;\">Równowaga ciała i umysłu</h2>\n<h2 style=\"text-align: center;\">Radość z dzielenia się miłością</h2>\n<h2 style=\"text-align: center;\">Głęboki oddech, dotleniony mózg</h2>\n<p>&nbsp;</p>\n");
INSERT INTO `wp_postmeta` VALUES("978", "82", "landing_page_main-img", "12");
INSERT INTO `wp_postmeta` VALUES("979", "82", "gallery_galeria", "88");
INSERT INTO `wp_postmeta` VALUES("980", "82", "gallery_galeria", "83");
INSERT INTO `wp_postmeta` VALUES("981", "82", "gallery_galeria", "84");
INSERT INTO `wp_postmeta` VALUES("982", "82", "gallery_galeria", "85");
INSERT INTO `wp_postmeta` VALUES("983", "82", "gallery_galeria", "86");
INSERT INTO `wp_postmeta` VALUES("984", "82", "gallery_galeria", "87");
INSERT INTO `wp_postmeta` VALUES("985", "207", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("986", "207", "_edit_lock", "1513091212:1");
INSERT INTO `wp_postmeta` VALUES("987", "208", "_wp_attached_file", "2017/11/Powerful-Brain-e1511524663748.jpg");
INSERT INTO `wp_postmeta` VALUES("988", "208", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:259;s:6:\"height\";i:194;s:4:\"file\";s:41:\"2017/11/Powerful-Brain-e1511524663748.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"Powerful-Brain-e1511524663748-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("989", "207", "_wp_page_template", "template-warsztaty.php");
INSERT INTO `wp_postmeta` VALUES("990", "207", "landing_page_page-title", "Trening Zarządzania");
INSERT INTO `wp_postmeta` VALUES("991", "207", "landing_page_page-subtitle", "Zostań mistrzem swoich myśli, emocji i ciała.");
INSERT INTO `wp_postmeta` VALUES("993", "207", "landing_page_section-active-1", "1");
INSERT INTO `wp_postmeta` VALUES("994", "207", "landing_page_section-title-1", "Najbliższy warsztat");
INSERT INTO `wp_postmeta` VALUES("995", "207", "landing_page_date", "<h2>Termin</h2>\n<p>Druga połowa 2018 roku.</p>\n<p>Warsztat trwa 6 dni.</p>\n");
INSERT INTO `wp_postmeta` VALUES("996", "207", "landing_page_column-2", "<h2>Cena</h2>\n<p>3 900 zł</p>\n");
INSERT INTO `wp_postmeta` VALUES("997", "207", "landing_page_place", "<h2>Miejsce</h2>\n<p>Centrum Body and Brain</p>\n<p>Rybnik ul. Sobieskiego 19 a</p>\n");
INSERT INTO `wp_postmeta` VALUES("998", "207", "landing_page_section-active-1a", "1");
INSERT INTO `wp_postmeta` VALUES("999", "207", "landing_page_section-active-2", "1");
INSERT INTO `wp_postmeta` VALUES("1000", "207", "landing_page_section-title-2", "Na czym polega Trening Zarządzania");
INSERT INTO `wp_postmeta` VALUES("1001", "207", "landing_page_price", "<p style=\"text-align: center;\">Warsztat Zarządzania to nauka i doświadczenie, jak działa ludzki mózg i jak można wykorzystać jego największy potencjał.</p>\n<p style=\"text-align: center;\">W trakcie warsztatu dowiesz się, jak zostać mistrzem swoich myśli i emocji. Przez 6 dni treningu będziesz doświadczał swojej wewnętrznej przemiany i rozbudzeń. Poznasz swoje wewnętrzne blokady i pasożyty i będziesz miał okazję je wszystkie usunąć, aby stać się jeszcze bardziej aktywnym i pozytywnym.</p>\n<p style=\"text-align: center;\">Trening Zarządzania Mózgiem to głębokie duchowe i energetyczne doznanie.<br />\nWarsztat ten odbywa się u nas tylko 1 raz w roku. W tym celu zapraszamy do nas niesamowitą osobę - trenera światowej klasy z ponad 20 - letnim doświadczeniem jako duchowy coach - Dahn Sa Nim.</p>\n<p>&nbsp;</p>\n");
INSERT INTO `wp_postmeta` VALUES("1002", "207", "landing_page_healinglife", "0");
INSERT INTO `wp_postmeta` VALUES("1003", "207", "landing_page_section-active-2a", "1");
INSERT INTO `wp_postmeta` VALUES("1004", "207", "landing_page_slide-title", "a:3:{i:0;s:24:\"Jak działa ludzki mózg\";i:1;s:29:\"Jak zarządzać swoim życiem\";i:2;s:26:\"Jak dzielić się z innymi\";}");
INSERT INTO `wp_postmeta` VALUES("1005", "207", "landing_page_slide-desc", "a:3:{i:0;s:130:\"Ludzki mózg cały czas kryje w sobie tajemnice. Podczas warsztatu dowiesz się, czym jest i jak działa System Operacyjny Mózgu.\";i:1;s:119:\"Na warsztacie poznasz 3 zasady zdrowia i jak wprowadzić je w swoje życie, a także poznasz 5 kroków edukacji mózgu.\";i:2;s:159:\"Po warsztacie otrzymasz uprawnienia do prowadzenia zajęć Body and Brain. W trakcie warsztatu nauczysz się, jak dzielić się metodami i technikami z innymi.\";}");
INSERT INTO `wp_postmeta` VALUES("1006", "207", "landing_page_footer-lp", "<p style=\"text-align: center;\"><strong>Aby wziąć udział w Warsztacie Zarządzanie Mózgiem należy najpierw ukończyć dwa podstawowe warsztaty tj. Uzdrawianie przez Pępek oraz Shimsung.</strong></p>\n<p>&nbsp;</p>\n<p style=\"text-align: center;\">Więcej informacji udziela Ola Mason tel. 887 362 809</p>\n");
INSERT INTO `wp_postmeta` VALUES("1008", "210", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1009", "210", "_menu_item_menu_item_parent", "58");
INSERT INTO `wp_postmeta` VALUES("1010", "210", "_menu_item_object_id", "207");
INSERT INTO `wp_postmeta` VALUES("1011", "210", "_menu_item_object", "warsztaty");
INSERT INTO `wp_postmeta` VALUES("1012", "210", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1013", "210", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1014", "210", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1015", "210", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1019", "208", "_wp_attachment_backup_sizes", "a:2:{s:9:\"full-orig\";a:3:{s:5:\"width\";i:259;s:6:\"height\";i:194;s:4:\"file\";s:18:\"Powerful-Brain.jpg\";}s:14:\"thumbnail-orig\";a:4:{s:4:\"file\";s:26:\"Powerful-Brain-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}");
INSERT INTO `wp_postmeta` VALUES("1022", "214", "_wp_attached_file", "2017/11/Powerful-Brain-1.jpg");
INSERT INTO `wp_postmeta` VALUES("1023", "214", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:259;s:6:\"height\";i:194;s:4:\"file\";s:28:\"2017/11/Powerful-Brain-1.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"Powerful-Brain-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1028", "217", "_wp_attached_file", "2017/11/creative-brain.jpg");
INSERT INTO `wp_postmeta` VALUES("1029", "217", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:259;s:6:\"height\";i:194;s:4:\"file\";s:26:\"2017/11/creative-brain.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"creative-brain-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1031", "218", "_wp_attached_file", "2017/11/ECO-World.jpg");
INSERT INTO `wp_postmeta` VALUES("1032", "218", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:300;s:6:\"height\";i:240;s:4:\"file\";s:21:\"2017/11/ECO-World.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"ECO-World-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"ECO-World-300x240.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1037", "220", "_wp_attached_file", "2017/11/love-earth-korten.jpg");
INSERT INTO `wp_postmeta` VALUES("1038", "220", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:955;s:6:\"height\";i:500;s:4:\"file\";s:29:\"2017/11/love-earth-korten.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:29:\"love-earth-korten-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:29:\"love-earth-korten-300x157.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:157;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:29:\"love-earth-korten-768x402.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:402;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1040", "221", "_wp_attached_file", "2017/11/Butterfly_.jpg");
INSERT INTO `wp_postmeta` VALUES("1041", "221", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:768;s:4:\"file\";s:22:\"2017/11/Butterfly_.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"Butterfly_-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"Butterfly_-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"Butterfly_-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"Butterfly_-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1067", "222", "_wp_attached_file", "2017/11/DSC_0332-e1511532648979.jpg");
INSERT INTO `wp_postmeta` VALUES("1068", "222", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:1920;s:4:\"file\";s:35:\"2017/11/DSC_0332-e1511532648979.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:35:\"DSC_0332-e1511532648979-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:35:\"DSC_0332-e1511532648979-169x300.jpg\";s:5:\"width\";i:169;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:36:\"DSC_0332-e1511532648979-768x1365.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1365;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:36:\"DSC_0332-e1511532648979-576x1024.jpg\";s:5:\"width\";i:576;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"D6603\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1510151227\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"1.81\";s:3:\"iso\";s:4:\"1600\";s:13:\"shutter_speed\";s:5:\"0.125\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"8\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1069", "222", "_wp_attachment_backup_sizes", "a:5:{s:9:\"full-orig\";a:3:{s:5:\"width\";i:1920;s:6:\"height\";i:1080;s:4:\"file\";s:12:\"DSC_0332.jpg\";}s:14:\"thumbnail-orig\";a:4:{s:4:\"file\";s:20:\"DSC_0332-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"medium-orig\";a:4:{s:4:\"file\";s:20:\"DSC_0332-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:17:\"medium_large-orig\";a:4:{s:4:\"file\";s:20:\"DSC_0332-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"large-orig\";a:4:{s:4:\"file\";s:21:\"DSC_0332-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}}");
INSERT INTO `wp_postmeta` VALUES("1071", "223", "_wp_attached_file", "2017/11/DSC_0333-—-kopia-e1511533353204.jpg");
INSERT INTO `wp_postmeta` VALUES("1072", "223", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:405;s:4:\"file\";s:45:\"2017/11/DSC_0333-—-kopia-e1511533353204.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"DSC_0333-—-kopia-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"DSC_0333-—-kopia-300x243.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:243;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:30:\"DSC_0333-—-kopia-768x622.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:622;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:31:\"DSC_0333-—-kopia-1024x830.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:830;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"D6603\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1510151268\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"1.81\";s:3:\"iso\";s:4:\"1600\";s:13:\"shutter_speed\";s:5:\"0.125\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1078", "223", "_wp_attachment_backup_sizes", "a:1:{s:9:\"full-orig\";a:3:{s:5:\"width\";i:1038;s:6:\"height\";i:841;s:4:\"file\";s:22:\"DSC_0333-—-kopia.jpg\";}}");
INSERT INTO `wp_postmeta` VALUES("1084", "224", "_wp_attached_file", "2017/11/DSC_0334-—-kopia.jpg");
INSERT INTO `wp_postmeta` VALUES("1085", "224", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:905;s:6:\"height\";i:729;s:4:\"file\";s:30:\"2017/11/DSC_0334-—-kopia.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"DSC_0334-—-kopia-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"DSC_0334-—-kopia-300x242.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:242;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:30:\"DSC_0334-—-kopia-768x619.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:619;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"D6603\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1510220859\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"4.6\";s:3:\"iso\";s:3:\"160\";s:13:\"shutter_speed\";s:7:\"0.03125\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1089", "225", "_wp_attached_file", "2017/11/DSC_0316-—-kopia.jpg");
INSERT INTO `wp_postmeta` VALUES("1090", "225", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:561;s:6:\"height\";i:765;s:4:\"file\";s:30:\"2017/11/DSC_0316-—-kopia.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"DSC_0316-—-kopia-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"DSC_0316-—-kopia-220x300.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"D6603\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1507886229\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"1.81\";s:3:\"iso\";s:3:\"800\";s:13:\"shutter_speed\";s:5:\"0.125\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1095", "199", "landing_page_main-img", "221");
INSERT INTO `wp_postmeta` VALUES("1096", "228", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1097", "228", "_edit_lock", "1513072479:1");
INSERT INTO `wp_postmeta` VALUES("1098", "228", "_wp_page_template", "template-o-nas.php");
INSERT INTO `wp_postmeta` VALUES("1099", "228", "landing_page_page-title", "Body & Brain Polska");
INSERT INTO `wp_postmeta` VALUES("1100", "228", "landing_page_page-subtitle", "Wypełnia Nas Radość Dzielenia Się ");
INSERT INTO `wp_postmeta` VALUES("1102", "228", "landing_page_section-active-1", "1");
INSERT INTO `wp_postmeta` VALUES("1104", "228", "landing_page_date", "<p>W każdym z nas drzemie nieograniczony potencjał. Każdy człowiek, bez względu na wiek czy możliwości fizyczne, ma dostęp do mocy tworzenia, kreacji i przywracania swojego naturalnego stanu, jakim jest zdrowie, radość i spełnienie.</p>\n");
INSERT INTO `wp_postmeta` VALUES("1105", "228", "landing_page_column-2", "<p>Naszą rolą jest pomoc i wspieranie każdej osoby, która do nas się zgłosi. Naszym celem jest edukacja, w jaki sposób samemu można kreować swoje życiowe warunki, bez względu na otoczenie. Pomagamy pokonywać limity, które stoją na drodze do szczęścia i spełnienia.</p>\n");
INSERT INTO `wp_postmeta` VALUES("1106", "228", "landing_page_place", "<p>Pragniemy, aby energia, która nas otacza i krąży w każdym z nas była czysta i pozytywna. Dlatego każdego dnia prężnie i aktywnie trenujemy, podnosimy swoje kwalifikacje i poziom energii. Nasze motto: \"Aby móc pomagać innym, najpierw trzeba pokonać swoje limity\".</p>\n");
INSERT INTO `wp_postmeta` VALUES("1107", "228", "landing_page_section-active-1a", "1");
INSERT INTO `wp_postmeta` VALUES("1108", "228", "landing_page_section-1a-title", "Założyciel");
INSERT INTO `wp_postmeta` VALUES("1109", "228", "landing_page_section-1a-desc", "<p style=\"text-align: center;\">Założycielem Body and Brain, jak i twórcą techniki Uzdrawiania przez Pępek jest Ilchi Lee. Z pochodzenia Koreańczyk, znany na całym świecie autor ponad 4o książek z tematyki uzdrawiania ciała i umysłu. Ilchi Lee przez 37 lat swojego życia stworzył liczne metody treningowe, które polecane są przez największe autorytety np. Dr Emeran Mayer, Dr Emanuel Pastreich czy Don Miguel Ruiz. Więcej na temat samego Ilchi Lee: <a href=\"http://www.ilchi.com\">www.ilchi.com</a></p>\n<p><img class=\" wp-image-176 aligncenter\" src=\"http://bnb.testuj.website/wp-content/uploads/2017/10/Ilchi-Lee_bbh-book.jpg\" alt=\"\" width=\"128\" height=\"168\" /></p>\n");
INSERT INTO `wp_postmeta` VALUES("1110", "228", "landing_page_section-active-2", "1");
INSERT INTO `wp_postmeta` VALUES("1111", "228", "landing_page_section-title-2", "O nas");
INSERT INTO `wp_postmeta` VALUES("1112", "228", "landing_page_price", "<p>Nasze Centrum Body and Brain w Rybniku to miejsce, gdzie można odkryć niezwykły potencjał, jaki znajduje się w każdym z nas. Oferujemy jogę dla ciała i mózgu, lekcje ki gong, osobiste uzdrawianie i coaching oraz warsztaty rozwojowe. Wszystkie zostały zaprojektowane tak, aby każdy uczestnik mógł nie tylko odczuć poprawę kondycji psycho-fizycznej, ale aby mógł także odkryć w sobie moc do kreowania swojego zdrowia, szczęścia i spokoju.</p>\n");
INSERT INTO `wp_postmeta` VALUES("1113", "228", "landing_page_healinglife", "0");
INSERT INTO `wp_postmeta` VALUES("1114", "228", "landing_page_section-active-2a", "1");
INSERT INTO `wp_postmeta` VALUES("1115", "228", "landing_page_section-2a-title", "Poznaj zespół");
INSERT INTO `wp_postmeta` VALUES("1116", "228", "landing_page_section-2a-input-1", "<p style=\"text-align: center;\"><img class=\"wp-image-223 aligncenter\" src=\"http://bnb.testuj.website/wp-content/uploads/2017/11/DSC_0333-—-kopia-300x243.jpg\" alt=\"\" width=\"91\" height=\"74\" /><strong>Ola Mason</strong><br />\nMoim poczuciem spełnienia jest widok uśmiechniętych i pełnych energii ludzi, którzy po spotkaniu ze mną wracają do domu, aby dzielić się dobrymi wibracjami z innymi.</p>\n");
INSERT INTO `wp_postmeta` VALUES("1117", "228", "landing_page_section-2a-input-2", "<p style=\"text-align: center;\"><img class=\"wp-image-224 aligncenter\" src=\"http://bnb.testuj.website/wp-content/uploads/2017/11/DSC_0334-—-kopia-300x242.jpg\" alt=\"\" width=\"91\" height=\"74\" /><strong>Pete Mason<br />\n</strong>Prowadzenie treningu Qi Gong i  sesji coachingowych to moja największa pasja. Współpraca ze mną to także odblokowanie i usprawnianie języka angielskiego.</p>\n");
INSERT INTO `wp_postmeta` VALUES("1118", "228", "landing_page_section-2a-input-3", "<p style=\"text-align: center;\"><img class=\"wp-image-225 aligncenter\" src=\"http://bnb.testuj.website/wp-content/uploads/2017/11/DSC_0316-—-kopia-220x300.jpg\" alt=\"\" width=\"60\" height=\"82\" /><strong>Lila Golik<br />\n</strong>Moją wizją jest żyć długo będąc zdrowa i pełna sił. Prowadzenie zajęć w Centrum Body and Brain jest moim najlepszym treningiem dla ciała i umysłu.</p>\n");
INSERT INTO `wp_postmeta` VALUES("1119", "228", "landing_page_slide-title", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("1120", "228", "landing_page_slide-desc", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("1121", "228", "landing_page_footer-lp", "<p>Witajcie w naszym Centrum. Czekamy na Ciebie.</p>\n");
INSERT INTO `wp_postmeta` VALUES("1123", "228", "landing_page_main-img", "221");
INSERT INTO `wp_postmeta` VALUES("1127", "231", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1128", "231", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1129", "231", "_menu_item_object_id", "228");
INSERT INTO `wp_postmeta` VALUES("1130", "231", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1131", "231", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1132", "231", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1133", "231", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1134", "231", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1136", "7", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("1137", "7", "_wp_trash_meta_time", "1512384728");
INSERT INTO `wp_postmeta` VALUES("1138", "7", "_wp_desired_post_slug", "power-brain-kids");
INSERT INTO `wp_postmeta` VALUES("1148", "233", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1149", "233", "_edit_lock", "1512386191:1");
INSERT INTO `wp_postmeta` VALUES("1150", "233", "_wp_page_template", "template-o-nas.php");
INSERT INTO `wp_postmeta` VALUES("1151", "233", "landing_page_page-title", "ZDAJ MATURĘ BEZ STRESU");
INSERT INTO `wp_postmeta` VALUES("1152", "233", "landing_page_page-subtitle", "Tylko z nami uda Ci się przejść przez egamin maturalny z pełną koncentracją i wewnętrznym spokojem.");
INSERT INTO `wp_postmeta` VALUES("1154", "233", "landing_page_section-active-1", "1");
INSERT INTO `wp_postmeta` VALUES("1155", "233", "landing_page_date", "<p>Every week</p>\n");
INSERT INTO `wp_postmeta` VALUES("1156", "233", "landing_page_column-2", "<p>something new</p>\n");
INSERT INTO `wp_postmeta` VALUES("1157", "233", "landing_page_place", "<p>another attempt</p>\n");
INSERT INTO `wp_postmeta` VALUES("1158", "233", "landing_page_section-active-1a", "1");
INSERT INTO `wp_postmeta` VALUES("1159", "233", "landing_page_section-1a-title", "Second section");
INSERT INTO `wp_postmeta` VALUES("1160", "233", "landing_page_section-1a-desc", "<p>Of course I like this</p>\n");
INSERT INTO `wp_postmeta` VALUES("1161", "233", "landing_page_section-active-2", "1");
INSERT INTO `wp_postmeta` VALUES("1162", "233", "landing_page_section-title-2", "Why Not?");
INSERT INTO `wp_postmeta` VALUES("1163", "233", "landing_page_price", "<p>I have an opinion</p>\n");
INSERT INTO `wp_postmeta` VALUES("1164", "233", "landing_page_healinglife", "0");
INSERT INTO `wp_postmeta` VALUES("1165", "233", "landing_page_section-2-btn", "No Orange letters please");
INSERT INTO `wp_postmeta` VALUES("1166", "233", "landing_page_section-active-2a", "1");
INSERT INTO `wp_postmeta` VALUES("1167", "233", "landing_page_section-2a-title", "Another section");
INSERT INTO `wp_postmeta` VALUES("1168", "233", "landing_page_section-2a-input-1", "<p>first field</p>\n");
INSERT INTO `wp_postmeta` VALUES("1169", "233", "landing_page_section-2a-input-2", "<p>2nd field</p>\n");
INSERT INTO `wp_postmeta` VALUES("1170", "233", "landing_page_section-2a-input-3", "<p>third field</p>\n");
INSERT INTO `wp_postmeta` VALUES("1171", "233", "landing_page_slide-title", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("1172", "233", "landing_page_slide-desc", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("1185", "233", "landing_page_main-img", "162");
INSERT INTO `wp_postmeta` VALUES("1186", "95", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("1187", "95", "_wp_trash_meta_time", "1512386385");
INSERT INTO `wp_postmeta` VALUES("1188", "95", "_wp_desired_post_slug", "zajecia-dla-dzieci");
INSERT INTO `wp_postmeta` VALUES("1189", "239", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1190", "239", "_wp_page_template", "template-o-nas.php");
INSERT INTO `wp_postmeta` VALUES("1191", "239", "landing_page_page-title", "Masaż Uzdrawiający");
INSERT INTO `wp_postmeta` VALUES("1192", "239", "landing_page_page-subtitle", "Już czas zająć się sobą. Daj sobie uwagę i miłość.");
INSERT INTO `wp_postmeta` VALUES("1194", "239", "landing_page_section-active-1", "1");
INSERT INTO `wp_postmeta` VALUES("1195", "239", "landing_page_section-active-1a", "1");
INSERT INTO `wp_postmeta` VALUES("1196", "239", "landing_page_section-1a-desc", "<p style=\"text-align: center;\">Masaż odbywa się na podłodze na miękkich matach. Osoba masowana jest ubrana w wygodny strój sportowy np dres lub legginsy. W trakcie masażu wykorzystujemy aromaterapię, a w tle rozbrzmiewają delikatne uspokajające dźwięki. Wszystko po to, aby osoba, mogła poczuć się wygodnie i bezpiecznie.</p>\n<p style=\"text-align: center;\">Nasz codzienny tryb życia często jest zabiegany, a w pierwszej kolejności zajmujemy się innymi. Dbamy o to, aby nasze rodziny miały ciepły obiad na stole, aby dom był czysty i zadbany. Dbamy o innych najpierw, zapominając o sobie.....</p>\n<p style=\"text-align: center;\">Masaż Uzdrawiający w naszym Centrum jest odpowiedzią dla wszystkich osób, niezależnie od płci, wieku czy sytuacji zdrowotnej, którzy pragną dla siebie odrobiny wyciszenia i miłości.</p>\n");
INSERT INTO `wp_postmeta` VALUES("1197", "239", "landing_page_section-active-2", "0");
INSERT INTO `wp_postmeta` VALUES("1198", "239", "landing_page_healinglife", "0");
INSERT INTO `wp_postmeta` VALUES("1199", "239", "landing_page_section-active-2a", "1");
INSERT INTO `wp_postmeta` VALUES("1200", "239", "landing_page_slide-title", "a:3:{i:0;s:32:\"Wybrana część ciała 30 minut\";i:1;s:21:\"Całe ciało 60 minut\";i:2;s:28:\"Odblokowanie emocji 90 minut\";}");
INSERT INTO `wp_postmeta` VALUES("1201", "239", "landing_page_slide-desc", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("1202", "239", "_edit_lock", "1512467323:1");
INSERT INTO `wp_postmeta` VALUES("1204", "242", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1205", "242", "_menu_item_menu_item_parent", "58");
INSERT INTO `wp_postmeta` VALUES("1206", "242", "_menu_item_object_id", "239");
INSERT INTO `wp_postmeta` VALUES("1207", "242", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1208", "242", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1209", "242", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1210", "242", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1211", "242", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1213", "243", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1214", "243", "_edit_lock", "1512745623:1");
INSERT INTO `wp_postmeta` VALUES("1215", "243", "_wp_page_template", "template-dla-firm.php");
INSERT INTO `wp_postmeta` VALUES("1216", "243", "landing_page_page-title", "Zajęcia grupowe");
INSERT INTO `wp_postmeta` VALUES("1217", "243", "landing_page_page-subtitle", "Zdrowe ciało Spokojny umysł");
INSERT INTO `wp_postmeta` VALUES("1219", "243", "landing_page_section-active-1", "1");
INSERT INTO `wp_postmeta` VALUES("1220", "243", "landing_page_section-title-1", "Liczba miejsc nieograniczona");
INSERT INTO `wp_postmeta` VALUES("1221", "243", "landing_page_date", "<h2 style=\"text-align: center;\">Elastyczność</h2>\n<p style=\"text-align: center;\">Na zajęcia możesz przychodzić w dogodnym dla siebie terminie, bez konieczności rezerwacji miejsca.  Trening odbywa się zawsze wg grafiku, niezależnie od liczby uczestników.</p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>\n");
INSERT INTO `wp_postmeta` VALUES("1223", "243", "landing_page_place", "<h2 style=\"text-align: center;\">Dostępność</h2>\n<p style=\"text-align: center;\">Zapraszamy dorosłych, młodzież i seniorów, niezależnie od stanu zdrowia i kondycji. Szczególnie zapraszamy osoby, które nigdy nie trenowały jogi ani tai chi. Każda lekcja prowadzona jest w sposób klarowny i podstawowy tak, aby uczestnicy mogli poczuć się bezpiecznie wykonując ćwiczenia Body and Brain.</p>\n");
INSERT INTO `wp_postmeta` VALUES("1224", "243", "landing_page_section-active-1a", "1");
INSERT INTO `wp_postmeta` VALUES("1225", "243", "landing_page_section-active-2", "1");
INSERT INTO `wp_postmeta` VALUES("1226", "243", "landing_page_section-title-2", "Sprawdź aktualny grafik");
INSERT INTO `wp_postmeta` VALUES("1227", "243", "landing_page_price", "<p>[caption id=\"attachment_257\" align=\"aligncenter\" width=\"300\"]<a href=\"http://bnb.testuj.website/wp-content/uploads/2017/12/Grafik-Body-and-Brain-_Grudzień.jpg\"><img class=\"wp-image-257 size-medium\" src=\"http://bnb.testuj.website/wp-content/uploads/2017/12/Grafik-Body-and-Brain-_Grudzień-300x168.jpg\" alt=\"\" width=\"300\" height=\"168\" /></a> Kliknij na grafik, aby powiększyć.[/caption]</p>\n");
INSERT INTO `wp_postmeta` VALUES("1228", "243", "landing_page_healinglife", "0");
INSERT INTO `wp_postmeta` VALUES("1229", "243", "landing_page_section-active-2a", "0");
INSERT INTO `wp_postmeta` VALUES("1230", "243", "landing_page_slide-title", "a:6:{i:0;s:13:\"poniedziałek\";i:1;s:6:\"wtorek\";i:2;s:6:\"środa\";i:3;s:7:\"cwartek\";i:4;s:7:\"piątek\";i:5;s:6:\"sobota\";}");
INSERT INTO `wp_postmeta` VALUES("1231", "243", "landing_page_slide-desc", "a:6:{i:0;s:148:\"Witalność: ćwiczenia brzucha w celu wzmocnienia układu odpornościowego, podniesienia poziomu energii i poprawy przepływu krwi w całym ciele. \";i:1;s:106:\"Rozciąganie: poprawa mobilności stawów i kręgosłupa, usuwanie bólu układu kostnego i mięśniowego.\";i:2;s:143:\"Wibracja: techniki relaksacyjne usuwania stresu, szybkie rozluźnienie spiętych mięśni, pobudzenie krążenia krwi i energii w całym ciele.\";i:3;s:125:\"Ki Gong: metoda na połączenie umysłu z ciałem, zbudowanie wewnętrznej równowagi, postawy ciała i koncentracji umysłu.\";i:4;s:119:\"Medytacja: techniki oddechowe i relaksacyjne w celu wyciszenia myśli i emocji, odpoczynek po ciężkim tygodniu pracy.\";i:5;s:178:\"Regeneracja: ładowanie baterii, ta specjalna lekcja koncentruje się na budowaniu zapasów energii, aby lepiej radzić sobie z intensywnym trybem życia, relaks i rewitalizacja.\";}");
INSERT INTO `wp_postmeta` VALUES("1232", "246", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1233", "246", "_menu_item_menu_item_parent", "58");
INSERT INTO `wp_postmeta` VALUES("1234", "246", "_menu_item_object_id", "243");
INSERT INTO `wp_postmeta` VALUES("1235", "246", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1236", "246", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1237", "246", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1238", "246", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1239", "246", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1242", "90", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("1243", "90", "_wp_trash_meta_time", "1512391737");
INSERT INTO `wp_postmeta` VALUES("1244", "90", "_wp_desired_post_slug", "cwiczenia-dla-doroslych");
INSERT INTO `wp_postmeta` VALUES("1245", "82", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("1246", "82", "_wp_trash_meta_time", "1512391737");
INSERT INTO `wp_postmeta` VALUES("1247", "82", "_wp_desired_post_slug", "masaz-hwal-gong");
INSERT INTO `wp_postmeta` VALUES("1258", "251", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1259", "251", "_edit_lock", "1512420407:1");
INSERT INTO `wp_postmeta` VALUES("1260", "251", "_wp_page_template", "template-o-nas.php");
INSERT INTO `wp_postmeta` VALUES("1261", "251", "landing_page_page-title", "Uzdrawianie przez pępek");
INSERT INTO `wp_postmeta` VALUES("1262", "251", "landing_page_page-subtitle", "To najnowsza naturalna metoda uzdrawiania ciała, umysłu i emocji.");
INSERT INTO `wp_postmeta` VALUES("1264", "251", "landing_page_section-active-1", "1");
INSERT INTO `wp_postmeta` VALUES("1265", "251", "landing_page_section-title-1", "Czy wiesz, że poprzez masaż jednego punktu możesz uzdrowić całe ciało?");
INSERT INTO `wp_postmeta` VALUES("1266", "251", "landing_page_date", "<p>Pępek to miejsce, w którym żyje tysiące drobnoustrojów. Jest to centralny punkt ciała, za którym znajdują się jelita, główne naczynia krwionośne, ważne węzły chłonne, tryliony bakterii, silna linia obronna układu odpornościowego, a co najważniejsze – nasz drugi mózg – jelitowy układ nerwowy.</p>\n");
INSERT INTO `wp_postmeta` VALUES("1267", "251", "landing_page_column-2", "<p>Wykonują technikę uzdrawiania przez pępek stymulujemy nerw błędny, który jest bezpośrednim połączeniem organów z mózgiem. Masując pępek włączamy tzw. układ przywspółczulny, który reguluje funkcje odpowiadające za trawienie i odpoczynek. Stymulując pępek poprawiamy też czujność i pamięć.</p>\n");
INSERT INTO `wp_postmeta` VALUES("1268", "251", "landing_page_place", "<p>Zaraz za pępkiem odbywa się produkcja hormonów szczęścia i radości. Aż 90{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77} serotoniny i 50{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77} dopaminy wytwarzane jest w jelitach. Badania udowodniły, że obniżony poziom serotoniny i dopaminy wpływają na nasze samopoczucie emocjonalne, a depresja zwiększa ryzyko wystąpienia choroby Alzheimera aż o 65{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}.</p>\n");
INSERT INTO `wp_postmeta` VALUES("1269", "251", "landing_page_section-active-1a", "1");
INSERT INTO `wp_postmeta` VALUES("1270", "251", "landing_page_section-1a-title", "Dowiedz się więcej na temat metody");
INSERT INTO `wp_postmeta` VALUES("1271", "251", "landing_page_section-1a-desc", "<h1 style=\"text-align: center;\"><strong>12 Korzyści z Uzdrawiania przez Pępek</strong></h1>\n<h2 style=\"text-align: left;\"><strong>1. LEPSZA CYRKULACJA KRWI</strong></h2>\n<p style=\"text-align: left;\">Uzdrawianie Pępkiem promuje cyrkulację krwi poprzez stymulację organów w jamie brzusznej, które kumulują ok. 30 – 40{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77} krwi. Technika ta wspomaga też lepszą cyrkulację w aorcie brzusznej  oraz w żyle dolnej głównej, które znajdują się za pępkiem. Powtarzające ruchy rozgrzewają brzuch, skłaniając naczynia krwionośne do rozszerzania się, co pozwala większej ilości krwi przez nie przepłynąć.</p>\n<h2 style=\"text-align: left;\"><strong>2. WYŻSZA TEMPERATURA CIAŁA</strong></h2>\n<p style=\"text-align: left;\">Możesz niemal natychmiast poczuć, że ciało od brzucha w dół do stop robi się ciepłe, kiedy wykonujesz ćwiczenie Uzdrawiania Pępkiem. Podnoszenie temperatury ciała wspomaga metabolizm oraz wzmacnia system odpornościowy, a także funkcje oczyszczające organizmu.</p>\n<h2 style=\"text-align: left;\"><strong>3. LEPSZE TRAWIENIE I WYDALANIE</strong></h2>\n<p style=\"text-align: left;\">Jelitowy układ nerwowy jest stymulowany. Promuje to lepszą perystaltykę jelit, co w efekcie daje nam lepsze trawienie i łatwe, płynne wydalanie.</p>\n<h2 style=\"text-align: left;\"><strong>4. ULGA DLA STAWÓW</strong></h2>\n<p style=\"text-align: left;\">Brzuch jest połączony ze stawami w miednicy poprzez powięzi mięśniowe i naczynia krwionośnie. W trakcie wykonywania techniki Uzdrawiania Pępkiem spięcia w powięziach są rozluźniane, co pozwala lepiej wyrównać ciało, poprawiając ogólną elastyczność i usuwając ból, który wynika z niepoprawnej postawy ciała.</p>\n<h2 style=\"text-align: left;\"><strong>5. ODPORNOŚĆ I DETOX</strong></h2>\n<p style=\"text-align: left;\">Węzły chłonne skoncentrowane wokół pępka są stymulowane, co poprawia cyrkulację płynu limfatycznego, który jest zaangażowany w poziom odporności i wydalanie toksyn i odpadków. Także, jelitowy ekosystem staje się zdrowszy, dzięki czemu podnosi się aktywność całego układu odpornościowego i bakteryjnego.</p>\n<h2 style=\"text-align: left;\"><strong>6. ZWIĘKSZENIE FIZYCZNEJ AKTYWNOŚCI</strong></h2>\n<p style=\"text-align: left;\">Dostarczenie tlenu i środków odżywczych do całego ciała jest ulepszone poprzez cyrkulację krwi I głębokie oddechy. Dlatego też energia witalna w brzuchu zaczyna cyrkulować w całym ciele, poprawiając aktywność fizyczną całego organizmu.</p>\n<h2 style=\"text-align: left;\"><strong>7. CZYSTA GŁOWA I LESZPA KONCENTRACJA</strong></h2>\n<p style=\"text-align: left;\">Cyrkulacja krwi oraz głębokie oddychanie dostarczając dużą ilość tlenu do mózgu a energia wody z nerek płynie do głowy, ochładzając ją. W efekcie uzyskujemy umysłową jasność i lepszą wizję.</p>\n<h2 style=\"text-align: left;\"><strong>8. RELAKS DLA CIAŁA I UMYSŁU</strong></h2>\n<p style=\"text-align: left;\">Koncentrując się na wydechu w trakcie wykonywania techniki Uzdrawiania Pępkiem wzmacniamy układ przywspółczulny, odpowiedzialny za odpoczynek i lepsze trawienie. Wykonując Uzdrawianie Pępkiem całe ciało i umysł się relaksują i doładowują energią.</p>\n<h2 style=\"text-align: left;\"><strong>9. ROZWÓJ FIZYCZNEGO I PSYCHICZNEGO ZDROWIA</strong></h2>\n<p style=\"text-align: left;\">Ponad 90{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77} serotoniny (hormonu szczęścia) jest produkowane w jelitach. Technika Uzdrawiania Pępkiem poprawia nastrój i daje poczucie zdrowia i spełnienia.</p>\n<h2 style=\"text-align: left;\"><strong>10. LŚNIĄCA I GŁADKA SKÓRA</strong></h2>\n<p style=\"text-align: left;\">Poprawa ogólnej cyrkulacji systemów krwionośnego, limfatycznego, nerwowego i trawiennego, a także poprawa odporności i układu wydalniczego, wpływa na przyspieszenie wydalania odpadków i toksyn z organizmu, dzięki czemu skóra odbudowuje się szybciej i staje się bardziej lśniąca i gładka.</p>\n<h2 style=\"text-align: left;\"><strong>11. WZMOCNIENIE WIĘZI RODZINNYCH</strong></h2>\n<p style=\"text-align: left;\">Technika Uzdrawiania Pępkiem pozwala lepiej zadbać o zdrowie swoje i swojej rodziny. Gdy nawzajem członkowie rodziny wykonują na sobie tę technikę, energia pomiędzy nimi oczyszcza się, a rodzinne więzy stają się bardziej naturalne, silniejsze i bliższe.</p>\n<h2 style=\"text-align: left;\"><strong>12. WIĘKSZA RÓWNOWAGA</strong></h2>\n<p style=\"text-align: left;\">Poprzez skupienie umysłu na pępku (centrum ciała) stan umysłu staje się bardziej zrównoważony i wyśrodkowany.</p>\n");
INSERT INTO `wp_postmeta` VALUES("1272", "251", "landing_page_section-active-2", "1");
INSERT INTO `wp_postmeta` VALUES("1273", "251", "landing_page_section-title-2", "W jaki sposób wykonywać masaż");
INSERT INTO `wp_postmeta` VALUES("1274", "251", "landing_page_price", "<p>Masaż pępka można wykonywać palcami lub specjalnie do tego zaprojektowanym masażerem tzw. Kijkiem Healing Life.</p>\n<h1>CZYM JEST KIJEK HEALING LIFE</h1>\n<p>Kijek <em>Healing Life </em>to ergonomicznie zaprojektowane narzędzie, aby efektywnie stymulować końcówki nerwów, tkanki, mięśnie i organy zlokalizowane wokół pępka. To wielofunkcyjne narzędzie do masażu. Posiada cztery końcówki o różnej długości i grubości, które mogą być używane do różnych technik masażu pępka, jak i całego ciała. Materiał, który został zawarty w kijku <em>Healing Life</em> to Hantoryum.</p>\n<p><strong>Czym jest Hantoryum?</strong></p>\n<p>Hantoryum jest związkiem zawierającym czerwoną glinkę i dokładnie wyselekcjonowane lecznicze minerały, takie jak zeolit, elwan i lessy. Substancje te ze względu na swe lecznicze właściwości są używane od tysięcy lat. Kiedy dochodzi do kontaktu ze skórą, naturalne właściwości materiału przenikają w głąb ciała i tu zaczyna się ich cudowne działanie.</p>\n<p>Zostało naukowo udowodnione, że Hantoryum emituje promieniowanie dalekiej podczerwieni (z ang. FIR). Są to naturalnie występujące, niewidoczne fale światła o leczniczym działaniu, o szczególnej długości fali, która dociera poprzez skórę w głąb ciała. Kiedy spędzasz czas na słońcu, doświadczasz uczucia wewnętrznego ciepła, relaksu i odmłodzenia. Jest to wynikiem emitowania dalekiej podczerwieni przez promienie słoneczne. Uzdrawiająca mata wykonana z Hantoryum zapewnia takie same wzmacniające korzyści, które możesz odczuć już zaledwie po kilku minutach.</p>\n");
INSERT INTO `wp_postmeta` VALUES("1276", "251", "landing_page_healinglife", "0");
INSERT INTO `wp_postmeta` VALUES("1277", "251", "landing_page_section-active-2a", "1");
INSERT INTO `wp_postmeta` VALUES("1278", "251", "landing_page_section-2a-title", "Jest kilka sposobów, aby nauczyć się metody Uzdrawiania przez Pępek");
INSERT INTO `wp_postmeta` VALUES("1279", "251", "landing_page_section-2a-input-1", "<p>Umów się na indywidualną sesję uzdrawiania, aby doświadczyć korzyści płynących z metody masażu pępka. Już po pierwszej wizycie poczujesz duże odprężenie i rozluźnienie mięśni i organów. W trakcie masażu poprawi się też przepływ krwi i energii.</p>\n");
INSERT INTO `wp_postmeta` VALUES("1280", "251", "landing_page_section-2a-input-2", "<p>Zapisz się na całodniowy warsztat, który odbywa się w naszym centrum raz w miesiącu. W trakcie warsztatu dogłębnie poznasz zasady uzdrawiania siebie i innych. Najbliższy warsztat Uzdrawiania przez Pępek odbędzie się w Rybniku 6 stycznia 2018.</p>\n");
INSERT INTO `wp_postmeta` VALUES("1281", "251", "landing_page_section-2a-input-3", "<p>Zamów dla siebie kijek Healing Life wraz z opisem metody w języku polskim w formie e-book i samodzielnie masuj swój pępek. Rozpocznij swój osobisty trening wspierania zdrowia masażem Healing Life 3 razy dziennie po 5 minut.</p>\n");
INSERT INTO `wp_postmeta` VALUES("1282", "251", "landing_page_slide-title", "a:3:{i:0;s:18:\"INDYWIDUALNA SESJA\";i:1;s:8:\"WARSZTAT\";i:2;s:18:\"KIJEK HEALING LIFE\";}");
INSERT INTO `wp_postmeta` VALUES("1283", "251", "landing_page_slide-desc", "a:3:{i:0;s:131:\"Na spotkaniu otrzymasz masaż uzdrawiający i poznasz zasady, jak wykonać go samemu. \r\nSesja trwa 1,5 godziny i kosztuje 150 zł. \";i:1;s:167:\"Podczas warsztatu połączysz umysł ze swoim ciałem.\r\nDoświadczysz Uzdrawiania przez Pępek i dowiesz się, jak wykonywać masaż najbliższym.\r\nInwestycja 420 zł.\";i:2;s:232:\"Zamawiając kijek Healing Life otrzymasz polskie opracowanie autora tej metody Ilchi Lee. \r\nNasze centrum jest jedynym w Polsce licencjonowanym dystrybutorem oryginalnego kijka zamawianego dla Was prosto z Korei. Inwestycja 390 zł.\";}");
INSERT INTO `wp_postmeta` VALUES("1284", "251", "landing_page_footer-lp", "<h2 style=\"text-align: center;\">Zapraszam do kontaktu</h2>\n<p style=\"text-align: center;\">[bnb-btn class=\"btn btn-orange btn-big\" link=\"kontakt\" text=\"Napisz do nas\"]</p>\n<p style=\"text-align: center;\">Ola Mason - Instruktor Metody Uzdrawiania przez Pępek</p>\n<p style=\"text-align: center;\">Telefon 887 362 809</p>\n<p><img class=\"size-medium wp-image-193 aligncenter\" src=\"http://bnb.testuj.website/wp-content/uploads/2017/10/DSC_0392-300x169.jpg\" alt=\"\" width=\"300\" height=\"169\" /></p>\n");
INSERT INTO `wp_postmeta` VALUES("1285", "251", "landing_page_main-img", "14");
INSERT INTO `wp_postmeta` VALUES("1286", "251", "landing_page_section-2-bg", "14");
INSERT INTO `wp_postmeta` VALUES("1296", "251", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("1297", "251", "_wp_trash_meta_time", "1512420746");
INSERT INTO `wp_postmeta` VALUES("1298", "251", "_wp_desired_post_slug", "pepek");
INSERT INTO `wp_postmeta` VALUES("1300", "255", "_wp_attached_file", "2017/10/Aleksandra-Mason-BODYBRAIN.mp4");
INSERT INTO `wp_postmeta` VALUES("1301", "255", "_wp_attachment_metadata", "a:10:{s:8:\"filesize\";i:86901846;s:9:\"mime_type\";s:9:\"video/mp4\";s:6:\"length\";i:543;s:16:\"length_formatted\";s:4:\"9:03\";s:5:\"width\";i:1280;s:6:\"height\";i:720;s:10:\"fileformat\";s:3:\"mp4\";s:10:\"dataformat\";s:9:\"quicktime\";s:5:\"audio\";a:7:{s:10:\"dataformat\";s:3:\"mp4\";s:5:\"codec\";s:19:\"ISO/IEC 14496-3 AAC\";s:11:\"sample_rate\";d:44100;s:8:\"channels\";i:2;s:15:\"bits_per_sample\";i:16;s:8:\"lossless\";b:0;s:11:\"channelmode\";s:6:\"stereo\";}s:17:\"created_timestamp\";i:1511870446;}");
INSERT INTO `wp_postmeta` VALUES("1302", "256", "_wp_attached_file", "2017/10/Aleksandra-Mason-BODYBRAIN-1.mp4");
INSERT INTO `wp_postmeta` VALUES("1303", "256", "_wp_attachment_metadata", "a:10:{s:8:\"filesize\";i:86901846;s:9:\"mime_type\";s:9:\"video/mp4\";s:6:\"length\";i:543;s:16:\"length_formatted\";s:4:\"9:03\";s:5:\"width\";i:1280;s:6:\"height\";i:720;s:10:\"fileformat\";s:3:\"mp4\";s:10:\"dataformat\";s:9:\"quicktime\";s:5:\"audio\";a:7:{s:10:\"dataformat\";s:3:\"mp4\";s:5:\"codec\";s:19:\"ISO/IEC 14496-3 AAC\";s:11:\"sample_rate\";d:44100;s:8:\"channels\";i:2;s:15:\"bits_per_sample\";i:16;s:8:\"lossless\";b:0;s:11:\"channelmode\";s:6:\"stereo\";}s:17:\"created_timestamp\";i:1511870446;}");
INSERT INTO `wp_postmeta` VALUES("1308", "257", "_wp_attached_file", "2017/12/Grafik-Body-and-Brain-_Grudzień.jpg");
INSERT INTO `wp_postmeta` VALUES("1309", "257", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2005;s:6:\"height\";i:1121;s:4:\"file\";s:44:\"2017/12/Grafik-Body-and-Brain-_Grudzień.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:44:\"Grafik-Body-and-Brain-_Grudzień-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:44:\"Grafik-Body-and-Brain-_Grudzień-300x168.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:168;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:44:\"Grafik-Body-and-Brain-_Grudzień-768x429.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:429;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:45:\"Grafik-Body-and-Brain-_Grudzień-1024x573.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:573;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1324", "243", "landing_page_section-1a-title", "Jak rozpocząć?");
INSERT INTO `wp_postmeta` VALUES("1326", "243", "landing_page_section-1a-desc", "<p style=\"text-align: center;\">Aby dołączyć do zajęć grupowych konieczne jest wcześniejsze umówienie się na spotkanie informacyjne, podczas którego instruktor będzie mógł dowiedzieć się, jakie są Twoje motywacje do treningu.</p>\n<p style=\"text-align: center;\">Pomimo że trening odbywa się w grupie, każdy z uczestników jest traktowany indywidualnie tj. znamy kondycję i możliwości wszystkich studentów, dzięki czemu możemy dostosować poziom ćwiczeń do Twoich potrzeb.</p>\n<p style=\"text-align: center;\">Spotkanie informacyjno - wprowadzające trwa około 45 minut. Prosimy o ubranie stroju sportowego, gdyż podczas spotkania będziesz miał okazję próbować kilku podstawowych ćwiczeń. Na spotkaniu też będziemy mogli wspólnie ustalić, które lekcje z grafiku najlepiej odpowiadają Twoim potrzebom i dostaniesz od nas atrakcyjną ofertę cenową.</p>\n<p style=\"text-align: center;\">Koszt spotkania informacyjno - wprowadzającego połączonego z wypróbowaniem 1 lekcji grupowej to 50 zł.  Jednakże w momencie wykupienia abonamentu kwota ta zostaje zwracana.</p>\n<p style=\"text-align: center;\">Zapraszamy do umawiania spotkań pod numerem telefonu 887 362 809</p>\n");
INSERT INTO `wp_postmeta` VALUES("1330", "243", "landing_page_column-2", "<h2 style=\"text-align: center;\">Pozytywna energia</h2>\n<p style=\"text-align: center;\">Dbamy o to, aby w naszym centrum była czysta i serdeczna energia. Staramy się, aby atmosfera zajęć była przyjazna i życzliwa dla wszystkich. Chcemy, aby każda osoba trenująca u nas czuła się ciepło i przyjaźnie. Naszych instruktorów cechuje wysoka wyrozumiałość i cierpliwość.</p>\n");
INSERT INTO `wp_postmeta` VALUES("1333", "243", "landing_page_footer-lp", "<h2 style=\"text-align: center;\">Zapraszamy do naszego Centrum Body and Brain na codzienny trening ciała i umysłu. Umów się z nami teraz:)</h2>\n<p style=\"text-align: center;\"><a href=\"http://bnb.testuj.website/rezerwacja-terminu/\">REZERWACJA SPOTKANIA</a></p>\n<p>&nbsp;</p>\n");
INSERT INTO `wp_postmeta` VALUES("1336", "259", "_wp_attached_file", "2017/12/healingmassageaz3-e1512463705322.jpg");
INSERT INTO `wp_postmeta` VALUES("1337", "259", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:960;s:6:\"height\";i:410;s:4:\"file\";s:44:\"2017/12/healingmassageaz3-e1512463705322.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:29:\"healingmassageaz3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:29:\"healingmassageaz3-300x128.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:128;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:29:\"healingmassageaz3-768x328.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:328;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1339", "259", "_wp_attachment_backup_sizes", "a:1:{s:9:\"full-orig\";a:3:{s:5:\"width\";i:960;s:6:\"height\";i:410;s:4:\"file\";s:21:\"healingmassageaz3.jpg\";}}");
INSERT INTO `wp_postmeta` VALUES("1340", "260", "_wp_attached_file", "2017/12/healing-massage-1.jpg");
INSERT INTO `wp_postmeta` VALUES("1341", "260", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1500;s:6:\"height\";i:1000;s:4:\"file\";s:29:\"2017/12/healing-massage-1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:29:\"healing-massage-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:29:\"healing-massage-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:29:\"healing-massage-1-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:30:\"healing-massage-1-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:24:\"Getty Images/iStockphoto\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:3:\"Spa\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:9:\"154418691\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1344", "239", "landing_page_section-title-1", "Czym jest Masaż Uzdrawiający?");
INSERT INTO `wp_postmeta` VALUES("1345", "239", "landing_page_date", "<h2>Uzdrawianie</h2>\n<p>Poprzez delikatny masaż odblokowujemy tzw meridiany czyli kanały, przez które płynie energia. Usprawnienie przepływu energii w ciele wpływa na lepszą kondycję organów, czego efektem jest poprawa zdrowia.</p>\n");
INSERT INTO `wp_postmeta` VALUES("1347", "239", "landing_page_column-2", "<h2>Relaksacja</h2>\n<p>Atmosfera masażu sprzyja pełnemu rozluźnieniu ciała i umysłu. W trakcie spotkania można w pełni się zrelaksować i odciąć się od problemów dnia codziennego.</p>\n");
INSERT INTO `wp_postmeta` VALUES("1348", "239", "landing_page_place", "<h2>Spokój</h2>\n<p>Gdy ciało i umysł zaczynają się uzdrawiać i relaksować, błogi spokój sam zawita do Twojego serca. Jeśli szukasz dla siebie momentu oddechu, uzdrawiający masaż jest rozwiązaniem na wyciągnięcie ręki.</p>\n");
INSERT INTO `wp_postmeta` VALUES("1353", "239", "landing_page_section-1a-title", "Jak wygląda masaż?");
INSERT INTO `wp_postmeta` VALUES("1359", "239", "landing_page_section-2a-title", "Poznaj naszą ofertę");
INSERT INTO `wp_postmeta` VALUES("1360", "239", "landing_page_section-2a-input-1", "<p>Masaż częściowy</p>\n<p>Koncentrujemy się na tej partii ciała, która przysparza najwięcej bólu i dyskomfortu na codzień np. głowa, ramiona i kark, kręgosłup, brzuch.<br />\nMasaż trwa 30 minut i kosztuje 45 zł.</p>\n");
INSERT INTO `wp_postmeta` VALUES("1361", "239", "landing_page_section-2a-input-2", "<p>Masaż całego ciała</p>\n<p>Od czubka głowy do stóp wszystkie partie ciała otrzymują uzdrawianie. Masaż trwa 60 minut i kosztuje 100 zł.</p>\n");
INSERT INTO `wp_postmeta` VALUES("1362", "239", "landing_page_section-2a-input-3", "<p>Odblokowanie emocji</p>\n<p>To głęboki masaż odblokowujący ciało i emocje. Masaż ten oczyszcza emocjonalnie i pozwala poczuć się lżej na duszy.<br />\nTrwa 90 minut i kosztuje 150 zł.</p>\n");
INSERT INTO `wp_postmeta` VALUES("1368", "239", "landing_page_footer-lp", "<h2 style=\"text-align: center;\">Jak się umówić?</h2>\n<p style=\"text-align: center;\">Na masaż najlepiej umówić się telefonicznie pod numerem 887 362 809. Szczególnie polecamy, aby skorzystać z masażu zaraz po zajęciach grupowych. Po treningu ciało już jest rozgrzane, masaż wtedy będzie miał jeszcze większą moc.</p>\n");
INSERT INTO `wp_postmeta` VALUES("1369", "239", "landing_page_main-img", "260");
INSERT INTO `wp_postmeta` VALUES("1370", "239", "landing_page_price", "<p><img class=\"size-medium wp-image-259 aligncenter\" src=\"http://bnb.testuj.website/wp-content/uploads/2017/12/healingmassageaz3-300x128.jpg\" alt=\"\" width=\"300\" height=\"128\" /></p>\n");
INSERT INTO `wp_postmeta` VALUES("1373", "13", "landing_page_section-title-1", "Najbliższy warsztat");
INSERT INTO `wp_postmeta` VALUES("1375", "13", "landing_page_column-2", "<h2>Cena</h2>\n<p>420 zł</p>\n");
INSERT INTO `wp_postmeta` VALUES("1379", "13", "landing_page_section-1a-desc", "<p>Warsztat Uzdrawianie przez Pępek to połączenie teorii i praktyki na temat</p>\n");
INSERT INTO `wp_postmeta` VALUES("1381", "13", "landing_page_section-title-2", "Jak będzie wyglądał warsztat?");
INSERT INTO `wp_postmeta` VALUES("1383", "13", "landing_page_price", "<p style=\"text-align: center;\">Zakres warsztatu to połączenie teorii i praktyki z tematu naturalnej mocy uzdrawiania się ludzkiego ciała.</p>\n<p style=\"text-align: center;\">W trakcie warsztatu dowiesz się, co robić w swoim codziennym trybie dnia, aby zapewnić sobie długie i zdrowe życie.</p>\n<p style=\"text-align: center;\">W ciągu jednego dnia nauczysz się, jak wykonywać ćwiczenia i masaż, aby zbudować w swoim ciele wysoki poziom energii gwarantujący zdrowie i dobre samopoczucie.</p>\n");
INSERT INTO `wp_postmeta` VALUES("1390", "261", "_wp_attached_file", "2017/10/DSC_0389-e1512471491331.jpg");
INSERT INTO `wp_postmeta` VALUES("1391", "261", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2000;s:6:\"height\";i:1125;s:4:\"file\";s:35:\"2017/10/DSC_0389-e1512471491331.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"DSC_0389-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"DSC_0389-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"DSC_0389-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"DSC_0389-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"D6603\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1511279407\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"4.6\";s:3:\"iso\";s:3:\"800\";s:13:\"shutter_speed\";s:4:\"0.05\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1393", "261", "_wp_attachment_backup_sizes", "a:1:{s:9:\"full-orig\";a:3:{s:5:\"width\";i:3840;s:6:\"height\";i:2160;s:4:\"file\";s:12:\"DSC_0389.jpg\";}}");
INSERT INTO `wp_postmeta` VALUES("1395", "262", "_wp_attached_file", "2017/10/free-body-brain-yoga-belly-button-healing-19-3.png");
INSERT INTO `wp_postmeta` VALUES("1396", "262", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:250;s:6:\"height\";i:134;s:4:\"file\";s:58:\"2017/10/free-body-brain-yoga-belly-button-healing-19-3.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:58:\"free-body-brain-yoga-belly-button-healing-19-3-150x134.png\";s:5:\"width\";i:150;s:6:\"height\";i:134;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1398", "263", "_wp_attached_file", "2017/10/sureandsimple-5-e1512471668574.jpg");
INSERT INTO `wp_postmeta` VALUES("1399", "263", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:416;s:6:\"height\";i:312;s:4:\"file\";s:42:\"2017/10/sureandsimple-5-e1512471668574.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"sureandsimple-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"sureandsimple-5-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1401", "263", "_wp_attachment_backup_sizes", "a:1:{s:9:\"full-orig\";a:3:{s:5:\"width\";i:416;s:6:\"height\";i:312;s:4:\"file\";s:19:\"sureandsimple-5.jpg\";}}");
INSERT INTO `wp_postmeta` VALUES("1402", "264", "_wp_attached_file", "2017/10/DSC_0327-e1512471876355.jpg");
INSERT INTO `wp_postmeta` VALUES("1403", "264", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:563;s:4:\"file\";s:35:\"2017/10/DSC_0327-e1512471876355.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"DSC_0327-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"DSC_0327-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"DSC_0327-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"DSC_0327-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"D6603\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1509616034\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"4.6\";s:3:\"iso\";s:2:\"80\";s:13:\"shutter_speed\";s:7:\"0.03125\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1405", "264", "_wp_attachment_backup_sizes", "a:3:{s:9:\"full-orig\";a:3:{s:5:\"width\";i:3840;s:6:\"height\";i:2160;s:4:\"file\";s:12:\"DSC_0327.jpg\";}s:18:\"full-1512471797569\";a:3:{s:5:\"width\";i:2000;s:6:\"height\";i:1125;s:4:\"file\";s:27:\"DSC_0327-e1512471767418.jpg\";}s:18:\"full-1512471876355\";a:3:{s:5:\"width\";i:1500;s:6:\"height\";i:844;s:4:\"file\";s:27:\"DSC_0327-e1512471797569.jpg\";}}");
INSERT INTO `wp_postmeta` VALUES("1408", "265", "_wp_attached_file", "2017/10/31865667_l-e1512471987817.jpg");
INSERT INTO `wp_postmeta` VALUES("1409", "265", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:37:\"2017/10/31865667_l-e1512471987817.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"31865667_l-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"31865667_l-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"31865667_l-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"31865667_l-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:78:\"31865667 - peaceful woman in white sitting in lotus pose  against snow falling\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:25:\"wavebreakmediamicro/123RF\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:78:\"31865667 - peaceful woman in white sitting in lotus pose  against snow falling\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:77:{i:0;s:3:\"20s\";i:1;s:11:\"young adult\";i:2;s:5:\"woman\";i:3;s:6:\"female\";i:4;s:10:\"mixed-race\";i:5;s:6:\"health\";i:6;s:4:\"body\";i:7;s:10:\"attractive\";i:8;s:6:\"pretty\";i:9;s:9:\"beautiful\";i:10;s:8:\"wellness\";i:11;s:9:\"body care\";i:12;s:7:\"leisure\";i:13;s:9:\"lifestyle\";i:14;s:3:\"fit\";i:15;s:7:\"healthy\";i:16;s:7:\"fitness\";i:17;s:8:\"physical\";i:18;s:5:\"shape\";i:19;s:10:\"sportswear\";i:20;s:6:\"sporty\";i:21;s:8:\"athletic\";i:22;s:7:\"sitting\";i:23;s:5:\"floor\";i:24;s:4:\"yoga\";i:25;s:4:\"calm\";i:26;s:8:\"peaceful\";i:27;s:8:\"relaxing\";i:28;s:7:\"content\";i:29;s:11:\"health farm\";i:30;s:3:\"spa\";i:31;s:8:\"serenity\";i:32;s:8:\"tranquil\";i:33;s:10:\"relaxation\";i:34;s:8:\"vacation\";i:35;s:7:\"retreat\";i:36;s:17:\"healthy lifestyle\";i:37;s:8:\"brunette\";i:38;s:10:\"brown hair\";i:39;s:14:\"tourist resort\";i:40;s:10:\"lotus pose\";i:41;s:10:\"meditating\";i:42;s:10:\"meditation\";i:43;s:19:\"relaxation exercise\";i:44;s:8:\"zen-like\";i:45;s:8:\"vitality\";i:46;s:12:\"spirituality\";i:47;s:4:\"snow\";i:48;s:9:\"snowflake\";i:49;s:7:\"snowing\";i:50;s:7:\"falling\";i:51;s:4:\"snow\";i:52;s:9:\"snowflake\";i:53;s:7:\"snowing\";i:54;s:7:\"falling\";i:55;s:7:\"falling\";i:56;s:3:\"ice\";i:57;s:4:\"cold\";i:58;s:8:\"blizzard\";i:59;s:7:\"falling\";i:60;s:3:\"ice\";i:61;s:4:\"cold\";i:62;s:8:\"blizzard\";i:63;s:9:\"snowflake\";i:64;s:8:\"delicate\";i:65;s:6:\"design\";i:66;s:7:\"crystal\";i:67;s:6:\"nature\";i:68;s:5:\"storm\";i:69;s:6:\"winter\";i:70;s:5:\"snowy\";i:71;s:5:\"frost\";i:72;s:4:\"cold\";i:73;s:5:\"chill\";i:74;s:9:\"snowflake\";i:75;s:8:\"delicate\";i:76;s:0:\"\";}}}");
INSERT INTO `wp_postmeta` VALUES("1410", "13", "landing_page_main-img", "265");
INSERT INTO `wp_postmeta` VALUES("1411", "265", "_wp_attachment_backup_sizes", "a:1:{s:9:\"full-orig\";a:3:{s:5:\"width\";i:2508;s:6:\"height\";i:1672;s:4:\"file\";s:14:\"31865667_l.jpg\";}}");
INSERT INTO `wp_postmeta` VALUES("1412", "6", "landing_page_main-img", "14");
INSERT INTO `wp_postmeta` VALUES("1413", "6", "landing_page_section-2-bg", "167");
INSERT INTO `wp_postmeta` VALUES("1421", "10", "landing_page_column-2", "<h2>Cena</h2>\n<p>700 zł</p>\n");
INSERT INTO `wp_postmeta` VALUES("1433", "10", "landing_page_main-img", "151");
INSERT INTO `wp_postmeta` VALUES("1434", "10", "gallery_galeria", "157");
INSERT INTO `wp_postmeta` VALUES("1435", "10", "gallery_galeria", "156");
INSERT INTO `wp_postmeta` VALUES("1436", "10", "gallery_galeria", "155");
INSERT INTO `wp_postmeta` VALUES("1437", "10", "gallery_galeria", "154");
INSERT INTO `wp_postmeta` VALUES("1438", "10", "gallery_galeria", "153");
INSERT INTO `wp_postmeta` VALUES("1440", "266", "_wp_attached_file", "2017/11/power-brain2.jpg");
INSERT INTO `wp_postmeta` VALUES("1441", "266", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1728;s:6:\"height\";i:800;s:4:\"file\";s:24:\"2017/11/power-brain2.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"power-brain2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"power-brain2-300x139.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:139;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:24:\"power-brain2-768x356.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:356;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:25:\"power-brain2-1024x474.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:474;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1449", "207", "landing_page_section-2a-input-1", "<p>Jak działa ludzki mózg</p>\n");
INSERT INTO `wp_postmeta` VALUES("1450", "207", "landing_page_section-2a-input-2", "<p>Jak zarządzać swoim mózgiem</p>\n");
INSERT INTO `wp_postmeta` VALUES("1451", "207", "landing_page_section-2a-input-3", "<p>Jak zmienić swoje nawyki</p>\n");
INSERT INTO `wp_postmeta` VALUES("1454", "267", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1455", "267", "_edit_lock", "1513069501:1");
INSERT INTO `wp_postmeta` VALUES("1458", "207", "landing_page_main-img", "266");
INSERT INTO `wp_postmeta` VALUES("1459", "243", "landing_page_main-img", "158");
INSERT INTO `wp_postmeta` VALUES("1460", "269", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1461", "269", "_edit_lock", "1512746530:1");
INSERT INTO `wp_postmeta` VALUES("1462", "269", "testimonials_zawod", "Artysta");
INSERT INTO `wp_postmeta` VALUES("1463", "269", "testimonials_opinia", "<p>Moja praca to malowanie na jedwabiu. Aby wykonać swoją pracę dobrze, konieczna jest pewna i spokojna ręka, oraz rozluźniony umysł i ciało. Trening Body and Brain poprawił  sprawność moich dłoni. Jestem zadowolona z wyników mojej pracy.</p>\n");
INSERT INTO `wp_postmeta` VALUES("1464", "269", "testimonials_home_page", "0");
INSERT INTO `wp_postmeta` VALUES("1465", "270", "_wp_attached_file", "2017/12/Mira-Rodacka-e1512746175270.jpg");
INSERT INTO `wp_postmeta` VALUES("1466", "270", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:844;s:6:\"height\";i:1500;s:4:\"file\";s:39:\"2017/12/Mira-Rodacka-e1512746175270.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:39:\"Mira-Rodacka-e1512746175270-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:39:\"Mira-Rodacka-e1512746175270-169x300.jpg\";s:5:\"width\";i:169;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:40:\"Mira-Rodacka-e1512746175270-768x1365.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1365;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:40:\"Mira-Rodacka-e1512746175270-576x1024.jpg\";s:5:\"width\";i:576;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"F3311\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1510825920\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"3.5\";s:3:\"iso\";s:3:\"525\";s:13:\"shutter_speed\";s:8:\"0.030004\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"6\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1467", "270", "_wp_attachment_backup_sizes", "a:6:{s:9:\"full-orig\";a:3:{s:5:\"width\";i:4096;s:6:\"height\";i:2304;s:4:\"file\";s:16:\"Mira-Rodacka.jpg\";}s:18:\"full-1512746175270\";a:3:{s:5:\"width\";i:1500;s:6:\"height\";i:844;s:4:\"file\";s:31:\"Mira-Rodacka-e1512746167656.jpg\";}s:14:\"thumbnail-orig\";a:4:{s:4:\"file\";s:24:\"Mira-Rodacka-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"medium-orig\";a:4:{s:4:\"file\";s:24:\"Mira-Rodacka-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:17:\"medium_large-orig\";a:4:{s:4:\"file\";s:24:\"Mira-Rodacka-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"large-orig\";a:4:{s:4:\"file\";s:25:\"Mira-Rodacka-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}}");
INSERT INTO `wp_postmeta` VALUES("1468", "269", "_thumbnail_id", "271");
INSERT INTO `wp_postmeta` VALUES("1469", "271", "_wp_attached_file", "2017/12/Mira-Rodacka-1-e1512746471322.jpg");
INSERT INTO `wp_postmeta` VALUES("1470", "271", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:150;s:6:\"height\";i:146;s:4:\"file\";s:41:\"2017/12/Mira-Rodacka-1-e1512746471322.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"Mira-Rodacka-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"Mira-Rodacka-1-300x292.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:292;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"Mira-Rodacka-1-768x748.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:748;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:27:\"Mira-Rodacka-1-1024x998.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:998;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"F3311\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1510825920\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"3.5\";s:3:\"iso\";s:3:\"525\";s:13:\"shutter_speed\";s:8:\"0.030004\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1471", "271", "_wp_attachment_backup_sizes", "a:5:{s:9:\"full-orig\";a:3:{s:5:\"width\";i:2185;s:6:\"height\";i:2129;s:4:\"file\";s:18:\"Mira-Rodacka-1.jpg\";}s:18:\"full-1512746405378\";a:3:{s:5:\"width\";i:1000;s:6:\"height\";i:974;s:4:\"file\";s:33:\"Mira-Rodacka-1-e1512746371705.jpg\";}s:18:\"full-1512746430161\";a:3:{s:5:\"width\";i:500;s:6:\"height\";i:487;s:4:\"file\";s:33:\"Mira-Rodacka-1-e1512746405378.jpg\";}s:18:\"full-1512746452698\";a:3:{s:5:\"width\";i:400;s:6:\"height\";i:390;s:4:\"file\";s:33:\"Mira-Rodacka-1-e1512746430161.jpg\";}s:18:\"full-1512746471322\";a:3:{s:5:\"width\";i:250;s:6:\"height\";i:244;s:4:\"file\";s:33:\"Mira-Rodacka-1-e1512746452698.jpg\";}}");
INSERT INTO `wp_postmeta` VALUES("1472", "269", "testimonials_opinia_krotka", "<p>Trening Body and Brain poprawił  sprawność moich dłoni. Jestem zadowolona z wyników mojej pracy.</p>\n");
INSERT INTO `wp_postmeta` VALUES("1473", "274", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1474", "274", "_edit_lock", "1513069524:1");
INSERT INTO `wp_postmeta` VALUES("1476", "274", "landing_page_section-active-1", "1");
INSERT INTO `wp_postmeta` VALUES("1477", "274", "landing_page_section-active-1a", "1");
INSERT INTO `wp_postmeta` VALUES("1478", "274", "landing_page_section-active-2", "1");
INSERT INTO `wp_postmeta` VALUES("1479", "274", "landing_page_healinglife", "0");
INSERT INTO `wp_postmeta` VALUES("1480", "274", "landing_page_section-active-2a", "1");
INSERT INTO `wp_postmeta` VALUES("1481", "274", "landing_page_slide-title", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("1482", "274", "landing_page_slide-desc", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("1501", "278", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1502", "278", "_edit_lock", "1513086039:1");
INSERT INTO `wp_postmeta` VALUES("1507", "278", "_thumbnail_id", "263");
INSERT INTO `wp_postmeta` VALUES("1517", "281", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1518", "281", "_edit_lock", "1513074506:1");
INSERT INTO `wp_postmeta` VALUES("1521", "281", "_thumbnail_id", "218");
INSERT INTO `wp_postmeta` VALUES("1526", "283", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1527", "283", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1528", "283", "_menu_item_object_id", "274");
INSERT INTO `wp_postmeta` VALUES("1529", "283", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1530", "283", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1531", "283", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1532", "283", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1533", "283", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1535", "287", "_wp_attached_file", "2017/12/banner_pepek_1.jpg");
INSERT INTO `wp_postmeta` VALUES("1536", "287", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:900;s:4:\"file\";s:26:\"2017/12/banner_pepek_1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"banner_pepek_1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"banner_pepek_1-300x141.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:141;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"banner_pepek_1-768x360.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:27:\"banner_pepek_1-1024x480.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1537", "286", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1539", "286", "_edit_lock", "1513094168:1");
INSERT INTO `wp_postmeta` VALUES("1541", "286", "slider-link", "6");
INSERT INTO `wp_postmeta` VALUES("1542", "288", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1543", "288", "_edit_lock", "1513094470:1");
INSERT INTO `wp_postmeta` VALUES("1544", "289", "_wp_attached_file", "2017/12/banner_masaz_uniwersalny.jpg");
INSERT INTO `wp_postmeta` VALUES("1545", "289", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:900;s:4:\"file\";s:36:\"2017/12/banner_masaz_uniwersalny.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"banner_masaz_uniwersalny-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"banner_masaz_uniwersalny-300x141.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:141;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:36:\"banner_masaz_uniwersalny-768x360.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:37:\"banner_masaz_uniwersalny-1024x480.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fiat_thumb\";a:4:{s:4:\"file\";s:34:\"banner_masaz_uniwersalny-60x60.jpg\";s:5:\"width\";i:60;s:6:\"height\";i:60;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1547", "290", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1548", "290", "_edit_lock", "1513094307:1");
INSERT INTO `wp_postmeta` VALUES("1549", "291", "_wp_attached_file", "2017/12/banner.jpg");
INSERT INTO `wp_postmeta` VALUES("1550", "291", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:900;s:4:\"file\";s:18:\"2017/12/banner.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"banner-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"banner-300x141.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:141;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:18:\"banner-768x360.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:19:\"banner-1024x480.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fiat_thumb\";a:4:{s:4:\"file\";s:16:\"banner-60x60.jpg\";s:5:\"width\";i:60;s:6:\"height\";i:60;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1554", "286", "slider-image", "287");
INSERT INTO `wp_postmeta` VALUES("1562", "278", "_wp_old_slug", "lorem-ipsum");
INSERT INTO `wp_postmeta` VALUES("1563", "278", "gallery_galeria", "265");
INSERT INTO `wp_postmeta` VALUES("1564", "278", "gallery_galeria", "264");
INSERT INTO `wp_postmeta` VALUES("1565", "278", "gallery_galeria", "263");
INSERT INTO `wp_postmeta` VALUES("1571", "267", "_wp_old_slug", "bangapsumnida__trashed");
INSERT INTO `wp_postmeta` VALUES("1573", "288", "slider-link", "239");
INSERT INTO `wp_postmeta` VALUES("1574", "290", "slider-image", "291");
INSERT INTO `wp_postmeta` VALUES("1575", "288", "slider-image", "289");

/* INSERT TABLE DATA: wp_posts */
INSERT INTO `wp_posts` VALUES("1", "1", "2017-10-05 10:42:16", "2017-10-05 10:42:16", "Welcome to WordPress. This is your first post. Edit or delete it, then start writing!", "Hello world!", "", "publish", "open", "open", "", "hello-world", "", "", "2017-10-05 10:42:16", "2017-10-05 10:42:16", "", "0", "http://bnb.testuj.website/?p=1", "0", "post", "", "1");
INSERT INTO `wp_posts` VALUES("2", "1", "2017-10-05 10:42:16", "2017-10-05 10:42:16", "This is an example page. It\'s different from a blog post because it will stay in one place and will show up in your site navigation (in most themes). Most people start with an About page that introduces them to potential site visitors. It might say something like this:\n\n<blockquote>Hi there! I\'m a bike messenger by day, aspiring actor by night, and this is my website. I live in Los Angeles, have a great dog named Jack, and I like pi&#241;a coladas. (And gettin\' caught in the rain.)</blockquote>\n\n...or something like this:\n\n<blockquote>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</blockquote>\n\nAs a new WordPress user, you should go to <a href=\"http://bnb.testuj.website/wp-admin/\">your dashboard</a> to delete this page and create new pages for your content. Have fun!", "Sample Page", "", "trash", "closed", "open", "", "sample-page__trashed", "", "", "2017-11-24 11:05:08", "2017-11-24 11:05:08", "", "0", "http://bnb.testuj.website/?page_id=2", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("6", "1", "2017-10-05 11:14:45", "2017-10-05 11:14:45", "", "Pępek", "", "publish", "closed", "closed", "", "uzdrawianie-przez-pepek-2", "", "", "2017-12-05 11:19:26", "2017-12-05 11:19:26", "", "0", "http://bnb.testuj.website/?post_type=warsztaty&#038;p=6", "0", "warsztaty", "", "0");
INSERT INTO `wp_posts` VALUES("7", "1", "2017-11-15 21:37:32", "2017-11-15 21:37:32", "", "Power Brain Kids", "", "trash", "closed", "closed", "", "power-brain-kids__trashed", "", "", "2017-12-04 10:52:08", "2017-12-04 10:52:08", "", "0", "http://bnb.testuj.website/?post_type=warsztaty&#038;p=7", "0", "warsztaty", "", "0");
INSERT INTO `wp_posts` VALUES("8", "1", "2017-10-05 11:24:44", "2017-10-05 11:24:44", "", "dla_firm_banner_1920x589-1", "", "inherit", "open", "closed", "", "dla_firm_banner_1920x589-1", "", "", "2017-10-05 11:24:44", "2017-10-05 11:24:44", "", "0", "http://bnb.testuj.website/wp-content/uploads/2017/10/dla_firm_banner_1920x589-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("10", "1", "2017-10-05 13:18:01", "2017-10-05 13:18:01", "", "Shimsung", "", "publish", "closed", "closed", "", "shimsung", "", "", "2017-12-05 11:38:16", "2017-12-05 11:38:16", "", "0", "http://bnb.testuj.website/?post_type=warsztaty&#038;p=10", "0", "warsztaty", "", "0");
INSERT INTO `wp_posts` VALUES("11", "1", "2017-10-05 13:19:03", "2017-10-05 13:19:03", "", "Shimsung", "", "inherit", "closed", "closed", "", "10-autosave-v1", "", "", "2017-10-05 13:19:03", "2017-10-05 13:19:03", "", "10", "http://bnb.testuj.website/10-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("12", "1", "2017-10-05 13:19:09", "2017-10-05 13:19:09", "", "wallpaper-bird-of-the-soul-type2-1366x768", "", "inherit", "open", "closed", "", "wallpaper-bird-of-the-soul-type2-1366x768", "", "", "2017-11-13 08:36:23", "2017-11-13 08:36:23", "", "82", "http://bnb.testuj.website/wp-content/uploads/2017/10/wallpaper-bird-of-the-soul-type2-1366x768.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("13", "1", "2017-10-05 13:23:42", "2017-10-05 13:23:42", "", "Uzdrawianie przez pępek", "", "publish", "closed", "closed", "", "uzdrawianie-przez-pepek", "", "", "2017-12-05 11:06:10", "2017-12-05 11:06:10", "", "0", "http://bnb.testuj.website/?post_type=warsztaty&#038;p=13", "0", "warsztaty", "", "0");
INSERT INTO `wp_posts` VALUES("14", "1", "2017-10-05 13:21:14", "2017-10-05 13:21:14", "", "belly-button-healing-gut-cropped", "", "inherit", "open", "closed", "", "belly-button-healing-gut-cropped", "", "", "2017-10-05 13:21:14", "2017-10-05 13:21:14", "", "0", "http://bnb.testuj.website/wp-content/uploads/2017/10/belly-button-healing-gut-cropped.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("15", "1", "2017-10-05 13:49:27", "2017-10-05 13:49:27", "<h1>Zapraszamy do Centrum Zdrowia Naturalnego Body and Brain w Rybniku</h1>\r\nStudio Body &amp; Brain Joga Tai Chi powstało z myślą o wszystkich tych, którzy pragną dla siebie zdrowia i spokoju. Wykorzystując wiedzę i naturalne techniki kreowania wewnętrznej harmonii, stworzyliśmy miejsce, które stało się oazą spokoju i nadziei dla wielu rybniczan, i nie tylko.\r\n\r\nZapraszamy na zajęcia każdą osobę, niezależnie od wieku czy kondycji, aby poprzez delikatny trening ciała i umysłu, mogła ona poczuć w sobie wewnętrzną moc do kreacji i działania.\r\n\r\nCodziennie prowadzimy zajęcia grupowe, indywidualne konsultacje coachingowe oraz warsztaty rozwojowe. Techniki, jakie wykorzystujemy to: joga, tai chi, qi gong, medytacja, ćwiczenia oddechowe i mindfulness.\r\n\r\nCentrum Body &amp; Brain Joga Tai Chi jest wyjątkowym miejscem, gdzie każdy zapisany członek otrzymuje od nas dużo uwagi i koncentracji. Zależy nam na pełnym zadowoleniu naszych studentów, aby mogli oni osiągnąć swoje życiowe cele tj: zdrowe i odporne ciało, spokojny i skoncentrowany umysł, lepsze zarządzanie stresem i emocjami.\r\n\r\nW naszej ofercie znajdziecie aż 16 różnych lekcji w tygodniu, a elastyczny system abonamentowy pozwala na uczestniczenie w każdej wybranej lekcji bez konieczności rezerwacji miejsca.\r\n\r\nZapraszamy wszystkich serdecznie.\r\n\r\nOla i Pete", "Strona główna", "", "publish", "closed", "closed", "", "strona-glowna", "", "", "2017-11-23 12:38:14", "2017-11-23 12:38:14", "", "0", "http://bnb.testuj.website/?page_id=15", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("16", "1", "2017-10-05 13:49:27", "2017-10-05 13:49:27", "", "Strona główna", "", "inherit", "closed", "closed", "", "15-revision-v1", "", "", "2017-10-05 13:49:27", "2017-10-05 13:49:27", "", "15", "http://bnb.testuj.website/15-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("19", "1", "2017-10-14 13:16:36", "2017-10-14 13:16:36", "", "Brygida lat 73", "", "publish", "closed", "closed", "", "brygida-lat-73", "", "", "2017-10-14 14:53:23", "2017-10-14 14:53:23", "", "0", "http://bnb.testuj.website/?post_type=testimonials&#038;p=19", "0", "testimonials", "", "0");
INSERT INTO `wp_posts` VALUES("20", "1", "2017-10-14 13:17:02", "2017-10-14 13:17:02", "", "Sabina Ficek", "", "publish", "closed", "closed", "", "sabina-ficek", "", "", "2017-10-14 14:51:36", "2017-10-14 14:51:36", "", "0", "http://bnb.testuj.website/?post_type=testimonials&#038;p=20", "0", "testimonials", "", "0");
INSERT INTO `wp_posts` VALUES("21", "1", "2017-10-14 13:17:20", "2017-10-14 13:17:20", "", "Eugenia Krakowczyk", "", "publish", "closed", "closed", "", "eugenia-krakowczyk", "", "", "2017-11-13 14:34:25", "2017-11-13 14:34:25", "", "0", "http://bnb.testuj.website/?post_type=testimonials&#038;p=21", "0", "testimonials", "", "0");
INSERT INTO `wp_posts` VALUES("22", "1", "2017-10-14 13:17:39", "2017-10-14 13:17:39", "", "Antonina Tomala", "", "publish", "closed", "closed", "", "antonina-tomala", "", "", "2017-10-14 14:48:40", "2017-10-14 14:48:40", "", "0", "http://bnb.testuj.website/?post_type=testimonials&#038;p=22", "0", "testimonials", "", "0");
INSERT INTO `wp_posts` VALUES("23", "1", "2017-10-14 13:17:57", "2017-10-14 13:17:57", "", "Bank Zachodni WBK", "", "publish", "closed", "closed", "", "bank-zachodni-wbk", "", "", "2017-10-14 14:47:57", "2017-10-14 14:47:57", "", "0", "http://bnb.testuj.website/?post_type=testimonials&#038;p=23", "0", "testimonials", "", "0");
INSERT INTO `wp_posts` VALUES("24", "1", "2017-10-14 13:18:12", "2017-10-14 13:18:12", "", "Karina Adamczyk", "", "publish", "closed", "closed", "", "karina-adamczyk", "", "", "2017-10-14 14:47:35", "2017-10-14 14:47:35", "", "0", "http://bnb.testuj.website/?post_type=testimonials&#038;p=24", "0", "testimonials", "", "0");
INSERT INTO `wp_posts` VALUES("25", "1", "2017-10-14 13:18:48", "2017-10-14 13:18:48", "", "Aneta Koterba", "", "publish", "closed", "closed", "", "aneta-koterba", "", "", "2017-10-14 14:46:58", "2017-10-14 14:46:58", "", "0", "http://bnb.testuj.website/?post_type=testimonials&#038;p=25", "0", "testimonials", "", "0");
INSERT INTO `wp_posts` VALUES("26", "1", "2017-10-14 13:19:08", "2017-10-14 13:19:08", "", "Anna Switka", "", "publish", "closed", "closed", "", "anna-switka", "", "", "2017-10-14 14:45:52", "2017-10-14 14:45:52", "", "0", "http://bnb.testuj.website/?post_type=testimonials&#038;p=26", "0", "testimonials", "", "0");
INSERT INTO `wp_posts` VALUES("27", "1", "2017-10-14 14:45:26", "2017-10-14 14:45:26", "", "Anna_Switka_3_20150731195204", "", "inherit", "open", "closed", "", "anna_switka_3_20150731195204", "", "", "2017-10-14 14:45:26", "2017-10-14 14:45:26", "", "26", "http://bnb.testuj.website/wp-content/uploads/2017/10/Anna_Switka_3_20150731195204.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("28", "1", "2017-10-14 14:46:19", "2017-10-14 14:46:19", "", "Antosia_20161213203942", "", "inherit", "open", "closed", "", "antosia_20161213203942", "", "", "2017-10-14 14:46:19", "2017-10-14 14:46:19", "", "25", "http://bnb.testuj.website/wp-content/uploads/2017/10/Antosia_20161213203942.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("29", "1", "2017-10-14 14:46:53", "2017-10-14 14:46:53", "", "Aneta_Koterba_20160606123813", "", "inherit", "open", "closed", "", "aneta_koterba_20160606123813", "", "", "2017-10-14 14:46:53", "2017-10-14 14:46:53", "", "25", "http://bnb.testuj.website/wp-content/uploads/2017/10/Aneta_Koterba_20160606123813.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("30", "1", "2017-10-14 14:47:29", "2017-10-14 14:47:29", "", "Karina_Adamczyk_20160606123532", "", "inherit", "open", "closed", "", "karina_adamczyk_20160606123532", "", "", "2017-10-14 14:47:29", "2017-10-14 14:47:29", "", "24", "http://bnb.testuj.website/wp-content/uploads/2017/10/Karina_Adamczyk_20160606123532.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("31", "1", "2017-10-14 14:47:53", "2017-10-14 14:47:53", "", "bank-zachodni_20161108122234", "", "inherit", "open", "closed", "", "bank-zachodni_20161108122234", "", "", "2017-10-14 14:47:53", "2017-10-14 14:47:53", "", "23", "http://bnb.testuj.website/wp-content/uploads/2017/10/bank-zachodni_20161108122234.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("32", "1", "2017-10-14 14:49:05", "2017-10-14 14:49:05", "", "Eugenia_Krakowczyk_20161223124844", "", "inherit", "open", "closed", "", "eugenia_krakowczyk_20161223124844", "", "", "2017-10-14 14:49:05", "2017-10-14 14:49:05", "", "21", "http://bnb.testuj.website/wp-content/uploads/2017/10/Eugenia_Krakowczyk_20161223124844.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("33", "1", "2017-10-14 14:51:33", "2017-10-14 14:51:33", "", "Sabina_Ficek_20170225130800", "", "inherit", "open", "closed", "", "sabina_ficek_20170225130800", "", "", "2017-10-14 14:51:33", "2017-10-14 14:51:33", "", "20", "http://bnb.testuj.website/wp-content/uploads/2017/10/Sabina_Ficek_20170225130800.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("34", "1", "2017-10-14 14:53:20", "2017-10-14 14:53:20", "", "Brygida_wwww_20171006143639", "", "inherit", "open", "closed", "", "brygida_wwww_20171006143639", "", "", "2017-10-14 14:53:20", "2017-10-14 14:53:20", "", "19", "http://bnb.testuj.website/wp-content/uploads/2017/10/Brygida_wwww_20171006143639.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("35", "1", "2017-10-14 15:22:25", "2017-10-14 15:22:25", "<h1>Zapraszamy do Centrum Zdrowia Naturalnego Body and Brain w Rybniku</h1>\r\nStudio Body &amp; Brain Joga Tai Chi powstało z myślą o wszystkich tych, którzy pragną dla siebie zdrowia i spokoju. Wykorzystując wiedzę i naturalne techniki kreowania wewnętrznej harmonii, stworzyliśmy miejsce, które stało się oazą spokoju i nadziei dla wielu rybniczan, i nie tylko.\r\n\r\nZapraszamy na zajęcia każdą osobę, niezależnie od wieku czy kondycji, aby poprzez delikatny trening ciała i umysłu, mogła ona poczuć w sobie wewnętrzną moc do kreacji i działania.\r\n\r\nCodziennie prowadzimy zajęcia grupowe, indywidualne konsultacje coachingowe oraz warsztaty rozwojowe. Techniki, jakie wykorzystujemy to: joga, tai chi, qi gong, medytacja, ćwiczenia oddechowe i mindfulness.\r\n\r\nCentrum Body &amp; Brain Joga Tai Chi jest wyjątkowym miejscem, gdzie każdy zapisany członek otrzymuje od nas dużo uwagi i koncentracji. Zależy nam na pełnym zadowoleniu naszych studentów, aby mogli oni osiągnąć swoje życiowe cele tj: zdrowe i odporne ciało, spokojny i skoncentrowany umysł, lepsze zarządzanie stresem i emocjami.\r\n\r\nW naszej ofercie znajdziecie aż 16 różnych lekcji w tygodniu, a elastyczny system abonamentowy pozwala na uczestniczenie w każdej wybranej lekcji bez konieczności rezerwacji miejsca.\r\n\r\nZapraszamy wszystkich serdecznie.\r\n\r\nOla i Pete", "Strona główna", "", "inherit", "closed", "closed", "", "15-revision-v1", "", "", "2017-10-14 15:22:25", "2017-10-14 15:22:25", "", "15", "http://bnb.testuj.website/15-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("40", "1", "2017-10-14 15:50:15", "2017-10-14 15:50:15", "Dołączenie do zespołu 2008", "1_Dolaczenie_do_zespolu_09_2008_20150415125605", "Dołączenie do zespołu 2008", "inherit", "open", "closed", "", "1_dolaczenie_do_zespolu_09_2008_20150415125605", "", "", "2017-10-14 15:53:33", "2017-10-14 15:53:33", "", "0", "http://bnb.testuj.website/wp-content/uploads/2017/10/1_Dolaczenie_do_zespolu_09_2008_20150415125605.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("41", "1", "2017-10-14 15:50:29", "2017-10-14 15:50:29", "ShimSung 2009", "2_ShimSung-Diploma_20150415125605", "ShimSung 2009", "inherit", "open", "closed", "", "2_shimsung-diploma_20150415125605", "", "", "2017-10-14 15:53:51", "2017-10-14 15:53:51", "", "0", "http://bnb.testuj.website/wp-content/uploads/2017/10/2_ShimSung-Diploma_20150415125605.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("42", "1", "2017-10-14 15:51:12", "2017-10-14 15:51:12", "Initial Awakening 2009", "3_Initial-Awakening-Diploma-04_20150415125605", "Initial Awakening 2009", "inherit", "open", "closed", "", "3_initial-awakening-diploma-04_20150415125605", "", "", "2017-10-14 15:54:29", "2017-10-14 15:54:29", "", "0", "http://bnb.testuj.website/wp-content/uploads/2017/10/3_Initial-Awakening-Diploma-04_20150415125605.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("43", "1", "2017-10-14 15:51:13", "2017-10-14 15:51:13", "Human Technogy School 2009", "4_Human-Technogy-School-Diploma-05_20150415125605", "Human Technogy School 2009", "inherit", "open", "closed", "", "4_human-technogy-school-diploma-05_20150415125605", "", "", "2017-10-14 15:54:54", "2017-10-14 15:54:54", "", "0", "http://bnb.testuj.website/wp-content/uploads/2017/10/4_Human-Technogy-School-Diploma-05_20150415125605.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("44", "1", "2017-10-14 15:51:14", "2017-10-14 15:51:14", "Francja 2009", "5_Chun_Hwa_07_2009_20150415125605", "Francja 2009", "inherit", "open", "closed", "", "5_chun_hwa_07_2009_20150415125605", "", "", "2017-10-14 15:55:06", "2017-10-14 15:55:06", "", "0", "http://bnb.testuj.website/wp-content/uploads/2017/10/5_Chun_Hwa_07_2009_20150415125605.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("45", "1", "2017-10-14 15:51:16", "2017-10-14 15:51:16", "Do Tong Londyn 20012", "7_Do_tong_11_2012_20150415125605", "Do Tong Londyn 20012", "inherit", "open", "closed", "", "7_do_tong_11_2012_20150415125605", "", "", "2017-10-14 15:55:54", "2017-10-14 15:55:54", "", "0", "http://bnb.testuj.website/wp-content/uploads/2017/10/7_Do_tong_11_2012_20150415125605.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("46", "1", "2017-10-14 15:51:18", "2017-10-14 15:51:18", "Dahn Master Dyplom", "8_Dahn-Master-Diploma-09_20150415125605", "Dahn Master Dyplom", "inherit", "open", "closed", "", "8_dahn-master-diploma-09_20150415125605", "", "", "2017-10-14 15:57:32", "2017-10-14 15:57:32", "", "0", "http://bnb.testuj.website/wp-content/uploads/2017/10/8_Dahn-Master-Diploma-09_20150415125605.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("47", "1", "2017-10-14 15:51:19", "2017-10-14 15:51:19", "Dahn Master Londyn 2013", "8_Dahn_master_Foto_09_2013_20150415125605", "Dahn Master Londyn 2013", "inherit", "open", "closed", "", "8_dahn_master_foto_09_2013_20150415125605", "", "", "2017-10-14 15:56:16", "2017-10-14 15:56:16", "", "0", "http://bnb.testuj.website/wp-content/uploads/2017/10/8_Dahn_master_Foto_09_2013_20150415125605.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("48", "1", "2017-10-14 15:51:20", "2017-10-14 15:51:20", "Korea 2015", "_A7CE52D49F6E16B2C5590BEC8038FB9EC7515FDD495EE06E01_pimgpsh_thumbnail_win_distr_20160313202517", "Korea 2015", "inherit", "open", "closed", "", "_a7ce52d49f6e16b2c5590bec8038fb9ec7515fdd495ee06e01_pimgpsh_thumbnail_win_distr_20160313202517", "", "", "2017-10-14 15:57:46", "2017-10-14 15:57:46", "", "0", "http://bnb.testuj.website/wp-content/uploads/2017/10/A7CE52D49F6E16B2C5590BEC8038FB9EC7515FDD495EE06E01_pimgpsh_thumbnail_win_distr_20160313202517.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("49", "1", "2017-10-14 15:51:21", "2017-10-14 15:51:21", "Healing Life KIJEK", "bellywand_20170607164716", "Healing Life KIJEK", "inherit", "open", "closed", "", "bellywand_20170607164716", "", "", "2017-10-14 15:59:00", "2017-10-14 15:59:00", "", "0", "http://bnb.testuj.website/wp-content/uploads/2017/10/bellywand_20170607164716.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("50", "1", "2017-10-14 15:51:21", "2017-10-14 15:51:21", "", "joga_seniorAlw_20160310124945", "", "inherit", "open", "closed", "", "joga_senioralw_20160310124945", "", "", "2017-10-14 15:51:21", "2017-10-14 15:51:21", "", "0", "http://bnb.testuj.website/wp-content/uploads/2017/10/joga_seniorAlw_20160310124945.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("51", "1", "2017-10-14 15:51:22", "2017-10-14 15:51:22", "", "joga_seniorAlw_20160310125208", "", "inherit", "open", "closed", "", "joga_senioralw_20160310125208", "", "", "2017-10-14 15:51:22", "2017-10-14 15:51:22", "", "0", "http://bnb.testuj.website/wp-content/uploads/2017/10/joga_seniorAlw_20160310125208.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("52", "1", "2017-10-14 15:51:23", "2017-10-14 15:51:23", "", "joga_seniorAlw_20160313203109", "", "inherit", "open", "closed", "", "joga_senioralw_20160313203109", "", "", "2017-10-14 15:51:23", "2017-10-14 15:51:23", "", "0", "http://bnb.testuj.website/wp-content/uploads/2017/10/joga_seniorAlw_20160313203109.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("53", "1", "2017-10-14 15:51:25", "2017-10-14 15:51:25", "Rybnik 2017 Warsztaty Rozwoju Osobistego", "Shimsung_2017_20170224161916", "Rybnik 2017 Warsztaty Rozwoju Osobistego", "inherit", "open", "closed", "", "shimsung_2017_20170224161916", "", "", "2017-10-14 15:58:42", "2017-10-14 15:58:42", "", "0", "http://bnb.testuj.website/wp-content/uploads/2017/10/Shimsung_2017_20170224161916.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("54", "1", "2017-10-14 15:51:26", "2017-10-14 15:51:26", "Rybnik 2016", "WP_20160305_10_48_34_Rich_small_20160313213152", "Rybnik 2016", "inherit", "open", "closed", "", "wp_20160305_10_48_34_rich_small_20160313213152", "", "", "2017-10-14 15:58:19", "2017-10-14 15:58:19", "", "0", "http://bnb.testuj.website/wp-content/uploads/2017/10/WP_20160305_10_48_34_Rich_small_20160313213152.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("57", "1", "2017-10-16 18:49:49", "2017-10-16 18:49:49", " ", "", "", "publish", "closed", "closed", "", "57", "", "", "2017-12-12 10:31:08", "2017-12-12 10:31:08", "", "0", "http://bnb.testuj.website/?p=57", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("58", "1", "2017-10-16 19:00:32", "2017-10-16 19:00:32", "", "Oferta", "", "publish", "closed", "closed", "", "oferta", "", "", "2017-12-12 10:31:08", "2017-12-12 10:31:08", "", "0", "http://bnb.testuj.website/?p=58", "4", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("59", "1", "2017-10-16 19:00:32", "2017-10-16 19:00:32", "", "Uzdrawianie przez Pępek - Warsztat", "", "publish", "closed", "closed", "", "59", "", "", "2017-12-12 10:31:08", "2017-12-12 10:31:08", "", "0", "http://bnb.testuj.website/?p=59", "7", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("60", "1", "2017-10-16 19:00:32", "2017-10-16 19:00:32", "", "Shimsung - Uwolnij się - Warsztat", "", "publish", "closed", "closed", "", "60", "", "", "2017-12-12 10:31:08", "2017-12-12 10:31:08", "", "0", "http://bnb.testuj.website/?p=60", "8", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("61", "1", "2017-10-16 19:00:32", "2017-10-16 19:00:32", " ", "", "", "publish", "closed", "closed", "", "61", "", "", "2017-12-12 10:31:08", "2017-12-12 10:31:08", "", "0", "http://bnb.testuj.website/?p=61", "3", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("62", "1", "2017-10-16 19:14:47", "2017-10-16 19:14:47", "", "Kontakt", "", "publish", "closed", "closed", "", "kontakt", "", "", "2017-10-16 19:55:59", "2017-10-16 19:55:59", "", "0", "http://bnb.testuj.website/?page_id=62", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("63", "1", "2017-10-16 19:14:47", "2017-10-16 19:14:47", "", "Kontakt", "", "inherit", "closed", "closed", "", "62-revision-v1", "", "", "2017-10-16 19:14:47", "2017-10-16 19:14:47", "", "62", "http://bnb.testuj.website/62-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("64", "1", "2017-10-16 19:15:00", "2017-10-16 19:15:00", " ", "", "", "publish", "closed", "closed", "", "64", "", "", "2017-12-12 10:31:08", "2017-12-12 10:31:08", "", "0", "http://bnb.testuj.website/?p=64", "12", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("65", "1", "2017-10-16 19:16:50", "2017-10-16 19:16:50", "", "Opinie", "", "publish", "closed", "closed", "", "opinie", "", "", "2017-12-12 10:31:08", "2017-12-12 10:31:08", "", "0", "http://bnb.testuj.website/?p=65", "11", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("66", "1", "2017-10-16 20:04:44", "2017-10-16 20:04:44", "<div class=\'pole_all2\'>			\r\n			<div class=\'pole_opis_pop\'>Imię i nazwisko</div>\r\n			<div class=\'pole_pop\'>\r\n    [text* your-name class:pole_in_pop]\r\n</div></div>\r\n\r\n<div class=\'pole_all2\'>			\r\n			<div class=\'pole_opis_pop\'>Twój Email</div>\r\n			<div class=\'pole_pop\'>\r\n    [email* your-email class:pole_in_pop]\r\n</div></div>\r\n<div class=\'pole_all\'>		\r\n			<div class=\'pole_opis2_pop\'>Treść wiadomości</div>\r\n			</div>\r\n			\r\n			<div class=\'pole_all\'>\r\n			<div class=\'pole_area2_pop\'>\r\n    [textarea your-message class:pole_area_pop]\r\n</div>\r\n</div>\r\n[submit class:sprawdz_bt6 \"Wyślij wiadomość >\"]\n1\nWelcome to the VCCW \"[your-subject]\"\n[your-name] <wordpress@bodynbrain.dev>\nvccw@example.com\nFrom: [your-name] <[your-email]>\r\nSubject: [your-subject]\r\n\r\nMessage Body:\r\n[your-message]\r\n\r\n-- \r\nThis e-mail was sent from a contact form on Welcome to the VCCW (http://bnb.testuj.website)\nReply-To: [your-email]\n\n\n\n\nWelcome to the VCCW \"[your-subject]\"\nWelcome to the VCCW <wordpress@bodynbrain.dev>\n[your-email]\nMessage Body:\r\n[your-message]\r\n\r\n-- \r\nThis e-mail was sent from a contact form on Welcome to the VCCW (http://bnb.testuj.website)\nReply-To: vccw@example.com\n\n\n\nThank you for your message. It has been sent.\nThere was an error trying to send your message. Please try again later.\nOne or more fields have an error. Please check and try again.\nThere was an error trying to send your message. Please try again later.\nYou must accept the terms and conditions before sending your message.\nThe field is required.\nThe field is too long.\nThe field is too short.\nThe date format is incorrect.\nThe date is before the earliest one allowed.\nThe date is after the latest one allowed.\nThere was an unknown error uploading the file.\nYou are not allowed to upload files of this type.\nThe file is too big.\nThere was an error uploading the file.\nThe number format is invalid.\nThe number is smaller than the minimum allowed.\nThe number is larger than the maximum allowed.\nThe answer to the quiz is incorrect.\nYour entered code is incorrect.\nThe e-mail address entered is invalid.\nThe URL is invalid.\nThe telephone number is invalid.", "Contact", "", "publish", "closed", "closed", "", "contact-form-1", "", "", "2017-10-16 20:20:28", "2017-10-16 20:20:28", "", "0", "http://bnb.testuj.website/?post_type=wpcf7_contact_form&#038;p=66", "0", "wpcf7_contact_form", "", "0");
INSERT INTO `wp_posts` VALUES("67", "1", "2017-10-16 20:26:10", "2017-10-16 20:26:10", "<div class=\'pole_all2\'>			\r\n			<div class=\'pole_opis_pop\'>Imię i nazwisko</div>\r\n			<div class=\'pole_pop\'>\r\n    [text* your-name class:pole_in_pop]\r\n</div></div>\r\n\r\n<div class=\'pole_all2\'>			\r\n			<div class=\'pole_opis_pop\'>Twój Email</div>\r\n			<div class=\'pole_pop\'>\r\n    [email* your-email class:pole_in_pop]\r\n</div></div>\r\n<div class=\'pole_all\'>		\r\n			<div class=\'pole_opis2_pop\'>Treść wiadomości</div>\r\n			</div>\r\n			\r\n			<div class=\'pole_all\'>\r\n			<div class=\'pole_area2_pop\'>\r\n    [textarea your-message class:pole_area_pop]\r\n</div>\r\n</div>\r\n[submit class:sprawdz_bt6 \"Wyślij wiadomość >\"]\n1\nWiadomość wysłana ze strony Bodynbrain.pl\n[your-name] <wordpress@bnb.testuj.website>\ncentrum@bodynbrain.pl\nNadawca: [your-name] <[your-email]>\r\n\r\nTreść wiadomości:\r\n[your-message]\r\n\r\n-- \r\nTa wiadomość została wysłana przez formularz kontaktowy na stronie Bodynbrain.pl (http://bnb.testuj.website).\nReply-To: [your-email]\n\n\n\n1\nKopia wiadomości do Bodynbrain.pl\nBodynbrain.pl <wordpress@bnb.testuj.website>\n[your-email]\nTreść wiadomości:\r\n[your-message]\r\n\r\n-- \r\nTa wiadomość została wysłana przez formularz kontaktowy na stronie Bodynbrain.pl (http://bnb.testuj.website).\nReply-To: centrum@bodynbrain.pl\n\n\n\nTwoja wiadomość została wysłana. Dziękujemy!\nWystąpił problem z wysłaniem twojej wiadomości. Spróbuj ponownie później.\nPrzynajmniej jedno pole jest błędnie wypełnione. Sprawdź wpisaną treść i spróbuj ponownie.\nWystąpił problem z wysłaniem twojej wiadomości. Spróbuj ponownie później.\nMusisz wyrazić zgodę na powyższe zapisy, aby móc wysłać formularz.\nWymagane jest wypełnienie tego pola.\nZawartość tego pola jest zbyt długa.\nZawartość tego pola jest zbyt krótka.\nFormat daty jest niepoprawny.\nData jest wcześniejsza, niż pierwsza dozwolona.\nData jest późniejsza, niż ostatnia dozwolona.\nPodczas wgrywania pliku wystąpił nieznany błąd.\nNie możesz wgrywać plików tego typu.\nTen plik jest zbyt duży.\nWystąpił błąd podczas wgrywania pliku.\nFormat liczby jest niepoprawny.\nTa liczba jest mniejsza, niż minimalna dopuszczana.\nTa liczba jest większa, niż maksymalna dopuszczalna.\nOdpowiedź w quizie jest nieprawidłowa.\nWpisany kod jest nieprawidłowy.\nWprowadzony adres e-mail jest nieprawidłowy.\nWprowadzony adres URL jest nieprawidłowy.\nWprowadzony numer telefonu jest nieprawidłowy.", "Kontakt", "", "publish", "closed", "closed", "", "kontakt", "", "", "2017-10-28 15:37:31", "2017-10-28 15:37:31", "", "0", "http://bnb.testuj.website/?post_type=wpcf7_contact_form&#038;p=67", "0", "wpcf7_contact_form", "", "0");
INSERT INTO `wp_posts` VALUES("70", "1", "2017-10-18 08:34:37", "2017-10-18 08:34:37", "", "Alicja Śmiałek", "", "publish", "closed", "closed", "", "wojtek-pieczkowski", "", "", "2017-11-12 09:30:27", "2017-11-12 09:30:27", "", "0", "http://bnb.testuj.website/?post_type=testimonials&#038;p=70", "0", "testimonials", "", "0");
INSERT INTO `wp_posts` VALUES("71", "1", "2017-10-18 08:34:10", "2017-10-18 08:34:10", "", "Kasia Nim", "", "inherit", "open", "closed", "", "kasia-nim", "", "", "2017-10-18 08:34:10", "2017-10-18 08:34:10", "", "70", "http://bnb.testuj.website/wp-content/uploads/2017/10/Kasia-Nim.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("72", "1", "2017-10-18 08:42:53", "2017-10-18 08:42:53", "", "Warsztaty", "", "publish", "closed", "closed", "", "warsztaty", "", "", "2017-10-18 08:42:53", "2017-10-18 08:42:53", "", "0", "http://bnb.testuj.website/?page_id=72", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("73", "1", "2017-10-18 08:42:53", "2017-10-18 08:42:53", "", "Warsztaty", "", "inherit", "closed", "closed", "", "72-revision-v1", "", "", "2017-10-18 08:42:53", "2017-10-18 08:42:53", "", "72", "http://bnb.testuj.website/72-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("77", "1", "2017-10-18 09:04:10", "2017-10-18 09:04:10", "", "Ola", "", "inherit", "open", "closed", "", "ola", "", "", "2017-10-18 09:04:10", "2017-10-18 09:04:10", "", "0", "http://bnb.testuj.website/wp-content/uploads/2017/10/Ola.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("78", "1", "2017-10-18 09:05:48", "2017-10-18 09:05:48", "", "DSC_1152", "", "inherit", "open", "closed", "", "dsc_1152", "", "", "2017-10-18 09:05:48", "2017-10-18 09:05:48", "", "0", "http://bnb.testuj.website/wp-content/uploads/2017/10/DSC_1152.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("82", "1", "2017-10-28 13:43:43", "2017-10-28 13:43:43", "<strong>Czym jest masaż Hwal Gong?</strong>\r\n\r\nHwal Gong pochodzi z Korei i oznacza w dosłownym tłumaczeniu \"Dawać Miłość\". Energia Miłości jest najpotężniejszą uzdrawiającą energią, dlatego z przyjemnością oferujemy technikę Hwal Gong w naszym Centrum Body and Brain w Rybniku.\r\n\r\n<strong>Na czym polega masaż Hwal Gong?</strong>\r\n\r\nMasaż odbywa się na podłodze na miękkich matach. Osoba masowana jest w swoim ubraniu, rekomendujemy wygodny strój sportowy np dres lub legginsy. Technika masażu oparta jest na akupresurze pochodzącej z Dalekiego Wschodu. Punkty, które uciskamy i rozmasowujemy odpowiadają punktom energetycznym i meridianom (kanałom, przez które płynie energia Ki). Poziom ucisku dostosowany jest do potrzeb i kondycji osoby, która jest masowana.\r\n\r\n<strong>Ile kosztuje masaż Hwal Gong?</strong>\r\n\r\n30 minut masażu skoncentrowanego na daną część ciała np. kręgosłup; szyja i kark; lub brzuch kosztuje 45 zł\r\n\r\n60 minut masażu całego ciała kosztuje 80 zł (wykonuje go przeszkolony w Londynie masażysta Pete Sabunim)\r\n\r\n60 minut masażu całego ciała, z uwzględnieniem odblokowania emocji i umysłu, kosztuje 150 zł (wykonuje go przeszkolona w Korei Aleksandra Wongjanim)\r\n\r\n<strong>Kiedy można przyjść na masaż Hwal Gong?</strong>\r\n\r\nOferta masażu dostępna jest w naszym centrum od poniedziałku do piątku w godzinach 11.00 - 17.00 i w sobotę w godzinach 11.00 - 13.00. Zapraszamy do kontaktu pod numerem telefonu 887 362 809", "Masaż Hwal Gong", "", "trash", "closed", "closed", "", "masaz-hwal-gong__trashed", "", "", "2017-12-04 12:48:57", "2017-12-04 12:48:57", "", "0", "http://bnb.testuj.website/?post_type=warsztaty&#038;p=82", "0", "warsztaty", "", "0");
INSERT INTO `wp_posts` VALUES("83", "1", "2017-10-28 14:22:05", "2017-10-28 14:22:05", "", "DSC_0001_w_20170525125122", "", "inherit", "open", "closed", "", "dsc_0001_w_20170525125122", "", "", "2017-10-28 14:22:05", "2017-10-28 14:22:05", "", "82", "http://bnb.testuj.website/wp-content/uploads/2017/10/DSC_0001_w_20170525125122.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("84", "1", "2017-10-28 14:22:06", "2017-10-28 14:22:06", "", "DSC_0002_w_20170525125214", "", "inherit", "open", "closed", "", "dsc_0002_w_20170525125214", "", "", "2017-10-28 14:22:06", "2017-10-28 14:22:06", "", "82", "http://bnb.testuj.website/wp-content/uploads/2017/10/DSC_0002_w_20170525125214.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("85", "1", "2017-10-28 14:22:07", "2017-10-28 14:22:07", "", "DSC_0003_w_20170525125302", "", "inherit", "open", "closed", "", "dsc_0003_w_20170525125302", "", "", "2017-10-28 14:22:07", "2017-10-28 14:22:07", "", "82", "http://bnb.testuj.website/wp-content/uploads/2017/10/DSC_0003_w_20170525125302.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("86", "1", "2017-10-28 14:22:07", "2017-10-28 14:22:07", "", "DSC_0004_w_20170525125345", "", "inherit", "open", "closed", "", "dsc_0004_w_20170525125345", "", "", "2017-10-28 14:22:07", "2017-10-28 14:22:07", "", "82", "http://bnb.testuj.website/wp-content/uploads/2017/10/DSC_0004_w_20170525125345.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("87", "1", "2017-10-28 14:22:08", "2017-10-28 14:22:08", "", "DSC_2360_w_20170525125452", "", "inherit", "open", "closed", "", "dsc_2360_w_20170525125452", "", "", "2017-10-28 14:22:08", "2017-10-28 14:22:08", "", "82", "http://bnb.testuj.website/wp-content/uploads/2017/10/DSC_2360_w_20170525125452.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("88", "1", "2017-10-28 14:22:09", "2017-10-28 14:22:09", "", "DSC_2379_w_20170525124411", "", "inherit", "open", "closed", "", "dsc_2379_w_20170525124411", "", "", "2017-10-28 14:22:09", "2017-10-28 14:22:09", "", "82", "http://bnb.testuj.website/wp-content/uploads/2017/10/DSC_2379_w_20170525124411.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("90", "1", "2017-10-28 14:41:48", "2017-10-28 14:41:48", "<h3>Centrum Body and Brain to Centrum Zdrowia Naturalnego. Podczas ćwiczeń z nami nauczysz się, jak lepiej zadbać o swoje zdrowie fizyczne, psychiczne i emocjonalne.</h3>\r\n&nbsp;\r\n\r\nZajęcia w Centrum Body &amp; Brain to połączenie:\r\n\r\n&nbsp;\r\n\r\n+ Tradycyjnych form usprawniających przepływ energii: joga, tai chi, qi gong, medytacja, ćwiczenia oddechowe\r\n\r\n&nbsp;\r\n\r\n+ Najnowszych naukowo potwierdzonych metod, które wpływają na poprawę pracy mózgu: Edukacja Mózgu, Healing Life, Wibracja Fal Mózgowych\r\n\r\n&nbsp;\r\n\r\nCodziennie odbywają się lekcje grupowe, podczas których będziesz miał możliwość poczuć swoje ciało i usprawnić jego kondycję, przy jednoczesnym pełnym  uwolnieniu skumulowanego stresu.\r\n\r\nEfektywność - już po pierwszych zajęciach poczujesz się lepiej.\r\n\r\nElastyczność – wykorzystujesz wykupiony abonament w dogodnym dla siebie terminie, bez konieczności rezerwacji miejsca (trening odbywa się zawsze niezależnie od liczby uczestników).\r\n\r\nDostępność – zajęcia odbywają się codziennie rano, po południu i wieczorem. Zapraszamy wszystkich niezależnie od stanu zdrowia i kondycji.\r\n\r\nJak rozpocząć?\r\n\r\nAby przystąpić do grupy najlepiej najpierw umówić się na spotkanie wprowadzające pod numerem telefonu 887 362 809 lub mailem <a href=\"http://bnb.testuj.website/rezerwacja-terminu/\">Umów się na Spotkanie</a>\r\n\r\nW trakcie spotkania zapoznasz się z grafikiem zajęć, a instruktor, po sprawdzeniu Twojej kondycji i potrzeb, zarekomenduje Tobie lekcje, które najbardziej  będą odpowiadały Twoim potrzebom. Na miejscu też otrzymasz najlepszą ofertę cenową.\r\n\r\n&nbsp;\r\n\r\n&nbsp;", "Ćwiczenia dla dorosłych", "", "trash", "closed", "closed", "", "cwiczenia-dla-doroslych__trashed", "", "", "2017-12-04 12:48:57", "2017-12-04 12:48:57", "", "0", "http://bnb.testuj.website/?post_type=warsztaty&#038;p=90", "0", "warsztaty", "", "0");
INSERT INTO `wp_posts` VALUES("91", "1", "2017-10-28 14:39:05", "2017-10-28 14:39:05", "", "grafik", "", "inherit", "open", "closed", "", "grafik", "", "", "2017-10-28 14:39:05", "2017-10-28 14:39:05", "", "90", "http://bnb.testuj.website/wp-content/uploads/2017/10/grafik.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("92", "1", "2017-10-28 14:41:31", "2017-10-28 14:41:31", "", "3 seg", "", "inherit", "open", "closed", "", "3-seg", "", "", "2017-10-28 14:41:31", "2017-10-28 14:41:31", "", "90", "http://bnb.testuj.website/wp-content/uploads/2017/10/3-seg.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("95", "1", "2017-10-28 14:50:06", "2017-10-28 14:50:06", "Zapraszamy młodzież od 13-tego roku życia na\r\n\r\nzajęcia Power Brain Students\r\n\r\nKażda Środa 15.15\r\n\r\nSala Korekcyjna Zespół Szkół nr 3 w Rybniku ul. Orzepowicka 15\r\n\r\nKontakt: 536 238 346\r\n\r\n[w roku szkolnym 2017/2018 - zajęcia są nieodpłatne]\r\n\r\nNAUCZ SIĘ RADZIĆ SOBIE Z EMOCJAMI I STRESEM\r\n\r\nPOPRAW PAMIĘĆ I KONCENTRACJĘ\r\n\r\nMATURA BEZ STRESU\r\n\r\n<img class=\"alignnone wp-image-96\" src=\"http://bnb.testuj.website/wp-content/uploads/2017/10/Szkola_20171005100641-300x181.jpg\" alt=\"\" width=\"600\" height=\"362\" />", "Zajęcia dla młodzieży", "", "trash", "closed", "closed", "", "zajecia-dla-dzieci__trashed", "", "", "2017-12-04 11:19:45", "2017-12-04 11:19:45", "", "0", "http://bnb.testuj.website/?post_type=warsztaty&#038;p=95", "0", "warsztaty", "", "0");
INSERT INTO `wp_posts` VALUES("96", "1", "2017-10-28 14:49:38", "2017-10-28 14:49:38", "", "Szkola_20171005100641", "", "inherit", "open", "closed", "", "szkola_20171005100641", "", "", "2017-10-28 14:49:38", "2017-10-28 14:49:38", "", "95", "http://bnb.testuj.website/wp-content/uploads/2017/10/Szkola_20171005100641.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("100", "1", "2017-10-28 15:39:56", "2017-10-28 15:39:56", "<h2 class=\"b_nag_of\">POLITYKA PRYWATNOŚCI</h2>\r\n<div class=\"b_tresc\">\r\n<h1>Polityka prywatności serwisu www.bodynbrain.pl</h1>\r\n1. Informacje ogólne.\r\n<ol>\r\n 	<li>Operatorem Serwisu www.olamason.pl jest Body and Brain Polska Peter Mckay Mason ul. Sobieskiego 19 a /4, 44-200 Rybnik</li>\r\n 	<li>Serwis realizuje funkcje pozyskiwania informacji o użytkownikach i ich zachowaniu w następujący sposób:\r\n<ol>\r\n 	<li>Poprzez dobrowolnie wprowadzone w formularzach informacje.</li>\r\n 	<li>Poprzez zapisywanie w urządzeniach końcowych pliki cookie (tzw. \"ciasteczka\").</li>\r\n</ol>\r\n</li>\r\n</ol>\r\n<h3>2. Informacje w formularzach.</h3>\r\n<ol>\r\n 	<li>Serwis zbiera informacje podane dobrowolnie przez użytkownika.</li>\r\n 	<li>Serwis może zapisać ponadto informacje o parametrach połączenia (oznaczenie czasu, adres IP)</li>\r\n 	<li>Dane w formularzu nie są udostępniane podmiotom trzecim inaczej, niż za dodatkową zgodą użytkownika.</li>\r\n 	<li>Dane podane w formularzu mogą stanowić zbiór potencjalnych klientów, zarejestrowany przez Operatora Serwisu w rejestrze prowadzonym przez Generalnego Inspektora Ochrony Danych Osobowych.</li>\r\n 	<li>Dane podane w formularzu są przetwarzane w celu wynikającym z funkcji formularza tj. w celu kontaktu handlowego.</li>\r\n</ol>\r\n<h3>3. Informacja o plikach cookies.</h3>\r\n<ol>\r\n 	<li>Serwis korzysta z plików cookies.</li>\r\n 	<li>Pliki cookies (tzw. „ciasteczka”) stanowią dane informatyczne, w szczególności pliki tekstowe, które przechowywane są w urządzeniu końcowym Użytkownika Serwisu i przeznaczone są do korzystania ze stron internetowych Serwisu. Cookies zazwyczaj zawierają nazwę strony internetowej, z której pochodzą, czas przechowywania ich na urządzeniu końcowym oraz unikalny numer.</li>\r\n 	<li>Podmiotem zamieszczającym na urządzeniu końcowym Użytkownika Serwisu pliki cookies oraz uzyskującym do nich dostęp jest operator Serwisu.</li>\r\n 	<li>Pliki cookies wykorzystywane są w następujących celach:\r\n<ol>\r\n 	<li>tworzenia statystyk, które pomagają zrozumieć, w jaki sposób Użytkownicy Serwisu korzystają ze stron internetowych, co umożliwia ulepszanie ich struktury i zawartości;</li>\r\n 	<li>określania profilu użytkownika w celu wyświetlania mu dopasowanych materiałów w sieciach reklamowych, w szczególności sieci Google.</li>\r\n</ol>\r\n</li>\r\n 	<li>W ramach Serwisu stosowane są dwa zasadnicze rodzaje plików cookies: „sesyjne” (session cookies) oraz „stałe” (persistent cookies). Cookies „sesyjne” są plikami tymczasowymi, które przechowywane są w urządzeniu końcowym Użytkownika do czasu wylogowania, opuszczenia strony internetowej lub wyłączenia oprogramowania (przeglądarki internetowej). „Stałe” pliki cookies przechowywane są w urządzeniu końcowym Użytkownika przez czas określony w parametrach plików cookies lub do czasu ich usunięcia przez Użytkownika.</li>\r\n 	<li>Oprogramowanie do przeglądania stron internetowych (przeglądarka internetowa) zazwyczaj domyślnie dopuszcza przechowywanie plików cookies w urządzeniu końcowym Użytkownika. Użytkownicy Serwisu mogą dokonać zmiany ustawień w tym zakresie. Przeglądarka internetowa umożliwia usunięcie plików cookies. Możliwe jest także automatyczne blokowanie plików cookies Szczegółowe informacje na ten temat zawiera pomoc lub dokumentacja przeglądarki internetowej.</li>\r\n 	<li>Ograniczenia stosowania plików cookies mogą wpłynąć na niektóre funkcjonalności dostępne na stronach internetowych Serwisu.</li>\r\n 	<li>Pliki cookies zamieszczane w urządzeniu końcowym Użytkownika Serwisu i wykorzystywane mogą być również przez współpracujących z operatorem Serwisu reklamodawców oraz partnerów.</li>\r\n 	<li>Zalecamy przeczytanie polityki ochrony prywatności tych firm, aby poznać zasady korzystania z plików cookie wykorzystywane w statystykach: <a href=\"http://www.google.pl/intl/pl/analytics/privacyoverview.html\">Polityka ochrony prywatności Google Analytics</a></li>\r\n 	<li>Pliki cookie mogą być wykorzystane przez sieci reklamowe, w szczególności sieć Google, do wyświetlenia reklam dopasowanych do sposobu, w jaki użytkownik korzysta z Serwisu. W tym celu mogą zachować informację o ścieżce nawigacji użytkownika lub czasie pozostawania na danej stronie.</li>\r\n 	<li>W zakresie informacji o preferencjach użytkownika gromadzonych przez sieć reklamową Google użytkownik może przeglądać i edytować informacje wynikające z plików cookies przy pomocy narzędzia: <a href=\"https://www.google.com/ads/preferences/\">https://www.google.com/ads/preferences/</a></li>\r\n</ol>\r\n<h3>4. Logi serwera.</h3>\r\n<ol>\r\n 	<li>Informacje o niektórych zachowaniach użytkowników podlegają logowaniu w warstwie serwerowej. Dane te są wykorzystywane wyłącznie w celu administrowania serwisem oraz w celu zapewnienia jak najbardziej sprawnej obsługi świadczonych usług hostingowych.</li>\r\n 	<li>Przeglądane zasoby identyfikowane są poprzez adresy URL. Ponadto zapisowi mogą podlegać:\r\n<ol>\r\n 	<li>czas nadejścia zapytania,</li>\r\n 	<li>czas wysłania odpowiedzi,</li>\r\n 	<li>nazwę stacji klienta – identyfikacja realizowana przez protokół HTTP,</li>\r\n 	<li>informacje o błędach jakie nastąpiły przy realizacji transakcji HTTP,</li>\r\n 	<li>adres URL strony poprzednio odwiedzanej przez użytkownika (referer link) – w przypadku gdy przejście do Serwisu nastąpiło przez odnośnik,</li>\r\n 	<li>informacje o przeglądarce użytkownika,</li>\r\n 	<li>Informacje o adresie IP.</li>\r\n</ol>\r\n</li>\r\n 	<li>Dane powyższe nie są kojarzone z konkretnymi osobami przeglądającymi strony.</li>\r\n 	<li>Dane powyższe są wykorzystywane jedynie dla celów administrowania serwerem.</li>\r\n</ol>\r\n<h3>5. Udostępnienie danych.</h3>\r\n<ol>\r\n 	<li>Dane podlegają udostępnieniu podmiotom zewnętrznym wyłącznie w granicach prawnie dozwolonych.</li>\r\n 	<li>Dane umożliwiające identyfikację osoby fizycznej są udostępniane wyłączenie za zgodą tej osoby.</li>\r\n 	<li>Operator może mieć obowiązek udzielania informacji zebranych przez Serwis upoważnionym organom na podstawie zgodnych z prawem żądań w zakresie wynikającym z żądania.</li>\r\n</ol>\r\n<h3>6. Zarządzanie plikami cookies – jak w praktyce wyrażać i cofać zgodę?</h3>\r\n<ol>\r\n 	<li>Jeśli użytkownik nie chce otrzymywać plików cookies, może zmienić ustawienia przeglądarki. Zastrzegamy, że wyłączenie obsługi plików cookies niezbędnych dla procesów uwierzytelniania, bezpieczeństwa, utrzymania preferencji użytkownika może utrudnić, a w skrajnych przypadkach może uniemożliwić korzystanie ze stron www</li>\r\n 	<li>W celu zarządzania ustawieniami cookies wybierz z listy poniżej przeglądarkę internetową/ system i postępuj zgodnie z instrukcjami:\r\n<ol>\r\n 	<li><a href=\"http://support.microsoft.com/kb/196955\">Internet Explorer</a></li>\r\n 	<li><a href=\"http://support.google.com/chrome/bin/answer.py?hl=pl&amp;answer=95647\">Chrome</a></li>\r\n 	<li><a href=\"http://support.apple.com/kb/PH5042\">Safari</a></li>\r\n 	<li><a href=\"http://support.mozilla.org/pl/kb/W{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}C5{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}82{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}C4{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}85czanie{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}20i{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}20wy{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}C5{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}82{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}C4{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}85czanie{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}20obs{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}C5{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}82ugi{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}20ciasteczek\">Firefox</a></li>\r\n 	<li><a href=\"http://help.opera.com/Windows/12.10/pl/cookies.html\">Opera</a></li>\r\n 	<li><a href=\"http://support.google.com/chrome/bin/answer.py?hl=pl&amp;answer=95647\">Android</a></li>\r\n 	<li><a href=\"http://support.apple.com/kb/HT1677?viewlocale=pl_PL\">Safari (iOS)</a></li>\r\n 	<li><a href=\"http://www.windowsphone.com/pl-pl/how-to/wp7/web/changing-privacy-and-other-browser-settings\">Windows Phone</a></li>\r\n 	<li><a href=\"http://docs.blackberry.com/en/smartphone_users/deliverables/32004/Turn_off_cookies_in_the_browser_60_1072866_11.jsp\">Blackberry</a></li>\r\n</ol>\r\n</li>\r\n</ol>\r\n</div>", "Polityka prywatności", "", "publish", "closed", "closed", "", "polityka-prywatnosci", "", "", "2017-10-28 15:39:56", "2017-10-28 15:39:56", "", "0", "http://bnb.testuj.website/?page_id=100", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("101", "1", "2017-10-28 15:39:56", "2017-10-28 15:39:56", "<h2 class=\"b_nag_of\">POLITYKA PRYWATNOŚCI</h2>\r\n<div class=\"b_tresc\">\r\n<h1>Polityka prywatności serwisu www.bodynbrain.pl</h1>\r\n1. Informacje ogólne.\r\n<ol>\r\n 	<li>Operatorem Serwisu www.olamason.pl jest Body and Brain Polska Peter Mckay Mason ul. Sobieskiego 19 a /4, 44-200 Rybnik</li>\r\n 	<li>Serwis realizuje funkcje pozyskiwania informacji o użytkownikach i ich zachowaniu w następujący sposób:\r\n<ol>\r\n 	<li>Poprzez dobrowolnie wprowadzone w formularzach informacje.</li>\r\n 	<li>Poprzez zapisywanie w urządzeniach końcowych pliki cookie (tzw. \"ciasteczka\").</li>\r\n</ol>\r\n</li>\r\n</ol>\r\n<h3>2. Informacje w formularzach.</h3>\r\n<ol>\r\n 	<li>Serwis zbiera informacje podane dobrowolnie przez użytkownika.</li>\r\n 	<li>Serwis może zapisać ponadto informacje o parametrach połączenia (oznaczenie czasu, adres IP)</li>\r\n 	<li>Dane w formularzu nie są udostępniane podmiotom trzecim inaczej, niż za dodatkową zgodą użytkownika.</li>\r\n 	<li>Dane podane w formularzu mogą stanowić zbiór potencjalnych klientów, zarejestrowany przez Operatora Serwisu w rejestrze prowadzonym przez Generalnego Inspektora Ochrony Danych Osobowych.</li>\r\n 	<li>Dane podane w formularzu są przetwarzane w celu wynikającym z funkcji formularza tj. w celu kontaktu handlowego.</li>\r\n</ol>\r\n<h3>3. Informacja o plikach cookies.</h3>\r\n<ol>\r\n 	<li>Serwis korzysta z plików cookies.</li>\r\n 	<li>Pliki cookies (tzw. „ciasteczka”) stanowią dane informatyczne, w szczególności pliki tekstowe, które przechowywane są w urządzeniu końcowym Użytkownika Serwisu i przeznaczone są do korzystania ze stron internetowych Serwisu. Cookies zazwyczaj zawierają nazwę strony internetowej, z której pochodzą, czas przechowywania ich na urządzeniu końcowym oraz unikalny numer.</li>\r\n 	<li>Podmiotem zamieszczającym na urządzeniu końcowym Użytkownika Serwisu pliki cookies oraz uzyskującym do nich dostęp jest operator Serwisu.</li>\r\n 	<li>Pliki cookies wykorzystywane są w następujących celach:\r\n<ol>\r\n 	<li>tworzenia statystyk, które pomagają zrozumieć, w jaki sposób Użytkownicy Serwisu korzystają ze stron internetowych, co umożliwia ulepszanie ich struktury i zawartości;</li>\r\n 	<li>określania profilu użytkownika w celu wyświetlania mu dopasowanych materiałów w sieciach reklamowych, w szczególności sieci Google.</li>\r\n</ol>\r\n</li>\r\n 	<li>W ramach Serwisu stosowane są dwa zasadnicze rodzaje plików cookies: „sesyjne” (session cookies) oraz „stałe” (persistent cookies). Cookies „sesyjne” są plikami tymczasowymi, które przechowywane są w urządzeniu końcowym Użytkownika do czasu wylogowania, opuszczenia strony internetowej lub wyłączenia oprogramowania (przeglądarki internetowej). „Stałe” pliki cookies przechowywane są w urządzeniu końcowym Użytkownika przez czas określony w parametrach plików cookies lub do czasu ich usunięcia przez Użytkownika.</li>\r\n 	<li>Oprogramowanie do przeglądania stron internetowych (przeglądarka internetowa) zazwyczaj domyślnie dopuszcza przechowywanie plików cookies w urządzeniu końcowym Użytkownika. Użytkownicy Serwisu mogą dokonać zmiany ustawień w tym zakresie. Przeglądarka internetowa umożliwia usunięcie plików cookies. Możliwe jest także automatyczne blokowanie plików cookies Szczegółowe informacje na ten temat zawiera pomoc lub dokumentacja przeglądarki internetowej.</li>\r\n 	<li>Ograniczenia stosowania plików cookies mogą wpłynąć na niektóre funkcjonalności dostępne na stronach internetowych Serwisu.</li>\r\n 	<li>Pliki cookies zamieszczane w urządzeniu końcowym Użytkownika Serwisu i wykorzystywane mogą być również przez współpracujących z operatorem Serwisu reklamodawców oraz partnerów.</li>\r\n 	<li>Zalecamy przeczytanie polityki ochrony prywatności tych firm, aby poznać zasady korzystania z plików cookie wykorzystywane w statystykach: <a href=\"http://www.google.pl/intl/pl/analytics/privacyoverview.html\">Polityka ochrony prywatności Google Analytics</a></li>\r\n 	<li>Pliki cookie mogą być wykorzystane przez sieci reklamowe, w szczególności sieć Google, do wyświetlenia reklam dopasowanych do sposobu, w jaki użytkownik korzysta z Serwisu. W tym celu mogą zachować informację o ścieżce nawigacji użytkownika lub czasie pozostawania na danej stronie.</li>\r\n 	<li>W zakresie informacji o preferencjach użytkownika gromadzonych przez sieć reklamową Google użytkownik może przeglądać i edytować informacje wynikające z plików cookies przy pomocy narzędzia: <a href=\"https://www.google.com/ads/preferences/\">https://www.google.com/ads/preferences/</a></li>\r\n</ol>\r\n<h3>4. Logi serwera.</h3>\r\n<ol>\r\n 	<li>Informacje o niektórych zachowaniach użytkowników podlegają logowaniu w warstwie serwerowej. Dane te są wykorzystywane wyłącznie w celu administrowania serwisem oraz w celu zapewnienia jak najbardziej sprawnej obsługi świadczonych usług hostingowych.</li>\r\n 	<li>Przeglądane zasoby identyfikowane są poprzez adresy URL. Ponadto zapisowi mogą podlegać:\r\n<ol>\r\n 	<li>czas nadejścia zapytania,</li>\r\n 	<li>czas wysłania odpowiedzi,</li>\r\n 	<li>nazwę stacji klienta – identyfikacja realizowana przez protokół HTTP,</li>\r\n 	<li>informacje o błędach jakie nastąpiły przy realizacji transakcji HTTP,</li>\r\n 	<li>adres URL strony poprzednio odwiedzanej przez użytkownika (referer link) – w przypadku gdy przejście do Serwisu nastąpiło przez odnośnik,</li>\r\n 	<li>informacje o przeglądarce użytkownika,</li>\r\n 	<li>Informacje o adresie IP.</li>\r\n</ol>\r\n</li>\r\n 	<li>Dane powyższe nie są kojarzone z konkretnymi osobami przeglądającymi strony.</li>\r\n 	<li>Dane powyższe są wykorzystywane jedynie dla celów administrowania serwerem.</li>\r\n</ol>\r\n<h3>5. Udostępnienie danych.</h3>\r\n<ol>\r\n 	<li>Dane podlegają udostępnieniu podmiotom zewnętrznym wyłącznie w granicach prawnie dozwolonych.</li>\r\n 	<li>Dane umożliwiające identyfikację osoby fizycznej są udostępniane wyłączenie za zgodą tej osoby.</li>\r\n 	<li>Operator może mieć obowiązek udzielania informacji zebranych przez Serwis upoważnionym organom na podstawie zgodnych z prawem żądań w zakresie wynikającym z żądania.</li>\r\n</ol>\r\n<h3>6. Zarządzanie plikami cookies – jak w praktyce wyrażać i cofać zgodę?</h3>\r\n<ol>\r\n 	<li>Jeśli użytkownik nie chce otrzymywać plików cookies, może zmienić ustawienia przeglądarki. Zastrzegamy, że wyłączenie obsługi plików cookies niezbędnych dla procesów uwierzytelniania, bezpieczeństwa, utrzymania preferencji użytkownika może utrudnić, a w skrajnych przypadkach może uniemożliwić korzystanie ze stron www</li>\r\n 	<li>W celu zarządzania ustawieniami cookies wybierz z listy poniżej przeglądarkę internetową/ system i postępuj zgodnie z instrukcjami:\r\n<ol>\r\n 	<li><a href=\"http://support.microsoft.com/kb/196955\">Internet Explorer</a></li>\r\n 	<li><a href=\"http://support.google.com/chrome/bin/answer.py?hl=pl&amp;answer=95647\">Chrome</a></li>\r\n 	<li><a href=\"http://support.apple.com/kb/PH5042\">Safari</a></li>\r\n 	<li><a href=\"http://support.mozilla.org/pl/kb/W{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}C5{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}82{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}C4{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}85czanie{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}20i{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}20wy{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}C5{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}82{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}C4{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}85czanie{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}20obs{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}C5{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}82ugi{b43dd82d1ad695f0330981e441649ee1223dd042b4666a47ed1a91bd3e0a5c77}20ciasteczek\">Firefox</a></li>\r\n 	<li><a href=\"http://help.opera.com/Windows/12.10/pl/cookies.html\">Opera</a></li>\r\n 	<li><a href=\"http://support.google.com/chrome/bin/answer.py?hl=pl&amp;answer=95647\">Android</a></li>\r\n 	<li><a href=\"http://support.apple.com/kb/HT1677?viewlocale=pl_PL\">Safari (iOS)</a></li>\r\n 	<li><a href=\"http://www.windowsphone.com/pl-pl/how-to/wp7/web/changing-privacy-and-other-browser-settings\">Windows Phone</a></li>\r\n 	<li><a href=\"http://docs.blackberry.com/en/smartphone_users/deliverables/32004/Turn_off_cookies_in_the_browser_60_1072866_11.jsp\">Blackberry</a></li>\r\n</ol>\r\n</li>\r\n</ol>\r\n</div>", "Polityka prywatności", "", "inherit", "closed", "closed", "", "100-revision-v1", "", "", "2017-10-28 15:39:56", "2017-10-28 15:39:56", "", "100", "http://bnb.testuj.website/100-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("103", "1", "2017-10-28 15:51:45", "2017-10-28 15:51:45", "[smlsubform prepend=\"\" showname=true nametxt=\"Name:\" nameholder=\"Name...\" emailtxt=\"Email:\" emailholder=\"Email Address...\" showsubmit=true submittxt=\"Submit\"  thankyou=\"Thank you for subscribing to our mailing list\"]\r\n", "Newsletter", "", "publish", "closed", "closed", "", "newsletter", "", "", "2017-11-08 17:32:51", "2017-11-08 17:32:51", "", "0", "http://bnb.testuj.website/?page_id=103", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("104", "1", "2017-10-28 15:51:45", "2017-10-28 15:51:45", "", "Newsletter", "", "inherit", "closed", "closed", "", "103-revision-v1", "", "", "2017-10-28 15:51:45", "2017-10-28 15:51:45", "", "103", "http://bnb.testuj.website/103-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("105", "1", "2017-10-28 15:53:23", "2017-10-28 15:53:23", "[newsletter]", "Newsletter", "", "inherit", "closed", "closed", "", "103-revision-v1", "", "", "2017-10-28 15:53:23", "2017-10-28 15:53:23", "", "103", "http://bnb.testuj.website/103-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("106", "1", "2017-10-28 17:19:14", "2017-10-28 17:19:14", "Hello {{NAME}},\r\n\r\nWe have published a new blog article on our website : {{POSTTITLE}}\r\n{{POSTIMAGE}}\r\n\r\nYou can view it from this link : {{POSTLINK}}\r\n\r\nThanks & Regards,\r\nAdmin\r\n\r\nYou received this email because in the past you have provided us your email address : {{EMAIL}} to receive notifications when new updates are posted.", "New Post Published - {{POSTTITLE}}", "", "publish", "closed", "closed", "", "new-post-published-posttitle", "", "", "2017-10-28 17:19:14", "2017-10-28 17:19:14", "", "0", "http://bnb.testuj.website/new-post-published-posttitle/", "0", "es_template", "", "0");
INSERT INTO `wp_posts` VALUES("107", "1", "2017-10-28 17:19:14", "2017-10-28 17:19:14", "<strong style=\"color: #990000\">What can you achieve using Email Subscribers?</strong><p>Add subscription forms on website, send HTML newsletters & automatically notify subscribers about new blog posts once it is published. You can also Import or Export subscribers from any list to Email Subscribers.</p> <strong style=\"color: #990000\">Plugin Features</strong><ol> <li>Send notification emails to subscribers when new blog posts are published.</li> <li>Subscribe form available with 3 options to setup.</li> <li>Double Opt-In and Single Opt-In support.</li> <li>Email notification to admin when a new user signs up (Optional).</li> <li>Automatic welcome email to subscriber.</li> <li>Auto add unsubscribe link in the email.</li> <li>Import/Export subscriber emails to migrate to any lists.</li> <li>Default WordPress editor to compose emails.</li> </ol> <strong>Thanks & Regards,</strong><br>Admin", "Welcome To Email Subscribers", "", "publish", "closed", "closed", "", "welcome-to-email-subscribers", "", "", "2017-10-28 17:19:14", "2017-10-28 17:19:14", "", "0", "http://bnb.testuj.website/welcome-to-email-subscribers/", "0", "es_template", "", "0");
INSERT INTO `wp_posts` VALUES("108", "1", "2017-10-29 09:56:21", "2017-10-29 09:56:21", "[contact-form-7 id=\"121\" title=\"Rezerwacja terminu\"]", "Rezerwacja terminu", "", "publish", "closed", "closed", "", "rezerwacja-terminu", "", "", "2017-10-29 14:31:56", "2017-10-29 14:31:56", "", "0", "http://bnb.testuj.website/?page_id=108", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("109", "1", "2017-10-29 09:56:21", "2017-10-29 09:56:21", "[wpdevart_booking_calendar id=\"2\"]", "Rezerwacja terminu", "", "inherit", "closed", "closed", "", "108-revision-v1", "", "", "2017-10-29 09:56:21", "2017-10-29 09:56:21", "", "108", "http://bnb.testuj.website/108-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("110", "1", "2017-10-29 09:57:27", "2017-10-29 09:57:27", "", "Rezerwacja terminu", "", "inherit", "closed", "closed", "", "108-revision-v1", "", "", "2017-10-29 09:57:27", "2017-10-29 09:57:27", "", "108", "http://bnb.testuj.website/108-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("111", "1", "2017-10-29 12:55:48", "2017-10-29 12:55:48", "CONTENTS", "Wydarzenia", "CONTENTS", "publish", "closed", "open", "", "wydarzenia", "", "", "2017-10-29 12:55:48", "2017-10-29 12:55:48", "", "0", "http://bnb.testuj.website/wydarzenia/", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("112", "1", "2017-10-29 12:55:48", "2017-10-29 12:55:48", "CONTENTS", "Lokalizacje", "", "publish", "closed", "open", "", "lokalizacje", "", "", "2017-10-29 12:55:48", "2017-10-29 12:55:48", "", "111", "http://bnb.testuj.website/wydarzenia/lokalizacje/", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("113", "1", "2017-10-29 12:55:48", "2017-10-29 12:55:48", "CONTENTS", "Kategorie", "", "publish", "closed", "open", "", "kategorie", "", "", "2017-10-29 12:55:48", "2017-10-29 12:55:48", "", "111", "http://bnb.testuj.website/wydarzenia/kategorie/", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("114", "1", "2017-10-29 12:55:48", "2017-10-29 12:55:48", "CONTENTS", "Tagi", "", "publish", "closed", "open", "", "tagi", "", "", "2017-10-29 12:55:48", "2017-10-29 12:55:48", "", "111", "http://bnb.testuj.website/wydarzenia/tagi/", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("115", "1", "2017-10-29 12:55:48", "2017-10-29 12:55:48", "CONTENTS", "Moje rezerwacje", "", "publish", "closed", "open", "", "moje-rezerwacje", "", "", "2017-10-29 12:55:48", "2017-10-29 12:55:48", "", "111", "http://bnb.testuj.website/wydarzenia/moje-rezerwacje/", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("116", "1", "2017-10-29 13:01:03", "2017-10-29 13:01:03", "[wpdevart_booking_calendar id=\"2\"]", "Rezerwacja terminu", "", "inherit", "closed", "closed", "", "108-revision-v1", "", "", "2017-10-29 13:01:03", "2017-10-29 13:01:03", "", "108", "http://bnb.testuj.website/108-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("117", "1", "2017-10-29 13:22:25", "2017-10-29 13:22:25", "[wpdevart_booking_calendar id=\"2\"]\n\n&nbsp;", "Rezerwacja terminu", "", "inherit", "closed", "closed", "", "108-autosave-v1", "", "", "2017-10-29 13:22:25", "2017-10-29 13:22:25", "", "108", "http://bnb.testuj.website/108-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("118", "1", "2017-10-29 13:22:50", "2017-10-29 13:22:50", "[wpdevart_booking_calendar id=\"2\"]\r\n\r\n[bookly-form service_id=\"1\"]", "Rezerwacja terminu", "", "inherit", "closed", "closed", "", "108-revision-v1", "", "", "2017-10-29 13:22:50", "2017-10-29 13:22:50", "", "108", "http://bnb.testuj.website/108-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("119", "1", "2017-10-29 13:23:36", "2017-10-29 13:23:36", "[wpdevart_booking_calendar id=\"2\"]\r\n\r\n[bookly-form service_id=\"1\" hide=\"categories,services,staff_members\"]", "Rezerwacja terminu", "", "inherit", "closed", "closed", "", "108-revision-v1", "", "", "2017-10-29 13:23:36", "2017-10-29 13:23:36", "", "108", "http://bnb.testuj.website/108-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("120", "1", "2017-10-29 14:17:09", "2017-10-29 14:17:09", "[wpdevart_booking_calendar id=\"2\"]\r\n\r\n[sbc title=\"no\"]", "Rezerwacja terminu", "", "inherit", "closed", "closed", "", "108-revision-v1", "", "", "2017-10-29 14:17:09", "2017-10-29 14:17:09", "", "108", "http://bnb.testuj.website/108-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("121", "1", "2017-10-29 14:31:31", "2017-10-29 14:31:31", "<div class=\"form_left\">\r\n						<div class=\"nag_form_l\">Twoje imię i nazwisko</div>\r\n						<div class=\"pole_form_l\">[text* your-name class:field_form_l]</div>\r\n</div>\r\n<div class=\"form_right\">\r\n						<div class=\"nag_form_l\">Twój adres email</div>\r\n						<div class=\"pole_form_l\">[email* your-email class:field_form_l]</div>\r\n</div>\r\n<div class=\"form_left3\">\r\n						<div class=\"nag_form_l\">Telefon</div>\r\n						<div class=\"pole_form_l\">    [text* your-phone class:field_form_l]</div>\r\n</div>\r\n<div class=\"form_right3\">\r\n						<div class=\"nag_form_l\">Wybierz termin spotkania</div>\r\n						<div class=\"pole_form_l\">[date* your-date date-format:mm/dd/yy first-day:1 class:field_form_l]</div>\r\n</div>\r\n<div class=\"form_reg\">[acceptance acceptance-519] Oświadczam, iż zapoznałem się z <a href=\"/polityka-prywatnosci\" class=\"link_pp\" target=\"_blank\">Polityką Prywatności</a> i akceptuję jej wszystkie postanowienia.\r\n</div>\r\n<div class=\'guzik_pop\'><button type=\'submit\' class=\'sprawdz_bt6\'>Rezerwuję termin <i class=\'fa fa-angle-right\' style=\'margin-left: 3px;\'></i></button><div class=\"wypisz\">W celu ustalenia szczegółów skontaktuję się z Tobą mailowo lub telefonicznie.</div></div>\n1\nBody & Brain - Rezerwacja terminu\n[your-name] <wordpress@bnb.testuj.website>\ncentrum@bodynbrain.pl\nNadawca: [your-name] <[your-email]>\r\nTelefon: [your-phone]\r\n\r\nData spotkania: [your-date]\r\n\r\n-- \r\nTa wiadomość została wysłana przez formularz kontaktowy na stronie Body &amp; Brain (http://bnb.testuj.website).\nReply-To: [your-email]\n\n\n\n\nBody & Brain - \"[your-subject]\"\nBody & Brain <wordpress@bnb.testuj.website>\n[your-email]\nTreść wiadomości:\r\n[your-message]\r\n\r\n-- \r\nTa wiadomość została wysłana przez formularz kontaktowy na stronie Body &amp; Brain (http://bnb.testuj.website).\nReply-To: wordpress@bnb.testuj.website\n\n\n\nTwoja propozycja spotkania została wysłana. Dziękujemy!\nWystąpił problem z wysłaniem twojej wiadomości. Spróbuj ponownie później.\nPrzynajmniej jedno pole jest błędnie wypełnione. Sprawdź wpisaną treść i spróbuj ponownie.\nWystąpił problem z wysłaniem twojej wiadomości. Spróbuj ponownie później.\nMusisz wyrazić zgodę na powyższe zapisy, aby móc wysłać formularz.\nWymagane jest wypełnienie tego pola.\nZawartość tego pola jest zbyt długa.\nZawartość tego pola jest zbyt krótka.\nPodczas wgrywania pliku wystąpił nieznany błąd.\nNie możesz wgrywać plików tego typu.\nTen plik jest zbyt duży.\nWystąpił błąd podczas wgrywania pliku.\nFormat liczby jest niepoprawny.\nTa liczba jest mniejsza, niż minimalna dopuszczana.\nTa liczba jest większa, niż maksymalna dopuszczalna.\nOdpowiedź w quizie jest nieprawidłowa.\nWpisany kod jest nieprawidłowy.\nWprowadzony adres e-mail jest nieprawidłowy.\nWprowadzony adres URL jest nieprawidłowy.\nWprowadzony numer telefonu jest nieprawidłowy.\nInvalid date and time supplied.\nFormat daty jest niepoprawny.\nInvalid time supplied.", "Rezerwacja terminu", "", "publish", "closed", "closed", "", "rezerwacja-terminu", "", "", "2017-12-12 15:44:25", "2017-12-12 15:44:25", "", "0", "http://bnb.testuj.website/?post_type=wpcf7_contact_form&#038;p=121", "0", "wpcf7_contact_form", "", "0");
INSERT INTO `wp_posts` VALUES("122", "1", "2017-10-29 14:31:56", "2017-10-29 14:31:56", "[contact-form-7 id=\"121\" title=\"Rezerwacja terminu\"]", "Rezerwacja terminu", "", "inherit", "closed", "closed", "", "108-revision-v1", "", "", "2017-10-29 14:31:56", "2017-10-29 14:31:56", "", "108", "http://bnb.testuj.website/108-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("124", "1", "2017-11-08 16:42:53", "2017-11-08 16:42:53", "", "ola-mason", "", "inherit", "open", "closed", "", "ola-mason", "", "", "2017-11-08 16:42:53", "2017-11-08 16:42:53", "", "15", "http://bnb.testuj.website/wp-content/uploads/2017/10/ola-mason.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("125", "1", "2017-11-08 16:43:32", "2017-11-08 16:43:32", "", "oferta", "", "inherit", "open", "closed", "", "oferta-2", "", "", "2017-11-08 16:43:32", "2017-11-08 16:43:32", "", "15", "http://bnb.testuj.website/wp-content/uploads/2017/10/oferta.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("126", "1", "2017-11-08 16:43:45", "2017-11-08 16:43:45", "", "ola-mason-spotkanie", "", "inherit", "open", "closed", "", "ola-mason-spotkanie", "", "", "2017-11-08 16:43:45", "2017-11-08 16:43:45", "", "15", "http://bnb.testuj.website/wp-content/uploads/2017/10/ola-mason-spotkanie.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("127", "1", "2017-11-08 16:51:39", "2017-11-08 16:51:39", "", "grafik", "", "inherit", "open", "closed", "", "grafik-2", "", "", "2017-11-08 16:51:39", "2017-11-08 16:51:39", "", "15", "http://bnb.testuj.website/wp-content/uploads/2017/10/grafik-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("128", "1", "2017-11-08 17:05:47", "2017-11-08 17:05:47", "[smlsubform prepend=\"\" showname=true nametxt=\"Name:\" nameholder=\"Name...\" emailtxt=\"Email:\" emailholder=\"Email Address...\" showsubmit=true submittxt=\"Submit\" jsthanks=false thankyou=\"Thank you for subscribing to our mailing list\"]\r\n", "Newsletter", "", "inherit", "closed", "closed", "", "103-revision-v1", "", "", "2017-11-08 17:05:47", "2017-11-08 17:05:47", "", "103", "http://bnb.testuj.website/103-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("129", "1", "2017-11-08 17:32:51", "2017-11-08 17:32:51", "[smlsubform prepend=\"\" showname=true nametxt=\"Name:\" nameholder=\"Name...\" emailtxt=\"Email:\" emailholder=\"Email Address...\" showsubmit=true submittxt=\"Submit\"  thankyou=\"Thank you for subscribing to our mailing list\"]\r\n", "Newsletter", "", "inherit", "closed", "closed", "", "103-revision-v1", "", "", "2017-11-08 17:32:51", "2017-11-08 17:32:51", "", "103", "http://bnb.testuj.website/103-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("130", "1", "2017-11-08 18:20:01", "2017-11-08 18:20:01", "<h2 style=\"text-align: center;\">Dziękujemy za zapisanie się do newslettera</h2>", "Potwierdzenie", "", "publish", "closed", "closed", "", "potwierdzenie", "", "", "2017-11-08 18:45:27", "2017-11-08 18:45:27", "", "103", "http://bnb.testuj.website/?page_id=130", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("131", "1", "2017-11-08 18:20:01", "2017-11-08 18:20:01", "Dziękujemy", "Newsletter Potwierdzenie", "", "inherit", "closed", "closed", "", "130-revision-v1", "", "", "2017-11-08 18:20:01", "2017-11-08 18:20:01", "", "130", "http://bnb.testuj.website/130-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("132", "1", "2017-11-08 18:32:01", "2017-11-08 18:32:01", "[sml_unsubscribe]", "Wypisz się", "", "publish", "closed", "closed", "", "wypisz-sie", "", "", "2017-11-08 18:45:40", "2017-11-08 18:45:40", "", "103", "http://bnb.testuj.website/?page_id=132", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("133", "1", "2017-11-08 18:32:01", "2017-11-08 18:32:01", "[sml_unsubscribe]", "Newsletter Wypisz się", "", "inherit", "closed", "closed", "", "132-revision-v1", "", "", "2017-11-08 18:32:01", "2017-11-08 18:32:01", "", "132", "http://bnb.testuj.website/132-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("134", "1", "2017-11-08 18:33:26", "2017-11-08 18:33:26", "[sml_unsubscribe]", "Wypisz się", "", "inherit", "closed", "closed", "", "132-revision-v1", "", "", "2017-11-08 18:33:26", "2017-11-08 18:33:26", "", "132", "http://bnb.testuj.website/132-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("135", "1", "2017-11-08 18:43:34", "2017-11-08 18:43:34", "Dziękujemy", "Potwierdzenie", "", "inherit", "closed", "closed", "", "130-revision-v1", "", "", "2017-11-08 18:43:34", "2017-11-08 18:43:34", "", "130", "http://bnb.testuj.website/130-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("136", "1", "2017-11-08 18:43:41", "2017-11-08 18:43:41", "", "Potwierdzenie", "", "inherit", "closed", "closed", "", "130-revision-v1", "", "", "2017-11-08 18:43:41", "2017-11-08 18:43:41", "", "130", "http://bnb.testuj.website/130-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("137", "1", "2017-11-08 18:45:27", "2017-11-08 18:45:27", "<h2 style=\"text-align: center;\">Dziękujemy za zapisanie się do newslettera</h2>", "Potwierdzenie", "", "inherit", "closed", "closed", "", "130-revision-v1", "", "", "2017-11-08 18:45:27", "2017-11-08 18:45:27", "", "130", "http://bnb.testuj.website/130-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("138", "1", "2017-11-12 09:24:35", "2017-11-12 09:24:35", "", "Alicja Smialek", "", "inherit", "open", "closed", "", "alicja-smialek", "", "", "2017-11-12 09:24:35", "2017-11-12 09:24:35", "", "70", "http://bnb.testuj.website/wp-content/uploads/2017/10/Alicja-Smialek.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("139", "1", "2017-11-12 09:25:28", "2017-11-12 09:25:28", "", "Alicja Śmiałek", "", "inherit", "closed", "closed", "", "70-autosave-v1", "", "", "2017-11-12 09:25:28", "2017-11-12 09:25:28", "", "70", "http://bnb.testuj.website/70-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("140", "1", "2017-11-12 09:28:54", "2017-11-12 09:28:54", "", "Lila Golik", "", "publish", "closed", "closed", "", "lila-golik", "", "", "2017-11-12 09:28:54", "2017-11-12 09:28:54", "", "0", "http://bnb.testuj.website/?post_type=testimonials&#038;p=140", "0", "testimonials", "", "0");
INSERT INTO `wp_posts` VALUES("141", "1", "2017-11-12 09:27:01", "2017-11-12 09:27:01", "", "Lila Golik", "", "inherit", "open", "closed", "", "lila-golik", "", "", "2017-11-12 09:27:01", "2017-11-12 09:27:01", "", "140", "http://bnb.testuj.website/wp-content/uploads/2017/11/Lila-Golik.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("142", "1", "2017-11-12 09:31:53", "2017-11-12 09:31:53", "", "Wojciech Pieczkowski", "", "publish", "closed", "closed", "", "wojciech-pieczkowski", "", "", "2017-11-12 09:31:53", "2017-11-12 09:31:53", "", "0", "http://bnb.testuj.website/?post_type=testimonials&#038;p=142", "0", "testimonials", "", "0");
INSERT INTO `wp_posts` VALUES("143", "1", "2017-11-12 09:31:43", "2017-11-12 09:31:43", "", "Wojciech Pieczkowski", "", "inherit", "open", "closed", "", "wojciech-pieczkowski", "", "", "2017-11-12 09:31:43", "2017-11-12 09:31:43", "", "142", "http://bnb.testuj.website/wp-content/uploads/2017/11/Wojciech-Pieczkowski.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("144", "1", "2017-11-12 09:33:59", "2017-11-12 09:33:59", "", "Elwira Skutek", "", "publish", "closed", "closed", "", "elwira-skutek", "", "", "2017-11-12 09:33:59", "2017-11-12 09:33:59", "", "0", "http://bnb.testuj.website/?post_type=testimonials&#038;p=144", "0", "testimonials", "", "0");
INSERT INTO `wp_posts` VALUES("145", "1", "2017-11-12 09:33:45", "2017-11-12 09:33:45", "", "Elwira Skutek", "", "inherit", "open", "closed", "", "elwira-skutek", "", "", "2017-11-12 09:33:45", "2017-11-12 09:33:45", "", "144", "http://bnb.testuj.website/wp-content/uploads/2017/11/Elwira-Skutek.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("147", "1", "2017-11-12 10:08:29", "2017-11-12 10:08:29", "", "Grafik listopad", "", "inherit", "open", "closed", "", "grafik-listopad", "", "", "2017-11-12 10:08:29", "2017-11-12 10:08:29", "", "90", "http://bnb.testuj.website/wp-content/uploads/2017/10/Grafik-listopad.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("148", "1", "2017-11-12 10:12:07", "2017-11-12 10:12:07", "", "Grafik 2017 NEW Jesien", "", "inherit", "open", "closed", "", "grafik-2017-new-jesien", "", "", "2017-11-12 10:12:07", "2017-11-12 10:12:07", "", "90", "http://bnb.testuj.website/wp-content/uploads/2017/10/Grafik-2017-NEW-Jesien.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("151", "1", "2017-11-13 08:40:42", "2017-11-13 08:40:42", "", "wallpaper-bird-of-the-soul-1600x1200-3", "", "inherit", "open", "closed", "", "wallpaper-bird-of-the-soul-1600x1200-3", "", "", "2017-11-13 08:40:42", "2017-11-13 08:40:42", "", "10", "http://bnb.testuj.website/wp-content/uploads/2017/10/wallpaper-bird-of-the-soul-1600x1200-3.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("152", "1", "2017-11-13 08:57:10", "2017-11-13 08:57:10", "", "DSC_0095", "", "inherit", "open", "closed", "", "dsc_0095", "", "", "2017-11-13 08:57:10", "2017-11-13 08:57:10", "", "10", "http://bnb.testuj.website/wp-content/uploads/2017/10/DSC_0095.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("153", "1", "2017-11-13 08:57:33", "2017-11-13 08:57:33", "", "1499682662389", "", "inherit", "open", "closed", "", "1499682662389", "", "", "2017-11-13 08:57:33", "2017-11-13 08:57:33", "", "10", "http://bnb.testuj.website/wp-content/uploads/2017/10/1499682662389.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("154", "1", "2017-11-13 08:57:48", "2017-11-13 08:57:48", "", "1499682661190", "", "inherit", "open", "closed", "", "1499682661190", "", "", "2017-11-13 08:57:48", "2017-11-13 08:57:48", "", "10", "http://bnb.testuj.website/wp-content/uploads/2017/10/1499682661190.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("155", "1", "2017-11-13 08:58:07", "2017-11-13 08:58:07", "", "1499682680823", "", "inherit", "open", "closed", "", "1499682680823", "", "", "2017-11-13 08:58:07", "2017-11-13 08:58:07", "", "10", "http://bnb.testuj.website/wp-content/uploads/2017/10/1499682680823.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("156", "1", "2017-11-13 08:58:45", "2017-11-13 08:58:45", "", "1499682676529", "", "inherit", "open", "closed", "", "1499682676529", "", "", "2017-11-13 08:58:45", "2017-11-13 08:58:45", "", "10", "http://bnb.testuj.website/wp-content/uploads/2017/10/1499682676529.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("157", "1", "2017-11-13 08:59:05", "2017-11-13 08:59:05", "", "1499682677807", "", "inherit", "open", "closed", "", "1499682677807", "", "", "2017-11-13 08:59:05", "2017-11-13 08:59:05", "", "10", "http://bnb.testuj.website/wp-content/uploads/2017/10/1499682677807.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("158", "1", "2017-11-13 09:24:42", "2017-11-13 09:24:42", "", "1499682600946", "", "inherit", "open", "closed", "", "1499682600946", "", "", "2017-11-13 09:24:42", "2017-11-13 09:24:42", "", "90", "http://bnb.testuj.website/wp-content/uploads/2017/10/1499682600946.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("159", "1", "2017-11-13 09:26:33", "2017-11-13 09:26:33", "", "maxresdefault", "", "inherit", "open", "closed", "", "maxresdefault", "", "", "2017-11-13 09:26:33", "2017-11-13 09:26:33", "", "90", "http://bnb.testuj.website/wp-content/uploads/2017/10/maxresdefault.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("160", "1", "2017-11-13 09:32:56", "2017-11-13 09:32:56", "", "Polar bear underwater close-up", "Close-up of a swimming polar bear underwater looking at the camera.", "inherit", "open", "closed", "", "polar-bear-underwater-close-up", "", "", "2017-11-13 09:32:56", "2017-11-13 09:32:56", "", "95", "http://bnb.testuj.website/wp-content/uploads/2017/10/bluebear_1280_1020.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("161", "1", "2017-11-13 09:34:27", "2017-11-13 09:34:27", "", "DSC_1152", "", "inherit", "open", "closed", "", "dsc_1152-2", "", "", "2017-11-13 09:34:27", "2017-11-13 09:34:27", "", "95", "http://bnb.testuj.website/wp-content/uploads/2017/10/DSC_1152-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("162", "1", "2017-11-13 09:38:25", "2017-11-13 09:38:25", "", "IMG_6288", "", "inherit", "open", "closed", "", "img_6288", "", "", "2017-11-13 09:38:25", "2017-11-13 09:38:25", "", "15", "http://bnb.testuj.website/wp-content/uploads/2017/10/IMG_6288.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("163", "1", "2017-11-13 09:41:54", "2017-11-13 09:41:54", "", "DSC_0938", "", "inherit", "open", "closed", "", "dsc_0938", "", "", "2017-11-13 09:41:54", "2017-11-13 09:41:54", "", "15", "http://bnb.testuj.website/wp-content/uploads/2017/10/DSC_0938.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("164", "1", "2017-11-13 09:43:15", "2017-11-13 09:43:15", "", "autumn", "", "inherit", "open", "closed", "", "autumn", "", "", "2017-11-13 09:43:15", "2017-11-13 09:43:15", "", "15", "http://bnb.testuj.website/wp-content/uploads/2017/10/autumn.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("165", "1", "2017-11-13 09:43:37", "2017-11-13 09:43:37", "", "3 segmenty", "", "inherit", "open", "closed", "", "3-segmenty", "", "", "2017-11-13 09:43:37", "2017-11-13 09:43:37", "", "15", "http://bnb.testuj.website/wp-content/uploads/2017/10/3-segmenty.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("166", "1", "2017-11-13 15:07:26", "2017-11-13 15:07:26", "", "testowy warsztat", "", "publish", "closed", "closed", "", "testowy-warsztat", "", "", "2017-11-13 15:39:37", "2017-11-13 15:39:37", "", "0", "http://bnb.testuj.website/?post_type=warsztaty&#038;p=166", "0", "warsztaty", "", "0");
INSERT INTO `wp_posts` VALUES("167", "1", "2017-11-13 15:31:52", "2017-11-13 15:31:52", "", "03_dla_firm_02", "", "inherit", "open", "closed", "", "03_dla_firm_02", "", "", "2017-11-13 15:31:52", "2017-11-13 15:31:52", "", "166", "http://bnb.testuj.website/wp-content/uploads/2017/11/03_dla_firm_02.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("168", "1", "2017-11-13 15:34:20", "2017-11-13 15:34:20", "", "plama_czakry", "", "inherit", "open", "closed", "", "plama_czakry", "", "", "2017-11-13 15:34:20", "2017-11-13 15:34:20", "", "166", "http://bnb.testuj.website/wp-content/uploads/2017/11/plama_czakry.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("169", "1", "2017-11-13 15:39:29", "2017-11-13 15:39:29", "", "bnb.testuj.website_warsztaty_testowy-warsztat_", "", "inherit", "open", "closed", "", "bnb-testuj-website_warsztaty_testowy-warsztat_", "", "", "2017-11-13 15:39:29", "2017-11-13 15:39:29", "", "166", "http://bnb.testuj.website/wp-content/uploads/2017/11/bnb.testuj.website_warsztaty_testowy-warsztat_.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("176", "1", "2017-11-22 21:22:25", "2017-11-22 21:22:25", "", "Ilchi Lee_bbh book", "", "inherit", "open", "closed", "", "ilchi-lee_bbh-book", "", "", "2017-11-22 21:22:25", "2017-11-22 21:22:25", "", "0", "http://bnb.testuj.website/wp-content/uploads/2017/10/Ilchi-Lee_bbh-book.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("179", "1", "2017-11-22 21:28:51", "2017-11-22 21:28:51", "{\n    \"nav_menu_item[61]\": {\n        \"value\": {\n            \"menu_item_parent\": 0,\n            \"object_id\": 6,\n            \"object\": \"warsztaty\",\n            \"type\": \"post_type\",\n            \"type_label\": \"Warsztat\",\n            \"url\": \"http://bnb.testuj.website/warsztaty/coaching/\",\n            \"title\": \"P\\u0119pek\",\n            \"target\": \"\",\n            \"attr_title\": \"\",\n            \"description\": \"\",\n            \"classes\": \"\",\n            \"xfn\": \"\",\n            \"nav_menu_term_id\": 2,\n            \"position\": 3,\n            \"status\": \"publish\",\n            \"original_title\": \"Uzdrawianie przez P\\u0119pek\",\n            \"_invalid\": false\n        },\n        \"type\": \"nav_menu_item\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "f00a9277-333b-43f2-80c2-15ba837522a9", "", "", "2017-11-22 21:28:51", "2017-11-22 21:28:51", "", "0", "http://bnb.testuj.website/?p=179", "0", "customize_changeset", "", "0");
INSERT INTO `wp_posts` VALUES("181", "1", "2017-11-23 12:12:34", "2017-11-23 12:12:34", "", "DSC_0316", "", "inherit", "open", "closed", "", "dsc_0316", "", "", "2017-11-23 12:12:34", "2017-11-23 12:12:34", "", "15", "http://bnb.testuj.website/wp-content/uploads/2017/10/DSC_0316.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("182", "1", "2017-11-23 12:17:38", "2017-11-23 12:17:38", "", "bnbjoga1", "", "inherit", "open", "closed", "", "bnbjoga1", "", "", "2017-11-23 12:17:38", "2017-11-23 12:17:38", "", "15", "http://bnb.testuj.website/wp-content/uploads/2017/10/bnbjoga1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("183", "1", "2017-11-23 12:28:08", "2017-11-23 12:28:08", "", "spotkanie", "", "inherit", "open", "closed", "", "spotkanie", "", "", "2017-11-23 12:28:08", "2017-11-23 12:28:08", "", "15", "http://bnb.testuj.website/wp-content/uploads/2017/10/spotkanie.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("184", "1", "2017-11-23 12:30:56", "2017-11-23 12:30:56", "", "free-body-brain-yoga-belly-button-healing-19", "", "inherit", "open", "closed", "", "free-body-brain-yoga-belly-button-healing-19", "", "", "2017-11-23 12:30:56", "2017-11-23 12:30:56", "", "15", "http://bnb.testuj.website/wp-content/uploads/2017/10/free-body-brain-yoga-belly-button-healing-19.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("185", "1", "2017-11-23 12:32:25", "2017-11-23 12:32:25", "", "free-body-brain-yoga-belly-button-healing-19", "", "inherit", "open", "closed", "", "free-body-brain-yoga-belly-button-healing-19-2", "", "", "2017-11-23 12:32:25", "2017-11-23 12:32:25", "", "15", "http://bnb.testuj.website/wp-content/uploads/2017/10/free-body-brain-yoga-belly-button-healing-19-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("186", "1", "2017-11-23 12:34:06", "2017-11-23 12:34:06", "", "free-body-brain-yoga-belly-button-healing-19", "", "inherit", "open", "closed", "", "free-body-brain-yoga-belly-button-healing-19-3", "", "", "2017-11-23 12:34:06", "2017-11-23 12:34:06", "", "15", "http://bnb.testuj.website/wp-content/uploads/2017/10/free-body-brain-yoga-belly-button-healing-19-2.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("187", "1", "2017-11-23 12:36:07", "2017-11-23 12:36:07", "", "spotkanie.jpg2", "", "inherit", "open", "closed", "", "spotkanie-jpg2", "", "", "2017-11-23 12:36:07", "2017-11-23 12:36:07", "", "15", "http://bnb.testuj.website/wp-content/uploads/2017/10/spotkanie.jpg2_.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("188", "1", "2017-11-23 12:44:15", "2017-11-23 12:44:15", "", "drugi mózg", "", "inherit", "open", "closed", "", "drugi-mozg", "", "", "2017-11-23 12:44:15", "2017-11-23 12:44:15", "", "6", "http://bnb.testuj.website/wp-content/uploads/2017/10/drugi-mózg.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("189", "1", "2017-11-23 12:45:39", "2017-11-23 12:45:39", "", "THIRD EYE BBH", "", "inherit", "open", "closed", "", "third-eye-bbh", "", "", "2017-11-23 12:45:39", "2017-11-23 12:45:39", "", "6", "http://bnb.testuj.website/wp-content/uploads/2017/10/THIRD-EYE-BBH.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("190", "1", "2017-11-23 12:55:00", "2017-11-23 12:55:00", "", "IMG_5436", "", "inherit", "open", "closed", "", "img_5436", "", "", "2017-11-23 12:55:00", "2017-11-23 12:55:00", "", "6", "http://bnb.testuj.website/wp-content/uploads/2017/10/IMG_5436.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("191", "1", "2017-11-23 12:56:37", "2017-11-23 12:56:37", "", "IMG_5436", "", "inherit", "open", "closed", "", "img_5436-2", "", "", "2017-11-23 12:56:37", "2017-11-23 12:56:37", "", "6", "http://bnb.testuj.website/wp-content/uploads/2017/10/IMG_5436-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("193", "1", "2017-11-23 13:29:56", "2017-11-23 13:29:56", "", "DSC_0392", "", "inherit", "open", "closed", "", "dsc_0392", "", "", "2017-11-23 13:29:56", "2017-11-23 13:29:56", "", "6", "http://bnb.testuj.website/wp-content/uploads/2017/10/DSC_0392.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("194", "1", "2017-11-24 09:22:58", "2017-11-24 09:22:58", "{\n    \"nav_menu_item[94]\": {\n        \"value\": {\n            \"menu_item_parent\": 58,\n            \"object_id\": 90,\n            \"object\": \"warsztaty\",\n            \"type\": \"post_type\",\n            \"type_label\": \"Warsztat\",\n            \"url\": \"http://bnb.testuj.website/warsztaty/cwiczenia-dla-doroslych/\",\n            \"title\": \"\\u0106wiczenia\",\n            \"target\": \"\",\n            \"attr_title\": \"\",\n            \"description\": \"\",\n            \"classes\": \"\",\n            \"xfn\": \"\",\n            \"nav_menu_term_id\": 2,\n            \"position\": 6,\n            \"status\": \"publish\",\n            \"original_title\": \"\\u0106wiczenia dla doros\\u0142ych\",\n            \"_invalid\": false\n        },\n        \"type\": \"nav_menu_item\",\n        \"user_id\": 1\n    },\n    \"nav_menu_item[97]\": {\n        \"value\": {\n            \"menu_item_parent\": 58,\n            \"object_id\": 95,\n            \"object\": \"warsztaty\",\n            \"type\": \"post_type\",\n            \"type_label\": \"Warsztat\",\n            \"url\": \"http://bnb.testuj.website/warsztaty/zajecia-dla-dzieci/\",\n            \"title\": \"M\\u0142odzie\\u017c\",\n            \"target\": \"\",\n            \"attr_title\": \"\",\n            \"description\": \"\",\n            \"classes\": \"\",\n            \"xfn\": \"\",\n            \"nav_menu_term_id\": 2,\n            \"position\": 7,\n            \"status\": \"publish\",\n            \"original_title\": \"Zaj\\u0119cia dla m\\u0142odzie\\u017cy\",\n            \"_invalid\": false\n        },\n        \"type\": \"nav_menu_item\",\n        \"user_id\": 1\n    },\n    \"nav_menu_item[89]\": {\n        \"value\": {\n            \"menu_item_parent\": 58,\n            \"object_id\": 82,\n            \"object\": \"warsztaty\",\n            \"type\": \"post_type\",\n            \"type_label\": \"Warsztat\",\n            \"url\": \"http://bnb.testuj.website/warsztaty/masaz-hwal-gong/\",\n            \"title\": \"Masa\\u017c\",\n            \"target\": \"\",\n            \"attr_title\": \"\",\n            \"description\": \"\",\n            \"classes\": \"\",\n            \"xfn\": \"\",\n            \"nav_menu_term_id\": 2,\n            \"position\": 8,\n            \"status\": \"publish\",\n            \"original_title\": \"Masa\\u017c Hwal Gong\",\n            \"_invalid\": false\n        },\n        \"type\": \"nav_menu_item\",\n        \"user_id\": 1\n    },\n    \"nav_menu_item[59]\": {\n        \"value\": {\n            \"menu_item_parent\": 58,\n            \"object_id\": 13,\n            \"object\": \"warsztaty\",\n            \"type\": \"post_type\",\n            \"type_label\": \"Warsztat\",\n            \"url\": \"http://bnb.testuj.website/warsztaty/uzdrawianie-przez-pepek/\",\n            \"title\": \"Uzdrawianie przez P\\u0119pek - Warsztat\",\n            \"target\": \"\",\n            \"attr_title\": \"\",\n            \"description\": \"\",\n            \"classes\": \"\",\n            \"xfn\": \"\",\n            \"nav_menu_term_id\": 2,\n            \"position\": 9,\n            \"status\": \"publish\",\n            \"original_title\": \"Uzdrawianie przez p\\u0119pek\",\n            \"_invalid\": false\n        },\n        \"type\": \"nav_menu_item\",\n        \"user_id\": 1\n    },\n    \"nav_menu_item[60]\": {\n        \"value\": {\n            \"menu_item_parent\": 58,\n            \"object_id\": 10,\n            \"object\": \"warsztaty\",\n            \"type\": \"post_type\",\n            \"type_label\": \"Warsztat\",\n            \"url\": \"http://bnb.testuj.website/warsztaty/shimsung/\",\n            \"title\": \"Shimsung - Uwolnij si\\u0119 - Warsztat\",\n            \"target\": \"\",\n            \"attr_title\": \"\",\n            \"description\": \"\",\n            \"classes\": \"\",\n            \"xfn\": \"\",\n            \"nav_menu_term_id\": 2,\n            \"position\": 10,\n            \"status\": \"publish\",\n            \"original_title\": \"Shimsung\",\n            \"_invalid\": false\n        },\n        \"type\": \"nav_menu_item\",\n        \"user_id\": 1\n    },\n    \"nav_menu_item[65]\": {\n        \"value\": {\n            \"menu_item_parent\": 0,\n            \"object_id\": 65,\n            \"object\": \"custom\",\n            \"type\": \"custom\",\n            \"type_label\": \"W\\u0142asny odno\\u015bnik\",\n            \"title\": \"Opinie\",\n            \"url\": \"/opinie\",\n            \"target\": \"\",\n            \"attr_title\": \"\",\n            \"description\": \"\",\n            \"classes\": \"\",\n            \"xfn\": \"\",\n            \"nav_menu_term_id\": 2,\n            \"position\": 11,\n            \"status\": \"publish\",\n            \"original_title\": \"\",\n            \"_invalid\": false\n        },\n        \"type\": \"nav_menu_item\",\n        \"user_id\": 1\n    },\n    \"nav_menu_item[64]\": {\n        \"value\": {\n            \"menu_item_parent\": 0,\n            \"object_id\": 62,\n            \"object\": \"page\",\n            \"type\": \"post_type\",\n            \"type_label\": \"Strona\",\n            \"url\": \"http://bnb.testuj.website/kontakt/\",\n            \"title\": \"\",\n            \"target\": \"\",\n            \"attr_title\": \"\",\n            \"description\": \"\",\n            \"classes\": \"\",\n            \"xfn\": \"\",\n            \"nav_menu_term_id\": 2,\n            \"position\": 12,\n            \"status\": \"publish\",\n            \"original_title\": \"Kontakt\",\n            \"_invalid\": false\n        },\n        \"type\": \"nav_menu_item\",\n        \"user_id\": 1\n    },\n    \"nav_menu_item[-5332217833721192000]\": {\n        \"value\": {\n            \"object_id\": 7,\n            \"object\": \"warsztaty\",\n            \"menu_item_parent\": 58,\n            \"position\": 5,\n            \"type\": \"post_type\",\n            \"title\": \"Power Brain Kids\",\n            \"url\": \"http://bnb.testuj.website/warsztaty/power-brain-kids/\",\n            \"target\": \"\",\n            \"attr_title\": \"\",\n            \"description\": \"\",\n            \"classes\": \"\",\n            \"xfn\": \"\",\n            \"status\": \"publish\",\n            \"original_title\": \"Power Brain Kids\",\n            \"nav_menu_term_id\": 2,\n            \"_invalid\": false,\n            \"type_label\": \"Warsztat\"\n        },\n        \"type\": \"nav_menu_item\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "31636159-229a-4458-b816-65d6ca97ebf4", "", "", "2017-11-24 09:22:58", "2017-11-24 09:22:58", "", "0", "http://bnb.testuj.website/31636159-229a-4458-b816-65d6ca97ebf4/", "0", "customize_changeset", "", "0");
INSERT INTO `wp_posts` VALUES("197", "1", "2017-11-24 09:29:26", "2017-11-24 09:29:26", "", "O Nas (Nowy)", "", "trash", "closed", "closed", "", "__trashed", "", "", "2017-11-24 09:31:30", "2017-11-24 09:31:30", "", "0", "http://bnb.testuj.website/?page_id=197", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("198", "1", "2017-11-24 09:31:30", "2017-11-24 09:31:30", "", "O Nas (Nowy)", "", "inherit", "closed", "closed", "", "197-revision-v1", "", "", "2017-11-24 09:31:30", "2017-11-24 09:31:30", "", "197", "http://bnb.testuj.website/197-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("199", "1", "2017-11-24 10:54:37", "2017-11-24 10:54:37", "", "O Nas", "", "publish", "closed", "closed", "", "o-nas-nowy", "", "", "2017-11-25 11:43:46", "2017-11-25 11:43:46", "", "0", "http://bnb.testuj.website/?post_type=warsztaty&#038;p=199", "0", "warsztaty", "", "0");
INSERT INTO `wp_posts` VALUES("203", "1", "2017-11-24 10:43:13", "2017-11-24 10:43:13", "", "Masaż Hwal Gong", "", "inherit", "closed", "closed", "", "82-autosave-v1", "", "", "2017-11-24 10:43:13", "2017-11-24 10:43:13", "", "82", "http://bnb.testuj.website/82-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("205", "1", "2017-11-24 11:02:56", "2017-11-24 11:02:56", "So this is how the Domyslny Szablon looks like. An interesting thing.", "Warsztaty", "", "inherit", "closed", "closed", "", "72-autosave-v1", "", "", "2017-11-24 11:02:56", "2017-11-24 11:02:56", "", "72", "http://bnb.testuj.website/72-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("206", "1", "2017-11-24 11:05:08", "2017-11-24 11:05:08", "This is an example page. It\'s different from a blog post because it will stay in one place and will show up in your site navigation (in most themes). Most people start with an About page that introduces them to potential site visitors. It might say something like this:\n\n<blockquote>Hi there! I\'m a bike messenger by day, aspiring actor by night, and this is my website. I live in Los Angeles, have a great dog named Jack, and I like pi&#241;a coladas. (And gettin\' caught in the rain.)</blockquote>\n\n...or something like this:\n\n<blockquote>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</blockquote>\n\nAs a new WordPress user, you should go to <a href=\"http://bnb.testuj.website/wp-admin/\">your dashboard</a> to delete this page and create new pages for your content. Have fun!", "Sample Page", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2017-11-24 11:05:08", "2017-11-24 11:05:08", "", "2", "http://bnb.testuj.website/2-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("207", "1", "2017-11-24 11:51:21", "2017-11-24 11:51:21", "", "Trening Zarządzania - Warsztat", "", "publish", "closed", "closed", "", "zarzadzanie-mozgiem", "", "", "2017-12-08 15:04:43", "2017-12-08 15:04:43", "", "0", "http://bnb.testuj.website/?post_type=warsztaty&#038;p=207", "0", "warsztaty", "", "0");
INSERT INTO `wp_posts` VALUES("208", "1", "2017-11-24 11:44:54", "2017-11-24 11:44:54", "", "Powerful Brain", "", "inherit", "open", "closed", "", "powerful-brain", "", "", "2017-11-24 11:44:54", "2017-11-24 11:44:54", "", "207", "http://bnb.testuj.website/wp-content/uploads/2017/11/Powerful-Brain.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("210", "1", "2017-11-24 11:54:11", "2017-11-24 11:54:11", "", "Trening Zarządzania – Warsztat", "", "publish", "closed", "closed", "", "210", "", "", "2017-12-12 10:31:08", "2017-12-12 10:31:08", "", "0", "http://bnb.testuj.website/?p=210", "9", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("214", "1", "2017-11-24 12:01:53", "2017-11-24 12:01:53", "", "Powerful Brain", "", "inherit", "open", "closed", "", "powerful-brain-2", "", "", "2017-11-24 12:01:53", "2017-11-24 12:01:53", "", "207", "http://bnb.testuj.website/wp-content/uploads/2017/11/Powerful-Brain-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("217", "1", "2017-11-24 12:13:48", "2017-11-24 12:13:48", "", "creative brain", "", "inherit", "open", "closed", "", "creative-brain", "", "", "2017-11-24 12:13:48", "2017-11-24 12:13:48", "", "207", "http://bnb.testuj.website/wp-content/uploads/2017/11/creative-brain.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("218", "1", "2017-11-24 12:17:03", "2017-11-24 12:17:03", "", "ECO World", "", "inherit", "open", "closed", "", "eco-world", "", "", "2017-11-24 12:17:03", "2017-11-24 12:17:03", "", "207", "http://bnb.testuj.website/wp-content/uploads/2017/11/ECO-World.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("219", "1", "2017-11-24 12:17:35", "2017-11-24 12:17:35", "", "Zarządzanie Mózgiem", "", "inherit", "closed", "closed", "", "207-autosave-v1", "", "", "2017-11-24 12:17:35", "2017-11-24 12:17:35", "", "207", "http://bnb.testuj.website/207-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("220", "1", "2017-11-24 13:12:21", "2017-11-24 13:12:21", "", "love-earth-korten", "", "inherit", "open", "closed", "", "love-earth-korten", "", "", "2017-11-24 13:12:21", "2017-11-24 13:12:21", "", "199", "http://bnb.testuj.website/wp-content/uploads/2017/11/love-earth-korten.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("221", "1", "2017-11-24 13:14:26", "2017-11-24 13:14:26", "", "Butterfly_", "", "inherit", "open", "closed", "", "butterfly_", "", "", "2017-11-24 13:14:26", "2017-11-24 13:14:26", "", "199", "http://bnb.testuj.website/wp-content/uploads/2017/11/Butterfly_.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("222", "1", "2017-11-24 14:10:15", "2017-11-24 14:10:15", "", "DSC_0332", "", "inherit", "open", "closed", "", "dsc_0332", "", "", "2017-11-24 14:10:15", "2017-11-24 14:10:15", "", "199", "http://bnb.testuj.website/wp-content/uploads/2017/11/DSC_0332.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("223", "1", "2017-11-24 14:18:55", "2017-11-24 14:18:55", "", "DSC_0333 — kopia", "", "inherit", "open", "closed", "", "dsc_0333-kopia", "", "", "2017-11-24 14:18:55", "2017-11-24 14:18:55", "", "199", "http://bnb.testuj.website/wp-content/uploads/2017/11/DSC_0333-—-kopia.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("224", "1", "2017-11-24 15:11:50", "2017-11-24 15:11:50", "", "DSC_0334 — kopia", "", "inherit", "open", "closed", "", "dsc_0334-kopia", "", "", "2017-11-24 15:11:50", "2017-11-24 15:11:50", "", "199", "http://bnb.testuj.website/wp-content/uploads/2017/11/DSC_0334-—-kopia.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("225", "1", "2017-11-24 15:26:10", "2017-11-24 15:26:10", "", "DSC_0316 — kopia", "", "inherit", "open", "closed", "", "dsc_0316-kopia", "", "", "2017-11-24 15:26:10", "2017-11-24 15:26:10", "", "199", "http://bnb.testuj.website/wp-content/uploads/2017/11/DSC_0316-—-kopia.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("228", "1", "2017-12-03 21:17:38", "2017-12-03 21:17:38", "", "O nas", "", "publish", "closed", "closed", "", "o-nas", "", "", "2017-12-03 21:26:16", "2017-12-03 21:26:16", "", "0", "http://bnb.testuj.website/?page_id=228", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("229", "1", "2017-12-03 18:55:54", "2017-12-03 18:55:54", "", "O nas - nowa strona", "", "inherit", "closed", "closed", "", "228-revision-v1", "", "", "2017-12-03 18:55:54", "2017-12-03 18:55:54", "", "228", "http://bnb.testuj.website/228-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("230", "1", "2017-12-03 21:26:09", "2017-12-03 21:26:09", "", "O nas", "", "inherit", "closed", "closed", "", "228-revision-v1", "", "", "2017-12-03 21:26:09", "2017-12-03 21:26:09", "", "228", "http://bnb.testuj.website/228-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("231", "1", "2017-12-03 21:26:47", "2017-12-03 21:26:47", " ", "", "", "publish", "closed", "closed", "", "231", "", "", "2017-12-12 10:31:08", "2017-12-12 10:31:08", "", "0", "http://bnb.testuj.website/?p=231", "2", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("233", "1", "2017-12-04 11:07:18", "2017-12-04 11:07:18", "", "Youth", "", "publish", "closed", "closed", "", "youth", "", "", "2017-12-04 11:11:04", "2017-12-04 11:11:04", "", "0", "http://bnb.testuj.website/?page_id=233", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("234", "1", "2017-12-04 11:06:08", "2017-12-04 11:06:08", "", "Youth", "", "inherit", "closed", "closed", "", "233-revision-v1", "", "", "2017-12-04 11:06:08", "2017-12-04 11:06:08", "", "233", "http://bnb.testuj.website/233-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("235", "1", "2017-12-04 11:08:08", "2017-12-04 11:08:08", "what if I type something in here. . .what will happen?", "Youth", "", "inherit", "closed", "closed", "", "233-revision-v1", "", "", "2017-12-04 11:08:08", "2017-12-04 11:08:08", "", "233", "http://bnb.testuj.website/233-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("238", "1", "2017-12-04 11:11:04", "2017-12-04 11:11:04", "", "Youth", "", "inherit", "closed", "closed", "", "233-revision-v1", "", "", "2017-12-04 11:11:04", "2017-12-04 11:11:04", "", "233", "http://bnb.testuj.website/233-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("239", "1", "2017-12-04 11:25:40", "2017-12-04 11:25:40", "", "Masaż Uzdrawiający", "", "publish", "closed", "closed", "", "239-2", "", "", "2017-12-05 09:50:12", "2017-12-05 09:50:12", "", "0", "http://bnb.testuj.website/?page_id=239", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("240", "1", "2017-12-04 11:25:40", "2017-12-04 11:25:40", "", "", "", "inherit", "closed", "closed", "", "239-revision-v1", "", "", "2017-12-04 11:25:40", "2017-12-04 11:25:40", "", "239", "http://bnb.testuj.website/239-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("241", "1", "2017-12-04 11:26:52", "2017-12-04 11:26:52", "", "Masaż Hwal Gong", "", "inherit", "closed", "closed", "", "239-revision-v1", "", "", "2017-12-04 11:26:52", "2017-12-04 11:26:52", "", "239", "http://bnb.testuj.website/239-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("242", "1", "2017-12-04 11:28:24", "2017-12-04 11:28:24", " ", "", "", "publish", "closed", "closed", "", "242", "", "", "2017-12-12 10:31:08", "2017-12-12 10:31:08", "", "0", "http://bnb.testuj.website/?p=242", "6", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("243", "1", "2017-12-04 11:40:25", "2017-12-04 11:40:25", "", "Ćwiczenia dla dorosłych", "", "publish", "closed", "closed", "", "cwiczenia-dla-doroslych", "", "", "2017-12-08 15:08:20", "2017-12-08 15:08:20", "", "0", "http://bnb.testuj.website/?page_id=243", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("244", "1", "2017-12-04 11:40:25", "2017-12-04 11:40:25", "", "Ćwiczenia dla dorosłych", "", "inherit", "closed", "closed", "", "243-revision-v1", "", "", "2017-12-04 11:40:25", "2017-12-04 11:40:25", "", "243", "http://bnb.testuj.website/243-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("246", "1", "2017-12-04 11:41:12", "2017-12-04 11:41:12", " ", "", "", "publish", "closed", "closed", "", "246", "", "", "2017-12-12 10:31:08", "2017-12-12 10:31:08", "", "0", "http://bnb.testuj.website/?p=246", "5", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("250", "1", "2017-12-04 20:36:55", "2017-12-04 20:36:55", "", "Pępek", "", "inherit", "closed", "closed", "", "6-autosave-v1", "", "", "2017-12-04 20:36:55", "2017-12-04 20:36:55", "", "6", "http://bnb.testuj.website/6-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("251", "1", "2017-12-04 20:48:20", "2017-12-04 20:48:20", "", "Pępek 2", "", "trash", "closed", "closed", "", "pepek__trashed", "", "", "2017-12-04 20:52:26", "2017-12-04 20:52:26", "", "0", "http://bnb.testuj.website/?page_id=251", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("252", "1", "2017-12-04 20:48:20", "2017-12-04 20:48:20", "", "Pępek", "", "inherit", "closed", "closed", "", "251-revision-v1", "", "", "2017-12-04 20:48:20", "2017-12-04 20:48:20", "", "251", "http://bnb.testuj.website/251-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("253", "1", "2017-12-04 20:48:54", "2017-12-04 20:48:54", "", "Pępek 2", "", "inherit", "closed", "closed", "", "251-revision-v1", "", "", "2017-12-04 20:48:54", "2017-12-04 20:48:54", "", "251", "http://bnb.testuj.website/251-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("255", "1", "2017-12-04 21:18:03", "2017-12-04 21:18:03", "", "Aleksandra Mason BODY&BRAIN", "", "inherit", "open", "closed", "", "aleksandra-mason-bodybrain", "", "", "2017-12-04 21:18:03", "2017-12-04 21:18:03", "", "6", "http://bnb.testuj.website/wp-content/uploads/2017/10/Aleksandra-Mason-BODYBRAIN.mp4", "0", "attachment", "video/mp4", "0");
INSERT INTO `wp_posts` VALUES("256", "1", "2017-12-04 21:19:50", "2017-12-04 21:19:50", "", "Aleksandra Mason BODY&BRAIN", "", "inherit", "open", "closed", "", "aleksandra-mason-bodybrain-2", "", "", "2017-12-04 21:19:50", "2017-12-04 21:19:50", "", "6", "http://bnb.testuj.website/wp-content/uploads/2017/10/Aleksandra-Mason-BODYBRAIN-1.mp4", "0", "attachment", "video/mp4", "0");
INSERT INTO `wp_posts` VALUES("257", "1", "2017-12-05 07:57:57", "2017-12-05 07:57:57", "", "Grafik Body and Brain _Grudzień", "", "inherit", "open", "closed", "", "grafik-body-and-brain-_grudzien", "", "", "2017-12-05 07:57:57", "2017-12-05 07:57:57", "", "243", "http://bnb.testuj.website/wp-content/uploads/2017/12/Grafik-Body-and-Brain-_Grudzień.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("258", "1", "2017-12-05 08:45:06", "2017-12-05 08:45:06", "", "Masaż Uzdrawiający", "", "inherit", "closed", "closed", "", "239-revision-v1", "", "", "2017-12-05 08:45:06", "2017-12-05 08:45:06", "", "239", "http://bnb.testuj.website/239-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("259", "1", "2017-12-05 08:47:53", "2017-12-05 08:47:53", "", "healingmassageaz3", "", "inherit", "open", "closed", "", "healingmassageaz3", "", "", "2017-12-05 08:47:53", "2017-12-05 08:47:53", "", "239", "http://bnb.testuj.website/wp-content/uploads/2017/12/healingmassageaz3.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("260", "1", "2017-12-05 08:49:39", "2017-12-05 08:49:39", "", "healing massage 1", "Spa", "inherit", "open", "closed", "", "healing-massage-1", "", "", "2017-12-05 08:49:39", "2017-12-05 08:49:39", "", "239", "http://bnb.testuj.website/wp-content/uploads/2017/12/healing-massage-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("261", "1", "2017-12-05 10:57:37", "2017-12-05 10:57:37", "", "DSC_0389", "", "inherit", "open", "closed", "", "dsc_0389", "", "", "2017-12-05 10:57:37", "2017-12-05 10:57:37", "", "13", "http://bnb.testuj.website/wp-content/uploads/2017/10/DSC_0389.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("262", "1", "2017-12-05 10:59:36", "2017-12-05 10:59:36", "", "free-body-brain-yoga-belly-button-healing-19", "", "inherit", "open", "closed", "", "free-body-brain-yoga-belly-button-healing-19-4", "", "", "2017-12-05 10:59:36", "2017-12-05 10:59:36", "", "13", "http://bnb.testuj.website/wp-content/uploads/2017/10/free-body-brain-yoga-belly-button-healing-19-3.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("263", "1", "2017-12-05 11:00:35", "2017-12-05 11:00:35", "", "sureandsimple-5", "", "inherit", "open", "closed", "", "sureandsimple-5", "", "", "2017-12-05 11:00:35", "2017-12-05 11:00:35", "", "13", "http://bnb.testuj.website/wp-content/uploads/2017/10/sureandsimple-5.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("264", "1", "2017-12-05 11:02:18", "2017-12-05 11:02:18", "", "DSC_0327", "", "inherit", "open", "closed", "", "dsc_0327", "", "", "2017-12-05 11:02:18", "2017-12-05 11:02:18", "", "13", "http://bnb.testuj.website/wp-content/uploads/2017/10/DSC_0327.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("265", "1", "2017-12-05 11:06:04", "2017-12-05 11:06:04", "", "31865667 - peaceful woman in white sitting in lotus pose  against snow falling", "31865667 - peaceful woman in white sitting in lotus pose  against snow falling", "inherit", "open", "closed", "", "31865667-peaceful-woman-in-white-sitting-in-lotus-pose-against-snow-falling", "", "", "2017-12-05 11:06:04", "2017-12-05 11:06:04", "", "13", "http://bnb.testuj.website/wp-content/uploads/2017/10/31865667_l.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("266", "1", "2017-12-05 11:41:52", "2017-12-05 11:41:52", "", "power brain2", "", "inherit", "open", "closed", "", "power-brain2", "", "", "2017-12-05 11:41:52", "2017-12-05 11:41:52", "", "207", "http://bnb.testuj.website/wp-content/uploads/2017/11/power-brain2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("267", "1", "2017-12-08 10:02:19", "2017-12-08 10:02:19", "To jest test", "Bangapsumnida", "", "publish", "open", "open", "", "bangapsumnida", "", "", "2017-12-12 13:43:49", "2017-12-12 13:43:49", "", "0", "http://bnb.testuj.website/?p=267", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("268", "1", "2017-12-08 10:02:19", "2017-12-08 10:02:19", "To jest test", "Bangapsumnida", "", "inherit", "closed", "closed", "", "267-revision-v1", "", "", "2017-12-08 10:02:19", "2017-12-08 10:02:19", "", "267", "http://bnb.testuj.website/267-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("269", "1", "2017-12-08 15:14:33", "2017-12-08 15:14:33", "", "Mira Rodacka", "", "publish", "closed", "closed", "", "mira-rodacka", "", "", "2017-12-08 15:23:13", "2017-12-08 15:23:13", "", "0", "http://bnb.testuj.website/?post_type=testimonials&#038;p=269", "0", "testimonials", "", "0");
INSERT INTO `wp_posts` VALUES("270", "1", "2017-12-08 15:15:27", "2017-12-08 15:15:27", "", "Mira Rodacka", "", "inherit", "open", "closed", "", "mira-rodacka-2", "", "", "2017-12-08 15:15:27", "2017-12-08 15:15:27", "", "269", "http://bnb.testuj.website/wp-content/uploads/2017/12/Mira-Rodacka.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("271", "1", "2017-12-08 15:19:03", "2017-12-08 15:19:03", "", "Mira Rodacka", "", "inherit", "open", "closed", "", "mira-rodacka-3", "", "", "2017-12-08 15:19:03", "2017-12-08 15:19:03", "", "269", "http://bnb.testuj.website/wp-content/uploads/2017/12/Mira-Rodacka-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("272", "1", "2017-12-10 16:47:49", "0000-00-00 00:00:00", "", "Automatycznie zapisany szkic", "", "auto-draft", "closed", "closed", "", "", "", "", "2017-12-10 16:47:49", "0000-00-00 00:00:00", "", "0", "http://bnb.testuj.website/?page_id=272", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("273", "1", "2017-12-10 16:51:28", "0000-00-00 00:00:00", "", "Automatycznie zapisany szkic", "", "auto-draft", "closed", "closed", "", "", "", "", "2017-12-10 16:51:28", "0000-00-00 00:00:00", "", "0", "http://bnb.testuj.website/?page_id=273", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("274", "1", "2017-12-10 16:59:25", "2017-12-10 16:59:25", "", "Blog", "", "publish", "closed", "closed", "", "blog", "", "", "2017-12-10 16:59:25", "2017-12-10 16:59:25", "", "0", "http://bnb.testuj.website/?page_id=274", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("275", "1", "2017-12-10 16:59:25", "2017-12-10 16:59:25", "", "Blog", "", "inherit", "closed", "closed", "", "274-revision-v1", "", "", "2017-12-10 16:59:25", "2017-12-10 16:59:25", "", "274", "http://bnb.testuj.website/274-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("278", "1", "2017-12-12 09:10:26", "2017-12-12 09:10:26", "Witamy na naszej nowej, odświeżonej stronie internetowej. Jest to strona, o której zawsze marzyliśmy, jest piękna, serdeczna i ciepła.", "Nowa strona", "", "publish", "open", "open", "", "nowa-joga", "", "", "2017-12-12 13:42:43", "2017-12-12 13:42:43", "", "0", "http://bnb.testuj.website/?p=278", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("279", "1", "2017-12-12 09:10:26", "2017-12-12 09:10:26", "Lorem ipsum dolor sit amet enim. Etiam ullamcorper. Suspendisse a pellentesque dui, non felis. Maecenas malesuada elit lectus felis, malesuada ultricies. Curabitur et ligula. Ut molestie a, ultricies porta urna. Vestibulum commodo volutpat a, convallis ac, laoreet enim. Phasellus fermentum in, dolor. Pellentesque facilisis. Nulla imperdiet sit amet magna. Vestibulum dapibus, mauris nec malesuada fames ac turpis velit, rhoncus eu, luctus et interdum adipiscing wisi. Aliquam erat ac ipsum. Integer aliquam purus.", "Lorem ipsum", "", "inherit", "closed", "closed", "", "278-revision-v1", "", "", "2017-12-12 09:10:26", "2017-12-12 09:10:26", "", "278", "http://bnb.testuj.website/278-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("280", "1", "2017-12-12 09:10:40", "2017-12-12 09:10:40", "Lorem ipsum dolor sit amet enim. Etiam ullamcorper. Suspendisse a pellentesque dui, non felis. Maecenas malesuada elit lectus felis, malesuada ultricies. Curabitur et ligula. Ut molestie a, ultricies porta urna. Vestibulum commodo volutpat a, convallis ac, laoreet enim. Phasellus fermentum in, dolor. Pellentesque facilisis. Nulla imperdiet sit amet magna. Vestibulum dapibus, mauris nec malesuada fames ac turpis velit, rhoncus eu, luctus et interdum adipiscing wisi. Aliquam erat ac ipsum. Integer aliquam purus.\r\n\r\nQuisque lorem tortor fringilla sed, vestibulum id, eleifend justo vel bibendum sapien massa ac turpis faucibus orci luctus non, consectetuer lobortis quis, varius in, purus. Integer ultrices posuere cubilia Curae, Nulla ipsum dolor lacus, suscipit adipiscing. Cum sociis natoque penatibus et ultrices volutpat. Nullam wisi ultricies a, gravida vitae, dapibus risus ante sodales lectus blandit eu, tempor diam pede cursus vitae, ultricies eu, faucibus quis, porttitor eros cursus lectus, pellentesque eget, bibendum a, gravida ullamcorper quam. Nullam viverra consectetuer. Quisque cursus et, porttitor risus. Aliquam sem. In hendrerit nulla quam nunc, accumsan congue. Lorem ipsum primis in nibh vel risus. Sed vel lectus. Ut sagittis, ipsum dolor quam.", "Lorem ipsum", "", "inherit", "closed", "closed", "", "278-revision-v1", "", "", "2017-12-12 09:10:40", "2017-12-12 09:10:40", "", "278", "http://bnb.testuj.website/278-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("281", "1", "2017-09-12 10:30:01", "2017-09-12 10:30:01", "Lorem ipsum dolor sit amet enim. Etiam ullamcorper. Suspendisse a pellentesque dui, non felis. Maecenas malesuada elit lectus felis, malesuada ultricies. Curabitur et ligula. Ut molestie a, ultricies porta urna. Vestibulum commodo volutpat a, convallis ac, laoreet enim. Phasellus fermentum in, dolor. Pellentesque facilisis. Nulla imperdiet sit amet magna. Vestibulum dapibus, mauris nec malesuada fames ac turpis velit, rhoncus eu, luctus et interdum adipiscing wisi. Aliquam erat ac ipsum. Integer aliquam purus. Quisque lorem tortor fringilla sed, vestibulum id, eleifend justo vel bibendum sapien massa ac turpis faucibus orci luctus non, consectetuer lobortis quis, varius in, purus. Integer ultrices posuere cubilia Curae, Nulla ipsum dolor lacus, suscipit adipiscing. Cum sociis natoque penatibus et ultrices volutpat. Nullam wisi ultricies a, gravida vitae, dapibus risus ante sodales lectus blandit eu, tempor diam pede cursus vitae, ultricies eu, faucibus quis, porttitor eros cursus lectus, pellentesque eget, bibendum a, gravida ullamcorper quam. Nullam viverra consectetuer. Quisque cursus et, porttitor risus. Aliquam sem. In hendrerit nulla quam nunc, accumsan congue. Lorem ipsum primis in nibh vel risus. Sed vel lectus. Ut sagittis, ipsum dolor quam.", "lorem ipsum", "", "publish", "open", "open", "", "lorem-ipsum-2", "", "", "2017-12-12 10:30:24", "2017-12-12 10:30:24", "", "0", "http://bnb.testuj.website/?p=281", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("282", "1", "2017-12-12 10:30:01", "2017-12-12 10:30:01", "Lorem ipsum dolor sit amet enim. Etiam ullamcorper. Suspendisse a pellentesque dui, non felis. Maecenas malesuada elit lectus felis, malesuada ultricies. Curabitur et ligula. Ut molestie a, ultricies porta urna. Vestibulum commodo volutpat a, convallis ac, laoreet enim. Phasellus fermentum in, dolor. Pellentesque facilisis. Nulla imperdiet sit amet magna. Vestibulum dapibus, mauris nec malesuada fames ac turpis velit, rhoncus eu, luctus et interdum adipiscing wisi. Aliquam erat ac ipsum. Integer aliquam purus. Quisque lorem tortor fringilla sed, vestibulum id, eleifend justo vel bibendum sapien massa ac turpis faucibus orci luctus non, consectetuer lobortis quis, varius in, purus. Integer ultrices posuere cubilia Curae, Nulla ipsum dolor lacus, suscipit adipiscing. Cum sociis natoque penatibus et ultrices volutpat. Nullam wisi ultricies a, gravida vitae, dapibus risus ante sodales lectus blandit eu, tempor diam pede cursus vitae, ultricies eu, faucibus quis, porttitor eros cursus lectus, pellentesque eget, bibendum a, gravida ullamcorper quam. Nullam viverra consectetuer. Quisque cursus et, porttitor risus. Aliquam sem. In hendrerit nulla quam nunc, accumsan congue. Lorem ipsum primis in nibh vel risus. Sed vel lectus. Ut sagittis, ipsum dolor quam.", "lorem ipsum", "", "inherit", "closed", "closed", "", "281-revision-v1", "", "", "2017-12-12 10:30:01", "2017-12-12 10:30:01", "", "281", "http://bnb.testuj.website/281-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("283", "1", "2017-12-12 10:31:03", "2017-12-12 10:31:03", " ", "", "", "publish", "closed", "closed", "", "283", "", "", "2017-12-12 10:31:08", "2017-12-12 10:31:08", "", "0", "http://bnb.testuj.website/?p=283", "10", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("284", "1", "2017-12-12 10:54:25", "0000-00-00 00:00:00", "", "Automatycznie zapisany szkic", "", "auto-draft", "closed", "closed", "", "", "", "", "2017-12-12 10:54:25", "0000-00-00 00:00:00", "", "0", "http://bnb.testuj.website/?post_type=slider&p=284", "0", "slider", "", "0");
INSERT INTO `wp_posts` VALUES("285", "1", "2017-12-12 10:58:39", "0000-00-00 00:00:00", "", "Automatycznie zapisany szkic", "", "auto-draft", "closed", "closed", "", "", "", "", "2017-12-12 10:58:39", "0000-00-00 00:00:00", "", "0", "http://bnb.testuj.website/?post_type=slider&p=285", "0", "slider", "", "0");
INSERT INTO `wp_posts` VALUES("286", "1", "2017-12-12 11:00:56", "2017-12-12 11:00:56", "", "Prosty i naturalny sposób powrotu do zdrowia", "", "publish", "closed", "closed", "", "prosty-i-naturalny-sposob-powrotu-do-zdrowia", "", "", "2017-12-12 11:25:34", "2017-12-12 11:25:34", "", "0", "http://bnb.testuj.website/?post_type=slider&#038;p=286", "0", "slider", "", "0");
INSERT INTO `wp_posts` VALUES("287", "1", "2017-12-12 11:00:18", "2017-12-12 11:00:18", "", "banner_pepek_1", "", "inherit", "open", "closed", "", "banner_pepek_1", "", "", "2017-12-12 11:00:18", "2017-12-12 11:00:18", "", "0", "http://bnb.testuj.website/wp-content/uploads/2017/12/banner_pepek_1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("288", "1", "2017-12-12 11:21:07", "2017-12-12 11:21:07", "", "Masaż Rybnik", "", "draft", "closed", "closed", "", "hwal-gong", "", "", "2017-12-12 16:01:10", "2017-12-12 16:01:10", "", "0", "http://bnb.testuj.website/?post_type=slider&#038;p=288", "2", "slider", "", "0");
INSERT INTO `wp_posts` VALUES("289", "1", "2017-12-12 11:21:02", "2017-12-12 11:21:02", "", "banner_masaz_uniwersalny", "", "inherit", "open", "closed", "", "banner_masaz_uniwersalny", "", "", "2017-12-12 11:21:02", "2017-12-12 11:21:02", "", "0", "http://bnb.testuj.website/wp-content/uploads/2017/12/banner_masaz_uniwersalny.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("290", "1", "2017-12-12 11:21:29", "2017-12-12 11:21:29", "", "Roczny abonament", "", "draft", "closed", "closed", "", "roczny-abonament", "", "", "2017-12-12 16:00:34", "2017-12-12 16:00:34", "", "0", "http://bnb.testuj.website/?post_type=slider&#038;p=290", "1", "slider", "", "0");
INSERT INTO `wp_posts` VALUES("291", "1", "2017-12-12 11:21:26", "2017-12-12 11:21:26", "", "banner", "", "inherit", "open", "closed", "", "banner", "", "", "2017-12-12 11:21:26", "2017-12-12 11:21:26", "", "0", "http://bnb.testuj.website/wp-content/uploads/2017/12/banner.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("292", "1", "2017-12-12 13:38:56", "2017-12-12 13:38:56", "Witamy na naszej nowej, odświeżonej stronie internetowej. Jest to strona, o której zawsze marzyliśmy, jest piękna, serdeczna i ciepła.", "Nowa strona", "", "inherit", "closed", "closed", "", "278-revision-v1", "", "", "2017-12-12 13:38:56", "2017-12-12 13:38:56", "", "278", "http://bnb.testuj.website/278-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("293", "1", "2017-12-12 13:50:27", "0000-00-00 00:00:00", "", "Automatycznie zapisany szkic", "", "auto-draft", "open", "open", "", "", "", "", "2017-12-12 13:50:27", "0000-00-00 00:00:00", "", "0", "http://bnb.testuj.website/?p=293", "0", "post", "", "0");

/* INSERT TABLE DATA: wp_sml */
INSERT INTO `wp_sml` VALUES("5", "Aneta", "aneta.koterba@gmail.com");
INSERT INTO `wp_sml` VALUES("6", "Zuzanna Drzezla", "zuzanna.drzezla@gmail.com");
INSERT INTO `wp_sml` VALUES("7", "Katarzyna babinska", "Kwiatek203@op.pl");
INSERT INTO `wp_sml` VALUES("8", "Agnieszka Jocz-Minich", "Agajoczmin@gmail.com");
INSERT INTO `wp_sml` VALUES("9", "Katarzyna Ben Taleb", "kasiabtaleb@googlemail.com");
INSERT INTO `wp_sml` VALUES("10", "Agnieszka Krec", "agnieszka.gromek1@wp.pl");
INSERT INTO `wp_sml` VALUES("11", "Asia Paruzel", "joannabizon@wp.pl");
INSERT INTO `wp_sml` VALUES("12", "DOROTA Lukas", "dorotalukas@interia.pl");
INSERT INTO `wp_sml` VALUES("13", "Anna Smyczek", "a.m.smyczek@gmail.com");
INSERT INTO `wp_sml` VALUES("14", "Bożena Lampart", "rea3@poczta.onet.pl");
INSERT INTO `wp_sml` VALUES("15", "Iwona Filipowska", "iwona.filipowska72@gmail.com");
INSERT INTO `wp_sml` VALUES("16", "asia mysliwiec", "mysliwiecasia@interia.pl");
INSERT INTO `wp_sml` VALUES("17", "Martyna Zielińska", "martyna_zielinska82@wp.pl");
INSERT INTO `wp_sml` VALUES("18", "Beata Piekarczyk", "beata.p64@wp.pl");
INSERT INTO `wp_sml` VALUES("19", "Ewa Lal", "ewalal1976@gmail.com");
INSERT INTO `wp_sml` VALUES("20", "Kamila kolesnik", "Kamila.kolesnik@gmail.com");
INSERT INTO `wp_sml` VALUES("21", "Marta Nurzyńska", "marta.nurzynska@vp.pl");
INSERT INTO `wp_sml` VALUES("22", "Piotr Gaś", "piotr_gas@wp.pl");
INSERT INTO `wp_sml` VALUES("23", "Sebastian Niesporek", "sebastian.niesporek@gmail.com");
INSERT INTO `wp_sml` VALUES("24", "Magdalena Sujkowska", "sujkowska.magdalena@gazeta.pl");
INSERT INTO `wp_sml` VALUES("25", "Dominika Kwol-Peszko", "Dominika.kwol@gmail.com");
INSERT INTO `wp_sml` VALUES("26", "Hanna Jakubowska", "hanna.jakubowska@gmail.com");
INSERT INTO `wp_sml` VALUES("27", "Martyna Bożek", "martyna.bozek@gmail.com");
INSERT INTO `wp_sml` VALUES("28", "Antonina Tomala", "atom102@vp.pl");
INSERT INTO `wp_sml` VALUES("29", "iza dera", "isabelflower@poczta.onet.pl");
INSERT INTO `wp_sml` VALUES("30", "Tatiana", "zmitati@gmail.com");
INSERT INTO `wp_sml` VALUES("31", "Urszula Sperling", "urszula_daw@poczta.onet.pl");
INSERT INTO `wp_sml` VALUES("32", "Dorota Bańka", "keke1@tlen.pl");
INSERT INTO `wp_sml` VALUES("33", "Iwona Szolc", "Iszolc@op.pl");
INSERT INTO `wp_sml` VALUES("34", "agnieszka kordjak", "yogi_ana@gazeta.pl");
INSERT INTO `wp_sml` VALUES("35", "Nina Łapka", "ninalapka@gazeta.pl");
INSERT INTO `wp_sml` VALUES("36", "ALDONA KACZMARCZYK-KOŁUCKA", "aldona-creatio2@wp.pl");
INSERT INTO `wp_sml` VALUES("37", "Beata Szulik", "szulikb@op.pl");
INSERT INTO `wp_sml` VALUES("38", "Sabina Ficek", "sabinaficek@gmail.com");
INSERT INTO `wp_sml` VALUES("41", "Aga Agasińska", "olamason@outlook.com");
INSERT INTO `wp_sml` VALUES("42", "Ola Mason", "centrum@bodynbrain.pl");

/* INSERT TABLE DATA: wp_term_relationships */
INSERT INTO `wp_term_relationships` VALUES("1", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("57", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("58", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("59", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("60", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("61", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("64", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("65", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("210", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("231", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("242", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("246", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("267", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("278", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("281", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("283", "2", "0");

/* INSERT TABLE DATA: wp_term_taxonomy */
INSERT INTO `wp_term_taxonomy` VALUES("1", "1", "category", "", "0", "4");
INSERT INTO `wp_term_taxonomy` VALUES("2", "2", "nav_menu", "", "0", "12");

/* INSERT TABLE DATA: wp_terms */
INSERT INTO `wp_terms` VALUES("1", "Uncategorized", "uncategorized", "0");
INSERT INTO `wp_terms` VALUES("2", "Menu główne", "menu-glowne", "0");

/* INSERT TABLE DATA: wp_usermeta */
INSERT INTO `wp_usermeta` VALUES("1", "1", "nickname", "admin");
INSERT INTO `wp_usermeta` VALUES("2", "1", "first_name", "");
INSERT INTO `wp_usermeta` VALUES("3", "1", "last_name", "");
INSERT INTO `wp_usermeta` VALUES("4", "1", "description", "");
INSERT INTO `wp_usermeta` VALUES("5", "1", "rich_editing", "true");
INSERT INTO `wp_usermeta` VALUES("6", "1", "comment_shortcuts", "false");
INSERT INTO `wp_usermeta` VALUES("7", "1", "admin_color", "fresh");
INSERT INTO `wp_usermeta` VALUES("8", "1", "use_ssl", "0");
INSERT INTO `wp_usermeta` VALUES("9", "1", "show_admin_bar_front", "true");
INSERT INTO `wp_usermeta` VALUES("10", "1", "locale", "");
INSERT INTO `wp_usermeta` VALUES("11", "1", "wp_capabilities", "a:1:{s:13:\"administrator\";b:1;}");
INSERT INTO `wp_usermeta` VALUES("12", "1", "wp_user_level", "10");
INSERT INTO `wp_usermeta` VALUES("13", "1", "dismissed_wp_pointers", "text_widget_paste_html");
INSERT INTO `wp_usermeta` VALUES("14", "1", "show_welcome_panel", "1");
INSERT INTO `wp_usermeta` VALUES("16", "1", "wp_dashboard_quick_press_last_post_id", "293");
INSERT INTO `wp_usermeta` VALUES("17", "1", "community-events-location", "a:1:{s:2:\"ip\";s:11:\"91.239.36.0\";}");
INSERT INTO `wp_usermeta` VALUES("18", "1", "closedpostboxes_warsztaty", "a:2:{i:0;s:10:\"section-1a\";i:1;s:10:\"section-2a\";}");
INSERT INTO `wp_usermeta` VALUES("19", "1", "metaboxhidden_warsztaty", "a:2:{i:0;s:10:\"postcustom\";i:1;s:7:\"slugdiv\";}");
INSERT INTO `wp_usermeta` VALUES("20", "1", "managenav-menuscolumnshidden", "a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}");
INSERT INTO `wp_usermeta` VALUES("21", "1", "metaboxhidden_nav-menus", "a:1:{i:0;s:12:\"add-post_tag\";}");
INSERT INTO `wp_usermeta` VALUES("22", "1", "closedpostboxes_nav-menus", "a:0:{}");
INSERT INTO `wp_usermeta` VALUES("23", "1", "nav_menu_recently_edited", "2");
INSERT INTO `wp_usermeta` VALUES("24", "1", "wp_user-settings", "libraryContent=browse&align=left&editor=tinymce&hidetb=1&editor_plain_text_paste_warning=2&advImgDetails=show");
INSERT INTO `wp_usermeta` VALUES("25", "1", "wp_user-settings-time", "1511537345");
INSERT INTO `wp_usermeta` VALUES("27", "1", "manageedit-eventcolumnshidden", "a:1:{i:0;s:8:\"event-id\";}");
INSERT INTO `wp_usermeta` VALUES("28", "1", "current-app_tutorial2-step", "9");
INSERT INTO `wp_usermeta` VALUES("29", "1", "current-app_tutorial1-step", "22");
INSERT INTO `wp_usermeta` VALUES("32", "1", "closedpostboxes_page", "a:2:{i:0;s:6:\"oferta\";i:1;s:9:\"spotkanie\";}");
INSERT INTO `wp_usermeta` VALUES("33", "1", "metaboxhidden_page", "a:4:{i:0;s:10:\"postcustom\";i:1;s:16:\"commentstatusdiv\";i:2;s:7:\"slugdiv\";i:3;s:9:\"authordiv\";}");
INSERT INTO `wp_usermeta` VALUES("34", "1", "closedpostboxes_testimonials", "a:0:{}");
INSERT INTO `wp_usermeta` VALUES("35", "1", "metaboxhidden_testimonials", "a:1:{i:0;s:7:\"slugdiv\";}");
INSERT INTO `wp_usermeta` VALUES("36", "1", "session_tokens", "a:1:{s:64:\"17260257f21eb79fae8d90b16c2e7fcba0685342ea97ba1ced66915dd7c945b0\";a:4:{s:10:\"expiration\";i:1513351422;s:2:\"ip\";s:12:\"91.239.36.33\";s:2:\"ua\";s:104:\"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.62 Safari/537.36\";s:5:\"login\";i:1513178622;}}");

/* INSERT TABLE DATA: wp_users */
INSERT INTO `wp_users` VALUES("1", "admin", "$P$BPA6NNFN87QA8fjFiKqLm58HGgNfHZ0", "admin", "vccw@example.com", "", "2017-10-05 10:42:16", "", "0", "admin");

/* INSERT TABLE DATA: wp_wpdevart_calendars */
INSERT INTO `wp_wpdevart_calendars` VALUES("1", "1", "Calendar", "", "", "1", "1", "0");
INSERT INTO `wp_wpdevart_calendars` VALUES("2", "1", "Rezerwacja spotkania", "", "", "1", "2", "0");

/* INSERT TABLE DATA: wp_wpdevart_dates */
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-10-29", "2", "2017-10-29", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-10-30", "2", "2017-10-30", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-10-31", "2", "2017-10-31", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-11-01", "2", "2017-11-01", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-11-02", "2", "2017-11-02", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-11-03", "2", "2017-11-03", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-11-04", "2", "2017-11-04", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-11-05", "2", "2017-11-05", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-11-06", "2", "2017-11-06", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-11-07", "2", "2017-11-07", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-11-08", "2", "2017-11-08", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-11-09", "2", "2017-11-09", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-11-10", "2", "2017-11-10", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-11-11", "2", "2017-11-11", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-11-12", "2", "2017-11-12", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-11-13", "2", "2017-11-13", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-11-14", "2", "2017-11-14", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-11-15", "2", "2017-11-15", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-11-16", "2", "2017-11-16", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-11-17", "2", "2017-11-17", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-11-18", "2", "2017-11-18", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-11-19", "2", "2017-11-19", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-11-20", "2", "2017-11-20", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-11-21", "2", "2017-11-21", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-11-22", "2", "2017-11-22", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-11-23", "2", "2017-11-23", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-11-24", "2", "2017-11-24", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-11-25", "2", "2017-11-25", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-11-26", "2", "2017-11-26", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-11-27", "2", "2017-11-27", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-11-28", "2", "2017-11-28", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-11-29", "2", "2017-11-29", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-11-30", "2", "2017-11-30", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-01", "2", "2017-12-01", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-02", "2", "2017-12-02", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-03", "2", "2017-12-03", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-04", "2", "2017-12-04", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-05", "2", "2017-12-05", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-06", "2", "2017-12-06", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-07", "2", "2017-12-07", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-08", "2", "2017-12-08", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-09", "2", "2017-12-09", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-10", "2", "2017-12-10", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-11", "2", "2017-12-11", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-12", "2", "2017-12-12", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-13", "2", "2017-12-13", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-14", "2", "2017-12-14", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-15", "2", "2017-12-15", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-16", "2", "2017-12-16", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-17", "2", "2017-12-17", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-18", "2", "2017-12-18", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-19", "2", "2017-12-19", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-20", "2", "2017-12-20", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-21", "2", "2017-12-21", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-22", "2", "2017-12-22", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-23", "2", "2017-12-23", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-24", "2", "2017-12-24", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-25", "2", "2017-12-25", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-26", "2", "2017-12-26", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-27", "2", "2017-12-27", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-28", "2", "2017-12-28", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-29", "2", "2017-12-29", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-30", "2", "2017-12-30", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");
INSERT INTO `wp_wpdevart_dates` VALUES("2_2017-12-31", "2", "2017-12-31", "{\"status\":\"available\",\"available\":\"999\",\"info_users\":\"\",\"info_admin\":\"\",\"price\":\"\",\"marked_price\":\"\"}");

/* INSERT TABLE DATA: wp_wpdevart_extras */
INSERT INTO `wp_wpdevart_extras` VALUES("1", "Extra", "{\"extra_field1\":{\"name\":\"extra_field1\",\"label\":\"Adults\",\"required\":\"on\",\"items\":{\"field_item1\":{\"name\":\"field_item1\",\"label\":\"1\",\"operation\":\"+\",\"price_type\":\"price\",\"price_percent\":\"0\"},\"field_item2\":{\"name\":\"field_item2\",\"label\":\"2\",\"operation\":\"+\",\"price_type\":\"price\",\"price_percent\":\"0\"},\"field_item3\":{\"name\":\"field_item3\",\"label\":\"3\",\"operation\":\"+\",\"price_type\":\"price\",\"price_percent\":\"0\"},\"field_item4\":{\"name\":\"field_item4\",\"label\":\"4\",\"operation\":\"+\",\"price_type\":\"price\",\"price_percent\":\"0\"}}},\"extra_field2\":{\"name\":\"extra_field2\",\"label\":\"Children \",\"items\":{\"field_item1\":{\"name\":\"field_item1\",\"label\":\"1\",\"operation\":\"+\",\"price_type\":\"price\",\"price_percent\":\"0\"},\"field_item2\":{\"name\":\"field_item2\",\"label\":\"2\",\"operation\":\"+\",\"price_type\":\"price\",\"price_percent\":\"0\"},\"field_item3\":{\"name\":\"field_item3\",\"label\":\"3\",\"operation\":\"+\",\"price_type\":\"price\",\"price_percent\":\"0\"},\"field_item4\":{\"name\":\"field_item4\",\"label\":\"4\",\"operation\":\"+\",\"price_type\":\"price\",\"price_percent\":\"0\"}}}}");

/* INSERT TABLE DATA: wp_wpdevart_forms */
INSERT INTO `wp_wpdevart_forms` VALUES("1", "Form", "{\"apply\":\"Apply\",\"form_field1\":{\"type\":\"text\",\"name\":\"form_field1\",\"label\":\"First Name\",\"required\":\"on\"},\"form_field2\":{\"type\":\"text\",\"name\":\"form_field2\",\"label\":\"Last Name\"},\"form_field3\":{\"type\":\"text\",\"name\":\"form_field3\",\"label\":\"Email\",\"required\":\"on\",\"isemail\":\"on\"},\"form_field4\":{\"type\":\"text\",\"name\":\"form_field4\",\"label\":\"Phone\",\"required\":\"on\"},\"form_field5\":{\"type\":\"textarea\",\"name\":\"form_field5\",\"label\":\"Message\",\"required\":\"on\"}}");
INSERT INTO `wp_wpdevart_forms` VALUES("2", "Formularz spotkania", "{\"save\":\"Save\",\"form_field1\":{\"type\":\"text\",\"name\":\"form_field1\",\"label\":\"Twoje imi\\u0119\\u00a0i nazwisko\",\"required\":\"on\"},\"form_field3\":{\"type\":\"text\",\"name\":\"form_field3\",\"label\":\"Tw\\u00f3j adres email\",\"required\":\"on\",\"isemail\":\"on\"},\"form_field4\":{\"type\":\"text\",\"name\":\"form_field4\",\"label\":\"Telefon\"}}");

/* INSERT TABLE DATA: wp_wpdevart_reservations */
INSERT INTO `wp_wpdevart_reservations` VALUES("1", "2", "2017-11-02", "", "", "", "", "&#36;", "1", "0", "0", "[]", "0", "{\"wpdevart_form_field1\":\"Micha\\u0142 Staniecko\",\"wpdevart_form_field3\":\"michalstaniecko@gmail.com\",\"wpdevart_form_field4\":\"123456789\"}", "", "", "michalstaniecko@gmail.com", "pending", "", "", "2017-10-29 13:56", "1");
INSERT INTO `wp_wpdevart_reservations` VALUES("2", "2", "2017-10-29", "", "", "", "", "&#36;", "1", "0", "0", "[]", "0", "{\"wpdevart_form_field1\":\"Micha\\u0142 Staniecko\",\"wpdevart_form_field3\":\"michalstaniecko@gmail.com\",\"wpdevart_form_field4\":\"12345679\"}", "", "", "michalstaniecko@gmail.com", "pending", "", "", "2017-10-29 14:02", "1");
INSERT INTO `wp_wpdevart_reservations` VALUES("3", "2", "2017-11-04", "", "", "", "", "&#36;", "1", "0", "0", "[]", "0", "{\"wpdevart_form_field1\":\"Micha\\u0142 Staniecko\",\"wpdevart_form_field3\":\"michal.staniecko@gmail.com\",\"wpdevart_form_field4\":\"111111\"}", "", "", "michal.staniecko@gmail.com", "pending", "", "", "2017-10-29 14:03", "1");

/* INSERT TABLE DATA: wp_wpdevart_themes */
INSERT INTO `wp_wpdevart_themes` VALUES("1", "Theme", "{\"title\":\"Theme\",\"date_format\":\"F j, Y\",\"week_days\":\"0\",\"day_start\":\"1\",\"default_year\":\"\",\"default_month\":\"0\",\"cal_animation_type\":\"none\",\"scroll_offset\":\"\",\"show_form\":\"on\",\"type_days_selection\":\"single_day\",\"hide_count_available\":\"on\",\"terms_cond_link\":\"\",\"enable_form_title\":\"on\",\"enable_extras_title\":\"on\",\"legend_available\":\"Available\",\"legend_booked\":\"Booked\",\"legend_unavailable\":\"Unavailable\",\"action_after_submit\":\"stay_on_calendar\",\"message_text\":\"Dzi\\u0119kujemy.\",\"redirect_url\":\"\",\"custom_css\":\"\",\"currency\":\"USD\",\"currency_pos\":\"after\",\"type_hours_selection\":\"multiple_hours\",\"show_hours_info\":\"on\",\"hours\":{\"hour_value\":[\"\"],\"hour_price\":[\"\"],\"hours_marked_price\":[\"\"],\"hours_availability\":[\"available\"],\"hours_number_availability\":[\"\"],\"hour_info\":[\"\"]},\"days_for_new\":\"30\",\"calendar_max_width\":\"680\",\"calendar_header_font_weight\":\"normal\",\"calendar_header_font_style\":\"normal\",\"calendar_header_padding\":\"10\",\"next_prev_month_size\":\"15\",\"current_month_size\":\"19\",\"current_year_size\":\"19\",\"week_days_font_weight\":\"normal\",\"week_days_font_style\":\"normal\",\"week_days_size\":\"13\",\"day_number_font_weight\":\"normal\",\"day_number_font_style\":\"normal\",\"day_number_size\":\"13\",\"day_availability_font_weight\":\"normal\",\"day_availability_font_style\":\"normal\",\"day_availability_size\":\"13\",\"day_price_font_weight\":\"normal\",\"day_price_font_style\":\"normal\",\"day_price_size\":\"12\",\"days_min_height\":\"65\",\"hours_width\":\"95\",\"hours_height\":\"125\",\"info_font_weight\":\"normal\",\"info_font_style\":\"normal\",\"info_size\":\"13\",\"info_border_radius\":\"\",\"form_title_weight\":\"normal\",\"form_title_style\":\"italic\",\"form_title_size\":\"21\",\"form_labels_weight\":\"normal\",\"form_labels_style\":\"italic\",\"form_labels_size\":\"15\",\"form_fields_weight\":\"normal\",\"form_fields_style\":\"normal\",\"form_fields_size\":\"15\",\"form_submit_weight\":\"normal\",\"form_style_style\":\"normal\",\"reserv_info_weight\":\"normal\",\"reserv_info_style\":\"normal\",\"reserv_info_size\":\"14\",\"widget_day_info_weight\":\"normal\",\"widget_day_info_style\":\"normal\",\"widget_day_info_size\":\"14\",\"load_spinner_color\":\"#464646\",\"calendar_header_bg\":\"#FFFFFF\",\"next_prev_month\":\"#636363\",\"current_month\":\"#636363\",\"current_year\":\"#636363\",\"week_days_bg\":\"#ECECEC\",\"week_days_color\":\"#656565\",\"calendar_bg\":\"#FFFFFF\",\"calendar_border\":\"#ddd\",\"day_bg\":\"#FFFFFF\",\"day_number_bg\":\"#ECECEC\",\"day_color\":\"#464646\",\"day_availability_color\":\"#848484\",\"day_price_color\":\"#848484\",\"available_day_bg\":\"#FFFFFF\",\"available_day_number_bg\":\"#85B70B\",\"available_day_color\":\"#FFFFFF\",\"selected_day_bg\":\"#FFFFFF\",\"selected_day_number_bg\":\"#373740\",\"selected_day_color\":\"#FFFFFF\",\"selected_day_availability_color\":\"#848484\",\"selected_day_price_color\":\"#848484\",\"unavailable_day_bg\":\"#FFFFFF\",\"unavailable_day_number_bg\":\"#464646\",\"unavailable_day_color\":\"#ECECEC\",\"unavailable_day_availability_color\":\"#848484\",\"booked_day_bg\":\"#FFFFFF\",\"booked_day_number_bg\":\"#FD7C93\",\"booked_day_color\":\"#FFFFFF\",\"booked_day_availability_color\":\"#848484\",\"info_icon_color\":\"#FFFFFF\",\"info_bg\":\"#FFFFFF\",\"info_color\":\"#4E4E4E\",\"form_bg\":\"#FDFDFD\",\"form_border\":\"#ddd\",\"form_title_color\":\"#636363\",\"form_title_bg\":\"#FDFDFD\",\"form_labels_color\":\"#636363\",\"form_fields_color\":\"#636363\",\"reserv_info_color\":\"#545454\",\"total_bg\":\"#545454\",\"total_color\":\"#F7F7F7\",\"required_star_color\":\"#FD7C93\",\"submit_button_bg\":\"#FD7C93\",\"submit_button_color\":\"#FFFFFF\",\"error_info_bg\":\"#FFFFFF\",\"error_info_color\":\"#C11212\",\"error_info_border\":\"#C11212\",\"error_info_close_bg\":\"#C11212\",\"error_info_close_color\":\"#FFFFFF\",\"successfully_info_bg\":\"#FFFFFF\",\"successfully_info_color\":\"#7FAD16\",\"successfully_info_border\":\"#7FAD16\",\"successfully_info_close_bg\":\"#7FAD16\",\"successfully_info_close_color\":\"#FFFFFF\",\"widget_day_info_bg\":\"#FFFFFF\",\"widget_day_info_color\":\"#6B6B6B\",\"widget_day_info_border_color\":\"#C7C7C7\",\"mail_bg\":\"#f3f3f3\",\"mail_content_bg\":\"#FFFFFF\",\"mail_color\":\"#5A5A5A\",\"mail_header_img\":\"\",\"mail_footer_text\":\"Copyrightu00a9 2016\",\"mail_footer_text_color\":\"#a7a7a7\",\"notify_admin_on_book\":\"on\",\"notify_admin_on_book_to\":\"michal.staniecko@gmail.com\",\"notify_admin_on_book_from\":\"[useremail]\",\"notify_admin_on_book_fromname\":\"\",\"notify_admin_on_book_subject\":\"Rezerwacja spotkania.\",\"notify_admin_on_book_content\":\"Rezerwacja spotkania. Szczeg\\u00f3\\u0142y spotkania: [moderatelink]\",\"notify_admin_on_approved\":\"on\",\"notify_admin_on_approved_to\":\"michal.staniecko@gmail.com\",\"notify_admin_on_approved_from\":\"[useremail]\",\"notify_admin_on_approved_fromname\":\"\",\"notify_admin_on_approved_subject\":\"Rezerwacja zosta\\u0142a potwierdzona.\",\"notify_admin_on_approved_content\":\"Rezerwacja zosta\\u0142a potwierdzona. Szczeg\\u00f3\\u0142y dotycz\\u0105ce rezerwacji: [moderatelink]\",\"notify_admin_paypal_to\":\"info@info.com\",\"notify_admin_paypal_from\":\"[useremail]\",\"notify_admin_paypal_fromname\":\"\",\"notify_admin_paypal_subject\":\"You received a booking request.\",\"notify_admin_paypal_content\":\"You received a payment. For more details, visit: [moderatelink]\",\"notify_user_on_book\":\"on\",\"notify_user_on_book_from\":\"wordpress@bnb.testuj.website\",\"notify_user_on_book_fromname\":\"Body & Brain\",\"notify_user_on_book_subject\":\"Twoja propozycja spotkania zosta\\u0142a wys\\u0142ana.\",\"notify_user_on_book_content\":\"Dzie\\u0144 dobry,<br\\/><br\\/>\\r\\n\\r\\nTwoja propozycja spotkania zosta\\u0142a wys\\u0142ana.<br\\/><br\\/>\\r\\n\\r\\nInformacje na temat spotkania:\\r\\n<br\\/>\\r\\n[details]\\r\\n\\r\\n<br\\/><br\\/><br\\/>\\r\\n\\r\\nPozdrawiamy<br\\/>\\r\\nBody &amp; Brain\",\"notify_user_on_approved\":\"on\",\"notify_user_on_approved_from\":\"wordpress@bnb.testuj.website\",\"notify_user_on_approved_fromname\":\"Body & Brain\",\"notify_user_on_approved_subject\":\"Twoja rezerwacja zosta\\u0142a potwierdzona\",\"notify_user_on_approved_content\":\"Dzie\\u0144 dobry,<br\\/><br\\/>\\r\\n\\r\\nTwoja rezerwacja zosta\\u0142a potwierdzona.\\r\\n<br\\/><br\\/>\\r\\nInformacje na temat rezerwacji:\\r\\n<br\\/>\\r\\n[details]\\r\\n\\r\\n<br\\/><br\\/>\\r\\n\\r\\nPozdrawiamy<br\\/>\\r\\nBody &amp; Brain\",\"notify_user_canceled\":\"on\",\"notify_user_canceled_from\":\"wordpress@bnb.testuj.website\",\"notify_user_canceled_fromname\":\"\",\"notify_user_canceled_subject\":\"Twoja rezerwacja spotkania zosta\\u0142a anulowana.\",\"notify_user_canceled_content\":\"Dzie\\u0144 dobry,<br\\/><br\\/>\\r\\n\\r\\nTwoja rezerwacja spotkania zosta\\u0142a anulowana.\\r\\n\\r\\n<br\\/><br\\/>\\r\\n\\r\\nPozdrawiamy<br\\/>\\r\\nBody &amp; Brain\",\"notify_user_deleted_from\":\"info@info.com\",\"notify_user_deleted_fromname\":\"\",\"notify_user_deleted_subject\":\"Your booking request has been rejected\",\"notify_user_deleted_content\":\"\",\"notify_user_paypal_from\":\"info@info.com\",\"notify_user_paypal_fromname\":\"\",\"notify_user_paypal_subject\":\"Thank you for your purchase\",\"notify_user_paypal_content\":\"Your order has been received. Thank you for your purchase! You will receive an order confirmation by email.\",\"notify_user_paypal_failed_from\":\"info@info.com\",\"notify_user_paypal_failed_fromname\":\"\",\"notify_user_paypal_failed_subject\":\"Payment failed\",\"notify_user_paypal_failed_content\":\"Your payment failed.\",\"for_available\":\"\",\"for_booked\":\"Booked\",\"for_unavailable\":\"Unavailable\",\"for_check_in\":\"Check in\",\"for_check_out\":\"Check out\",\"for_date\":\"Data\",\"for_no_hour\":\"No hour available.\",\"for_start_hour\":\"Start hour\",\"for_end_hour\":\"End hour\",\"for_hour\":\"Hour\",\"for_item_count\":\"Item count\",\"for_termscond\":\"I accept to agree to the Terms & Conditions.\",\"for_reservation\":\"\",\"for_select_days\":\"Wybierz dzie\\u0144 z kalendarza.\",\"for_price\":\"Price\",\"for_total\":\"Total\",\"for_submit_button\":\"Rezerwuj\\u0119 termin >\",\"for_request_successfully_sent\":\"Twoja propozycja spotkania zosta\\u0142a wys\\u0142ana. Czekaj na potwierdzenie.\",\"for_request_successfully_received\":\"Your request has been successfully received. We are waiting you!\",\"for_error_single\":\"There are no services available for this day.\",\"for_error_multi\":\"There are no services available for the period you selected.\",\"for_night\":\"You must select at least two days\",\"for_pay_in_cash\":\"Pay in cash\",\"for_payPal\":\"Pay with PayPal\",\"for_shipping_info\":\"Same as billing info\",\"for_notify_admin_on_book\":\"Email on book to administrator does not send\",\"for_notify_admin_on_approved\":\"Email on approved to administrator does not send\",\"for_notify_user_on_book\":\"Email on book to user does not send\",\"for_notify_user_on_approved\":\"Email on approved to user does not send\",\"for_notify_user_canceled\":\"Email on canceled to user does not send\",\"for_notify_user_deleted\":\"Email on delete to user does not send\",\"billing_address_form\":\"1\",\"shipping_address_form\":\"1\",\"redirect_url_successful\":\"\",\"tax\":\"\",\"payment_mode\":\"sandbox\",\"payPal_email\":\"\",\"payPal_image\":\"http:\\/\\/localhost\\/wp_updates\\/wp-content\\/plugins\\/booking-calendar-pro\\/css\\/images\\/paynow.png\",\"button_action\":\"apply\",\"task\":\"save\",\"id\":\"1\"}");

SET FOREIGN_KEY_CHECKS = 1; 

/* Duplicator WordPress Timestamp: 2017-12-13 15:48:49*/
/* DUPLICATOR_MYSQLDUMP_EOF */
