<?php 

add_shortcode('booking', 'booking_form');
function booking_form() {
	if (!empty($_POST)) {
		
		global $wpdb;

		$table = $wpdb->prefix.'booking';
		$data = array(
			'name'			=> (!empty($_POST['booking_name']) ? $_POST['booking_name'] : ''),
			'date'			=> (!empty($_POST['booking_date']) ? $_POST['booking_date'] : ''),
			'email'			=> (!empty($_POST['booking_email']) ? $_POST['booking_email'] : ''),
		);
		$format = array(
			'%s',
			'%s'
		);
		if (
			!empty($_POST['booking_name']) &&
			!empty($_POST['booking_date']) &&
			!empty($_POST['booking_email'])
		):
			$success = $wpdb->insert($table, $data, $format);
		endif;
		
		if (isset($success) && $success) {
			//return var_dump($_POST);
			return 'Zapisano do bazy danych';
		}
		
	} else {
		ob_start();
		?>
			<form method="post">
				<input type="text" name="booking_name" placeholder="name" />
				<input type="text" name="booking_date" placeholder="date" />
				<input type="text" name="booking_email" placeholder="Email" />
				<input type="submit" value="Save" />
			</form>
		<?
		$out = ob_get_clean();
		return $out;
	}
}

add_action('admin_menu', 'booking_create_menu');
function booking_create_menu() {
	add_menu_page('Rezerwacja terminów', 'Rezerwacja terminów', 'administrator', 'booking_settings', 'booking_settings' );
}

function booking_settings() {
	global $wpdb;	
	$r = $wpdb-> get_results(
		"SELECT * FROM ".$wpdb->prefix."booking;"
	);
	if (!empty($_GET['confirm'])) {
		booking_update_reservation($_GET['confirm']);
	}
	?>
		<div class="wrap">
			<h1>Rezerwacje terminów</h1>

			<table>
				<thead>
					<tr>
						<th>
							ID
						</th>
						<th>
							Nazwa
						</th>
						<th>
							E-mail
						</th>
						<th>
							Data
						</th>
						<th>
							Rezerwacja potwierdzona?
						</th>
						<th>
							Potwierdz datę
						</th>
					</tr>
				</thead>
				<tbody>
	<?

	foreach ($r as $row) {
		echo '<tr>';
		echo '<td>'.$row->id.'</td>';
		echo '<td>'.$row->name.'</td>';
		echo '<td>'.$row->email.'</td>';
		echo '<td>'.$row->date.'</td>';
		echo '<td>'.($row->is_confirmed ? 'tak' : 'nie').'</td>';
		echo '<td><a href="?page='.$_GET['page'].'&confirm='.$row->id.'">Wyślij link potwierdzający datę</a></td>';
		echo '</tr>';
	}
	?>
			</tbody>
		</table>
	</div>
	<?
}

function booking_update_reservation($booking_id) {
	echo 'Reserwacja '.$booking_id.' została potwierdzona';
}

add_shortcode('booking_reservation_confirmed', 'booking_reservation_confirmed');
function booking_reservation_confirmed() {
	global $wpdb;
	if (!empty($_GET['confirm'])) {
		$table = $wpdb->prefix.'booking';
		$booking_id = $_GET['confirm'];
		$update = $wpdb->update(
			$table, 
			array(
				'is_confirmed' => 1,
			),
			array(
				'id' => $booking_id,
			)
		);
		if ($update) {
			return 'rezerwacja potwierdzona';
		}
	}
}