<?php
/**
 * Registering meta boxes
 *
 * All the definitions of meta boxes are listed below with comments.
 * Please read them CAREFULLY.
 *
 * You also should read the changelog to know what has been changed before updating.
 *
 * For more information, please visit:
 *
 * @link http://metabox.io/docs/registering-meta-boxes/
 */
add_filter( 'rwmb_meta_boxes', 'landing_page_register_meta_boxes' );
/**
 * Register meta boxes
 *
 * Remember to change "your_prefix" to actual prefix in your project
 *
 * @param array $meta_boxes List of meta boxes
 *
 * @return array
 */
function landing_page_register_meta_boxes( $meta_boxes ) {
	/**
	 * prefix of meta keys (optional)
	 * Use underscore (_) at the beginning to make keys hidden
	 * Alt.: You also can make prefix empty to disable it
	 */
	// Better has an underscore as last sign
	$prefix = 'landing_page_';
	// 1st meta box

	$meta_boxes[] = array(
		'id'         => 'header',
		'title'      => __( 'Nagłówek' ),
		'post_types' => array( 'warsztaty', 'page' ),
		'show'       => array(
			'template' => array(
				'template-o-nas.php',
				'template-warsztaty.php',
				'template-dla-firm.php'
			)
		),
		'fields'     => array(
			array(
				'name' => __( 'Tytuł strony' ),
				'id'   => "{$prefix}page-title",
				'type' => "text",
			),
			array(
				'name' => __( 'Podtytuł' ),
				'id'   => "{$prefix}page-subtitle",
				"type" => "textarea",
			),
			array(
				'name'             => __( 'Dodaje główne zdjęcie' ),
				'id'               => "{$prefix}main-img",
				'type'             => 'image_advanced',
				'force_delete'     => false,
				'max_file_uploads' => 1,
			),
		),
	);

	$meta_boxes[] = array(
		'id'         => 'section-1',
		'title'      => esc_html__( 'Sekcja Pierwsza - gdzie i kto prowadzi warsztaty', 'landing-page-section-1' ),
		'post_types' => array( 'warsztaty', 'page' ),
		'context'    => 'normal',
		'show'       => array(
			'template' => array(
				'template-o-nas.php',
				'template-warsztaty.php',
				'template-dla-firm.php'
			)
		),
		'fields'     => array(
			array(
				'name' => esc_html__( 'Sekcja aktywna?' ),
				'id'   => "{$prefix}section-active-1",
				'type' => 'checkbox',
				'std'  => 1,
			),
			// Title
			array(
				'name' => esc_html__( 'Tytuł sekcji', 'section-title-1' ),
				'id'   => "{$prefix}section-title-1",
				'desc' => esc_html__( 'Tytuł pierwszej sekcji', 'section-title-1' ),
				'type' => 'text'
			),
			array(
				'name' => esc_html__( 'Kolumna 1', 'date' ),
				'id'   => "{$prefix}date",
				'type' => 'wysiwyg',
				'cols' => 30,
				'rows' => 5
			),
			array(
				'name' => esc_html__( 'Kolumna 2', 'place' ),
				'id'   => "{$prefix}column-2",
				'type' => 'wysiwyg',
				'cols' => 30,
				'rows' => 5
			),
			array(
				'name' => esc_html__( 'Kolumna 3', 'place' ),
				'id'   => "{$prefix}place",
				'type' => 'wysiwyg',
				'cols' => 30,
				'rows' => 5
			),
			array(
				'name' => esc_html__( 'Prowadząca', 'teacher' ),
				'id'   => "{$prefix}teacher",
				'type' => 'text'
			),
			array(
				'name' => esc_html__( 'Link - więcej o prowadzącej' ),
				'id'   => "{$prefix}more_about_teacher",
				'type' => "text"
			),
			array(
				'name'             => esc_html__( 'Zdjęcie prowadzącej/prowadzącego', 'teacher-img' ),
				'id'               => "{$prefix}teacher-img",
				'type'             => 'image_advanced',
				// Delete image from Media Library when remove it from post meta?
				// Note: it might affect other posts if you use same image for multiple posts
				'force_delete'     => false,
				// Maximum image uploads
				'max_file_uploads' => 1,
				// Display the "Uploaded 1/2 files" status
				'max_status'       => true,
			),
		),
	);

	$meta_boxes[] = array(
		'id'         => 'section-1a',
		'title'      => esc_html__( 'Sekcja', 'section' ),
		'post_types' => array( 'warsztaty', 'page' ),
		'context'    => 'normal',
		'show'       => array(
			'template' => array(
				'template-o-nas.php',
				'template-warsztaty.php',
				'template-dla-firm.php'
			)
		),
		'fields'     => array(
			array(
				'name' => esc_html__( 'Sekcja aktywna?', 'section-active' ),
				'id'   => "{$prefix}section-active-1a",
				'type' => 'checkbox',
				'std'  => 1,
			),
			array(
				'name' => esc_html__( 'Tytuł', 'title' ),
				'id'   => "{$prefix}section-1a-title",
				'type' => 'text'
			),
			array(
				'name' => esc_html__( 'Opis', 'description' ),
				'id'   => "{$prefix}section-1a-desc",
				'type' => 'wysiwyg'
			),
		),
	);

	$meta_boxes[] = array(
		'id'         => 'section-2',
		'title'      => esc_html__( 'Sekcja - opis', 'landing-page-section-2' ),
		'post_types' => array( 'warsztaty', 'page' ),
		'context'    => 'normal',
		'show'       => array(
			'template' => array(
				'template-o-nas.php',
				'template-warsztaty.php',
				'template-dla-firm.php'
			)
		),
		'fields'     => array(
			array(
				'name' => esc_html__( 'Sekcja aktywna?' ),
				'id'   => "{$prefix}section-active-2",
				'type' => 'checkbox',
				'std'  => 1,
			),
			array(
				'name' => esc_html__( 'Tytuł sekcji', 'section-title-2' ),
				'id'   => "{$prefix}section-title-2",
				"type" => "text",
			),
			array(
				"name" => esc_html__( "Opis/Cena", "price" ),
				"id"   => "{$prefix}price",
				"type" => "wysiwyg"
			),
			array(
				"name"             => __( "Wybierz tło" ),
				"id"               => "{$prefix}section-2-bg",
				"type"             => "image_advanced",
				'force_delete'     => false,
				'max_file_uploads' => 1,
				'max_status'       => false
			),
			array(
				"name" => __( 'Kijek HealingLife' ),
				"id"   => "{$prefix}healinglife",
				"type" => "checkbox"
			),
			array(
				"name" => "Pomarańczowy przycisk",
				'id'   => "{$prefix}section-2-btn",
				"type" => "text",
			)
		),
	);

	$meta_boxes[] = array(
		'id'         => 'section-2a',
		'title'      => 'Sekcja',
		'post_types' => array( 'warsztaty', 'page' ),
		'context'    => 'normal',
		'show'       => array(
			'template' => array(
				'template-o-nas.php',
				'template-warsztaty.php',
				'template-dla-firm.php'
			)
		),
		'fields'     => array(
			array(
				'name' => esc_html__( 'Sekcja aktywna?' ),
				'id'   => "{$prefix}section-active-2a",
				'type' => 'checkbox',
				'std'  => 1,
			),
			array(
				'name' => 'Tytuł',
				'id'   => "{$prefix}section-2a-title",
				'type' => 'text',
			),
			array(
				'name' => 'Pole 1',
				'id'   => "{$prefix}section-2a-input-1",
				'type' => 'wysiwyg',
			),
			array(
				'name' => 'Pole 2',
				'id'   => "{$prefix}section-2a-input-2",
				'type' => 'wysiwyg',
			),
			array(
				'name' => 'Pole 3',
				'id'   => "{$prefix}section-2a-input-3",
				'type' => 'wysiwyg',
			),
		),
	);


	$meta_boxes[] = array(
		'id'         => 'slider',
		'title'      => __( 'Slider' ),
		'post_types' => array( 'warsztaty', 'page' ),
		'show'       => array(
			'template' => array(
				'template-o-nas.php',
				'template-warsztaty.php',
				'template-dla-firm.php'
			)
		),
		'fields'     => array(
			array(
				'name'       => __( 'Tytuł slide' ),
				'id'         => "{$prefix}slide-title",
				'type'       => "text",
				"clone"      => true,
				"sort_clone" => true
			),
			array(
				'name'       => __( 'Opis slide' ),
				'id'         => "{$prefix}slide-desc",
				'type'       => "textarea",
				"clone"      => true,
				"sort_clone" => true
			),
		),
	);

	$meta_boxes[] = array(
		'id'         => 'footer-lp',
		'title'      => __( 'Stopka' ),
		'post_types' => array( 'warsztaty', 'page' ),
		'show'       => array(
			'template' => array(
				'template-o-nas.php',
				'template-warsztaty.php',
				'template-dla-firm.php'
			)
		),
		'fields'     => array(
			array(
				'name' => __( 'Stopka' ),
				'id'   => "{$prefix}footer-lp",
				'type' => 'wysiwyg',
			),
		),
	);


	return $meta_boxes;
}
