<?php

add_filter( 'rwmb_meta_boxes', 'home_register_meta_boxes' );
function home_register_meta_boxes( $meta_boxes ) {
	$prefix       = 'home_';
	$meta_boxes[] = array(
		'id'         => 'o-nas',
		'title'      => 'O nas',
		'post_types' => 'page',
		'context'    => 'normal',
		'priority'   => 'high',

		'fields' => array(
			array(
				'name' => 'Treść',
				'desc' => 'Treść',
				'id'   => $prefix . 'o-nas-tresc',
				'type' => 'textarea',
			),
			array(
				'name'             => 'Zdjęcie',
				'id'               => $prefix . 'o-nas-zdjecie',
				'type'             => 'image_advanced',
				'max_file_uploads' => 1
			)
		)
	);

	$meta_boxes[] = array(
		'id'         => 'oferta',
		'title'      => 'Zapoznaj się z ofertą',
		'post_types' => 'page',
		'context'    => 'normal',
		'priority'   => 'high',

		'fields' => array(
			array(
				'name' => 'Treść',
				'desc' => 'Treść',
				'id'   => $prefix . 'oferta-tresc',
				'type' => 'textarea',
			),
			array(
				'name'             => 'Zdjęcie',
				'id'               => $prefix . 'oferta-zdjecie',
				'type'             => 'image_advanced',
				'max_file_uploads' => 1
			),
			array(
				'name'             => 'Grafik',
				'id'               => $prefix . 'oferta-grafik',
				'type'             => 'image_advanced',
				'max_file_uploads' => 1
			),

		)
	);

	$meta_boxes[] = array(
		'id'         => 'spotkanie',
		'title'      => 'Umów się na spotkanie',
		'post_types' => 'page',
		'context'    => 'normal',
		'priority'   => 'high',

		'fields' => array(
			array(
				'name' => 'Treść',
				'desc' => 'Treść',
				'id'   => $prefix . 'spotkanie-tresc',
				'type' => 'textarea',
			),
			array(
				'name'             => 'Zdjęcie',
				'id'               => $prefix . 'spotkanie-zdjecie',
				'type'             => 'image_advanced',
				'max_file_uploads' => 1
			)
		)
	);
	return $meta_boxes;
}