<?php
// Register Custom Post Type
function slider_post_type() {

	$labels = array(
		'name'                  => _x( 'Slides', 'Post Type General Name', 'bnb' ),
		'singular_name'         => _x( 'Slide', 'Post Type Singular Name', 'bnb' ),
		'menu_name'             => __( 'Slider', 'bnb' ),
		'name_admin_bar'        => __( 'Slider', 'bnb' ),
		'archives'              => __( 'Item Archives', 'bnb' ),
		'attributes'            => __( 'Item Attributes', 'bnb' ),
		'parent_item_colon'     => __( 'Parent Item:', 'bnb' ),
		'all_items'             => __( 'All Items', 'bnb' ),
		'add_new_item'          => __( 'Add New Item', 'bnb' ),
		'add_new'               => __( 'Add New', 'bnb' ),
		'new_item'              => __( 'New Item', 'bnb' ),
		'edit_item'             => __( 'Edit Item', 'bnb' ),
		'update_item'           => __( 'Update Item', 'bnb' ),
		'view_item'             => __( 'View Item', 'bnb' ),
		'view_items'            => __( 'View Items', 'bnb' ),
		'search_items'          => __( 'Search Item', 'bnb' ),
		'not_found'             => __( 'Not found', 'bnb' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'bnb' ),
		'featured_image'        => __( 'Featured Image', 'bnb' ),
		'set_featured_image'    => __( 'Set featured image', 'bnb' ),
		'remove_featured_image' => __( 'Remove featured image', 'bnb' ),
		'use_featured_image'    => __( 'Use as featured image', 'bnb' ),
		'insert_into_item'      => __( 'Insert into item', 'bnb' ),
		'uploaded_to_this_item' => __( 'Uploaded to this item', 'bnb' ),
		'items_list'            => __( 'Items list', 'bnb' ),
		'items_list_navigation' => __( 'Items list navigation', 'bnb' ),
		'filter_items_list'     => __( 'Filter items list', 'bnb' ),
	);
	$args = array(
		'label'                 => __( 'Slide', 'bnb' ),
		'description'           => __( 'Slider', 'bnb' ),
		'labels'                => $labels,
		'supports'              => array( 'title' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => false,
		'exclude_from_search'   => true,
		'publicly_queryable'    => true,
		'rewrite'               => false,
		'capability_type'       => 'page',
		'show_in_rest'          => false,
	);
	register_post_type( 'slider', $args );

}
add_action( 'init', 'slider_post_type', 0 );
