<?php
// Register Custom Post Type
function testimonials_post_type() {

	$labels = array(
		'name'                  => 'Opinie',
		'singular_name'         => 'Opinia',
		'menu_name'             => 'Opinie',
		'name_admin_bar'        => 'Opinie',
		'archives'              => 'Item Archives',
		'attributes'            => 'Item Attributes',
		'parent_item_colon'     => 'Parent Item:',
		'all_items'             => 'All Items',
		'add_new_item'          => 'Add New Item',
		'add_new'               => 'Add New',
		'new_item'              => 'New Item',
		'edit_item'             => 'Edit Item',
		'update_item'           => 'Update Item',
		'view_item'             => 'View Item',
		'view_items'            => 'View Items',
		'search_items'          => 'Search Item',
		'not_found'             => 'Not found',
		'not_found_in_trash'    => 'Not found in Trash',
		'featured_image'        => 'Zdjęcie studenta',
		'set_featured_image'    => 'Set featured image',
		'remove_featured_image' => 'Remove featured image',
		'use_featured_image'    => 'Use as featured image',
		'insert_into_item'      => 'Insert into item',
		'uploaded_to_this_item' => 'Uploaded to this item',
		'items_list'            => 'Items list',
		'items_list_navigation' => 'Items list navigation',
		'filter_items_list'     => 'Filter items list',
	);
	$args   = array(
		'label'               => 'Opinia',
		'description'         => 'Opinie',
		'labels'              => $labels,
		'supports'            => array( 'title', 'thumbnail', ),
		'hierarchical'        => false,
		'public'              => true,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'menu_position'       => 5,
		'show_in_admin_bar'   => true,
		'show_in_nav_menus'   => true,
		'can_export'          => true,
		'has_archive'         => true,
		'exclude_from_search' => true,
		'publicly_queryable'  => true,
		'rewrite'             => array(
			'slug'  => 'opinie'
		),
		'capability_type'     => 'page',
		'show_in_rest'        => false,
	);
	register_post_type( 'testimonials', $args );

}

add_action( 'init', 'testimonials_post_type', 0 );

add_filter( 'rwmb_meta_boxes', 'testimonials_register_meta_boxes' );

function testimonials_register_meta_boxes( $meta_boxes ) {
	$prefix       = 'testimonials_';
	$meta_boxes[] = array(
		'id'         => 'testimonials',
		'title'      => 'Opinia',
		'post_types' => 'testimonials',
		'context'    => 'normal',
		'priority'   => 'high',

		'fields' => array(
			array(
				'name' => 'Zawód',
				'desc' => 'Zawód',
				'id'   => $prefix . 'zawod',
				'type' => 'text',
			),
			array(
				'name' => 'Opinia',
				'desc' => 'Opinia',
				'id'   => $prefix . 'opinia',
				'type' => 'wysiwyg'
			),
			array(
				'name'  =>  'Opinia krótka',
				'desc'  =>  'Opinia krótka',
				'id'    => $prefix.'opinia_krotka',
				'type'  => 'wysiwyg'
			),
			array(
				'name'  => 'Pokaż na stronie głównej',
				'desc'  => 'Pokaż na stronie głównej',
				'id'    => $prefix.'home_page',
				'type'  => 'checkbox',
				'std'   => 1
			)
		)
	);

	return $meta_boxes;
}